/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.http.multipart;

import com.android.internal.http.multipart.PartSource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class FilePartSource
implements PartSource {
    private File file = null;
    private String fileName = null;

    public FilePartSource(File file) throws FileNotFoundException {
        this.file = file;
        if (file != null) {
            if (!file.isFile()) {
                throw new FileNotFoundException("File is not a normal file.");
            }
            if (!file.canRead()) {
                throw new FileNotFoundException("File is not readable.");
            }
            this.fileName = file.getName();
        }
    }

    public FilePartSource(String string2, File file) throws FileNotFoundException {
        this(file);
        if (string2 != null) {
            this.fileName = string2;
        }
    }

    @Override
    public InputStream createInputStream() throws IOException {
        if (this.file != null) {
            return new FileInputStream(this.file);
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    @Override
    public String getFileName() {
        if (this.fileName == null) {
            return "noname";
        }
        return this.fileName;
    }

    @Override
    public long getLength() {
        if (this.file != null) {
            return this.file.length();
        }
        return 0L;
    }
}

