/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.media.MediaRouter;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.SeekBar;

public class MediaRouteControllerDialog
extends Dialog {
    private static final int VOLUME_UPDATE_DELAY_MILLIS = 250;
    private final MediaRouterCallback mCallback;
    private View mControlView;
    private boolean mCreated;
    private Drawable mCurrentIconDrawable;
    private Button mDisconnectButton;
    private Drawable mMediaRouteConnectingDrawable;
    private Drawable mMediaRouteOnDrawable;
    private final MediaRouter.RouteInfo mRoute;
    private final MediaRouter mRouter;
    private boolean mVolumeControlEnabled = true;
    private LinearLayout mVolumeLayout;
    private SeekBar mVolumeSlider;
    private boolean mVolumeSliderTouched;

    public MediaRouteControllerDialog(Context context, int n) {
        super(context, n);
        this.mRouter = (MediaRouter)context.getSystemService("media_router");
        this.mCallback = new MediaRouterCallback();
        this.mRoute = this.mRouter.getSelectedRoute();
    }

    static /* synthetic */ boolean access$102(MediaRouteControllerDialog mediaRouteControllerDialog, boolean bl) {
        mediaRouteControllerDialog.mVolumeSliderTouched = bl;
        return bl;
    }

    private Drawable getIconDrawable() {
        if (this.mRoute.isConnecting()) {
            if (this.mMediaRouteConnectingDrawable == null) {
                this.mMediaRouteConnectingDrawable = this.getContext().getDrawable(17302676);
            }
            return this.mMediaRouteConnectingDrawable;
        }
        if (this.mMediaRouteOnDrawable == null) {
            this.mMediaRouteOnDrawable = this.getContext().getDrawable(17302697);
        }
        return this.mMediaRouteOnDrawable;
    }

    private boolean isVolumeControlAvailable() {
        return this.mVolumeControlEnabled && this.mRoute.getVolumeHandling() == 1;
    }

    private boolean update() {
        if (!this.mRoute.isSelected() || this.mRoute.isDefault()) {
            this.dismiss();
            return false;
        }
        this.setTitle(this.mRoute.getName());
        this.updateVolume();
        Drawable drawable2 = this.getIconDrawable();
        if (drawable2 != this.mCurrentIconDrawable) {
            this.mCurrentIconDrawable = drawable2;
            this.getWindow().setFeatureDrawable(3, drawable2);
        }
        return true;
    }

    private void updateVolume() {
        block3: {
            block2: {
                if (this.mVolumeSliderTouched) break block2;
                if (!this.isVolumeControlAvailable()) break block3;
                this.mVolumeLayout.setVisibility(0);
                this.mVolumeSlider.setMax(this.mRoute.getVolumeMax());
                this.mVolumeSlider.setProgress(this.mRoute.getVolume());
            }
            return;
        }
        this.mVolumeLayout.setVisibility(8);
    }

    public View getMediaControlView() {
        return this.mControlView;
    }

    public MediaRouter.RouteInfo getRoute() {
        return this.mRoute;
    }

    public boolean isVolumeControlEnabled() {
        return this.mVolumeControlEnabled;
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mRouter.addCallback(0, this.mCallback, 2);
        this.update();
    }

    @Override
    protected void onCreate(Bundle bundle) {
        FrameLayout frameLayout;
        block3: {
            block2: {
                super.onCreate(bundle);
                this.getWindow().requestFeature(3);
                this.setContentView(17367177);
                this.mVolumeLayout = (LinearLayout)this.findViewById(16909164);
                this.mVolumeSlider = (SeekBar)this.findViewById(16909165);
                this.mVolumeSlider.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){
                    private final Runnable mStopTrackingTouch = new Runnable(){

                        @Override
                        public void run() {
                            if (MediaRouteControllerDialog.this.mVolumeSliderTouched) {
                                MediaRouteControllerDialog.access$102(MediaRouteControllerDialog.this, false);
                                MediaRouteControllerDialog.this.updateVolume();
                            }
                        }
                    };

                    @Override
                    public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
                        if (bl) {
                            MediaRouteControllerDialog.this.mRoute.requestSetVolume(n);
                        }
                    }

                    @Override
                    public void onStartTrackingTouch(SeekBar seekBar) {
                        if (MediaRouteControllerDialog.this.mVolumeSliderTouched) {
                            MediaRouteControllerDialog.this.mVolumeSlider.removeCallbacks(this.mStopTrackingTouch);
                            return;
                        }
                        MediaRouteControllerDialog.access$102(MediaRouteControllerDialog.this, true);
                    }

                    @Override
                    public void onStopTrackingTouch(SeekBar seekBar) {
                        MediaRouteControllerDialog.this.mVolumeSlider.postDelayed(this.mStopTrackingTouch, 250L);
                    }
                });
                this.mDisconnectButton = (Button)this.findViewById(16909167);
                this.mDisconnectButton.setOnClickListener(new View.OnClickListener(){

                    @Override
                    public void onClick(View view) {
                        if (MediaRouteControllerDialog.this.mRoute.isSelected()) {
                            MediaRouteControllerDialog.this.mRouter.getDefaultRoute().select();
                        }
                        MediaRouteControllerDialog.this.dismiss();
                    }
                });
                this.mCreated = true;
                if (!this.update()) break block2;
                this.mControlView = this.onCreateMediaControlView(bundle);
                frameLayout = (FrameLayout)this.findViewById(16909166);
                if (this.mControlView == null) break block3;
                frameLayout.addView(this.mControlView);
                frameLayout.setVisibility(0);
            }
            return;
        }
        frameLayout.setVisibility(8);
    }

    public View onCreateMediaControlView(Bundle bundle) {
        return null;
    }

    @Override
    public void onDetachedFromWindow() {
        this.mRouter.removeCallback(this.mCallback);
        super.onDetachedFromWindow();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        if (n != 25 && n != 24) {
            return super.onKeyDown(n, keyEvent);
        }
        MediaRouter.RouteInfo routeInfo = this.mRoute;
        int n2 = n == 25 ? -1 : 1;
        routeInfo.requestUpdateVolume(n2);
        return true;
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (n == 25 || n == 24) {
            return true;
        }
        return super.onKeyUp(n, keyEvent);
    }

    public void setVolumeControlEnabled(boolean bl) {
        if (this.mVolumeControlEnabled != bl) {
            this.mVolumeControlEnabled = bl;
            if (this.mCreated) {
                this.updateVolume();
            }
        }
    }

    private final class MediaRouterCallback
    extends MediaRouter.SimpleCallback {
        private MediaRouterCallback() {
        }

        @Override
        public void onRouteChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            MediaRouteControllerDialog.this.update();
        }

        @Override
        public void onRouteGrouped(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo, MediaRouter.RouteGroup routeGroup, int n) {
            MediaRouteControllerDialog.this.update();
        }

        @Override
        public void onRouteUngrouped(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo, MediaRouter.RouteGroup routeGroup) {
            MediaRouteControllerDialog.this.update();
        }

        @Override
        public void onRouteUnselected(MediaRouter mediaRouter, int n, MediaRouter.RouteInfo routeInfo) {
            MediaRouteControllerDialog.this.update();
        }

        @Override
        public void onRouteVolumeChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            if (routeInfo == MediaRouteControllerDialog.this.mRoute) {
                MediaRouteControllerDialog.this.updateVolume();
            }
        }
    }
}

