/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Dialog;
import android.content.Context;
import android.media.MediaRouter;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ListView;
import android.widget.TextView;
import java.util.Comparator;

public class MediaRouteChooserDialog
extends Dialog {
    private RouteAdapter mAdapter;
    private boolean mAttachedToWindow;
    private final MediaRouterCallback mCallback;
    private Button mExtendedSettingsButton;
    private View.OnClickListener mExtendedSettingsClickListener;
    private ListView mListView;
    private int mRouteTypes;
    private final MediaRouter mRouter;

    public MediaRouteChooserDialog(Context context, int n) {
        super(context, n);
        this.mRouter = (MediaRouter)context.getSystemService("media_router");
        this.mCallback = new MediaRouterCallback();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateExtendedSettingsButton() {
        if (this.mExtendedSettingsButton != null) {
            this.mExtendedSettingsButton.setOnClickListener(this.mExtendedSettingsClickListener);
            Button button = this.mExtendedSettingsButton;
            int n = this.mExtendedSettingsClickListener != null ? 0 : 8;
            button.setVisibility(n);
        }
    }

    public int getRouteTypes() {
        return this.mRouteTypes;
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
        this.mRouter.addCallback(this.mRouteTypes, this.mCallback, 1);
        this.refreshRoutes();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.getWindow().requestFeature(3);
        this.setContentView(17367176);
        int n = this.mRouteTypes == 4 ? 17040837 : 17040836;
        this.setTitle(n);
        this.getWindow().setFeatureDrawableResource(3, 17302685);
        this.mAdapter = new RouteAdapter(this.getContext());
        this.mListView = (ListView)this.findViewById(16909162);
        this.mListView.setAdapter(this.mAdapter);
        this.mListView.setOnItemClickListener(this.mAdapter);
        this.mListView.setEmptyView(this.findViewById(16908292));
        this.mExtendedSettingsButton = (Button)this.findViewById(16909163);
        this.updateExtendedSettingsButton();
    }

    @Override
    public void onDetachedFromWindow() {
        this.mAttachedToWindow = false;
        this.mRouter.removeCallback(this.mCallback);
        super.onDetachedFromWindow();
    }

    public boolean onFilterRoute(MediaRouter.RouteInfo routeInfo) {
        return !routeInfo.isDefault() && routeInfo.isEnabled() && routeInfo.matchesTypes(this.mRouteTypes);
    }

    public void refreshRoutes() {
        if (this.mAttachedToWindow) {
            this.mAdapter.update();
        }
    }

    public void setExtendedSettingsClickListener(View.OnClickListener onClickListener) {
        if (onClickListener != this.mExtendedSettingsClickListener) {
            this.mExtendedSettingsClickListener = onClickListener;
            this.updateExtendedSettingsButton();
        }
    }

    public void setRouteTypes(int n) {
        if (this.mRouteTypes != n) {
            this.mRouteTypes = n;
            if (this.mAttachedToWindow) {
                this.mRouter.removeCallback(this.mCallback);
                this.mRouter.addCallback(n, this.mCallback, 1);
            }
            this.refreshRoutes();
        }
    }

    private final class MediaRouterCallback
    extends MediaRouter.SimpleCallback {
        private MediaRouterCallback() {
        }

        @Override
        public void onRouteAdded(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            MediaRouteChooserDialog.this.refreshRoutes();
        }

        @Override
        public void onRouteChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            MediaRouteChooserDialog.this.refreshRoutes();
        }

        @Override
        public void onRouteRemoved(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            MediaRouteChooserDialog.this.refreshRoutes();
        }

        @Override
        public void onRouteSelected(MediaRouter mediaRouter, int n, MediaRouter.RouteInfo routeInfo) {
            MediaRouteChooserDialog.this.dismiss();
        }
    }

    private final class RouteAdapter
    extends ArrayAdapter<MediaRouter.RouteInfo>
    implements AdapterView.OnItemClickListener {
        private final LayoutInflater mInflater;

        public RouteAdapter(Context context) {
            super(context, 0);
            this.mInflater = LayoutInflater.from(context);
        }

        @Override
        public boolean areAllItemsEnabled() {
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            View view2 = view;
            if (view2 == null) {
                view2 = this.mInflater.inflate(17367178, viewGroup, false);
            }
            MediaRouter.RouteInfo routeInfo = (MediaRouter.RouteInfo)this.getItem(n);
            TextView textView = (TextView)view2.findViewById(16908308);
            TextView textView2 = (TextView)view2.findViewById(16908309);
            textView.setText(routeInfo.getName());
            CharSequence charSequence = routeInfo.getDescription();
            if (TextUtils.isEmpty(charSequence)) {
                textView2.setVisibility(8);
                textView2.setText("");
            } else {
                textView2.setVisibility(0);
                textView2.setText(charSequence);
            }
            view2.setEnabled(routeInfo.isEnabled());
            return view2;
        }

        @Override
        public boolean isEnabled(int n) {
            return ((MediaRouter.RouteInfo)this.getItem(n)).isEnabled();
        }

        @Override
        public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
            MediaRouter.RouteInfo routeInfo = (MediaRouter.RouteInfo)this.getItem(n);
            if (routeInfo.isEnabled()) {
                routeInfo.select();
                MediaRouteChooserDialog.this.dismiss();
            }
        }

        public void update() {
            this.clear();
            int n = MediaRouteChooserDialog.this.mRouter.getRouteCount();
            for (int i = 0; i < n; ++i) {
                MediaRouter.RouteInfo routeInfo = MediaRouteChooserDialog.this.mRouter.getRouteAt(i);
                if (!MediaRouteChooserDialog.this.onFilterRoute(routeInfo)) continue;
                this.add(routeInfo);
            }
            this.sort(RouteComparator.sInstance);
            this.notifyDataSetChanged();
        }
    }

    private static final class RouteComparator
    implements Comparator<MediaRouter.RouteInfo> {
        public static final RouteComparator sInstance = new RouteComparator();

        private RouteComparator() {
        }

        @Override
        public int compare(MediaRouter.RouteInfo routeInfo, MediaRouter.RouteInfo routeInfo2) {
            return routeInfo.getName().toString().compareTo(routeInfo2.getName().toString());
        }
    }
}

