/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.content.Context;
import android.content.Intent;
import android.content.pm.UserInfo;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Slog;
import android.widget.Toast;

public class IntentForwarderActivity
extends Activity {
    public static String FORWARD_INTENT_TO_MANAGED_PROFILE;
    public static String FORWARD_INTENT_TO_USER_OWNER;
    public static String TAG;

    static {
        TAG = "IntentForwarderActivity";
        FORWARD_INTENT_TO_USER_OWNER = "com.android.internal.app.ForwardIntentToUserOwner";
        FORWARD_INTENT_TO_MANAGED_PROFILE = "com.android.internal.app.ForwardIntentToManagedProfile";
    }

    private UserHandle getManagedProfile() {
        for (UserInfo userInfo : ((UserManager)this.getSystemService("user")).getProfiles(0)) {
            if (!userInfo.isManagedProfile()) continue;
            return new UserHandle(userInfo.id);
        }
        Slog.wtf(TAG, FORWARD_INTENT_TO_MANAGED_PROFILE + " has been called, but there is no managed profile");
        return null;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onCreate(Bundle var1_1) {
        block14: {
            super.onCreate(var1_1);
            var2_2 = this.getIntent();
            var3_3 = var2_2.getComponent().getClassName();
            if (var3_3.equals(IntentForwarderActivity.FORWARD_INTENT_TO_USER_OWNER)) {
                var5_4 = 17040692;
                var6_5 = UserHandle.OWNER;
            } else if (var3_3.equals(IntentForwarderActivity.FORWARD_INTENT_TO_MANAGED_PROFILE)) {
                var5_4 = 17040693;
                var6_5 = this.getManagedProfile();
            } else {
                Slog.wtf(IntentForwarderActivity.TAG, IntentForwarderActivity.class.getName() + " cannot be called directly");
                var5_4 = -1;
                var6_5 = null;
            }
            if (var6_5 == null) {
                this.finish();
                return;
            }
            var7_6 = new Intent(var2_2);
            var7_6.setComponent(null);
            var7_6.setPackage(null);
            var7_6.addFlags(0x3000000);
            var11_7 = this.getUserId();
            var12_8 = AppGlobals.getPackageManager();
            var13_9 = var7_6.resolveTypeIfNeeded(this.getContentResolver());
            var14_10 = var7_6.getSelector();
            if (var14_10 == null) {
                var14_10 = var7_6;
            }
            try {
                var17_12 = var26_11 = var12_8.canForwardTo(var14_10, var13_9, var11_7, var6_5.getIdentifier());
            }
            catch (RemoteException var15_14) {
                Slog.e(IntentForwarderActivity.TAG, "PackageManagerService is dead?");
                var17_12 = false;
            }
            if (!var17_12) ** GOTO lbl53
            var7_6.setContentUserHint(var11_7);
            var19_13 = UserHandle.isSameApp(this.getPackageManager().resolveActivityAsUser((Intent)var7_6, (int)65536, (int)var6_5.getIdentifier()).activityInfo.applicationInfo.uid, 1000) == false;
            try {
                this.startActivityAsCaller(var7_6, null, var6_5.getIdentifier());
            }
            catch (RuntimeException var20_15) {
                block13: {
                    var21_16 = -1;
                    var22_17 = "?";
                    try {
                        var21_16 = ActivityManagerNative.getDefault().getLaunchedFromUid(this.getActivityToken());
                        var22_17 = var25_18 = ActivityManagerNative.getDefault().getLaunchedFromPackage(this.getActivityToken());
                        break block13;
                    }
                    catch (RemoteException var23_19) {}
lbl53:
                    // 1 sources

                    Slog.wtf(IntentForwarderActivity.TAG, "the intent: " + var7_6 + "cannot be forwarded from user " + var11_7 + " to user " + var6_5.getIdentifier());
                    break block14;
                }
                Slog.wtf(IntentForwarderActivity.TAG, "Unable to launch as UID " + var21_16 + " package " + var22_17 + ", while running in " + ActivityThread.currentProcessName(), var20_15);
            }
            if (var19_13) {
                Toast.makeText((Context)this, this.getString(var5_4), 1).show();
            }
        }
        this.finish();
    }
}

