/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.widget.TextView;
import com.android.internal.R;

class TextViewWithCircularIndicator
extends TextView {
    private static final int SELECTED_CIRCLE_ALPHA = 60;
    private int mCircleColor;
    private final Paint mCirclePaint = new Paint();
    private boolean mDrawIndicator;
    private final String mItemIsSelectedText;

    public TextViewWithCircularIndicator(Context context) {
        this(context, null);
    }

    public TextViewWithCircularIndicator(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public TextViewWithCircularIndicator(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public TextViewWithCircularIndicator(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet);
        TypedArray typedArray = this.mContext.obtainStyledAttributes(attributeSet, R.styleable.DatePicker, n, n2);
        int n3 = typedArray.getResourceId(13, -1);
        if (n3 != -1) {
            this.setTextAppearance(context, n3);
        }
        this.mItemIsSelectedText = context.getResources().getString(17041006);
        typedArray.recycle();
        this.init();
    }

    private void init() {
        this.mCirclePaint.setTypeface(Typeface.create(this.mCirclePaint.getTypeface(), 1));
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mCirclePaint.setStyle(Paint.Style.FILL);
    }

    @Override
    public CharSequence getContentDescription() {
        CharSequence charSequence = this.getText();
        if (this.mDrawIndicator) {
            charSequence = String.format(this.mItemIsSelectedText, charSequence);
        }
        return charSequence;
    }

    @Override
    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawIndicator) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = Math.min(n, n2) / 2;
            canvas.drawCircle(n / 2, n2 / 2, n3, this.mCirclePaint);
        }
    }

    public void setCircleColor(int n) {
        if (n != this.mCircleColor) {
            this.mCircleColor = n;
            this.mCirclePaint.setColor(this.mCircleColor);
            this.mCirclePaint.setAlpha(60);
            this.requestLayout();
        }
    }

    public void setDrawIndicator(boolean bl) {
        this.mDrawIndicator = bl;
    }
}

