/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.LinearLayout;
import com.android.internal.R;

public class TabWidget
extends LinearLayout
implements View.OnFocusChangeListener {
    private final Rect mBounds = new Rect();
    private boolean mDrawBottomStrips = true;
    private int[] mImposedTabWidths;
    private int mImposedTabsHeight = -1;
    private Drawable mLeftStrip;
    private Drawable mRightStrip;
    private int mSelectedTab = -1;
    private OnTabSelectionChanged mSelectionChangedListener;
    private boolean mStripMoved;

    public TabWidget(Context context) {
        this(context, null);
    }

    public TabWidget(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842883);
    }

    public TabWidget(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public TabWidget(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TabWidget, n, n2);
        this.setStripEnabled(typedArray.getBoolean(3, true));
        this.setLeftStripDrawable(typedArray.getDrawable(1));
        this.setRightStripDrawable(typedArray.getDrawable(2));
        typedArray.recycle();
        this.initTabWidget();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initTabWidget() {
        this.setChildrenDrawingOrderEnabled(true);
        Context context = this.mContext;
        if (context.getApplicationInfo().targetSdkVersion <= 4) {
            if (this.mLeftStrip == null) {
                this.mLeftStrip = context.getDrawable(17303491);
            }
            if (this.mRightStrip == null) {
                this.mRightStrip = context.getDrawable(17303493);
            }
        } else {
            if (this.mLeftStrip == null) {
                this.mLeftStrip = context.getDrawable(17303490);
            }
            if (this.mRightStrip == null) {
                this.mRightStrip = context.getDrawable(17303492);
            }
        }
        this.setFocusable(true);
        this.setOnFocusChangeListener(this);
    }

    @Override
    public void addView(View view) {
        if (view.getLayoutParams() == null) {
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -1, 1.0f);
            layoutParams.setMargins(0, 0, 0, 0);
            view.setLayoutParams(layoutParams);
        }
        view.setFocusable(true);
        view.setClickable(true);
        super.addView(view);
        view.setOnClickListener(new TabClickListener(-1 + this.getTabCount()));
        view.setOnFocusChangeListener(this);
    }

    @Override
    public void childDrawableStateChanged(View view) {
        if (this.getTabCount() > 0 && view == this.getChildTabViewAt(this.mSelectedTab)) {
            this.invalidate();
        }
        super.childDrawableStateChanged(view);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.getTabCount() == 0 || !this.mDrawBottomStrips) {
            return;
        }
        View view = this.getChildTabViewAt(this.mSelectedTab);
        Drawable drawable2 = this.mLeftStrip;
        Drawable drawable3 = this.mRightStrip;
        drawable2.setState(view.getDrawableState());
        drawable3.setState(view.getDrawableState());
        if (this.mStripMoved) {
            Rect rect = this.mBounds;
            rect.left = view.getLeft();
            rect.right = view.getRight();
            int n = this.getHeight();
            drawable2.setBounds(Math.min(0, rect.left - drawable2.getIntrinsicWidth()), n - drawable2.getIntrinsicHeight(), rect.left, n);
            drawable3.setBounds(rect.right, n - drawable3.getIntrinsicHeight(), Math.max(this.getWidth(), rect.right + drawable3.getIntrinsicWidth()), n);
            this.mStripMoved = false;
        }
        drawable2.draw(canvas);
        drawable3.draw(canvas);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        View view;
        this.onPopulateAccessibilityEvent(accessibilityEvent);
        if (this.mSelectedTab != -1 && (view = this.getChildTabViewAt(this.mSelectedTab)) != null && view.getVisibility() == 0) {
            return view.dispatchPopulateAccessibilityEvent(accessibilityEvent);
        }
        return false;
    }

    public void focusCurrentTab(int n) {
        int n2 = this.mSelectedTab;
        this.setCurrentTab(n);
        if (n2 != n) {
            this.getChildTabViewAt(n).requestFocus();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int getChildDrawingOrder(int n, int n2) {
        block5: {
            block4: {
                if (this.mSelectedTab == -1) break block4;
                if (n2 == n - 1) {
                    return this.mSelectedTab;
                }
                if (n2 >= this.mSelectedTab) break block5;
            }
            return n2;
        }
        return n2 + 1;
    }

    public View getChildTabViewAt(int n) {
        return this.getChildAt(n);
    }

    public int getTabCount() {
        return this.getChildCount();
    }

    public boolean isStripEnabled() {
        return this.mDrawBottomStrips;
    }

    @Override
    void measureChildBeforeLayout(View view, int n, int n2, int n3, int n4, int n5) {
        if (!this.isMeasureWithLargestChildEnabled() && this.mImposedTabsHeight >= 0) {
            n2 = View.MeasureSpec.makeMeasureSpec(n3 + this.mImposedTabWidths[n], 0x40000000);
            n4 = View.MeasureSpec.makeMeasureSpec(this.mImposedTabsHeight, 0x40000000);
        }
        super.measureChildBeforeLayout(view, n, n2, n3, n4, n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    void measureHorizontal(int n, int n2) {
        if (View.MeasureSpec.getMode(n) == 0) {
            super.measureHorizontal(n, n2);
            return;
        }
        int n3 = View.MeasureSpec.makeMeasureSpec(0, 0);
        this.mImposedTabsHeight = -1;
        super.measureHorizontal(n3, n2);
        int n4 = this.getMeasuredWidth() - View.MeasureSpec.getSize(n);
        if (n4 > 0) {
            int n5 = this.getChildCount();
            int n6 = 0;
            for (int i = 0; i < n5; ++i) {
                if (this.getChildAt(i).getVisibility() == 8) continue;
                ++n6;
            }
            if (n6 > 0) {
                if (this.mImposedTabWidths == null || this.mImposedTabWidths.length != n5) {
                    this.mImposedTabWidths = new int[n5];
                }
                for (int i = 0; i < n5; ++i) {
                    int n7;
                    View view = this.getChildAt(i);
                    if (view.getVisibility() == 8) continue;
                    int n8 = view.getMeasuredWidth();
                    this.mImposedTabWidths[i] = n7 = Math.max(0, n8 - n4 / n6);
                    n4 -= n8 - n7;
                    --n6;
                    this.mImposedTabsHeight = Math.max(this.mImposedTabsHeight, view.getMeasuredHeight());
                }
            }
        }
        super.measureHorizontal(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @Override
    public void onFocusChange(View view, boolean bl) {
        if (view == this && bl && this.getTabCount() > 0) {
            this.getChildTabViewAt(this.mSelectedTab).requestFocus();
            return;
        }
        if (!bl) return;
        int n = 0;
        int n2 = this.getTabCount();
        while (n < n2) {
            if (this.getChildTabViewAt(n) == view) {
                this.setCurrentTab(n);
                this.mSelectionChangedListener.onTabSelectionChanged(n, false);
                if (!this.isShown()) return;
                this.sendAccessibilityEvent(8);
                return;
            }
            ++n;
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(TabWidget.class.getName());
        accessibilityEvent.setItemCount(this.getTabCount());
        accessibilityEvent.setCurrentItemIndex(this.mSelectedTab);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(TabWidget.class.getName());
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        this.mStripMoved = true;
        super.onSizeChanged(n, n2, n3, n4);
    }

    @Override
    public void removeAllViews() {
        super.removeAllViews();
        this.mSelectedTab = -1;
    }

    @Override
    public void sendAccessibilityEventUnchecked(AccessibilityEvent accessibilityEvent) {
        if (accessibilityEvent.getEventType() == 8 && this.isFocused()) {
            accessibilityEvent.recycle();
            return;
        }
        super.sendAccessibilityEventUnchecked(accessibilityEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCurrentTab(int n) {
        block5: {
            block4: {
                if (n < 0 || n >= this.getTabCount() || n == this.mSelectedTab) break block4;
                if (this.mSelectedTab != -1) {
                    this.getChildTabViewAt(this.mSelectedTab).setSelected(false);
                }
                this.mSelectedTab = n;
                this.getChildTabViewAt(this.mSelectedTab).setSelected(true);
                this.mStripMoved = true;
                if (this.isShown()) break block5;
            }
            return;
        }
        this.sendAccessibilityEvent(4);
    }

    public void setDividerDrawable(int n) {
        this.setDividerDrawable(this.mContext.getDrawable(n));
    }

    @Override
    public void setDividerDrawable(Drawable drawable2) {
        super.setDividerDrawable(drawable2);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        int n = this.getTabCount();
        for (int i = 0; i < n; ++i) {
            this.getChildTabViewAt(i).setEnabled(bl);
        }
    }

    public void setLeftStripDrawable(int n) {
        this.setLeftStripDrawable(this.mContext.getDrawable(n));
    }

    public void setLeftStripDrawable(Drawable drawable2) {
        this.mLeftStrip = drawable2;
        this.requestLayout();
        this.invalidate();
    }

    public void setRightStripDrawable(int n) {
        this.setRightStripDrawable(this.mContext.getDrawable(n));
    }

    public void setRightStripDrawable(Drawable drawable2) {
        this.mRightStrip = drawable2;
        this.requestLayout();
        this.invalidate();
    }

    public void setStripEnabled(boolean bl) {
        this.mDrawBottomStrips = bl;
        this.invalidate();
    }

    void setTabSelectionListener(OnTabSelectionChanged onTabSelectionChanged) {
        this.mSelectionChangedListener = onTabSelectionChanged;
    }

    static interface OnTabSelectionChanged {
        public void onTabSelectionChanged(int var1, boolean var2);
    }

    private class TabClickListener
    implements View.OnClickListener {
        private final int mTabIndex;

        private TabClickListener(int n) {
            this.mTabIndex = n;
        }

        @Override
        public void onClick(View view) {
            TabWidget.this.mSelectionChangedListener.onTabSelectionChanged(this.mTabIndex, true);
        }
    }
}

