/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Insets;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.AllCapsTransformationMethod;
import android.text.method.TransformationMethod2;
import android.util.AttributeSet;
import android.util.FloatProperty;
import android.util.MathUtils;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.CompoundButton;
import com.android.internal.R;

public class Switch
extends CompoundButton {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final int HELVETICA = 4;
    private static final int MONOSPACE = 3;
    private static final int SANS = 1;
    private static final int SERIF = 2;
    private static final int THUMB_ANIMATION_DURATION = 250;
    private static final FloatProperty<Switch> THUMB_POS = new FloatProperty<Switch>("thumbPos"){

        @Override
        public Float get(Switch switch_) {
            return Float.valueOf(switch_.mThumbPosition);
        }

        @Override
        public void setValue(Switch switch_, float f) {
            switch_.setThumbPosition(f);
        }
    };
    private static final int TOUCH_MODE_DOWN = 1;
    private static final int TOUCH_MODE_DRAGGING = 2;
    private static final int TOUCH_MODE_IDLE = 0;
    private static final int WEATHERFONTREG = 5;
    private int mMinFlingVelocity;
    private Layout mOffLayout;
    private Layout mOnLayout;
    private ObjectAnimator mPositionAnimator;
    private boolean mShowText;
    private boolean mSplitTrack;
    private int mSwitchBottom;
    private int mSwitchHeight;
    private int mSwitchLeft;
    private int mSwitchMinWidth;
    private int mSwitchPadding;
    private int mSwitchRight;
    private int mSwitchTop;
    private TransformationMethod2 mSwitchTransformationMethod;
    private int mSwitchWidth;
    private final Rect mTempRect;
    private ColorStateList mTextColors;
    private CharSequence mTextOff;
    private CharSequence mTextOn;
    private TextPaint mTextPaint;
    private Drawable mThumbDrawable;
    private float mThumbPosition;
    private int mThumbTextPadding;
    private int mThumbWidth;
    private int mTouchMode;
    private int mTouchSlop;
    private float mTouchX;
    private float mTouchY;
    private Drawable mTrackDrawable;
    private VelocityTracker mVelocityTracker = VelocityTracker.obtain();

    public Switch(Context context) {
        this(context, null);
    }

    public Switch(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843839);
    }

    public Switch(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public Switch(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mTempRect = new Rect();
        this.mTextPaint = new TextPaint(1);
        Resources resources = this.getResources();
        this.mTextPaint.density = resources.getDisplayMetrics().density;
        this.mTextPaint.setCompatibilityScaling(resources.getCompatibilityInfo().applicationScale);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.Switch, n, n2);
        this.mThumbDrawable = typedArray.getDrawable(2);
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.setCallback(this);
        }
        this.mTrackDrawable = typedArray.getDrawable(4);
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.setCallback(this);
        }
        this.mTextOn = typedArray.getText(0);
        this.mTextOff = typedArray.getText(1);
        this.mShowText = typedArray.getBoolean(9, true);
        this.mThumbTextPadding = typedArray.getDimensionPixelSize(7, 0);
        this.mSwitchMinWidth = typedArray.getDimensionPixelSize(5, 0);
        this.mSwitchPadding = typedArray.getDimensionPixelSize(6, 0);
        this.mSplitTrack = typedArray.getBoolean(8, false);
        int n3 = typedArray.getResourceId(3, 0);
        if (n3 != 0) {
            this.setSwitchTextAppearance(context, n3);
        }
        typedArray.recycle();
        ViewConfiguration viewConfiguration = ViewConfiguration.get(context);
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mMinFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.refreshDrawableState();
        this.setChecked(this.isChecked());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void animateThumbToCheckedState(boolean bl) {
        float f = bl ? 1.0f : 0.0f;
        this.mPositionAnimator = ObjectAnimator.ofFloat(this, THUMB_POS, f);
        this.mPositionAnimator.setDuration(250L);
        this.mPositionAnimator.setAutoCancel(true);
        this.mPositionAnimator.start();
    }

    private void cancelPositionAnimator() {
        if (this.mPositionAnimator != null) {
            this.mPositionAnimator.cancel();
        }
    }

    private void cancelSuperTouch(MotionEvent motionEvent) {
        MotionEvent motionEvent2 = MotionEvent.obtain(motionEvent);
        motionEvent2.setAction(3);
        super.onTouchEvent(motionEvent2);
        motionEvent2.recycle();
    }

    private boolean getTargetCheckedState() {
        return this.mThumbPosition > 0.5f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getThumbOffset() {
        float f;
        if (this.isLayoutRtl()) {
            f = 1.0f - this.mThumbPosition;
            return (int)(0.5f + f * (float)this.getThumbScrollRange());
        }
        f = this.mThumbPosition;
        return (int)(0.5f + f * (float)this.getThumbScrollRange());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getThumbScrollRange() {
        Insets insets;
        if (this.mTrackDrawable == null) return 0;
        Rect rect = this.mTempRect;
        this.mTrackDrawable.getPadding(rect);
        if (this.mThumbDrawable != null) {
            insets = this.mThumbDrawable.getOpticalInsets();
            return this.mSwitchWidth - this.mThumbWidth - rect.left - rect.right - insets.left - insets.right;
        }
        insets = Insets.NONE;
        return this.mSwitchWidth - this.mThumbWidth - rect.left - rect.right - insets.left - insets.right;
    }

    private boolean hitThumb(float f, float f2) {
        int n = this.getThumbOffset();
        this.mThumbDrawable.getPadding(this.mTempRect);
        int n2 = this.mSwitchTop - this.mTouchSlop;
        int n3 = n + this.mSwitchLeft - this.mTouchSlop;
        int n4 = n3 + this.mThumbWidth + this.mTempRect.left + this.mTempRect.right + this.mTouchSlop;
        int n5 = this.mSwitchBottom + this.mTouchSlop;
        return f > (float)n3 && f < (float)n4 && f2 > (float)n2 && f2 < (float)n5;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Layout makeLayout(CharSequence charSequence) {
        CharSequence charSequence2;
        if (this.mSwitchTransformationMethod != null) {
            charSequence2 = this.mSwitchTransformationMethod.getTransformation(charSequence, this);
            return new StaticLayout(charSequence2, this.mTextPaint, (int)Math.ceil(Layout.getDesiredWidth(charSequence2, this.mTextPaint)), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        }
        charSequence2 = charSequence;
        return new StaticLayout(charSequence2, this.mTextPaint, (int)Math.ceil(Layout.getDesiredWidth(charSequence2, this.mTextPaint)), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setSwitchTypefaceByIndex(int n, int n2) {
        Typeface typeface = null;
        switch (n) {
            case 1: {
                typeface = Typeface.SANS_SERIF;
                break;
            }
            case 2: {
                typeface = Typeface.SERIF;
                break;
            }
            case 3: {
                typeface = Typeface.MONOSPACE;
                break;
            }
            case 4: {
                typeface = Typeface.HELVETICA;
                break;
            }
            case 5: {
                typeface = Typeface.WEATHERFONTREG;
                break;
            }
        }
        this.setSwitchTypeface(typeface, n2);
    }

    private void setThumbPosition(float f) {
        this.mThumbPosition = f;
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void stopDrag(MotionEvent motionEvent) {
        int n;
        block6: {
            block4: {
                block5: {
                    n = 1;
                    this.mTouchMode = 0;
                    int n2 = motionEvent.getAction() == n && this.isEnabled() ? n : 0;
                    if (n2 == 0) break block4;
                    this.mVelocityTracker.computeCurrentVelocity(1000);
                    float f = this.mVelocityTracker.getXVelocity();
                    if (!(Math.abs(f) > (float)this.mMinFlingVelocity)) break block5;
                    if (this.isLayoutRtl()) {
                        if (!(f < 0.0f)) {
                            n = 0;
                        }
                        break block6;
                    } else if (!(f > 0.0f)) {
                        n = 0;
                    }
                    break block6;
                }
                n = this.getTargetCheckedState();
                break block6;
            }
            n = this.isChecked() ? 1 : 0;
        }
        this.setChecked(n != 0);
        this.cancelSuperTouch(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Canvas canvas) {
        Rect rect = this.mTempRect;
        int n = this.mSwitchLeft;
        int n2 = this.mSwitchTop;
        int n3 = this.mSwitchRight;
        int n4 = this.mSwitchBottom;
        int n5 = n + this.getThumbOffset();
        Insets insets = this.mThumbDrawable != null ? this.mThumbDrawable.getOpticalInsets() : Insets.NONE;
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.getPadding(rect);
            n5 += rect.left;
            int n6 = n;
            int n7 = n2;
            int n8 = n3;
            int n9 = n4;
            if (insets != Insets.NONE) {
                if (insets.left > rect.left) {
                    n6 += insets.left - rect.left;
                }
                if (insets.top > rect.top) {
                    n7 += insets.top - rect.top;
                }
                if (insets.right > rect.right) {
                    n8 -= insets.right - rect.right;
                }
                if (insets.bottom > rect.bottom) {
                    n9 -= insets.bottom - rect.bottom;
                }
            }
            this.mTrackDrawable.setBounds(n6, n7, n8, n9);
        }
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.getPadding(rect);
            int n10 = n5 - rect.left;
            int n11 = n5 + this.mThumbWidth + rect.right;
            this.mThumbDrawable.setBounds(n10, n2, n11, n4);
            Drawable drawable2 = this.getBackground();
            if (drawable2 != null) {
                drawable2.setHotspotBounds(n10, n2, n11, n4);
            }
        }
        super.draw(canvas);
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        super.drawableHotspotChanged(f, f2);
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.setHotspot(f, f2);
        }
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.setHotspot(f, f2);
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        int[] nArray = this.getDrawableState();
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.setState(nArray);
        }
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.setState(nArray);
        }
        this.invalidate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getCompoundPaddingLeft() {
        if (!this.isLayoutRtl()) {
            return super.getCompoundPaddingLeft();
        }
        int n = super.getCompoundPaddingLeft() + this.mSwitchWidth;
        if (TextUtils.isEmpty(this.getText())) return n;
        return n + this.mSwitchPadding;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getCompoundPaddingRight() {
        if (this.isLayoutRtl()) {
            return super.getCompoundPaddingRight();
        }
        int n = super.getCompoundPaddingRight() + this.mSwitchWidth;
        if (TextUtils.isEmpty(this.getText())) return n;
        return n + this.mSwitchPadding;
    }

    public boolean getShowText() {
        return this.mShowText;
    }

    public boolean getSplitTrack() {
        return this.mSplitTrack;
    }

    public int getSwitchMinWidth() {
        return this.mSwitchMinWidth;
    }

    public int getSwitchPadding() {
        return this.mSwitchPadding;
    }

    public CharSequence getTextOff() {
        return this.mTextOff;
    }

    public CharSequence getTextOn() {
        return this.mTextOn;
    }

    public Drawable getThumbDrawable() {
        return this.mThumbDrawable;
    }

    public int getThumbTextPadding() {
        return this.mThumbTextPadding;
    }

    public Drawable getTrackDrawable() {
        return this.mTrackDrawable;
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.jumpToCurrentState();
        }
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.jumpToCurrentState();
        }
        if (this.mPositionAnimator != null && this.mPositionAnimator.isRunning()) {
            this.mPositionAnimator.end();
            this.mPositionAnimator = null;
        }
    }

    @Override
    protected int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 1);
        if (this.isChecked()) {
            Switch.mergeDrawableStates(nArray, CHECKED_STATE_SET);
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDraw(Canvas canvas) {
        Layout layout2;
        super.onDraw(canvas);
        Rect rect = this.mTempRect;
        Drawable drawable2 = this.mTrackDrawable;
        if (drawable2 != null) {
            drawable2.getPadding(rect);
        } else {
            rect.setEmpty();
        }
        int n = this.mSwitchTop;
        int n2 = this.mSwitchBottom;
        int n3 = n + rect.top;
        int n4 = n2 - rect.bottom;
        Drawable drawable3 = this.mThumbDrawable;
        if (drawable2 != null) {
            if (this.mSplitTrack && drawable3 != null) {
                Insets insets = drawable3.getOpticalInsets();
                drawable3.copyBounds(rect);
                rect.left += insets.left;
                rect.right -= insets.right;
                int n5 = canvas.save();
                canvas.clipRect(rect, Region.Op.DIFFERENCE);
                drawable2.draw(canvas);
                canvas.restoreToCount(n5);
            } else {
                drawable2.draw(canvas);
            }
        }
        int n6 = canvas.save();
        if (drawable3 != null) {
            drawable3.draw(canvas);
        }
        if ((layout2 = this.getTargetCheckedState() ? this.mOnLayout : this.mOffLayout) != null) {
            int n7;
            int[] nArray = this.getDrawableState();
            if (this.mTextColors != null) {
                this.mTextPaint.setColor(this.mTextColors.getColorForState(nArray, 0));
            }
            this.mTextPaint.drawableState = nArray;
            if (drawable3 != null) {
                Rect rect2 = drawable3.getBounds();
                n7 = rect2.left + rect2.right;
            } else {
                n7 = this.getWidth();
            }
            int n8 = n7 / 2 - layout2.getWidth() / 2;
            int n9 = (n3 + n4) / 2 - layout2.getHeight() / 2;
            canvas.translate(n8, n9);
            layout2.draw(canvas);
        }
        canvas.restoreToCount(n6);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(Switch.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(Switch.class.getName());
        CharSequence charSequence = this.isChecked() ? this.mTextOn : this.mTextOff;
        if (!TextUtils.isEmpty(charSequence)) {
            CharSequence charSequence2 = accessibilityNodeInfo.getText();
            if (!TextUtils.isEmpty(charSequence2)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(charSequence2).append(' ').append(charSequence);
                accessibilityNodeInfo.setText(stringBuilder);
                return;
            }
            accessibilityNodeInfo.setText(charSequence);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        super.onLayout(bl, n, n2, n3, n4);
        Drawable drawable2 = this.mThumbDrawable;
        int n9 = 0;
        int n10 = 0;
        if (drawable2 != null) {
            Rect rect = this.mTempRect;
            if (this.mTrackDrawable != null) {
                this.mTrackDrawable.getPadding(rect);
            } else {
                rect.setEmpty();
            }
            Insets insets = this.mThumbDrawable.getOpticalInsets();
            n9 = Math.max(0, insets.left - rect.left);
            n10 = Math.max(0, insets.right - rect.right);
        }
        if (this.isLayoutRtl()) {
            n8 = n9 + this.getPaddingLeft();
            n7 = n8 + this.mSwitchWidth - n9 - n10;
        } else {
            n7 = this.getWidth() - this.getPaddingRight() - n10;
            n8 = n10 + (n9 + (n7 - this.mSwitchWidth));
        }
        switch (0x70 & this.getGravity()) {
            default: {
                n6 = this.getPaddingTop();
                n5 = n6 + this.mSwitchHeight;
                break;
            }
            case 16: {
                n6 = (this.getPaddingTop() + this.getHeight() - this.getPaddingBottom()) / 2 - this.mSwitchHeight / 2;
                n5 = n6 + this.mSwitchHeight;
                break;
            }
            case 80: {
                n5 = this.getHeight() - this.getPaddingBottom();
                n6 = n5 - this.mSwitchHeight;
            }
        }
        this.mSwitchLeft = n8;
        this.mSwitchTop = n6;
        this.mSwitchBottom = n5;
        this.mSwitchRight = n7;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onMeasure(int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (this.mShowText) {
            if (this.mOnLayout == null) {
                this.mOnLayout = this.makeLayout(this.mTextOn);
            }
            if (this.mOffLayout == null) {
                this.mOffLayout = this.makeLayout(this.mTextOff);
            }
        }
        Rect rect = this.mTempRect;
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.getPadding(rect);
            n5 = this.mThumbDrawable.getIntrinsicWidth() - rect.left - rect.right;
            n4 = this.mThumbDrawable.getIntrinsicHeight();
        } else {
            n4 = 0;
            n5 = 0;
        }
        int n6 = this.mShowText ? Math.max(this.mOnLayout.getWidth(), this.mOffLayout.getWidth()) + 2 * this.mThumbTextPadding : 0;
        this.mThumbWidth = Math.max(n6, n5);
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.getPadding(rect);
            n3 = this.mTrackDrawable.getIntrinsicHeight();
        } else {
            rect.setEmpty();
            n3 = 0;
        }
        int n7 = rect.left;
        int n8 = rect.right;
        if (this.mThumbDrawable != null) {
            Insets insets = this.mThumbDrawable.getOpticalInsets();
            n7 = Math.max(n7, insets.left);
            n8 = Math.max(n8, insets.right);
        }
        int n9 = Math.max(this.mSwitchMinWidth, n8 + (n7 + 2 * this.mThumbWidth));
        int n10 = Math.max(n3, n4);
        this.mSwitchWidth = n9;
        this.mSwitchHeight = n10;
        super.onMeasure(n, n2);
        if (this.getMeasuredHeight() < n10) {
            this.setMeasuredDimension(this.getMeasuredWidthAndState(), n10);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onPopulateAccessibilityEvent(accessibilityEvent);
        CharSequence charSequence = this.isChecked() ? this.mTextOn : this.mTextOff;
        if (charSequence != null) {
            accessibilityEvent.getText().add(charSequence);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.mVelocityTracker.addMovement(motionEvent);
        switch (motionEvent.getActionMasked()) {
            case 0: {
                float f = motionEvent.getX();
                float f2 = motionEvent.getY();
                if (!this.isEnabled()) return super.onTouchEvent(motionEvent);
                if (!this.hitThumb(f, f2)) return super.onTouchEvent(motionEvent);
                this.mTouchMode = 1;
                this.mTouchX = f;
                this.mTouchY = f2;
                return super.onTouchEvent(motionEvent);
            }
            case 2: {
                switch (this.mTouchMode) {
                    default: {
                        return super.onTouchEvent(motionEvent);
                    }
                    case 1: {
                        float f = motionEvent.getX();
                        float f3 = motionEvent.getY();
                        if (!(Math.abs(f - this.mTouchX) > (float)this.mTouchSlop)) {
                            if (!(Math.abs(f3 - this.mTouchY) > (float)this.mTouchSlop)) return super.onTouchEvent(motionEvent);
                        }
                        this.mTouchMode = 2;
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                        this.mTouchX = f;
                        this.mTouchY = f3;
                        return true;
                    }
                    case 2: {
                        float f;
                        float f4 = motionEvent.getX();
                        int n = this.getThumbScrollRange();
                        float f5 = f4 - this.mTouchX;
                        float f6 = n != 0 ? f5 / (float)n : (f5 > 0.0f ? 1.0f : -1.0f);
                        if (this.isLayoutRtl()) {
                            f6 = -f6;
                        }
                        if ((f = MathUtils.constrain(f6 + this.mThumbPosition, 0.0f, 1.0f)) == this.mThumbPosition) return true;
                        this.mTouchX = f4;
                        this.setThumbPosition(f);
                        return true;
                    }
                    case 0: 
                }
                return super.onTouchEvent(motionEvent);
            }
            case 1: 
            case 3: {
                if (this.mTouchMode == 2) {
                    this.stopDrag(motionEvent);
                    super.onTouchEvent(motionEvent);
                    return true;
                }
                this.mTouchMode = 0;
                this.mVelocityTracker.clear();
                return super.onTouchEvent(motionEvent);
            }
        }
        return super.onTouchEvent(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setChecked(boolean bl) {
        super.setChecked(bl);
        boolean bl2 = this.isChecked();
        if (this.isAttachedToWindow() && this.isLaidOut()) {
            this.animateThumbToCheckedState(bl2);
            return;
        }
        this.cancelPositionAnimator();
        float f = bl2 ? 1.0f : 0.0f;
        this.setThumbPosition(f);
    }

    public void setShowText(boolean bl) {
        if (this.mShowText != bl) {
            this.mShowText = bl;
            this.requestLayout();
        }
    }

    public void setSplitTrack(boolean bl) {
        this.mSplitTrack = bl;
        this.invalidate();
    }

    public void setSwitchMinWidth(int n) {
        this.mSwitchMinWidth = n;
        this.requestLayout();
    }

    public void setSwitchPadding(int n) {
        this.mSwitchPadding = n;
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSwitchTextAppearance(Context context, int n) {
        TypedArray typedArray = context.obtainStyledAttributes(n, R.styleable.TextAppearance);
        ColorStateList colorStateList = typedArray.getColorStateList(3);
        this.mTextColors = colorStateList != null ? colorStateList : this.getTextColors();
        int n2 = typedArray.getDimensionPixelSize(0, 0);
        if (n2 != 0 && (float)n2 != this.mTextPaint.getTextSize()) {
            this.mTextPaint.setTextSize(n2);
            this.requestLayout();
        }
        this.setSwitchTypefaceByIndex(typedArray.getInt(1, -1), typedArray.getInt(2, -1));
        if (typedArray.getBoolean(11, false)) {
            this.mSwitchTransformationMethod = new AllCapsTransformationMethod(this.getContext());
            this.mSwitchTransformationMethod.setLengthChangesAllowed(true);
        } else {
            this.mSwitchTransformationMethod = null;
        }
        typedArray.recycle();
    }

    public void setSwitchTypeface(Typeface typeface) {
        if (this.mTextPaint.getTypeface() != typeface) {
            this.mTextPaint.setTypeface(typeface);
            this.requestLayout();
            this.invalidate();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSwitchTypeface(Typeface typeface, int n) {
        if (n <= 0) {
            this.mTextPaint.setFakeBoldText(false);
            this.mTextPaint.setTextSkewX(0.0f);
            this.setSwitchTypeface(typeface);
            return;
        }
        Typeface typeface2 = typeface == null ? Typeface.defaultFromStyle(n) : Typeface.create(typeface, n);
        this.setSwitchTypeface(typeface2);
        int n2 = typeface2 != null ? typeface2.getStyle() : 0;
        int n3 = n & ~n2;
        TextPaint textPaint = this.mTextPaint;
        int n4 = n3 & 1;
        boolean bl = false;
        if (n4 != 0) {
            bl = true;
        }
        textPaint.setFakeBoldText(bl);
        TextPaint textPaint2 = this.mTextPaint;
        float f = (n3 & 2) != 0 ? -0.25f : 0.0f;
        textPaint2.setTextSkewX(f);
    }

    public void setTextOff(CharSequence charSequence) {
        this.mTextOff = charSequence;
        this.requestLayout();
    }

    public void setTextOn(CharSequence charSequence) {
        this.mTextOn = charSequence;
        this.requestLayout();
    }

    public void setThumbDrawable(Drawable drawable2) {
        if (this.mThumbDrawable != null) {
            this.mThumbDrawable.setCallback(null);
        }
        this.mThumbDrawable = drawable2;
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
        this.requestLayout();
    }

    public void setThumbResource(int n) {
        this.setThumbDrawable(this.getContext().getDrawable(n));
    }

    public void setThumbTextPadding(int n) {
        this.mThumbTextPadding = n;
        this.requestLayout();
    }

    public void setTrackDrawable(Drawable drawable2) {
        if (this.mTrackDrawable != null) {
            this.mTrackDrawable.setCallback(null);
        }
        this.mTrackDrawable = drawable2;
        if (drawable2 != null) {
            drawable2.setCallback(this);
        }
        this.requestLayout();
    }

    public void setTrackResource(int n) {
        this.setTrackDrawable(this.getContext().getDrawable(n));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void toggle() {
        boolean bl = !this.isChecked();
        this.setChecked(bl);
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return super.verifyDrawable(drawable2) || drawable2 == this.mThumbDrawable || drawable2 == this.mTrackDrawable;
    }
}

