/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AnimationUtils;
import android.widget.EdgeEffect;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import com.android.internal.R;
import java.util.ArrayList;

public class ScrollView
extends FrameLayout {
    static final int ANIMATED_SCROLL_GAP = 250;
    private static final int INVALID_POINTER = -1;
    static final float MAX_SCROLL_FACTOR = 0.5f;
    private static final String TAG = "ScrollView";
    private int mActivePointerId = -1;
    private View mChildToScrollTo = null;
    private EdgeEffect mEdgeGlowBottom;
    private EdgeEffect mEdgeGlowTop;
    @ViewDebug.ExportedProperty(category="layout")
    private boolean mFillViewport;
    private StrictMode.Span mFlingStrictSpan = null;
    private boolean mIsBeingDragged = false;
    private boolean mIsLayoutDirty = true;
    private int mLastMotionY;
    private long mLastScroll;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    private int mNestedYOffset;
    private int mOverflingDistance;
    private int mOverscrollDistance;
    private SavedState mSavedState;
    private final int[] mScrollConsumed;
    private final int[] mScrollOffset;
    private StrictMode.Span mScrollStrictSpan = null;
    private OverScroller mScroller;
    private boolean mSmoothScrollingEnabled = true;
    private final Rect mTempRect = new Rect();
    private int mTouchSlop;
    private VelocityTracker mVelocityTracker;

    public ScrollView(Context context) {
        this(context, null);
    }

    public ScrollView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010080);
    }

    public ScrollView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public ScrollView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mScrollOffset = new int[2];
        this.mScrollConsumed = new int[2];
        this.initScrollView();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ScrollView, n, n2);
        this.setFillViewport(typedArray.getBoolean(0, false));
        typedArray.recycle();
    }

    private boolean canScroll() {
        View view = this.getChildAt(0);
        boolean bl = false;
        if (view != null) {
            int n = view.getHeight();
            int n2 = this.getHeight();
            int n3 = n + this.mPaddingTop + this.mPaddingBottom;
            bl = false;
            if (n2 < n3) {
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int clamp(int n, int n2, int n3) {
        if (n2 >= n3) return 0;
        if (n < 0) {
            return 0;
        }
        if (n2 + n <= n3) return n;
        return n3 - n2;
    }

    private void doScrollY(int n) {
        block3: {
            block2: {
                if (n == 0) break block2;
                if (!this.mSmoothScrollingEnabled) break block3;
                this.smoothScrollBy(0, n);
            }
            return;
        }
        this.scrollBy(0, n);
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.recycleVelocityTracker();
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
        }
        if (this.mScrollStrictSpan != null) {
            this.mScrollStrictSpan.finish();
            this.mScrollStrictSpan = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private View findFocusableViewInBounds(boolean bl, int n, int n2) {
        ArrayList<View> arrayList = this.getFocusables(2);
        View view = null;
        boolean bl2 = false;
        int n3 = arrayList.size();
        int n4 = 0;
        while (n4 < n3) {
            View view2 = (View)arrayList.get(n4);
            int n5 = view2.getTop();
            int n6 = view2.getBottom();
            if (n < n6 && n5 < n2) {
                boolean bl3 = n < n5 && n6 < n2;
                if (view == null) {
                    view = view2;
                    bl2 = bl3;
                } else {
                    boolean bl4 = bl && n5 < view.getTop() || !bl && n6 > view.getBottom();
                    if (bl2) {
                        if (bl3 && bl4) {
                            view = view2;
                        }
                    } else if (bl3) {
                        view = view2;
                        bl2 = true;
                    } else if (bl4) {
                        view = view2;
                    }
                }
            }
            ++n4;
        }
        return view;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void flingWithNestedDispatch(int n) {
        boolean bl = !(this.mScrollY <= 0 && n <= 0 || this.mScrollY >= this.getScrollRange() && n >= 0);
        if (!this.dispatchNestedPreFling(0.0f, n)) {
            this.dispatchNestedFling(0.0f, n, bl);
            if (bl) {
                this.fling(n);
            }
        }
    }

    private int getScrollRange() {
        int n = this.getChildCount();
        int n2 = 0;
        if (n > 0) {
            n2 = Math.max(0, this.getChildAt(0).getHeight() - (this.getHeight() - this.mPaddingBottom - this.mPaddingTop));
        }
        return n2;
    }

    private boolean inChild(int n, int n2) {
        int n3 = this.getChildCount();
        boolean bl = false;
        if (n3 > 0) {
            int n4 = this.mScrollY;
            View view = this.getChildAt(0);
            int n5 = view.getTop() - n4;
            bl = false;
            if (n2 >= n5) {
                int n6 = view.getBottom() - n4;
                bl = false;
                if (n2 < n6) {
                    int n7 = view.getLeft();
                    bl = false;
                    if (n >= n7) {
                        int n8 = view.getRight();
                        bl = false;
                        if (n < n8) {
                            bl = true;
                        }
                    }
                }
            }
        }
        return bl;
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
            return;
        }
        this.mVelocityTracker.clear();
    }

    private void initScrollView() {
        this.mScroller = new OverScroller(this.getContext());
        this.setFocusable(true);
        this.setDescendantFocusability(262144);
        this.setWillNotDraw(false);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(this.mContext);
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mMinimumVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mOverscrollDistance = viewConfiguration.getScaledOverscrollDistance();
        this.mOverflingDistance = viewConfiguration.getScaledOverflingDistance();
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private boolean isOffScreen(View view) {
        boolean bl = this.isWithinDeltaOfScreen(view, 0, this.getHeight());
        boolean bl2 = false;
        if (!bl) {
            bl2 = true;
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean isViewDescendantOf(View view, View view2) {
        ViewParent viewParent;
        return view == view2 || (viewParent = view.getParent()) instanceof ViewGroup && ScrollView.isViewDescendantOf((View)((Object)viewParent), view2);
    }

    private boolean isWithinDeltaOfScreen(View view, int n, int n2) {
        view.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(view, this.mTempRect);
        return n + this.mTempRect.bottom >= this.getScrollY() && this.mTempRect.top - n <= n2 + this.getScrollY();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        int n = (0xFF00 & motionEvent.getAction()) >> 8;
        if (motionEvent.getPointerId(n) == this.mActivePointerId) {
            int n2 = n == 0 ? 1 : 0;
            this.mLastMotionY = (int)motionEvent.getY(n2);
            this.mActivePointerId = motionEvent.getPointerId(n2);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean scrollAndFocus(int n, int n2, int n3) {
        boolean bl = true;
        int n4 = this.getHeight();
        int n5 = this.getScrollY();
        int n6 = n5 + n4;
        boolean bl2 = n == 33;
        View view = this.findFocusableViewInBounds(bl2, n2, n3);
        if (view == null) {
            view = this;
        }
        if (n2 >= n5 && n3 <= n6) {
            bl = false;
        } else {
            int n7 = bl2 ? n2 - n5 : n3 - n6;
            this.doScrollY(n7);
        }
        if (view != this.findFocus()) {
            view.requestFocus(n);
        }
        return bl;
    }

    private void scrollToChild(View view) {
        view.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(view, this.mTempRect);
        int n = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
        if (n != 0) {
            this.scrollBy(0, n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean scrollToChildRect(Rect rect, boolean bl) {
        int n = this.computeScrollDeltaToGetChildRectOnScreen(rect);
        if (n == 0) return false;
        boolean bl2 = true;
        if (!bl2) return bl2;
        if (bl) {
            this.scrollBy(0, n);
            return bl2;
        }
        this.smoothScrollBy(0, n);
        return bl2;
    }

    @Override
    public void addView(View view) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(view);
    }

    @Override
    public void addView(View view, int n) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(view, n);
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(view, n, layoutParams);
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("ScrollView can host only one direct child");
        }
        super.addView(view, layoutParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean arrowScroll(int n) {
        View view = this.findFocus();
        if (view == this) {
            view = null;
        }
        View view2 = FocusFinder.getInstance().findNextFocus(this, view, n);
        int n2 = this.getMaxScrollAmount();
        if (view2 != null && this.isWithinDeltaOfScreen(view2, n2, this.getHeight())) {
            view2.getDrawingRect(this.mTempRect);
            this.offsetDescendantRectToMyCoords(view2, this.mTempRect);
            this.doScrollY(this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect));
            view2.requestFocus(n);
        } else {
            int n3;
            int n4;
            int n5 = n2;
            if (n == 33 && this.getScrollY() < n5) {
                n5 = this.getScrollY();
            } else if (n == 130 && this.getChildCount() > 0 && (n4 = this.getChildAt(0).getBottom()) - (n3 = this.getScrollY() + this.getHeight() - this.mPaddingBottom) < n2) {
                n5 = n4 - n3;
            }
            boolean bl = false;
            if (n5 == 0) return bl;
            int n6 = n == 130 ? n5 : -n5;
            this.doScrollY(n6);
        }
        if (view == null) return true;
        if (!view.isFocused()) return true;
        if (!this.isOffScreen(view)) return true;
        int n7 = this.getDescendantFocusability();
        this.setDescendantFocusability(131072);
        this.requestFocus();
        this.setDescendantFocusability(n7);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void computeScroll() {
        int n = 1;
        if (this.mScroller.computeScrollOffset()) {
            int n2 = this.mScrollX;
            int n3 = this.mScrollY;
            int n4 = this.mScroller.getCurrX();
            int n5 = this.mScroller.getCurrY();
            if (n2 != n4 || n3 != n5) {
                int n6 = this.getScrollRange();
                int n7 = this.getOverScrollMode();
                if (n7 != 0 && (n7 != n || n6 <= 0)) {
                    n = 0;
                }
                this.overScrollBy(n4 - n2, n5 - n3, n2, n3, 0, n6, 0, this.mOverflingDistance, false);
                this.onScrollChanged(this.mScrollX, this.mScrollY, n2, n3);
                if (n != 0) {
                    if (n5 < 0 && n3 >= 0) {
                        this.mEdgeGlowTop.onAbsorb((int)this.mScroller.getCurrVelocity());
                    } else if (n5 > n6 && n3 <= n6) {
                        this.mEdgeGlowBottom.onAbsorb((int)this.mScroller.getCurrVelocity());
                    }
                }
            }
            if (this.awakenScrollBars()) return;
            this.postInvalidateOnAnimation();
            return;
        }
        if (this.mFlingStrictSpan == null) return;
        this.mFlingStrictSpan.finish();
        this.mFlingStrictSpan = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int computeScrollDeltaToGetChildRectOnScreen(Rect rect) {
        int n;
        if (this.getChildCount() == 0) {
            return 0;
        }
        int n2 = this.getHeight();
        int n3 = this.getScrollY();
        int n4 = n3 + n2;
        int n5 = this.getVerticalFadingEdgeLength();
        if (rect.top > 0) {
            n3 += n5;
        }
        if (rect.bottom < this.getChildAt(0).getHeight()) {
            n4 -= n5;
        }
        if (rect.bottom > n4 && rect.top > n3) {
            int n6;
            if (rect.height() > n2) {
                n6 = 0 + (rect.top - n3);
                return Math.min(n6, this.getChildAt(0).getBottom() - n4);
            }
            n6 = 0 + (rect.bottom - n4);
            return Math.min(n6, this.getChildAt(0).getBottom() - n4);
        }
        if (rect.top >= n3) return 0;
        if (rect.bottom >= n4) return 0;
        if (rect.height() > n2) {
            n = 0 - (n4 - rect.bottom);
            return Math.max(n, -this.getScrollY());
        }
        n = 0 - (n3 - rect.top);
        return Math.max(n, -this.getScrollY());
    }

    @Override
    protected int computeVerticalScrollOffset() {
        return Math.max(0, super.computeVerticalScrollOffset());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int computeVerticalScrollRange() {
        int n = this.getChildCount();
        int n2 = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
        if (n == 0) {
            return n2;
        }
        int n3 = this.getChildAt(0).getBottom();
        int n4 = this.mScrollY;
        int n5 = Math.max(0, n3 - n2);
        if (n4 < 0) {
            n3 -= n4;
            return n3;
        }
        if (n4 <= n5) return n3;
        return n3 += n4 - n5;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return super.dispatchKeyEvent(keyEvent) || this.executeKeyEvent(keyEvent);
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mEdgeGlowTop != null) {
            int n = this.mScrollY;
            if (!this.mEdgeGlowTop.isFinished()) {
                int n2 = canvas.save();
                int n3 = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
                canvas.translate(this.mPaddingLeft, Math.min(0, n));
                this.mEdgeGlowTop.setSize(n3, this.getHeight());
                if (this.mEdgeGlowTop.draw(canvas)) {
                    this.postInvalidateOnAnimation();
                }
                canvas.restoreToCount(n2);
            }
            if (!this.mEdgeGlowBottom.isFinished()) {
                int n4 = canvas.save();
                int n5 = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
                int n6 = this.getHeight();
                canvas.translate(-n5 + this.mPaddingLeft, n6 + Math.max(this.getScrollRange(), n));
                canvas.rotate(180.0f, n5, 0.0f);
                this.mEdgeGlowBottom.setSize(n5, n6);
                if (this.mEdgeGlowBottom.draw(canvas)) {
                    this.postInvalidateOnAnimation();
                }
                canvas.restoreToCount(n4);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean executeKeyEvent(KeyEvent keyEvent) {
        this.mTempRect.setEmpty();
        if (!this.canScroll()) {
            boolean bl = this.isFocused();
            boolean bl2 = false;
            if (!bl) return bl2;
            int n = keyEvent.getKeyCode();
            bl2 = false;
            if (n == 4) return bl2;
            View view = this.findFocus();
            if (view == this) {
                view = null;
            }
            View view2 = FocusFinder.getInstance().findNextFocus(this, view, 130);
            bl2 = false;
            if (view2 == null) return bl2;
            bl2 = false;
            if (view2 == this) return bl2;
            boolean bl3 = view2.requestFocus(130);
            bl2 = false;
            if (!bl3) return bl2;
            return true;
        }
        int n = keyEvent.getAction();
        boolean bl = false;
        if (n != 0) return bl;
        int n2 = keyEvent.getKeyCode();
        bl = false;
        switch (n2) {
            case 19: {
                if (keyEvent.isAltPressed()) return this.fullScroll(33);
                return this.arrowScroll(33);
            }
            case 20: {
                if (keyEvent.isAltPressed()) return this.fullScroll(130);
                return this.arrowScroll(130);
            }
            case 62: {
                int n3 = keyEvent.isShiftPressed() ? 33 : 130;
                this.pageScroll(n3);
                return false;
            }
        }
        return bl;
    }

    public void fling(int n) {
        if (this.getChildCount() > 0) {
            int n2 = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
            int n3 = this.getChildAt(0).getHeight();
            this.mScroller.fling(this.mScrollX, this.mScrollY, 0, n, 0, 0, 0, Math.max(0, n3 - n2), 0, n2 / 2);
            if (this.mFlingStrictSpan == null) {
                this.mFlingStrictSpan = StrictMode.enterCriticalSpan("ScrollView-fling");
            }
            this.postInvalidateOnAnimation();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean fullScroll(int n) {
        int n2;
        boolean bl = n == 130;
        int n3 = this.getHeight();
        this.mTempRect.top = 0;
        this.mTempRect.bottom = n3;
        if (bl && (n2 = this.getChildCount()) > 0) {
            View view = this.getChildAt(n2 - 1);
            this.mTempRect.bottom = view.getBottom() + this.mPaddingBottom;
            this.mTempRect.top = this.mTempRect.bottom - n3;
        }
        return this.scrollAndFocus(n, this.mTempRect.top, this.mTempRect.bottom);
    }

    @Override
    protected float getBottomFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int n = this.getVerticalFadingEdgeLength();
        int n2 = this.getHeight() - this.mPaddingBottom;
        int n3 = this.getChildAt(0).getBottom() - this.mScrollY - n2;
        if (n3 < n) {
            return (float)n3 / (float)n;
        }
        return 1.0f;
    }

    public int getMaxScrollAmount() {
        return (int)(0.5f * (float)(this.mBottom - this.mTop));
    }

    @Override
    protected float getTopFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int n = this.getVerticalFadingEdgeLength();
        if (this.mScrollY < n) {
            return (float)this.mScrollY / (float)n;
        }
        return 1.0f;
    }

    public boolean isFillViewport() {
        return this.mFillViewport;
    }

    public boolean isSmoothScrollingEnabled() {
        return this.mSmoothScrollingEnabled;
    }

    @Override
    protected void measureChild(View view, int n, int n2) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        view.measure(ScrollView.getChildMeasureSpec(n, this.mPaddingLeft + this.mPaddingRight, layoutParams.width), View.MeasureSpec.makeMeasureSpec(0, 0));
    }

    @Override
    protected void measureChildWithMargins(View view, int n, int n2, int n3, int n4) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        view.measure(ScrollView.getChildMeasureSpec(n, n2 + (this.mPaddingLeft + this.mPaddingRight + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin), marginLayoutParams.width), View.MeasureSpec.makeMeasureSpec(marginLayoutParams.topMargin + marginLayoutParams.bottomMargin, 0));
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mScrollStrictSpan != null) {
            this.mScrollStrictSpan.finish();
            this.mScrollStrictSpan = null;
        }
        if (this.mFlingStrictSpan != null) {
            this.mFlingStrictSpan.finish();
            this.mFlingStrictSpan = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if ((2 & motionEvent.getSource()) == 0) return super.onGenericMotionEvent(motionEvent);
        switch (motionEvent.getAction()) {
            default: {
                return super.onGenericMotionEvent(motionEvent);
            }
            case 8: {
                float f;
                if (this.mIsBeingDragged || (f = motionEvent.getAxisValue(9)) == 0.0f) return super.onGenericMotionEvent(motionEvent);
                int n = (int)(f * this.getVerticalScrollFactor());
                int n2 = this.getScrollRange();
                int n3 = this.mScrollY;
                int n4 = n3 - n;
                if (n4 < 0) {
                    n4 = 0;
                } else if (n4 > n2) {
                    n4 = n2;
                }
                if (n4 == n3) return super.onGenericMotionEvent(motionEvent);
                super.scrollTo(this.mScrollX, n4);
                return true;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(ScrollView.class.getName());
        boolean bl = this.getScrollRange() > 0;
        accessibilityEvent.setScrollable(bl);
        accessibilityEvent.setScrollX(this.mScrollX);
        accessibilityEvent.setScrollY(this.mScrollY);
        accessibilityEvent.setMaxScrollX(this.mScrollX);
        accessibilityEvent.setMaxScrollY(this.getScrollRange());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        int n;
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(ScrollView.class.getName());
        if (this.isEnabled() && (n = this.getScrollRange()) > 0) {
            accessibilityNodeInfo.setScrollable(true);
            if (this.mScrollY > 0) {
                accessibilityNodeInfo.addAction(8192);
            }
            if (this.mScrollY < n) {
                accessibilityNodeInfo.addAction(4096);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        if (n == 2 && this.mIsBeingDragged) {
            return true;
        }
        if (this.getScrollY() == 0 && !this.canScrollVertically(1)) {
            return false;
        }
        switch (n & 0xFF) {
            case 2: {
                ViewParent viewParent;
                int n2 = this.mActivePointerId;
                if (n2 == -1) return this.mIsBeingDragged;
                int n3 = motionEvent.findPointerIndex(n2);
                if (n3 == -1) {
                    Log.e(TAG, "Invalid pointerId=" + n2 + " in onInterceptTouchEvent");
                    return this.mIsBeingDragged;
                }
                int n4 = (int)motionEvent.getY(n3);
                if (Math.abs(n4 - this.mLastMotionY) <= this.mTouchSlop) return this.mIsBeingDragged;
                if ((2 & this.getNestedScrollAxes()) != 0) return this.mIsBeingDragged;
                this.mIsBeingDragged = true;
                this.mLastMotionY = n4;
                this.initVelocityTrackerIfNotExists();
                this.mVelocityTracker.addMovement(motionEvent);
                this.mNestedYOffset = 0;
                if (this.mScrollStrictSpan == null) {
                    this.mScrollStrictSpan = StrictMode.enterCriticalSpan("ScrollView-scroll");
                }
                if ((viewParent = this.getParent()) == null) return this.mIsBeingDragged;
                viewParent.requestDisallowInterceptTouchEvent(true);
                return this.mIsBeingDragged;
            }
            case 0: {
                int n5 = (int)motionEvent.getY();
                if (!this.inChild((int)motionEvent.getX(), n5)) {
                    this.mIsBeingDragged = false;
                    this.recycleVelocityTracker();
                    return this.mIsBeingDragged;
                }
                this.mLastMotionY = n5;
                this.mActivePointerId = motionEvent.getPointerId(0);
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(motionEvent);
                boolean bl = this.mScroller.isFinished();
                boolean bl2 = false;
                if (!bl) {
                    bl2 = true;
                }
                this.mIsBeingDragged = bl2;
                if (this.mIsBeingDragged && this.mScrollStrictSpan == null) {
                    this.mScrollStrictSpan = StrictMode.enterCriticalSpan("ScrollView-scroll");
                }
                this.startNestedScroll(2);
                return this.mIsBeingDragged;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                this.recycleVelocityTracker();
                if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, 0, 0, this.getScrollRange())) {
                    this.postInvalidateOnAnimation();
                }
                this.stopNestedScroll();
                return this.mIsBeingDragged;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                return this.mIsBeingDragged;
            }
        }
        return this.mIsBeingDragged;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.mIsLayoutDirty = false;
        if (this.mChildToScrollTo != null && ScrollView.isViewDescendantOf(this.mChildToScrollTo, this)) {
            this.scrollToChild(this.mChildToScrollTo);
        }
        this.mChildToScrollTo = null;
        if (!this.isLaidOut()) {
            int n5;
            int n6;
            if (this.mSavedState != null) {
                this.mScrollY = this.mSavedState.scrollPosition;
                this.mSavedState = null;
            }
            if (this.mScrollY > (n6 = Math.max(0, (n5 = this.getChildCount() > 0 ? this.getChildAt(0).getMeasuredHeight() : 0) - (n4 - n2 - this.mPaddingBottom - this.mPaddingTop)))) {
                this.mScrollY = n6;
            } else if (this.mScrollY < 0) {
                this.mScrollY = 0;
            }
        }
        this.scrollTo(this.mScrollX, this.mScrollY);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        View view;
        block3: {
            block2: {
                super.onMeasure(n, n2);
                if (!this.mFillViewport || View.MeasureSpec.getMode(n2) == 0 || this.getChildCount() <= 0) break block2;
                view = this.getChildAt(0);
                n3 = this.getMeasuredHeight();
                if (view.getMeasuredHeight() < n3) break block3;
            }
            return;
        }
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
        view.measure(ScrollView.getChildMeasureSpec(n, this.mPaddingLeft + this.mPaddingRight, layoutParams.width), View.MeasureSpec.makeMeasureSpec(n3 - this.mPaddingTop - this.mPaddingBottom, 0x40000000));
    }

    @Override
    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        if (!bl) {
            this.flingWithNestedDispatch((int)f2);
            return true;
        }
        return false;
    }

    @Override
    public void onNestedScroll(View view, int n, int n2, int n3, int n4) {
        int n5 = this.mScrollY;
        this.scrollBy(0, n4);
        int n6 = this.mScrollY - n5;
        this.dispatchNestedScroll(0, n6, 0, n4 - n6, null);
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n) {
        super.onNestedScrollAccepted(view, view2, n);
        this.startNestedScroll(2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onOverScrolled(int n, int n2, boolean bl, boolean bl2) {
        if (!this.mScroller.isFinished()) {
            int n3 = this.mScrollX;
            int n4 = this.mScrollY;
            this.mScrollX = n;
            this.mScrollY = n2;
            this.invalidateParentIfNeeded();
            this.onScrollChanged(this.mScrollX, this.mScrollY, n3, n4);
            if (bl2) {
                this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, 0, 0, this.getScrollRange());
            }
        } else {
            super.scrollTo(n, n2);
        }
        this.awakenScrollBars();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean onRequestFocusInDescendants(int n, Rect rect) {
        if (n == 2) {
            n = 130;
        } else if (n == 1) {
            n = 33;
        }
        View view = rect == null ? FocusFinder.getInstance().findNextFocus(this, null, n) : FocusFinder.getInstance().findNextFocusFromRect(this, rect, n);
        if (view == null || this.isOffScreen(view)) {
            return false;
        }
        return view.requestFocus(n, rect);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        if (this.mContext.getApplicationInfo().targetSdkVersion <= 18) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mSavedState = savedState;
        this.requestLayout();
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        if (this.mContext.getApplicationInfo().targetSdkVersion <= 18) {
            return super.onSaveInstanceState();
        }
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.scrollPosition = this.mScrollY;
        return savedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        View view = this.findFocus();
        if (view == null || this == view || !this.isWithinDeltaOfScreen(view, 0, n4)) {
            return;
        }
        view.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(view, this.mTempRect);
        this.doScrollY(this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect));
    }

    @Override
    public boolean onStartNestedScroll(View view, View view2, int n) {
        return (n & 2) != 0;
    }

    @Override
    public void onStopNestedScroll(View view) {
        super.onStopNestedScroll(view);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.initVelocityTrackerIfNotExists();
        MotionEvent motionEvent2 = MotionEvent.obtain(motionEvent);
        int n = motionEvent.getActionMasked();
        if (n == 0) {
            this.mNestedYOffset = 0;
        }
        motionEvent2.offsetLocation(0.0f, this.mNestedYOffset);
        switch (n) {
            case 0: {
                ViewParent viewParent;
                if (this.getChildCount() == 0) {
                    return false;
                }
                boolean bl = !this.mScroller.isFinished();
                this.mIsBeingDragged = bl;
                if (bl && (viewParent = this.getParent()) != null) {
                    viewParent.requestDisallowInterceptTouchEvent(true);
                }
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                    if (this.mFlingStrictSpan != null) {
                        this.mFlingStrictSpan.finish();
                        this.mFlingStrictSpan = null;
                    }
                }
                this.mLastMotionY = (int)motionEvent.getY();
                this.mActivePointerId = motionEvent.getPointerId(0);
                this.startNestedScroll(2);
                break;
            }
            case 2: {
                int n2;
                int n3 = motionEvent.findPointerIndex(this.mActivePointerId);
                if (n3 == -1) {
                    Log.e(TAG, "Invalid pointerId=" + this.mActivePointerId + " in onTouchEvent");
                    break;
                }
                int n4 = (int)motionEvent.getY(n3);
                int n5 = this.mLastMotionY - n4;
                if (this.dispatchNestedPreScroll(0, n5, this.mScrollConsumed, this.mScrollOffset)) {
                    n5 -= this.mScrollConsumed[1];
                    motionEvent2.offsetLocation(0.0f, this.mScrollOffset[1]);
                    this.mNestedYOffset += this.mScrollOffset[1];
                }
                if (!this.mIsBeingDragged && Math.abs(n5) > this.mTouchSlop) {
                    ViewParent viewParent = this.getParent();
                    if (viewParent != null) {
                        viewParent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.mIsBeingDragged = true;
                    n5 = n5 > 0 ? (n5 -= this.mTouchSlop) : (n5 += this.mTouchSlop);
                }
                if (!this.mIsBeingDragged) break;
                this.mLastMotionY = n4 - this.mScrollOffset[1];
                int n6 = this.mScrollY;
                int n7 = this.getScrollRange();
                int n8 = this.getOverScrollMode();
                boolean bl = n8 == 0 || n8 == 1 && n7 > 0;
                if (this.overScrollBy(0, n5, 0, this.mScrollY, 0, n7, 0, this.mOverscrollDistance, true) && !this.hasNestedScrollingParent()) {
                    this.mVelocityTracker.clear();
                }
                if (this.dispatchNestedScroll(0, n2 = this.mScrollY - n6, 0, n5 - n2, this.mScrollOffset)) {
                    this.mLastMotionY -= this.mScrollOffset[1];
                    motionEvent2.offsetLocation(0.0f, this.mScrollOffset[1]);
                    this.mNestedYOffset += this.mScrollOffset[1];
                    break;
                }
                if (!bl) break;
                int n9 = n6 + n5;
                if (n9 < 0) {
                    this.mEdgeGlowTop.onPull((float)n5 / (float)this.getHeight(), motionEvent.getX(n3) / (float)this.getWidth());
                    if (!this.mEdgeGlowBottom.isFinished()) {
                        this.mEdgeGlowBottom.onRelease();
                    }
                } else if (n9 > n7) {
                    this.mEdgeGlowBottom.onPull((float)n5 / (float)this.getHeight(), 1.0f - motionEvent.getX(n3) / (float)this.getWidth());
                    if (!this.mEdgeGlowTop.isFinished()) {
                        this.mEdgeGlowTop.onRelease();
                    }
                }
                if (this.mEdgeGlowTop == null || this.mEdgeGlowTop.isFinished() && this.mEdgeGlowBottom.isFinished()) break;
                this.postInvalidateOnAnimation();
                break;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                int n10 = (int)velocityTracker.getYVelocity(this.mActivePointerId);
                if (Math.abs(n10) > this.mMinimumVelocity) {
                    this.flingWithNestedDispatch(-n10);
                } else if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, 0, 0, this.getScrollRange())) {
                    this.postInvalidateOnAnimation();
                }
                this.mActivePointerId = -1;
                this.endDrag();
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged || this.getChildCount() <= 0) break;
                if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, 0, 0, this.getScrollRange())) {
                    this.postInvalidateOnAnimation();
                }
                this.mActivePointerId = -1;
                this.endDrag();
                break;
            }
            case 5: {
                int n11 = motionEvent.getActionIndex();
                this.mLastMotionY = (int)motionEvent.getY(n11);
                this.mActivePointerId = motionEvent.getPointerId(n11);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                this.mLastMotionY = (int)motionEvent.getY(motionEvent.findPointerIndex(this.mActivePointerId));
                break;
            }
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(motionEvent2);
        }
        motionEvent2.recycle();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean pageScroll(int n) {
        boolean bl = n == 130;
        int n2 = this.getHeight();
        if (bl) {
            View view;
            this.mTempRect.top = n2 + this.getScrollY();
            int n3 = this.getChildCount();
            if (n3 > 0 && n2 + this.mTempRect.top > (view = this.getChildAt(n3 - 1)).getBottom()) {
                this.mTempRect.top = view.getBottom() - n2;
            }
        } else {
            this.mTempRect.top = this.getScrollY() - n2;
            if (this.mTempRect.top < 0) {
                this.mTempRect.top = 0;
            }
        }
        this.mTempRect.bottom = n2 + this.mTempRect.top;
        return this.scrollAndFocus(n, this.mTempRect.top, this.mTempRect.bottom);
    }

    @Override
    public boolean performAccessibilityAction(int n, Bundle bundle) {
        if (super.performAccessibilityAction(n, bundle)) {
            return true;
        }
        if (!this.isEnabled()) {
            return false;
        }
        switch (n) {
            default: {
                return false;
            }
            case 4096: {
                int n2 = Math.min(this.getHeight() - this.mPaddingBottom - this.mPaddingTop + this.mScrollY, this.getScrollRange());
                if (n2 != this.mScrollY) {
                    this.smoothScrollTo(0, n2);
                    return true;
                }
                return false;
            }
            case 8192: 
        }
        int n3 = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
        int n4 = Math.max(this.mScrollY - n3, 0);
        if (n4 != this.mScrollY) {
            this.smoothScrollTo(0, n4);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void requestChildFocus(View view, View view2) {
        if (!this.mIsLayoutDirty) {
            this.scrollToChild(view2);
        } else {
            this.mChildToScrollTo = view2;
        }
        super.requestChildFocus(view, view2);
    }

    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        rect.offset(view.getLeft() - view.getScrollX(), view.getTop() - view.getScrollY());
        return this.scrollToChildRect(rect, bl);
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean bl) {
        if (bl) {
            this.recycleVelocityTracker();
        }
        super.requestDisallowInterceptTouchEvent(bl);
    }

    @Override
    public void requestLayout() {
        this.mIsLayoutDirty = true;
        super.requestLayout();
    }

    @Override
    public void scrollTo(int n, int n2) {
        if (this.getChildCount() > 0) {
            View view = this.getChildAt(0);
            int n3 = ScrollView.clamp(n, this.getWidth() - this.mPaddingRight - this.mPaddingLeft, view.getWidth());
            int n4 = ScrollView.clamp(n2, this.getHeight() - this.mPaddingBottom - this.mPaddingTop, view.getHeight());
            if (n3 != this.mScrollX || n4 != this.mScrollY) {
                super.scrollTo(n3, n4);
            }
        }
    }

    public void setFillViewport(boolean bl) {
        if (bl != this.mFillViewport) {
            this.mFillViewport = bl;
            this.requestLayout();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setOverScrollMode(int n) {
        if (n != 2) {
            if (this.mEdgeGlowTop == null) {
                Context context = this.getContext();
                this.mEdgeGlowTop = new EdgeEffect(context);
                this.mEdgeGlowBottom = new EdgeEffect(context);
            }
        } else {
            this.mEdgeGlowTop = null;
            this.mEdgeGlowBottom = null;
        }
        super.setOverScrollMode(n);
    }

    public void setSmoothScrollingEnabled(boolean bl) {
        this.mSmoothScrollingEnabled = bl;
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void smoothScrollBy(int n, int n2) {
        if (this.getChildCount() == 0) {
            return;
        }
        if (AnimationUtils.currentAnimationTimeMillis() - this.mLastScroll > 250L) {
            int n3 = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
            int n4 = Math.max(0, this.getChildAt(0).getHeight() - n3);
            int n5 = this.mScrollY;
            int n6 = Math.max(0, Math.min(n5 + n2, n4)) - n5;
            this.mScroller.startScroll(this.mScrollX, n5, 0, n6);
            this.postInvalidateOnAnimation();
        } else {
            if (!this.mScroller.isFinished()) {
                this.mScroller.abortAnimation();
                if (this.mFlingStrictSpan != null) {
                    this.mFlingStrictSpan.finish();
                    this.mFlingStrictSpan = null;
                }
            }
            this.scrollBy(n, n2);
        }
        this.mLastScroll = AnimationUtils.currentAnimationTimeMillis();
    }

    public final void smoothScrollTo(int n, int n2) {
        this.smoothScrollBy(n - this.mScrollX, n2 - this.mScrollY);
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        public int scrollPosition;

        public SavedState(Parcel parcel) {
            super(parcel);
            this.scrollPosition = parcel.readInt();
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            return "HorizontalScrollView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " scrollPosition=" + this.scrollPosition + "}";
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.scrollPosition);
        }
    }
}

