/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.util.FloatMath;
import android.util.Log;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.Scroller;

public class OverScroller {
    private static final int DEFAULT_DURATION = 250;
    private static final int FLING_MODE = 1;
    private static final int SCROLL_MODE;
    private final boolean mFlywheel;
    private Interpolator mInterpolator;
    private int mMode;
    private final SplineOverScroller mScrollerX;
    private final SplineOverScroller mScrollerY;

    public OverScroller(Context context) {
        this(context, null);
    }

    public OverScroller(Context context, Interpolator interpolator2) {
        this(context, interpolator2, true);
    }

    public OverScroller(Context context, Interpolator interpolator2, float f, float f2) {
        this(context, interpolator2, true);
    }

    public OverScroller(Context context, Interpolator interpolator2, float f, float f2, boolean bl) {
        this(context, interpolator2, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public OverScroller(Context context, Interpolator interpolator2, boolean bl) {
        this.mInterpolator = interpolator2 == null ? new Scroller.ViscousFluidInterpolator() : interpolator2;
        this.mFlywheel = bl;
        this.mScrollerX = new SplineOverScroller(context);
        this.mScrollerY = new SplineOverScroller(context);
    }

    public void abortAnimation() {
        this.mScrollerX.finish();
        this.mScrollerY.finish();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean computeScrollOffset() {
        if (this.isFinished()) {
            return false;
        }
        switch (this.mMode) {
            case 0: {
                long l = AnimationUtils.currentAnimationTimeMillis() - this.mScrollerX.mStartTime;
                int n = this.mScrollerX.mDuration;
                if (l < (long)n) {
                    float f = this.mInterpolator.getInterpolation((float)l / (float)n);
                    this.mScrollerX.updateScroll(f);
                    this.mScrollerY.updateScroll(f);
                } else {
                    this.abortAnimation();
                }
            }
            default: {
                return true;
            }
            case 1: 
        }
        if (!(this.mScrollerX.mFinished || this.mScrollerX.update() || this.mScrollerX.continueWhenFinished())) {
            this.mScrollerX.finish();
        }
        if (this.mScrollerY.mFinished) return true;
        if (this.mScrollerY.update()) return true;
        if (this.mScrollerY.continueWhenFinished()) return true;
        this.mScrollerY.finish();
        return true;
    }

    @Deprecated
    public void extendDuration(int n) {
        this.mScrollerX.extendDuration(n);
        this.mScrollerY.extendDuration(n);
    }

    public void fling(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.fling(n, n2, n3, n4, n5, n6, n7, n8, 0, 0);
    }

    public void fling(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        if (this.mFlywheel && !this.isFinished()) {
            float f = this.mScrollerX.mCurrVelocity;
            float f2 = this.mScrollerY.mCurrVelocity;
            if (Math.signum(n3) == Math.signum(f) && Math.signum(n4) == Math.signum(f2)) {
                n3 = (int)(f + (float)n3);
                n4 = (int)(f2 + (float)n4);
            }
        }
        this.mMode = 1;
        this.mScrollerX.fling(n, n3, n5, n6, n9);
        this.mScrollerY.fling(n2, n4, n7, n8, n10);
    }

    public final void forceFinished(boolean bl) {
        SplineOverScroller.access$002(this.mScrollerX, SplineOverScroller.access$002(this.mScrollerY, bl));
    }

    public float getCurrVelocity() {
        return FloatMath.sqrt(this.mScrollerX.mCurrVelocity * this.mScrollerX.mCurrVelocity + this.mScrollerY.mCurrVelocity * this.mScrollerY.mCurrVelocity);
    }

    public final int getCurrX() {
        return this.mScrollerX.mCurrentPosition;
    }

    public final int getCurrY() {
        return this.mScrollerY.mCurrentPosition;
    }

    @Deprecated
    public final int getDuration() {
        return Math.max(this.mScrollerX.mDuration, this.mScrollerY.mDuration);
    }

    public final int getFinalX() {
        return this.mScrollerX.mFinal;
    }

    public final int getFinalY() {
        return this.mScrollerY.mFinal;
    }

    public final int getStartX() {
        return this.mScrollerX.mStart;
    }

    public final int getStartY() {
        return this.mScrollerY.mStart;
    }

    public final boolean isFinished() {
        return this.mScrollerX.mFinished && this.mScrollerY.mFinished;
    }

    public boolean isOverScrolled() {
        return !this.mScrollerX.mFinished && this.mScrollerX.mState != 0 || !this.mScrollerY.mFinished && this.mScrollerY.mState != 0;
    }

    public boolean isScrollingInDirection(float f, float f2) {
        int n = this.mScrollerX.mFinal - this.mScrollerX.mStart;
        int n2 = this.mScrollerY.mFinal - this.mScrollerY.mStart;
        return !this.isFinished() && Math.signum(f) == Math.signum(n) && Math.signum(f2) == Math.signum(n2);
    }

    public void notifyHorizontalEdgeReached(int n, int n2, int n3) {
        this.mScrollerX.notifyEdgeReached(n, n2, n3);
    }

    public void notifyVerticalEdgeReached(int n, int n2, int n3) {
        this.mScrollerY.notifyEdgeReached(n, n2, n3);
    }

    @Deprecated
    public void setFinalX(int n) {
        this.mScrollerX.setFinalPosition(n);
    }

    @Deprecated
    public void setFinalY(int n) {
        this.mScrollerY.setFinalPosition(n);
    }

    public final void setFriction(float f) {
        this.mScrollerX.setFriction(f);
        this.mScrollerY.setFriction(f);
    }

    void setInterpolator(Interpolator interpolator2) {
        if (interpolator2 == null) {
            this.mInterpolator = new Scroller.ViscousFluidInterpolator();
            return;
        }
        this.mInterpolator = interpolator2;
    }

    public boolean springBack(int n, int n2, int n3, int n4, int n5, int n6) {
        this.mMode = 1;
        boolean bl = this.mScrollerX.springback(n, n3, n4);
        boolean bl2 = this.mScrollerY.springback(n2, n5, n6);
        return bl || bl2;
    }

    public void startScroll(int n, int n2, int n3, int n4) {
        this.startScroll(n, n2, n3, n4, 250);
    }

    public void startScroll(int n, int n2, int n3, int n4, int n5) {
        this.mMode = 0;
        this.mScrollerX.startScroll(n, n3, n5);
        this.mScrollerY.startScroll(n2, n4, n5);
    }

    public int timePassed() {
        return (int)(AnimationUtils.currentAnimationTimeMillis() - Math.min(this.mScrollerX.mStartTime, this.mScrollerY.mStartTime));
    }

    static class SplineOverScroller {
        private static final int BALLISTIC = 2;
        private static final int CUBIC = 1;
        private static float DECELERATION_RATE = 0.0f;
        private static final float END_TENSION = 1.0f;
        private static final float GRAVITY = 2000.0f;
        private static final float INFLEXION = 0.35f;
        private static final int NB_SAMPLES = 100;
        private static final float P1 = 0.175f;
        private static final float P2 = 0.35000002f;
        private static final int SPLINE = 0;
        private static final float[] SPLINE_POSITION;
        private static final float[] SPLINE_TIME;
        private static final float START_TENSION = 0.5f;
        private float mCurrVelocity;
        private int mCurrentPosition;
        private float mDeceleration;
        private int mDuration;
        private int mFinal;
        private boolean mFinished = true;
        private float mFlingFriction = ViewConfiguration.getScrollFriction();
        private int mOver;
        private float mPhysicalCoeff;
        private int mSplineDistance;
        private int mSplineDuration;
        private int mStart;
        private long mStartTime;
        private int mState = 0;
        private int mVelocity;

        /*
         * Enabled aggressive block sorting
         */
        static {
            DECELERATION_RATE = (float)(Math.log(0.78) / Math.log(0.9));
            SPLINE_POSITION = new float[101];
            SPLINE_TIME = new float[101];
            float f = 0.0f;
            float f2 = 0.0f;
            int n = 0;
            block0: while (true) {
                float f3;
                float f4;
                if (n >= 100) {
                    float[] fArray = SPLINE_POSITION;
                    SplineOverScroller.SPLINE_TIME[100] = 1.0f;
                    fArray[100] = 1.0f;
                    return;
                }
                float f5 = (float)n / 100.0f;
                float f6 = 1.0f;
                while (true) {
                    float f7;
                    if ((double)Math.abs((f7 = (f4 = 3.0f * (f3 = f + (f6 - f) / 2.0f) * (1.0f - f3)) * (0.175f * (1.0f - f3) + 0.35000002f * f3) + f3 * (f3 * f3)) - f5) < 1.0E-5) break;
                    if (f7 > f5) {
                        f6 = f3;
                        continue;
                    }
                    f = f3;
                }
                SplineOverScroller.SPLINE_POSITION[n] = f4 * (f3 + 0.5f * (1.0f - f3)) + f3 * (f3 * f3);
                float f8 = 1.0f;
                while (true) {
                    float f9;
                    float f10;
                    float f11;
                    if ((double)Math.abs((f11 = (f10 = 3.0f * (f9 = f2 + (f8 - f2) / 2.0f) * (1.0f - f9)) * (f9 + 0.5f * (1.0f - f9)) + f9 * (f9 * f9)) - f5) < 1.0E-5) {
                        SplineOverScroller.SPLINE_TIME[n] = f10 * (0.175f * (1.0f - f9) + 0.35000002f * f9) + f9 * (f9 * f9);
                        ++n;
                        continue block0;
                    }
                    if (f11 > f5) {
                        f8 = f9;
                        continue;
                    }
                    f2 = f9;
                }
                break;
            }
        }

        SplineOverScroller(Context context) {
            this.mPhysicalCoeff = 0.84f * (386.0878f * (160.0f * context.getResources().getDisplayMetrics().density));
        }

        static /* synthetic */ boolean access$002(SplineOverScroller splineOverScroller, boolean bl) {
            splineOverScroller.mFinished = bl;
            return bl;
        }

        private void adjustDuration(int n, int n2, int n3) {
            int n4 = n2 - n;
            float f = Math.abs((float)(n3 - n) / (float)n4);
            int n5 = (int)(100.0f * f);
            if (n5 < 100) {
                float f2 = (float)n5 / 100.0f;
                float f3 = (float)(n5 + 1) / 100.0f;
                float f4 = SPLINE_TIME[n5];
                float f5 = SPLINE_TIME[n5 + 1];
                this.mDuration = (int)((f4 + (f - f2) / (f3 - f2) * (f5 - f4)) * (float)this.mDuration);
            }
        }

        private void fitOnBounceCurve(int n, int n2, int n3) {
            float f = (float)(-n3) / this.mDeceleration;
            float f2 = (float)Math.sqrt(2.0 * (double)((float)(n3 * n3) / 2.0f / Math.abs(this.mDeceleration) + (float)Math.abs(n2 - n)) / (double)Math.abs(this.mDeceleration));
            this.mStartTime -= (long)((int)(1000.0f * (f2 - f)));
            this.mStart = n2;
            this.mVelocity = (int)(f2 * -this.mDeceleration);
        }

        private static float getDeceleration(int n) {
            if (n > 0) {
                return -2000.0f;
            }
            return 2000.0f;
        }

        private double getSplineDeceleration(int n) {
            return Math.log(0.35f * (float)Math.abs(n) / (this.mFlingFriction * this.mPhysicalCoeff));
        }

        private double getSplineFlingDistance(int n) {
            double d = this.getSplineDeceleration(n);
            double d2 = (double)DECELERATION_RATE - 1.0;
            return (double)(this.mFlingFriction * this.mPhysicalCoeff) * Math.exp(d * ((double)DECELERATION_RATE / d2));
        }

        private int getSplineFlingDuration(int n) {
            return (int)(1000.0 * Math.exp(this.getSplineDeceleration(n) / ((double)DECELERATION_RATE - 1.0)));
        }

        /*
         * Enabled aggressive block sorting
         */
        private void onEdgeReached() {
            float f = (float)(this.mVelocity * this.mVelocity) / (2.0f * Math.abs(this.mDeceleration));
            float f2 = Math.signum(this.mVelocity);
            if (f > (float)this.mOver) {
                this.mDeceleration = -f2 * (float)this.mVelocity * (float)this.mVelocity / (2.0f * (float)this.mOver);
                f = this.mOver;
            }
            this.mOver = (int)f;
            this.mState = 2;
            int n = this.mStart;
            if (this.mVelocity <= 0) {
                f = -f;
            }
            this.mFinal = n + (int)f;
            this.mDuration = -((int)(1000.0f * (float)this.mVelocity / this.mDeceleration));
        }

        /*
         * Enabled aggressive block sorting
         */
        private void startAfterEdge(int n, int n2, int n3, int n4) {
            if (n > n2 && n < n3) {
                Log.e("OverScroller", "startAfterEdge called from a valid position");
                this.mFinished = true;
                return;
            }
            boolean bl = n > n3;
            int n5 = bl ? n3 : n2;
            int n6 = n - n5;
            boolean bl2 = n6 * n4 >= 0;
            if (bl2) {
                this.startBounceAfterEdge(n, n5, n4);
                return;
            }
            if (!(this.getSplineFlingDistance(n4) > (double)Math.abs(n6))) {
                this.startSpringback(n, n5, n4);
                return;
            }
            int n7 = bl ? n2 : n;
            int n8 = bl ? n : n3;
            this.fling(n, n4, n7, n8, this.mOver);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void startBounceAfterEdge(int n, int n2, int n3) {
            int n4 = n3 == 0 ? n - n2 : n3;
            this.mDeceleration = SplineOverScroller.getDeceleration(n4);
            this.fitOnBounceCurve(n, n2, n3);
            this.onEdgeReached();
        }

        private void startSpringback(int n, int n2, int n3) {
            this.mFinished = false;
            this.mState = 1;
            this.mStart = n;
            this.mFinal = n2;
            int n4 = n - n2;
            this.mDeceleration = SplineOverScroller.getDeceleration(n4);
            this.mVelocity = -n4;
            this.mOver = Math.abs(n4);
            this.mDuration = (int)(1000.0 * Math.sqrt(-2.0 * (double)n4 / (double)this.mDeceleration));
        }

        /*
         * Handled duff style switch with additional control
         * Unable to fully structure code
         * Enabled aggressive block sorting
         */
        boolean continueWhenFinished() {
            var1_1 = this.mState;
            var2_2 = false;
            cfr_temp_0 = -2147483648;
            block5: do {
                switch (cfr_temp_0 == -2147483648 ? var1_1 : cfr_temp_0) {
                    case 0: {
                        var4_3 = this.mDuration;
                        var5_4 = this.mSplineDuration;
                        var2_2 = false;
                        cfr_temp_0 = 1;
                        if (var4_3 >= var5_4) continue block5;
                        this.mStart = this.mFinal;
                        this.mVelocity = (int)this.mCurrVelocity;
                        this.mDeceleration = SplineOverScroller.getDeceleration(this.mVelocity);
                        this.mStartTime += (long)this.mDuration;
                        this.onEdgeReached();
                    }
                    default: {
                        ** GOTO lbl22
                    }
                    case 2: {
                        this.mStartTime += (long)this.mDuration;
                        this.startSpringback(this.mFinal, this.mStart, 0);
lbl22:
                        // 2 sources

                        this.update();
                        var2_2 = true;
                    }
                    case 1: 
                }
                return var2_2;
            } while (true);
            return var2_2;
        }

        void extendDuration(int n) {
            this.mDuration = n + (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
            this.mFinished = false;
        }

        void finish() {
            this.mCurrentPosition = this.mFinal;
            this.mFinished = true;
        }

        /*
         * Enabled aggressive block sorting
         */
        void fling(int n, int n2, int n3, int n4, int n5) {
            this.mOver = n5;
            this.mFinished = false;
            this.mVelocity = n2;
            this.mCurrVelocity = n2;
            this.mSplineDuration = 0;
            this.mDuration = 0;
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            this.mStart = n;
            this.mCurrentPosition = n;
            if (n > n4 || n < n3) {
                this.startAfterEdge(n, n3, n4, n2);
                return;
            } else {
                this.mState = 0;
                double d = 0.0;
                if (n2 != 0) {
                    int n6;
                    this.mSplineDuration = n6 = this.getSplineFlingDuration(n2);
                    this.mDuration = n6;
                    d = this.getSplineFlingDistance(n2);
                }
                this.mSplineDistance = (int)(d * (double)Math.signum(n2));
                this.mFinal = n + this.mSplineDistance;
                if (this.mFinal < n3) {
                    this.adjustDuration(this.mStart, this.mFinal, n3);
                    this.mFinal = n3;
                }
                if (this.mFinal <= n4) return;
                this.adjustDuration(this.mStart, this.mFinal, n4);
                this.mFinal = n4;
                return;
            }
        }

        void notifyEdgeReached(int n, int n2, int n3) {
            if (this.mState == 0) {
                this.mOver = n3;
                this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
                this.startAfterEdge(n, n2, n2, (int)this.mCurrVelocity);
            }
        }

        void setFinalPosition(int n) {
            this.mFinal = n;
            this.mFinished = false;
        }

        void setFriction(float f) {
            this.mFlingFriction = f;
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean springback(int n, int n2, int n3) {
            this.mFinished = true;
            this.mFinal = n;
            this.mStart = n;
            this.mVelocity = 0;
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            this.mDuration = 0;
            if (n < n2) {
                this.startSpringback(n, n2, 0);
                return !this.mFinished;
            } else {
                if (n <= n3) return !this.mFinished;
                this.startSpringback(n, n3, 0);
            }
            return !this.mFinished;
        }

        void startScroll(int n, int n2, int n3) {
            this.mFinished = false;
            this.mStart = n;
            this.mFinal = n + n2;
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            this.mDuration = n3;
            this.mDeceleration = 0.0f;
            this.mVelocity = 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        boolean update() {
            long l = AnimationUtils.currentAnimationTimeMillis() - this.mStartTime;
            if (l > (long)this.mDuration) {
                return false;
            }
            double d = 0.0;
            switch (this.mState) {
                case 0: {
                    float f = (float)l / (float)this.mSplineDuration;
                    int n = (int)(100.0f * f);
                    float f2 = 1.0f;
                    float f3 = 0.0f;
                    if (n < 100) {
                        float f4 = (float)n / 100.0f;
                        float f5 = (float)(n + 1) / 100.0f;
                        float f6 = SPLINE_POSITION[n];
                        f3 = (SPLINE_POSITION[n + 1] - f6) / (f5 - f4);
                        f2 = f6 + f3 * (f - f4);
                    }
                    d = f2 * (float)this.mSplineDistance;
                    this.mCurrVelocity = 1000.0f * (f3 * (float)this.mSplineDistance / (float)this.mSplineDuration);
                    break;
                }
                case 2: {
                    float f = (float)l / 1000.0f;
                    this.mCurrVelocity = (float)this.mVelocity + f * this.mDeceleration;
                    d = f * (float)this.mVelocity + f * (f * this.mDeceleration) / 2.0f;
                    break;
                }
                case 1: {
                    float f = (float)l / (float)this.mDuration;
                    float f7 = f * f;
                    float f8 = Math.signum(this.mVelocity);
                    d = f8 * (float)this.mOver * (3.0f * f7 - f7 * (2.0f * f));
                    this.mCurrVelocity = 6.0f * (f8 * (float)this.mOver) * (f7 + -f);
                    break;
                }
            }
            this.mCurrentPosition = this.mStart + (int)Math.round(d);
            return true;
        }

        void updateScroll(float f) {
            this.mCurrentPosition = this.mStart + Math.round(f * (float)(this.mFinal - this.mStart));
        }
    }
}

