/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Insets;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.LogPrinter;
import android.util.Pair;
import android.util.Printer;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RemoteViews;
import android.widget.Space;
import com.android.internal.R;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

@RemoteViews.RemoteView
public class GridLayout
extends ViewGroup {
    private static final int ALIGNMENT_MODE = 6;
    public static final int ALIGN_BOUNDS = 0;
    public static final int ALIGN_MARGINS = 1;
    public static final Alignment BASELINE;
    public static final Alignment BOTTOM;
    private static final int CAN_STRETCH = 2;
    public static final Alignment CENTER;
    private static final int COLUMN_COUNT = 3;
    private static final int COLUMN_ORDER_PRESERVED = 4;
    private static final int DEFAULT_ALIGNMENT_MODE = 1;
    static final int DEFAULT_CONTAINER_MARGIN = 0;
    private static final int DEFAULT_COUNT = Integer.MIN_VALUE;
    private static final boolean DEFAULT_ORDER_PRESERVED = true;
    private static final int DEFAULT_ORIENTATION = 0;
    private static final boolean DEFAULT_USE_DEFAULT_MARGINS = false;
    public static final Alignment END;
    public static final Alignment FILL;
    public static final int HORIZONTAL = 0;
    private static final int INFLEXIBLE = 0;
    private static final Alignment LEADING;
    public static final Alignment LEFT;
    static final Printer LOG_PRINTER;
    static final int MAX_SIZE = 100000;
    static final Printer NO_PRINTER;
    private static final int ORIENTATION = 0;
    public static final Alignment RIGHT;
    private static final int ROW_COUNT = 1;
    private static final int ROW_ORDER_PRESERVED = 2;
    public static final Alignment START;
    public static final Alignment TOP;
    private static final Alignment TRAILING;
    public static final int UNDEFINED = Integer.MIN_VALUE;
    static final Alignment UNDEFINED_ALIGNMENT;
    static final int UNINITIALIZED_HASH = 0;
    private static final int USE_DEFAULT_MARGINS = 5;
    public static final int VERTICAL = 1;
    int mAlignmentMode = 1;
    int mDefaultGap;
    final Axis mHorizontalAxis = new Axis(true);
    int mLastLayoutParamsHashCode = 0;
    int mOrientation = 0;
    Printer mPrinter;
    boolean mUseDefaultMargins = false;
    final Axis mVerticalAxis = new Axis(false);

    static {
        LOG_PRINTER = new LogPrinter(3, GridLayout.class.getName());
        NO_PRINTER = new Printer(){

            @Override
            public void println(String string2) {
            }
        };
        UNDEFINED_ALIGNMENT = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return Integer.MIN_VALUE;
            }

            @Override
            int getGravityOffset(View view, int n) {
                return Integer.MIN_VALUE;
            }
        };
        LEADING = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return 0;
            }

            @Override
            int getGravityOffset(View view, int n) {
                return 0;
            }
        };
        TRAILING = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return n;
            }

            @Override
            int getGravityOffset(View view, int n) {
                return n;
            }
        };
        TOP = LEADING;
        BOTTOM = TRAILING;
        START = LEADING;
        END = TRAILING;
        LEFT = GridLayout.createSwitchingAlignment(START, END);
        RIGHT = GridLayout.createSwitchingAlignment(END, START);
        CENTER = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return n >> 1;
            }

            @Override
            int getGravityOffset(View view, int n) {
                return n >> 1;
            }
        };
        BASELINE = new Alignment(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                if (view.getVisibility() == 8) {
                    return 0;
                }
                int n3 = view.getBaseline();
                if (n3 != -1) return n3;
                return Integer.MIN_VALUE;
            }

            @Override
            public Bounds getBounds() {
                return new Bounds(){
                    private int size;

                    @Override
                    protected int getOffset(GridLayout gridLayout, View view, Alignment alignment, int n, boolean bl) {
                        return Math.max(0, super.getOffset(gridLayout, view, alignment, n, bl));
                    }

                    @Override
                    protected void include(int n, int n2) {
                        super.include(n, n2);
                        this.size = Math.max(this.size, n + n2);
                    }

                    @Override
                    protected void reset() {
                        super.reset();
                        this.size = Integer.MIN_VALUE;
                    }

                    @Override
                    protected int size(boolean bl) {
                        return Math.max(super.size(bl), this.size);
                    }
                };
            }

            @Override
            int getGravityOffset(View view, int n) {
                return 0;
            }
        };
        FILL = new Alignment(){

            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                return Integer.MIN_VALUE;
            }

            @Override
            int getGravityOffset(View view, int n) {
                return 0;
            }

            @Override
            public int getSizeInCell(View view, int n, int n2) {
                return n2;
            }
        };
    }

    public GridLayout(Context context) {
        this(context, null);
    }

    public GridLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public GridLayout(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public GridLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mPrinter = LOG_PRINTER;
        this.mDefaultGap = context.getResources().getDimensionPixelOffset(17104966);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.GridLayout, n, n2);
        try {
            this.setRowCount(typedArray.getInt(1, Integer.MIN_VALUE));
            this.setColumnCount(typedArray.getInt(3, Integer.MIN_VALUE));
            this.setOrientation(typedArray.getInt(0, 0));
            this.setUseDefaultMargins(typedArray.getBoolean(5, false));
            this.setAlignmentMode(typedArray.getInt(6, 1));
            this.setRowOrderPreserved(typedArray.getBoolean(2, true));
            this.setColumnOrderPreserved(typedArray.getBoolean(4, true));
            return;
        }
        finally {
            typedArray.recycle();
        }
    }

    static int adjust(int n, int n2) {
        return View.MeasureSpec.makeMeasureSpec(View.MeasureSpec.getSize(n + n2), View.MeasureSpec.getMode(n));
    }

    static <T> T[] append(T[] TArray, T[] TArray2) {
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length + TArray2.length);
        System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
        System.arraycopy(TArray2, 0, objectArray, TArray.length, TArray2.length);
        return objectArray;
    }

    static boolean canStretch(int n) {
        return (n & 2) != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void checkLayoutParams(LayoutParams layoutParams, boolean bl) {
        String string2 = bl ? "column" : "row";
        Spec spec = bl ? layoutParams.columnSpec : layoutParams.rowSpec;
        Interval interval = spec.span;
        if (interval.min != Integer.MIN_VALUE && interval.min < 0) {
            GridLayout.handleInvalidParams(string2 + " indices must be positive");
        }
        Axis axis = bl ? this.mHorizontalAxis : this.mVerticalAxis;
        int n = axis.definedCount;
        if (n != Integer.MIN_VALUE) {
            if (interval.max > n) {
                GridLayout.handleInvalidParams(string2 + " indices (start + span) mustn't exceed the " + string2 + " count");
            }
            if (interval.size() > n) {
                GridLayout.handleInvalidParams(string2 + " span mustn't exceed the " + string2 + " count");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int clip(Interval interval, boolean bl, int n) {
        int n2;
        int n3 = interval.size();
        if (n == 0) {
            return n3;
        }
        if (bl) {
            n2 = Math.min(interval.min, n);
            return Math.min(n3, n - n2);
        }
        n2 = 0;
        return Math.min(n3, n - n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int computeLayoutParamsHashCode() {
        int n = 1;
        int n2 = 0;
        int n3 = this.getChildCount();
        while (n2 < n3) {
            View view = this.getChildAt(n2);
            if (view.getVisibility() != 8) {
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                n = n * 31 + layoutParams.hashCode();
            }
            ++n2;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void consistencyCheck() {
        if (this.mLastLayoutParamsHashCode == 0) {
            this.validateLayoutParams();
            this.mLastLayoutParamsHashCode = this.computeLayoutParamsHashCode();
            return;
        } else {
            if (this.mLastLayoutParamsHashCode == this.computeLayoutParamsHashCode()) return;
            this.mPrinter.println("The fields of some layout parameters were modified in between layout operations. Check the javadoc for GridLayout.LayoutParams#rowSpec.");
            this.invalidateStructure();
            this.consistencyCheck();
            return;
        }
    }

    private static Alignment createSwitchingAlignment(final Alignment alignment, final Alignment alignment2) {
        return new Alignment(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public int getAlignmentValue(View view, int n, int n2) {
                Alignment alignment3;
                if (!view.isLayoutRtl()) {
                    alignment3 = alignment;
                    return alignment3.getAlignmentValue(view, n, n2);
                }
                alignment3 = alignment2;
                return alignment3.getAlignmentValue(view, n, n2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            int getGravityOffset(View view, int n) {
                Alignment alignment3;
                if (!view.isLayoutRtl()) {
                    alignment3 = alignment;
                    return alignment3.getGravityOffset(view, n);
                }
                alignment3 = alignment2;
                return alignment3.getGravityOffset(view, n);
            }
        };
    }

    private void drawLine(Canvas canvas, int n, int n2, int n3, int n4, Paint paint) {
        if (this.isLayoutRtl()) {
            int n5 = this.getWidth();
            canvas.drawLine(n5 - n, n2, n5 - n3, n4, paint);
            return;
        }
        canvas.drawLine(n, n2, n3, n4, paint);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean fits(int[] nArray, int n, int n2, int n3) {
        if (n3 <= nArray.length) {
            int n4 = n2;
            while (true) {
                if (n4 >= n3) {
                    return true;
                }
                if (nArray[n4] > n) break;
                ++n4;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    static Alignment getAlignment(int n, boolean bl) {
        int n2 = bl ? 7 : 112;
        int n3 = bl ? 0 : 4;
        switch ((n & n2) >> n3) {
            default: {
                return UNDEFINED_ALIGNMENT;
            }
            case 3: {
                if (bl) {
                    return LEFT;
                }
                return TOP;
            }
            case 5: {
                if (bl) {
                    return RIGHT;
                }
                return BOTTOM;
            }
            case 7: {
                return FILL;
            }
            case 1: {
                return CENTER;
            }
            case 0x800003: {
                return START;
            }
            case 0x800005: 
        }
        return END;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getDefaultMargin(View view, LayoutParams layoutParams, boolean bl, boolean bl2) {
        boolean bl3 = true;
        if (!this.mUseDefaultMargins) {
            return 0;
        }
        Spec spec = bl ? layoutParams.columnSpec : layoutParams.rowSpec;
        Axis axis = bl ? this.mHorizontalAxis : this.mVerticalAxis;
        Interval interval = spec.span;
        boolean bl4 = bl && this.isLayoutRtl() ? (!bl2 ? bl3 : false) : bl2;
        if (!bl4) {
            if (interval.max == axis.getCount()) return this.getDefaultMargin(view, bl3, bl, bl2);
            bl3 = false;
            return this.getDefaultMargin(view, bl3, bl, bl2);
        }
        if (interval.min == 0) {
            return this.getDefaultMargin(view, bl3, bl, bl2);
        }
        bl3 = false;
        return this.getDefaultMargin(view, bl3, bl, bl2);
    }

    private int getDefaultMargin(View view, boolean bl, boolean bl2) {
        if (view.getClass() == Space.class) {
            return 0;
        }
        return this.mDefaultGap / 2;
    }

    private int getDefaultMargin(View view, boolean bl, boolean bl2, boolean bl3) {
        return this.getDefaultMargin(view, bl2, bl3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getMargin(View view, boolean bl, boolean bl2) {
        int n;
        if (this.mAlignmentMode == 1) {
            return this.getMargin1(view, bl, bl2);
        }
        Axis axis = bl ? this.mHorizontalAxis : this.mVerticalAxis;
        int[] nArray = bl2 ? axis.getLeadingMargins() : axis.getTrailingMargins();
        LayoutParams layoutParams = this.getLayoutParams(view);
        Spec spec = bl ? layoutParams.columnSpec : layoutParams.rowSpec;
        if (bl2) {
            n = spec.span.min;
            return nArray[n];
        }
        n = spec.span.max;
        return nArray[n];
    }

    private int getMeasurement(View view, boolean bl) {
        if (bl) {
            return view.getMeasuredWidth();
        }
        return view.getMeasuredHeight();
    }

    private int getTotalMargin(View view, boolean bl) {
        return this.getMargin(view, bl, true) + this.getMargin(view, bl, false);
    }

    private static void handleInvalidParams(String string2) {
        throw new IllegalArgumentException(string2 + ". ");
    }

    private void invalidateStructure() {
        this.mLastLayoutParamsHashCode = 0;
        this.mHorizontalAxis.invalidateStructure();
        this.mVerticalAxis.invalidateStructure();
        this.invalidateValues();
    }

    private void invalidateValues() {
        if (this.mHorizontalAxis != null && this.mVerticalAxis != null) {
            this.mHorizontalAxis.invalidateValues();
            this.mVerticalAxis.invalidateValues();
        }
    }

    static int max2(int[] nArray, int n) {
        int n2 = n;
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            n2 = Math.max(n2, nArray[i]);
        }
        return n2;
    }

    private void measureChildWithMargins2(View view, int n, int n2, int n3, int n4) {
        view.measure(GridLayout.getChildMeasureSpec(n, this.getTotalMargin(view, true), n3), GridLayout.getChildMeasureSpec(n2, this.getTotalMargin(view, false), n4));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void measureChildrenWithMargins(int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = this.getChildCount();
        while (n3 < n4) {
            View view = this.getChildAt(n3);
            if (view.getVisibility() != 8) {
                LayoutParams layoutParams = this.getLayoutParams(view);
                if (bl) {
                    this.measureChildWithMargins2(view, n, n2, layoutParams.width, layoutParams.height);
                    this.mHorizontalAxis.recordOriginalMeasurement(n3);
                    this.mVerticalAxis.recordOriginalMeasurement(n3);
                } else {
                    boolean bl2 = this.mOrientation == 0;
                    Spec spec = bl2 ? layoutParams.columnSpec : layoutParams.rowSpec;
                    if (spec.alignment == FILL) {
                        Interval interval = spec.span;
                        Axis axis = bl2 ? this.mHorizontalAxis : this.mVerticalAxis;
                        int[] nArray = axis.getLocations();
                        int n5 = nArray[interval.max] - nArray[interval.min] - this.getTotalMargin(view, bl2);
                        if (bl2) {
                            this.measureChildWithMargins2(view, n, n2, n5, layoutParams.height);
                        } else {
                            this.measureChildWithMargins2(view, n, n2, layoutParams.width, n5);
                        }
                    }
                }
            }
            ++n3;
        }
        return;
    }

    private static void procrusteanFill(int[] nArray, int n, int n2, int n3) {
        int n4 = nArray.length;
        Arrays.fill(nArray, Math.min(n, n4), Math.min(n2, n4), n3);
    }

    private static void setCellGroup(LayoutParams layoutParams, int n, int n2, int n3, int n4) {
        layoutParams.setRowSpecSpan(new Interval(n, n + n2));
        layoutParams.setColumnSpecSpan(new Interval(n3, n3 + n4));
    }

    public static Spec spec(int n) {
        return GridLayout.spec(n, 1);
    }

    public static Spec spec(int n, float f) {
        return GridLayout.spec(n, 1, f);
    }

    public static Spec spec(int n, int n2) {
        return GridLayout.spec(n, n2, UNDEFINED_ALIGNMENT);
    }

    public static Spec spec(int n, int n2, float f) {
        return GridLayout.spec(n, n2, UNDEFINED_ALIGNMENT, f);
    }

    public static Spec spec(int n, int n2, Alignment alignment) {
        return GridLayout.spec(n, n2, alignment, 0.0f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Spec spec(int n, int n2, Alignment alignment, float f) {
        boolean bl;
        if (n != Integer.MIN_VALUE) {
            bl = true;
            return new Spec(bl, n, n2, alignment, f);
        }
        bl = false;
        return new Spec(bl, n, n2, alignment, f);
    }

    public static Spec spec(int n, Alignment alignment) {
        return GridLayout.spec(n, 1, alignment);
    }

    public static Spec spec(int n, Alignment alignment, float f) {
        return GridLayout.spec(n, 1, alignment, f);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateLayoutParams() {
        boolean bl = this.mOrientation == 0;
        Axis axis = bl ? this.mHorizontalAxis : this.mVerticalAxis;
        int n = axis.definedCount != Integer.MIN_VALUE ? axis.definedCount : 0;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = new int[n];
        int n4 = 0;
        int n5 = this.getChildCount();
        while (n4 < n5) {
            LayoutParams layoutParams = (LayoutParams)this.getChildAt(n4).getLayoutParams();
            Spec spec = bl ? layoutParams.rowSpec : layoutParams.columnSpec;
            Interval interval = spec.span;
            boolean bl2 = spec.startDefined;
            int n6 = interval.size();
            if (bl2) {
                n2 = interval.min;
            }
            Spec spec2 = bl ? layoutParams.columnSpec : layoutParams.rowSpec;
            Interval interval2 = spec2.span;
            boolean bl3 = spec2.startDefined;
            int n7 = GridLayout.clip(interval2, bl3, n);
            if (bl3) {
                n3 = interval2.min;
            }
            if (n != 0) {
                if (!bl2 || !bl3) {
                    while (!GridLayout.fits(nArray, n2, n3, n3 + n7)) {
                        if (bl3) {
                            ++n2;
                            continue;
                        }
                        if (n3 + n7 <= n) {
                            ++n3;
                            continue;
                        }
                        ++n2;
                        n3 = 0;
                    }
                }
                GridLayout.procrusteanFill(nArray, n3, n3 + n7, n2 + n6);
            }
            if (bl) {
                GridLayout.setCellGroup(layoutParams, n2, n6, n3, n7);
            } else {
                GridLayout.setCellGroup(layoutParams, n3, n7, n2, n6);
            }
            n3 += n7;
            ++n4;
        }
        return;
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (!(layoutParams instanceof LayoutParams)) {
            return false;
        }
        LayoutParams layoutParams2 = (LayoutParams)layoutParams;
        this.checkLayoutParams(layoutParams2, true);
        this.checkLayoutParams(layoutParams2, false);
        return true;
    }

    @Override
    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    @Override
    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    final Alignment getAlignment(Alignment alignment, boolean bl) {
        if (alignment != UNDEFINED_ALIGNMENT) {
            return alignment;
        }
        if (bl) {
            return START;
        }
        return BASELINE;
    }

    public int getAlignmentMode() {
        return this.mAlignmentMode;
    }

    public int getColumnCount() {
        return this.mHorizontalAxis.getCount();
    }

    final LayoutParams getLayoutParams(View view) {
        return (LayoutParams)view.getLayoutParams();
    }

    /*
     * Enabled aggressive block sorting
     */
    int getMargin1(View view, boolean bl, boolean bl2) {
        LayoutParams layoutParams = this.getLayoutParams(view);
        int n = bl ? (bl2 ? layoutParams.leftMargin : layoutParams.rightMargin) : (bl2 ? layoutParams.topMargin : layoutParams.bottomMargin);
        if (n != Integer.MIN_VALUE) return n;
        return this.getDefaultMargin(view, layoutParams, bl, bl2);
    }

    final int getMeasurementIncludingMargin(View view, boolean bl) {
        if (view.getVisibility() == 8) {
            return 0;
        }
        return this.getMeasurement(view, bl) + this.getTotalMargin(view, bl);
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public Printer getPrinter() {
        return this.mPrinter;
    }

    public int getRowCount() {
        return this.mVerticalAxis.getCount();
    }

    public boolean getUseDefaultMargins() {
        return this.mUseDefaultMargins;
    }

    public boolean isColumnOrderPreserved() {
        return this.mHorizontalAxis.isOrderPreserved();
    }

    public boolean isRowOrderPreserved() {
        return this.mVerticalAxis.isOrderPreserved();
    }

    @Override
    protected void onChildVisibilityChanged(View view, int n, int n2) {
        super.onChildVisibilityChanged(view, n, n2);
        if (n == 8 || n2 == 8) {
            this.invalidateStructure();
        }
    }

    @Override
    protected void onDebugDraw(Canvas canvas) {
        int[] nArray;
        Paint paint = new Paint();
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(Color.argb(50, 255, 255, 255));
        Insets insets = this.getOpticalInsets();
        int n = this.getPaddingTop() + insets.top;
        int n2 = this.getPaddingLeft() + insets.left;
        int n3 = this.getWidth() - this.getPaddingRight() - insets.right;
        int n4 = this.getHeight() - this.getPaddingBottom() - insets.bottom;
        int[] nArray2 = this.mHorizontalAxis.locations;
        if (nArray2 != null) {
            int n5 = nArray2.length;
            for (int i = 0; i < n5; ++i) {
                int n6 = n2 + nArray2[i];
                this.drawLine(canvas, n6, n, n6, n4, paint);
            }
        }
        if ((nArray = this.mVerticalAxis.locations) != null) {
            int n7 = nArray.length;
            for (int i = 0; i < n7; ++i) {
                int n8 = n + nArray[i];
                this.drawLine(canvas, n2, n8, n3, n8, paint);
            }
        }
        super.onDebugDraw(canvas);
    }

    @Override
    protected void onDebugDrawMargins(Canvas canvas, Paint paint) {
        LayoutParams layoutParams = new LayoutParams();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            layoutParams.setMargins(this.getMargin1(view, true, true), this.getMargin1(view, false, true), this.getMargin1(view, true, false), this.getMargin1(view, false, false));
            layoutParams.onDebugDraw(view, canvas, paint);
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(GridLayout.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(GridLayout.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.consistencyCheck();
        int n5 = n3 - n;
        int n6 = n4 - n2;
        int n7 = this.getPaddingLeft();
        int n8 = this.getPaddingTop();
        int n9 = this.getPaddingRight();
        int n10 = this.getPaddingBottom();
        this.mHorizontalAxis.layout(n5 - n7 - n9);
        this.mVerticalAxis.layout(n6 - n8 - n10);
        int[] nArray = this.mHorizontalAxis.getLocations();
        int[] nArray2 = this.mVerticalAxis.getLocations();
        int n11 = 0;
        int n12 = this.getChildCount();
        while (n11 < n12) {
            View view = this.getChildAt(n11);
            if (view.getVisibility() != 8) {
                LayoutParams layoutParams = this.getLayoutParams(view);
                Spec spec = layoutParams.columnSpec;
                Spec spec2 = layoutParams.rowSpec;
                Interval interval = spec.span;
                Interval interval2 = spec2.span;
                int n13 = nArray[interval.min];
                int n14 = nArray2[interval2.min];
                int n15 = nArray[interval.max];
                int n16 = nArray2[interval2.max];
                int n17 = n15 - n13;
                int n18 = n16 - n14;
                int n19 = this.getMeasurement(view, true);
                int n20 = this.getMeasurement(view, false);
                Alignment alignment = this.getAlignment(spec.alignment, true);
                Alignment alignment2 = this.getAlignment(spec2.alignment, false);
                Bounds bounds = this.mHorizontalAxis.getGroupBounds().getValue(n11);
                Bounds bounds2 = this.mVerticalAxis.getGroupBounds().getValue(n11);
                int n21 = alignment.getGravityOffset(view, n17 - bounds.size(true));
                int n22 = alignment2.getGravityOffset(view, n18 - bounds2.size(true));
                int n23 = this.getMargin(view, true, true);
                int n24 = this.getMargin(view, false, true);
                int n25 = this.getMargin(view, true, false);
                int n26 = this.getMargin(view, false, false);
                int n27 = n23 + n25;
                int n28 = n24 + n26;
                int n29 = bounds.getOffset(this, view, alignment, n19 + n27, true);
                int n30 = bounds2.getOffset(this, view, alignment2, n20 + n28, false);
                int n31 = alignment.getSizeInCell(view, n19, n17 - n27);
                int n32 = alignment2.getSizeInCell(view, n20, n18 - n28);
                int n33 = n29 + (n13 + n21);
                int n34 = !this.isLayoutRtl() ? n33 + (n7 + n23) : n5 - n31 - n9 - n25 - n33;
                int n35 = n24 + (n30 + (n22 + (n8 + n14)));
                if (n31 != view.getMeasuredWidth() || n32 != view.getMeasuredHeight()) {
                    view.measure(View.MeasureSpec.makeMeasureSpec(n31, 0x40000000), View.MeasureSpec.makeMeasureSpec(n32, 0x40000000));
                }
                int n36 = n34 + n31;
                int n37 = n35 + n32;
                view.layout(n34, n35, n36, n37);
            }
            ++n11;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        this.consistencyCheck();
        this.invalidateValues();
        int n5 = this.getPaddingLeft() + this.getPaddingRight();
        int n6 = this.getPaddingTop() + this.getPaddingBottom();
        int n7 = GridLayout.adjust(n, -n5);
        int n8 = GridLayout.adjust(n2, -n6);
        this.measureChildrenWithMargins(n7, n8, true);
        if (this.mOrientation == 0) {
            n4 = this.mHorizontalAxis.getMeasure(n7);
            this.measureChildrenWithMargins(n7, n8, false);
            n3 = this.mVerticalAxis.getMeasure(n8);
        } else {
            n3 = this.mVerticalAxis.getMeasure(n8);
            this.measureChildrenWithMargins(n7, n8, false);
            n4 = this.mHorizontalAxis.getMeasure(n7);
        }
        int n9 = Math.max(n4 + n5, this.getSuggestedMinimumWidth());
        int n10 = Math.max(n3 + n6, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(GridLayout.resolveSizeAndState(n9, n, 0), GridLayout.resolveSizeAndState(n10, n2, 0));
    }

    @Override
    protected void onSetLayoutParams(View view, ViewGroup.LayoutParams layoutParams) {
        super.onSetLayoutParams(view, layoutParams);
        if (!this.checkLayoutParams(layoutParams)) {
            GridLayout.handleInvalidParams("supplied LayoutParams are of the wrong type");
        }
        this.invalidateStructure();
    }

    @Override
    protected void onViewAdded(View view) {
        super.onViewAdded(view);
        this.invalidateStructure();
    }

    @Override
    protected void onViewRemoved(View view) {
        super.onViewRemoved(view);
        this.invalidateStructure();
    }

    @Override
    public void requestLayout() {
        super.requestLayout();
        this.invalidateValues();
    }

    public void setAlignmentMode(int n) {
        this.mAlignmentMode = n;
        this.requestLayout();
    }

    public void setColumnCount(int n) {
        this.mHorizontalAxis.setCount(n);
        this.invalidateStructure();
        this.requestLayout();
    }

    public void setColumnOrderPreserved(boolean bl) {
        this.mHorizontalAxis.setOrderPreserved(bl);
        this.invalidateStructure();
        this.requestLayout();
    }

    public void setOrientation(int n) {
        if (this.mOrientation != n) {
            this.mOrientation = n;
            this.invalidateStructure();
            this.requestLayout();
        }
    }

    public void setPrinter(Printer printer) {
        if (printer == null) {
            printer = NO_PRINTER;
        }
        this.mPrinter = printer;
    }

    public void setRowCount(int n) {
        this.mVerticalAxis.setCount(n);
        this.invalidateStructure();
        this.requestLayout();
    }

    public void setRowOrderPreserved(boolean bl) {
        this.mVerticalAxis.setOrderPreserved(bl);
        this.invalidateStructure();
        this.requestLayout();
    }

    public void setUseDefaultMargins(boolean bl) {
        this.mUseDefaultMargins = bl;
        this.requestLayout();
    }

    public static abstract class Alignment {
        Alignment() {
        }

        abstract int getAlignmentValue(View var1, int var2, int var3);

        Bounds getBounds() {
            return new Bounds();
        }

        abstract int getGravityOffset(View var1, int var2);

        int getSizeInCell(View view, int n, int n2) {
            return n;
        }
    }

    static final class Arc {
        public final Interval span;
        public boolean valid = true;
        public final MutableInt value;

        public Arc(Interval interval, MutableInt mutableInt) {
            this.span = interval;
            this.value = mutableInt;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String toString() {
            String string2;
            StringBuilder stringBuilder = new StringBuilder().append(this.span).append(" ");
            if (!this.valid) {
                string2 = "+>";
                return stringBuilder.append(string2).append(" ").append(this.value).toString();
            }
            string2 = "->";
            return stringBuilder.append(string2).append(" ").append(this.value).toString();
        }
    }

    static final class Assoc<K, V>
    extends ArrayList<Pair<K, V>> {
        private final Class<K> keyType;
        private final Class<V> valueType;

        private Assoc(Class<K> clazz, Class<V> clazz2) {
            this.keyType = clazz;
            this.valueType = clazz2;
        }

        public static <K, V> Assoc<K, V> of(Class<K> clazz, Class<V> clazz2) {
            return new Assoc<K, V>(clazz, clazz2);
        }

        public PackedMap<K, V> pack() {
            int n = this.size();
            Object[] objectArray = (Object[])Array.newInstance(this.keyType, n);
            Object[] objectArray2 = (Object[])Array.newInstance(this.valueType, n);
            for (int i = 0; i < n; ++i) {
                objectArray[i] = ((Pair)this.get((int)i)).first;
                objectArray2[i] = ((Pair)this.get((int)i)).second;
            }
            return new PackedMap(objectArray, objectArray2);
        }

        public void put(K k, V v) {
            this.add(Pair.create(k, v));
        }
    }

    final class Axis {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        private static final int COMPLETE = 2;
        private static final int NEW = 0;
        private static final int PENDING = 1;
        public Arc[] arcs;
        public boolean arcsValid = false;
        PackedMap<Interval, MutableInt> backwardLinks;
        public boolean backwardLinksValid = false;
        public int definedCount = Integer.MIN_VALUE;
        public int[] deltas;
        PackedMap<Interval, MutableInt> forwardLinks;
        public boolean forwardLinksValid = false;
        PackedMap<Spec, Bounds> groupBounds;
        public boolean groupBoundsValid = false;
        public boolean hasWeights;
        public boolean hasWeightsValid = false;
        public final boolean horizontal;
        public int[] leadingMargins;
        public boolean leadingMarginsValid = false;
        public int[] locations;
        public boolean locationsValid = false;
        private int maxIndex = Integer.MIN_VALUE;
        boolean orderPreserved = true;
        public int[] originalMeasurements;
        private MutableInt parentMax;
        private MutableInt parentMin = new MutableInt(0);
        public int[] trailingMargins;
        public boolean trailingMarginsValid = false;

        /*
         * Enabled aggressive block sorting
         */
        static {
            boolean bl = !GridLayout.class.desiredAssertionStatus();
            $assertionsDisabled = bl;
        }

        private Axis(boolean bl) {
            this.parentMax = new MutableInt(-100000);
            this.horizontal = bl;
        }

        private void addComponentSizes(List<Arc> list, PackedMap<Interval, MutableInt> packedMap) {
            for (int i = 0; i < ((Interval[])packedMap.keys).length; ++i) {
                this.include(list, ((Interval[])packedMap.keys)[i], ((MutableInt[])packedMap.values)[i], false);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private String arcsToString(List<Arc> list) {
            String string2 = this.horizontal ? "x" : "y";
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            Iterator<Arc> iterator = list.iterator();
            while (iterator.hasNext()) {
                Arc arc = iterator.next();
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder = stringBuilder.append(", ");
                }
                int n = arc.span.min;
                int n2 = arc.span.max;
                int n3 = arc.value.value;
                String string3 = n < n2 ? string2 + n2 + "-" + string2 + n + ">=" + n3 : string2 + n + "-" + string2 + n2 + "<=" + -n3;
                stringBuilder.append(string3);
            }
            return stringBuilder.toString();
        }

        /*
         * Enabled aggressive block sorting
         */
        private int calculateMaxIndex() {
            int n = -1;
            int n2 = GridLayout.this.getChildCount();
            for (int i = 0; i < n2; ++i) {
                View view = GridLayout.this.getChildAt(i);
                LayoutParams layoutParams = GridLayout.this.getLayoutParams(view);
                Spec spec = this.horizontal ? layoutParams.columnSpec : layoutParams.rowSpec;
                Interval interval = spec.span;
                n = Math.max(Math.max(Math.max(n, interval.min), interval.max), interval.size());
            }
            if (n != -1) return n;
            return Integer.MIN_VALUE;
        }

        private void computeArcs() {
            this.getForwardLinks();
            this.getBackwardLinks();
        }

        /*
         * Enabled aggressive block sorting
         */
        private void computeGroupBounds() {
            Bounds[] boundsArray = (Bounds[])this.groupBounds.values;
            for (int i = 0; i < boundsArray.length; ++i) {
                boundsArray[i].reset();
            }
            int n = 0;
            int n2 = GridLayout.this.getChildCount();
            while (n < n2) {
                View view = GridLayout.this.getChildAt(n);
                LayoutParams layoutParams = GridLayout.this.getLayoutParams(view);
                Spec spec = this.horizontal ? layoutParams.columnSpec : layoutParams.rowSpec;
                int n3 = spec.weight == 0.0f ? GridLayout.this.getMeasurementIncludingMargin(view, this.horizontal) : this.getOriginalMeasurements()[n] + this.getDeltas()[n];
                this.groupBounds.getValue(n).include(GridLayout.this, view, spec, this, n3);
                ++n;
            }
            return;
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean computeHasWeights() {
            int n = 0;
            int n2 = GridLayout.this.getChildCount();
            while (n < n2) {
                LayoutParams layoutParams = GridLayout.this.getLayoutParams(GridLayout.this.getChildAt(n));
                Spec spec = this.horizontal ? layoutParams.columnSpec : layoutParams.rowSpec;
                if (spec.weight != 0.0f) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void computeLinks(PackedMap<Interval, MutableInt> packedMap, boolean bl) {
            MutableInt[] mutableIntArray = (MutableInt[])packedMap.values;
            for (int i = 0; i < mutableIntArray.length; ++i) {
                mutableIntArray[i].reset();
            }
            Bounds[] boundsArray = (Bounds[])this.getGroupBounds().values;
            int n = 0;
            while (n < boundsArray.length) {
                int n2 = boundsArray[n].size(bl);
                MutableInt mutableInt = packedMap.getValue(n);
                int n3 = mutableInt.value;
                if (!bl) {
                    n2 = -n2;
                }
                mutableInt.value = Math.max(n3, n2);
                ++n;
            }
            return;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void computeLocations(int[] nArray) {
            if (!this.hasWeights()) {
                this.solve(nArray);
            } else {
                this.solveAndDistributeSpace(nArray);
            }
            if (!this.orderPreserved) {
                int n = nArray[0];
                int n2 = nArray.length;
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = nArray[i] - n;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void computeMargins(boolean bl) {
            int[] nArray = bl ? this.leadingMargins : this.trailingMargins;
            int n = 0;
            int n2 = GridLayout.this.getChildCount();
            while (n < n2) {
                View view = GridLayout.this.getChildAt(n);
                if (view.getVisibility() != 8) {
                    LayoutParams layoutParams = GridLayout.this.getLayoutParams(view);
                    Spec spec = this.horizontal ? layoutParams.columnSpec : layoutParams.rowSpec;
                    Interval interval = spec.span;
                    int n3 = bl ? interval.min : interval.max;
                    nArray[n3] = Math.max(nArray[n3], GridLayout.this.getMargin1(view, this.horizontal, bl));
                }
                ++n;
            }
            return;
        }

        private Arc[] createArcs() {
            ArrayList<Arc> arrayList = new ArrayList<Arc>();
            ArrayList<Arc> arrayList2 = new ArrayList<Arc>();
            this.addComponentSizes(arrayList, this.getForwardLinks());
            this.addComponentSizes(arrayList2, this.getBackwardLinks());
            if (this.orderPreserved) {
                for (int i = 0; i < this.getCount(); ++i) {
                    this.include(arrayList, new Interval(i, i + 1), new MutableInt(0));
                }
            }
            int n = this.getCount();
            this.include(arrayList, new Interval(0, n), this.parentMin, false);
            this.include(arrayList2, new Interval(n, 0), this.parentMax, false);
            return GridLayout.append(this.topologicalSort(arrayList), this.topologicalSort(arrayList2));
        }

        /*
         * Enabled aggressive block sorting
         */
        private PackedMap<Spec, Bounds> createGroupBounds() {
            Assoc<Spec, Bounds> assoc = Assoc.of(Spec.class, Bounds.class);
            int n = 0;
            int n2 = GridLayout.this.getChildCount();
            while (n < n2) {
                View view = GridLayout.this.getChildAt(n);
                LayoutParams layoutParams = GridLayout.this.getLayoutParams(view);
                Spec spec = this.horizontal ? layoutParams.columnSpec : layoutParams.rowSpec;
                assoc.put(spec, GridLayout.this.getAlignment(spec.alignment, this.horizontal).getBounds());
                ++n;
            }
            return assoc.pack();
        }

        /*
         * Enabled aggressive block sorting
         */
        private PackedMap<Interval, MutableInt> createLinks(boolean bl) {
            Assoc<Interval, MutableInt> assoc = Assoc.of(Interval.class, MutableInt.class);
            Spec[] specArray = (Spec[])this.getGroupBounds().keys;
            int n = 0;
            int n2 = specArray.length;
            while (n < n2) {
                Interval interval = bl ? specArray[n].span : specArray[n].span.inverse();
                assoc.put(interval, new MutableInt());
                ++n;
            }
            return assoc.pack();
        }

        private PackedMap<Interval, MutableInt> getBackwardLinks() {
            if (this.backwardLinks == null) {
                this.backwardLinks = this.createLinks(false);
            }
            if (!this.backwardLinksValid) {
                this.computeLinks(this.backwardLinks, false);
                this.backwardLinksValid = true;
            }
            return this.backwardLinks;
        }

        private PackedMap<Interval, MutableInt> getForwardLinks() {
            if (this.forwardLinks == null) {
                this.forwardLinks = this.createLinks(true);
            }
            if (!this.forwardLinksValid) {
                this.computeLinks(this.forwardLinks, true);
                this.forwardLinksValid = true;
            }
            return this.forwardLinks;
        }

        private int getMaxIndex() {
            if (this.maxIndex == Integer.MIN_VALUE) {
                this.maxIndex = Math.max(0, this.calculateMaxIndex());
            }
            return this.maxIndex;
        }

        private int getMeasure(int n, int n2) {
            this.setParentConstraints(n, n2);
            return this.size(this.getLocations());
        }

        private boolean hasWeights() {
            if (!this.hasWeightsValid) {
                this.hasWeights = this.computeHasWeights();
                this.hasWeightsValid = true;
            }
            return this.hasWeights;
        }

        private void include(List<Arc> list, Interval interval, MutableInt mutableInt) {
            this.include(list, interval, mutableInt, true);
        }

        private void include(List<Arc> list, Interval interval, MutableInt mutableInt, boolean bl) {
            if (interval.size() == 0) {
                return;
            }
            if (bl) {
                Iterator<Arc> iterator = list.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().span.equals(interval)) continue;
                    return;
                }
            }
            list.add(new Arc(interval, mutableInt));
        }

        private void init(int[] nArray) {
            Arrays.fill(nArray, 0);
        }

        private void logError(String string2, Arc[] arcArray, boolean[] blArray) {
            ArrayList<Arc> arrayList = new ArrayList<Arc>();
            ArrayList<Arc> arrayList2 = new ArrayList<Arc>();
            for (int i = 0; i < arcArray.length; ++i) {
                Arc arc = arcArray[i];
                if (blArray[i]) {
                    arrayList.add(arc);
                }
                if (arc.valid) continue;
                arrayList2.add(arc);
            }
            GridLayout.this.mPrinter.println(string2 + " constraints: " + this.arcsToString(arrayList) + " are inconsistent; permanently removing: " + this.arcsToString(arrayList2) + ". ");
        }

        private void recordOriginalMeasurement(int n) {
            if (this.hasWeights()) {
                this.getOriginalMeasurements()[n] = GridLayout.this.getMeasurementIncludingMargin(GridLayout.this.getChildAt(n), this.horizontal);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean relax(int[] nArray, Arc arc) {
            int n;
            block3: {
                block2: {
                    if (!arc.valid) break block2;
                    Interval interval = arc.span;
                    int n2 = interval.min;
                    n = arc.value.value + nArray[n2];
                    int n3 = interval.max;
                    if (n > nArray[n3]) break block3;
                }
                return false;
            }
            nArray[n3] = n;
            return true;
        }

        private void setParentConstraints(int n, int n2) {
            this.parentMin.value = n;
            this.parentMax.value = -n2;
            this.locationsValid = false;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void shareOutDelta() {
            int n = 0;
            float f = 0.0f;
            int n2 = GridLayout.this.getChildCount();
            for (int i = 0; i < n2; ++i) {
                View view = GridLayout.this.getChildAt(i);
                LayoutParams layoutParams = GridLayout.this.getLayoutParams(view);
                Spec spec = this.horizontal ? layoutParams.columnSpec : layoutParams.rowSpec;
                float f2 = spec.weight;
                if (f2 == 0.0f) continue;
                n += GridLayout.this.getMeasurement(view, this.horizontal) - this.getOriginalMeasurements()[i];
                f += f2;
            }
            int n3 = 0;
            int n4 = GridLayout.this.getChildCount();
            while (n3 < n4) {
                LayoutParams layoutParams = GridLayout.this.getLayoutParams(GridLayout.this.getChildAt(n3));
                Spec spec = this.horizontal ? layoutParams.columnSpec : layoutParams.rowSpec;
                float f3 = spec.weight;
                if (f3 != 0.0f) {
                    int n5;
                    this.deltas[n3] = n5 = Math.round(f3 * (float)n / f);
                    n -= n5;
                    f -= f3;
                }
                ++n3;
            }
            return;
        }

        private int size(int[] nArray) {
            return nArray[this.getCount()];
        }

        private void solve(int[] nArray) {
            this.solve(this.getArcs(), nArray);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void solve(Arc[] arcArray, int[] nArray) {
            String string2 = this.horizontal ? "horizontal" : "vertical";
            int n = 1 + this.getCount();
            boolean[] blArray = null;
            int n2 = 0;
            while (n2 < arcArray.length) {
                this.init(nArray);
                for (int i = 0; i < n; ++i) {
                    boolean bl = false;
                    int n3 = arcArray.length;
                    for (int j = 0; j < n3; bl |= this.relax(nArray, arcArray[j]), ++j) {
                    }
                    if (bl) continue;
                    if (blArray == null) return;
                    this.logError(string2, arcArray, blArray);
                    return;
                }
                boolean[] blArray2 = new boolean[arcArray.length];
                for (int i = 0; i < n; ++i) {
                    int n4 = arcArray.length;
                    for (int j = 0; j < n4; ++j) {
                        blArray2[j] = blArray2[j] | this.relax(nArray, arcArray[j]);
                    }
                }
                if (n2 == 0) {
                    blArray = blArray2;
                }
                for (int i = 0; i < arcArray.length; ++i) {
                    if (!blArray2[i]) continue;
                    Arc arc = arcArray[i];
                    if (arc.span.min < arc.span.max) {
                        continue;
                    }
                    arc.valid = false;
                    break;
                }
                ++n2;
            }
            return;
        }

        private void solveAndDistributeSpace(int[] nArray) {
            Arrays.fill(this.getDeltas(), 0);
            this.solve(nArray);
            this.shareOutDelta();
            this.arcsValid = false;
            this.forwardLinksValid = false;
            this.backwardLinksValid = false;
            this.groupBoundsValid = false;
            this.solve(nArray);
        }

        private Arc[] topologicalSort(List<Arc> list) {
            return this.topologicalSort(list.toArray(new Arc[list.size()]));
        }

        private Arc[] topologicalSort(final Arc[] arcArray) {
            return new Object(){
                static final /* synthetic */ boolean $assertionsDisabled;
                Arc[][] arcsByVertex;
                int cursor;
                Arc[] result;
                int[] visited;

                /*
                 * Enabled aggressive block sorting
                 */
                static {
                    boolean bl = !GridLayout.class.desiredAssertionStatus();
                    $assertionsDisabled = bl;
                }
                {
                    this.result = new Arc[arcArray.length];
                    this.cursor = -1 + this.result.length;
                    this.arcsByVertex = Axis.this.groupArcsByFirstVertex(arcArray);
                    this.visited = new int[1 + Axis.this.getCount()];
                }

                Arc[] sort() {
                    int n = this.arcsByVertex.length;
                    for (int i = 0; i < n; ++i) {
                        this.walk(i);
                    }
                    if (!$assertionsDisabled && this.cursor != -1) {
                        throw new AssertionError();
                    }
                    return this.result;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                void walk(int n) {
                    switch (this.visited[n]) {
                        default: {
                            return;
                        }
                        case 0: {
                            this.visited[n] = 1;
                            Arc[] arcArray3 = this.arcsByVertex[n];
                            int n2 = arcArray3.length;
                            int n3 = 0;
                            while (true) {
                                if (n3 >= n2) {
                                    this.visited[n] = 2;
                                    return;
                                }
                                Arc arc = arcArray3[n3];
                                this.walk(arc.span.max);
                                Arc[] arcArray2 = this.result;
                                int n4 = this.cursor;
                                this.cursor = n4 - 1;
                                arcArray2[n4] = arc;
                                ++n3;
                            }
                        }
                        case 1: {
                            if ($assertionsDisabled) return;
                            throw new AssertionError();
                        }
                    }
                }
            }.sort();
        }

        public Arc[] getArcs() {
            if (this.arcs == null) {
                this.arcs = this.createArcs();
            }
            if (!this.arcsValid) {
                this.computeArcs();
                this.arcsValid = true;
            }
            return this.arcs;
        }

        public int getCount() {
            return Math.max(this.definedCount, this.getMaxIndex());
        }

        public int[] getDeltas() {
            if (this.deltas == null) {
                this.deltas = new int[GridLayout.this.getChildCount()];
            }
            return this.deltas;
        }

        public PackedMap<Spec, Bounds> getGroupBounds() {
            if (this.groupBounds == null) {
                this.groupBounds = this.createGroupBounds();
            }
            if (!this.groupBoundsValid) {
                this.computeGroupBounds();
                this.groupBoundsValid = true;
            }
            return this.groupBounds;
        }

        public int[] getLeadingMargins() {
            if (this.leadingMargins == null) {
                this.leadingMargins = new int[1 + this.getCount()];
            }
            if (!this.leadingMarginsValid) {
                this.computeMargins(true);
                this.leadingMarginsValid = true;
            }
            return this.leadingMargins;
        }

        public int[] getLocations() {
            if (this.locations == null) {
                this.locations = new int[1 + this.getCount()];
            }
            if (!this.locationsValid) {
                this.computeLocations(this.locations);
                this.locationsValid = true;
            }
            return this.locations;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getMeasure(int n) {
            int n2 = View.MeasureSpec.getMode(n);
            int n3 = View.MeasureSpec.getSize(n);
            switch (n2) {
                default: {
                    boolean bl = $assertionsDisabled;
                    int n4 = 0;
                    if (bl) return n4;
                    throw new AssertionError();
                }
                case 0: {
                    return this.getMeasure(0, 100000);
                }
                case 0x40000000: {
                    return this.getMeasure(n3, n3);
                }
                case -2147483648: 
            }
            return this.getMeasure(0, n3);
        }

        public int[] getOriginalMeasurements() {
            if (this.originalMeasurements == null) {
                this.originalMeasurements = new int[GridLayout.this.getChildCount()];
            }
            return this.originalMeasurements;
        }

        public int[] getTrailingMargins() {
            if (this.trailingMargins == null) {
                this.trailingMargins = new int[1 + this.getCount()];
            }
            if (!this.trailingMarginsValid) {
                this.computeMargins(false);
                this.trailingMarginsValid = true;
            }
            return this.trailingMargins;
        }

        Arc[][] groupArcsByFirstVertex(Arc[] arcArray) {
            int n = 1 + this.getCount();
            Arc[][] arcArray2 = new Arc[n][];
            int[] nArray = new int[n];
            int n2 = arcArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = arcArray[i].span.min;
                nArray[n3] = 1 + nArray[n3];
            }
            for (int i = 0; i < nArray.length; ++i) {
                arcArray2[i] = new Arc[nArray[i]];
            }
            Arrays.fill(nArray, 0);
            for (Arc arc : arcArray) {
                int n4 = arc.span.min;
                Arc[] arcArray3 = arcArray2[n4];
                int n5 = nArray[n4];
                nArray[n4] = n5 + 1;
                arcArray3[n5] = arc;
            }
            return arcArray2;
        }

        public void invalidateStructure() {
            this.maxIndex = Integer.MIN_VALUE;
            this.groupBounds = null;
            this.forwardLinks = null;
            this.backwardLinks = null;
            this.leadingMargins = null;
            this.trailingMargins = null;
            this.arcs = null;
            this.locations = null;
            this.originalMeasurements = null;
            this.deltas = null;
            this.hasWeightsValid = false;
            this.invalidateValues();
        }

        public void invalidateValues() {
            this.groupBoundsValid = false;
            this.forwardLinksValid = false;
            this.backwardLinksValid = false;
            this.leadingMarginsValid = false;
            this.trailingMarginsValid = false;
            this.arcsValid = false;
            this.locationsValid = false;
        }

        public boolean isOrderPreserved() {
            return this.orderPreserved;
        }

        public void layout(int n) {
            this.setParentConstraints(n, n);
            this.getLocations();
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setCount(int n) {
            if (n != Integer.MIN_VALUE && n < this.getMaxIndex()) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = this.horizontal ? "column" : "row";
                GridLayout.handleInvalidParams(stringBuilder.append(string2).append("Count must be greater than or equal to the maximum of all grid indices ").append("(and spans) defined in the LayoutParams of each child").toString());
            }
            this.definedCount = n;
        }

        public void setOrderPreserved(boolean bl) {
            this.orderPreserved = bl;
            this.invalidateStructure();
        }
    }

    static class Bounds {
        public int after;
        public int before;
        public int flexibility;

        private Bounds() {
            this.reset();
        }

        protected int getOffset(GridLayout gridLayout, View view, Alignment alignment, int n, boolean bl) {
            return this.before - alignment.getAlignmentValue(view, n, gridLayout.getLayoutMode());
        }

        protected void include(int n, int n2) {
            this.before = Math.max(this.before, n);
            this.after = Math.max(this.after, n2);
        }

        protected final void include(GridLayout gridLayout, View view, Spec spec, Axis axis, int n) {
            this.flexibility &= spec.getFlexibility();
            boolean bl = axis.horizontal;
            int n2 = gridLayout.getAlignment(spec.alignment, bl).getAlignmentValue(view, n, gridLayout.getLayoutMode());
            this.include(n2, n - n2);
        }

        protected void reset() {
            this.before = Integer.MIN_VALUE;
            this.after = Integer.MIN_VALUE;
            this.flexibility = 2;
        }

        protected int size(boolean bl) {
            if (!bl && GridLayout.canStretch(this.flexibility)) {
                return 100000;
            }
            return this.before + this.after;
        }

        public String toString() {
            return "Bounds{before=" + this.before + ", after=" + this.after + '}';
        }
    }

    static final class Interval {
        public final int max;
        public final int min;

        public Interval(int n, int n2) {
            this.min = n;
            this.max = n2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block6: {
                block5: {
                    if (this == object) break block5;
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Interval interval = (Interval)object;
                    if (this.max != interval.max) {
                        return false;
                    }
                    if (this.min != interval.min) break block6;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.min + this.max;
        }

        Interval inverse() {
            return new Interval(this.max, this.min);
        }

        int size() {
            return this.max - this.min;
        }

        public String toString() {
            return "[" + this.min + ", " + this.max + "]";
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        private static final int BOTTOM_MARGIN = 6;
        private static final int COLUMN = 1;
        private static final int COLUMN_SPAN = 4;
        private static final int COLUMN_WEIGHT = 6;
        private static final int DEFAULT_COLUMN = Integer.MIN_VALUE;
        private static final int DEFAULT_HEIGHT = -2;
        private static final int DEFAULT_MARGIN = Integer.MIN_VALUE;
        private static final int DEFAULT_ROW = Integer.MIN_VALUE;
        private static final Interval DEFAULT_SPAN = new Interval(Integer.MIN_VALUE, -2147483647);
        private static final int DEFAULT_SPAN_SIZE = 0;
        private static final int DEFAULT_WIDTH = -2;
        private static final int GRAVITY = 0;
        private static final int LEFT_MARGIN = 3;
        private static final int MARGIN = 2;
        private static final int RIGHT_MARGIN = 5;
        private static final int ROW = 2;
        private static final int ROW_SPAN = 3;
        private static final int ROW_WEIGHT = 5;
        private static final int TOP_MARGIN = 4;
        public Spec columnSpec;
        public Spec rowSpec = Spec.UNDEFINED;

        static {
            DEFAULT_SPAN_SIZE = DEFAULT_SPAN.size();
        }

        public LayoutParams() {
            this(Spec.UNDEFINED, Spec.UNDEFINED);
        }

        private LayoutParams(int n, int n2, int n3, int n4, int n5, int n6, Spec spec, Spec spec2) {
            super(n, n2);
            this.columnSpec = Spec.UNDEFINED;
            this.setMargins(n3, n4, n5, n6);
            this.rowSpec = spec;
            this.columnSpec = spec2;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.columnSpec = Spec.UNDEFINED;
            this.reInitSuper(context, attributeSet);
            this.init(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.columnSpec = Spec.UNDEFINED;
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.columnSpec = Spec.UNDEFINED;
        }

        public LayoutParams(LayoutParams layoutParams) {
            super(layoutParams);
            this.columnSpec = Spec.UNDEFINED;
            this.rowSpec = layoutParams.rowSpec;
            this.columnSpec = layoutParams.columnSpec;
        }

        public LayoutParams(Spec spec, Spec spec2) {
            this(-2, -2, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, spec, spec2);
        }

        private void init(Context context, AttributeSet attributeSet) {
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.GridLayout_Layout);
            try {
                int n = typedArray.getInt(0, 0);
                int n2 = typedArray.getInt(1, Integer.MIN_VALUE);
                int n3 = typedArray.getInt(4, DEFAULT_SPAN_SIZE);
                float f = typedArray.getFloat(6, 0.0f);
                this.columnSpec = GridLayout.spec(n2, n3, GridLayout.getAlignment(n, true), f);
                int n4 = typedArray.getInt(2, Integer.MIN_VALUE);
                int n5 = typedArray.getInt(3, DEFAULT_SPAN_SIZE);
                float f2 = typedArray.getFloat(5, 0.0f);
                this.rowSpec = GridLayout.spec(n4, n5, GridLayout.getAlignment(n, false), f2);
                return;
            }
            finally {
                typedArray.recycle();
            }
        }

        private void reInitSuper(Context context, AttributeSet attributeSet) {
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.ViewGroup_MarginLayout);
            try {
                int n = typedArray.getDimensionPixelSize(2, Integer.MIN_VALUE);
                this.leftMargin = typedArray.getDimensionPixelSize(3, n);
                this.topMargin = typedArray.getDimensionPixelSize(4, n);
                this.rightMargin = typedArray.getDimensionPixelSize(5, n);
                this.bottomMargin = typedArray.getDimensionPixelSize(6, n);
                return;
            }
            finally {
                typedArray.recycle();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block6: {
                block5: {
                    if (this == object) break block5;
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    LayoutParams layoutParams = (LayoutParams)object;
                    if (!this.columnSpec.equals(layoutParams.columnSpec)) {
                        return false;
                    }
                    if (!this.rowSpec.equals(layoutParams.rowSpec)) break block6;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return 31 * this.rowSpec.hashCode() + this.columnSpec.hashCode();
        }

        @Override
        protected void setBaseAttributes(TypedArray typedArray, int n, int n2) {
            this.width = typedArray.getLayoutDimension(n, -2);
            this.height = typedArray.getLayoutDimension(n2, -2);
        }

        final void setColumnSpecSpan(Interval interval) {
            this.columnSpec = this.columnSpec.copyWriteSpan(interval);
        }

        public void setGravity(int n) {
            this.rowSpec = this.rowSpec.copyWriteAlignment(GridLayout.getAlignment(n, false));
            this.columnSpec = this.columnSpec.copyWriteAlignment(GridLayout.getAlignment(n, true));
        }

        final void setRowSpecSpan(Interval interval) {
            this.rowSpec = this.rowSpec.copyWriteSpan(interval);
        }
    }

    static final class MutableInt {
        public int value;

        public MutableInt() {
            this.reset();
        }

        public MutableInt(int n) {
            this.value = n;
        }

        public void reset() {
            this.value = Integer.MIN_VALUE;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    static final class PackedMap<K, V> {
        public final int[] index;
        public final K[] keys;
        public final V[] values;

        private PackedMap(K[] KArray, V[] VArray) {
            this.index = PackedMap.createIndex(KArray);
            this.keys = PackedMap.compact(KArray, this.index);
            this.values = PackedMap.compact(VArray, this.index);
        }

        private static <K> K[] compact(K[] KArray, int[] nArray) {
            int n = KArray.length;
            Object[] objectArray = (Object[])Array.newInstance(KArray.getClass().getComponentType(), 1 + GridLayout.max2(nArray, -1));
            for (int i = 0; i < n; ++i) {
                objectArray[nArray[i]] = KArray[i];
            }
            return objectArray;
        }

        private static <K> int[] createIndex(K[] KArray) {
            int n = KArray.length;
            int[] nArray = new int[n];
            HashMap<K, Integer> hashMap = new HashMap<K, Integer>();
            for (int i = 0; i < n; ++i) {
                K k = KArray[i];
                Integer n2 = (Integer)hashMap.get(k);
                if (n2 == null) {
                    n2 = hashMap.size();
                    hashMap.put(k, n2);
                }
                nArray[i] = n2;
            }
            return nArray;
        }

        public V getValue(int n) {
            return this.values[this.index[n]];
        }
    }

    public static class Spec {
        static final float DEFAULT_WEIGHT;
        static final Spec UNDEFINED;
        final Alignment alignment;
        final Interval span;
        final boolean startDefined;
        final float weight;

        static {
            UNDEFINED = GridLayout.spec(Integer.MIN_VALUE);
        }

        private Spec(boolean bl, int n, int n2, Alignment alignment, float f) {
            this(bl, new Interval(n, n + n2), alignment, f);
        }

        private Spec(boolean bl, Interval interval, Alignment alignment, float f) {
            this.startDefined = bl;
            this.span = interval;
            this.alignment = alignment;
            this.weight = f;
        }

        final Spec copyWriteAlignment(Alignment alignment) {
            return new Spec(this.startDefined, this.span, alignment, this.weight);
        }

        final Spec copyWriteSpan(Interval interval) {
            return new Spec(this.startDefined, interval, this.alignment, this.weight);
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block6: {
                block5: {
                    if (this == object) break block5;
                    if (object == null || this.getClass() != object.getClass()) {
                        return false;
                    }
                    Spec spec = (Spec)object;
                    if (!this.alignment.equals(spec.alignment)) {
                        return false;
                    }
                    if (!this.span.equals(spec.span)) break block6;
                }
                return true;
            }
            return false;
        }

        final int getFlexibility() {
            if (this.alignment == UNDEFINED_ALIGNMENT && this.weight == 0.0f) {
                return 0;
            }
            return 2;
        }

        public int hashCode() {
            return 31 * this.span.hashCode() + this.alignment.hashCode();
        }
    }
}

