/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;

public abstract class Filter {
    private static final int FILTER_TOKEN = -791613427;
    private static final int FINISH_TOKEN = -559038737;
    private static final String LOG_TAG = "Filter";
    private static final String THREAD_NAME = "Filter";
    private Delayer mDelayer;
    private final Object mLock = new Object();
    private Handler mResultHandler = new ResultsHandler();
    private Handler mThreadHandler;

    static /* synthetic */ Handler access$402(Filter filter, Handler handler) {
        filter.mThreadHandler = handler;
        return handler;
    }

    public CharSequence convertResultToString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public final void filter(CharSequence charSequence) {
        this.filter(charSequence, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void filter(CharSequence charSequence, FilterListener filterListener) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mThreadHandler == null) {
                HandlerThread handlerThread = new HandlerThread("Filter", 10);
                handlerThread.start();
                this.mThreadHandler = new RequestHandler(handlerThread.getLooper());
            }
            long l = this.mDelayer == null ? 0L : this.mDelayer.getPostingDelay(charSequence);
            Message message = this.mThreadHandler.obtainMessage(-791613427);
            RequestArguments requestArguments = new RequestArguments();
            String string2 = null;
            if (charSequence != null) {
                string2 = charSequence.toString();
            }
            requestArguments.constraint = string2;
            requestArguments.listener = filterListener;
            message.obj = requestArguments;
            this.mThreadHandler.removeMessages(-791613427);
            this.mThreadHandler.removeMessages(-559038737);
            this.mThreadHandler.sendMessageDelayed(message, l);
            return;
        }
    }

    protected abstract FilterResults performFiltering(CharSequence var1);

    protected abstract void publishResults(CharSequence var1, FilterResults var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDelayer(Delayer delayer) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDelayer = delayer;
            return;
        }
    }

    public static interface Delayer {
        public long getPostingDelay(CharSequence var1);
    }

    public static interface FilterListener {
        public void onFilterComplete(int var1);
    }

    protected static class FilterResults {
        public int count;
        public Object values;
    }

    private static class RequestArguments {
        CharSequence constraint;
        FilterListener listener;
        FilterResults results;

        private RequestArguments() {
        }
    }

    private class RequestHandler
    extends Handler {
        public RequestHandler(Looper looper) {
            super(looper);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            int n = message.what;
            switch (n) {
                default: {
                    return;
                }
                case -791613427: {
                    RequestArguments requestArguments = (RequestArguments)message.obj;
                    try {
                        requestArguments.results = Filter.this.performFiltering(requestArguments.constraint);
                        Message message2 = Filter.this.mResultHandler.obtainMessage(n);
                        message2.obj = requestArguments;
                        message2.sendToTarget();
                    }
                    catch (Exception exception) {
                        try {
                            requestArguments.results = new FilterResults();
                            Log.w("Filter", "An exception occured during performFiltering()!", exception);
                            Message message3 = Filter.this.mResultHandler.obtainMessage(n);
                            message3.obj = requestArguments;
                            message3.sendToTarget();
                        }
                        catch (Throwable throwable) {
                            Message message4 = Filter.this.mResultHandler.obtainMessage(n);
                            message4.obj = requestArguments;
                            message4.sendToTarget();
                            throw throwable;
                        }
                    }
                    Object object = Filter.this.mLock;
                    synchronized (object) {
                        if (Filter.this.mThreadHandler != null) {
                            Message message5 = Filter.this.mThreadHandler.obtainMessage(-559038737);
                            Filter.this.mThreadHandler.sendMessageDelayed(message5, 3000L);
                        }
                        return;
                    }
                }
                case -559038737: 
            }
            Object object = Filter.this.mLock;
            synchronized (object) {
                if (Filter.this.mThreadHandler != null) {
                    Filter.this.mThreadHandler.getLooper().quit();
                    Filter.access$402(Filter.this, null);
                }
                return;
            }
        }
    }

    private class ResultsHandler
    extends Handler {
        private ResultsHandler() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            RequestArguments requestArguments = (RequestArguments)message.obj;
            Filter.this.publishResults(requestArguments.constraint, requestArguments.results);
            if (requestArguments.listener != null) {
                int n = requestArguments.results != null ? requestArguments.results.count : -1;
                requestArguments.listener.onFilterComplete(n);
            }
        }
    }
}

