/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.IntProperty;
import android.util.MathUtils;
import android.util.Property;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListConnector;
import android.widget.ExpandableListView;
import android.widget.HeaderViewListAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.SectionIndexer;
import android.widget.TextView;
import com.android.internal.R;

class FastScroller {
    private static Property<View, Integer> BOTTOM;
    private static final int DURATION_CROSS_FADE = 50;
    private static final int DURATION_FADE_IN = 150;
    private static final int DURATION_FADE_OUT = 300;
    private static final int DURATION_RESIZE = 100;
    private static final long FADE_TIMEOUT = 1500L;
    private static Property<View, Integer> LEFT;
    private static final int MIN_PAGES = 4;
    private static final int OVERLAY_ABOVE_THUMB = 2;
    private static final int OVERLAY_AT_THUMB = 1;
    private static final int OVERLAY_FLOATING = 0;
    private static final int PREVIEW_LEFT = 0;
    private static final int PREVIEW_RIGHT = 1;
    private static Property<View, Integer> RIGHT;
    private static final int STATE_DRAGGING = 2;
    private static final int STATE_NONE = 0;
    private static final int STATE_VISIBLE = 1;
    private static final long TAP_TIMEOUT;
    private static Property<View, Integer> TOP;
    private boolean mAlwaysShow;
    private final Rect mContainerRect;
    private int mCurrentSection;
    private AnimatorSet mDecorAnimation;
    private final Runnable mDeferHide;
    private boolean mEnabled;
    private int mFirstVisibleItem;
    private int mHeaderCount;
    private float mInitialTouchY;
    private boolean mLayoutFromRight;
    private final AbsListView mList;
    private Adapter mListAdapter;
    private boolean mLongList;
    private boolean mMatchDragPosition;
    private int mOldChildCount;
    private int mOldItemCount;
    private final ViewGroupOverlay mOverlay;
    private int mOverlayPosition;
    private long mPendingDrag;
    private AnimatorSet mPreviewAnimation;
    private final View mPreviewImage;
    private int mPreviewMinHeight;
    private int mPreviewMinWidth;
    private int mPreviewPadding;
    private final int[] mPreviewResId;
    private final TextView mPrimaryText;
    private int mScaledTouchSlop;
    private int mScrollBarStyle;
    private boolean mScrollCompleted;
    private int mScrollbarPosition;
    private final TextView mSecondaryText;
    private SectionIndexer mSectionIndexer;
    private Object[] mSections;
    private boolean mShowingPreview;
    private boolean mShowingPrimary;
    private int mState;
    private final Animator.AnimatorListener mSwitchPrimaryListener;
    private final Rect mTempBounds;
    private final Rect mTempMargins;
    private int mTextAppearance;
    private ColorStateList mTextColor;
    private float mTextSize;
    private Drawable mThumbDrawable;
    private final ImageView mThumbImage;
    private int mThumbMinHeight;
    private int mThumbMinWidth;
    private Drawable mTrackDrawable;
    private final ImageView mTrackImage;
    private boolean mUpdatingLayout;
    private int mWidth;

    static {
        TAP_TIMEOUT = ViewConfiguration.getTapTimeout();
        LEFT = new IntProperty<View>("left"){

            @Override
            public Integer get(View view) {
                return view.getLeft();
            }

            @Override
            public void setValue(View view, int n) {
                view.setLeft(n);
            }
        };
        TOP = new IntProperty<View>("top"){

            @Override
            public Integer get(View view) {
                return view.getTop();
            }

            @Override
            public void setValue(View view, int n) {
                view.setTop(n);
            }
        };
        RIGHT = new IntProperty<View>("right"){

            @Override
            public Integer get(View view) {
                return view.getRight();
            }

            @Override
            public void setValue(View view, int n) {
                view.setRight(n);
            }
        };
        BOTTOM = new IntProperty<View>("bottom"){

            @Override
            public Integer get(View view) {
                return view.getBottom();
            }

            @Override
            public void setValue(View view, int n) {
                view.setBottom(n);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    public FastScroller(AbsListView absListView, int n) {
        ViewGroupOverlay viewGroupOverlay;
        boolean bl = true;
        this.mTempBounds = new Rect();
        this.mTempMargins = new Rect();
        this.mContainerRect = new Rect();
        this.mPreviewResId = new int[2];
        this.mCurrentSection = -1;
        this.mScrollbarPosition = -1;
        this.mPendingDrag = -1L;
        this.mDeferHide = new Runnable(){

            @Override
            public void run() {
                FastScroller.this.setState(0);
            }
        };
        this.mSwitchPrimaryListener = new AnimatorListenerAdapter(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void onAnimationEnd(Animator animator2) {
                FastScroller fastScroller = FastScroller.this;
                boolean bl = !FastScroller.this.mShowingPrimary;
                FastScroller.access$102(fastScroller, bl);
            }
        };
        this.mList = absListView;
        this.mOldItemCount = absListView.getCount();
        this.mOldChildCount = absListView.getChildCount();
        Context context = absListView.getContext();
        this.mScaledTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
        this.mScrollBarStyle = absListView.getScrollBarStyle();
        this.mScrollCompleted = bl;
        this.mState = bl ? 1 : 0;
        if (context.getApplicationInfo().targetSdkVersion < 11) {
            bl = false;
        }
        this.mMatchDragPosition = bl;
        this.mTrackImage = new ImageView(context);
        this.mTrackImage.setScaleType(ImageView.ScaleType.FIT_XY);
        this.mThumbImage = new ImageView(context);
        this.mThumbImage.setScaleType(ImageView.ScaleType.FIT_XY);
        this.mPreviewImage = new View(context);
        this.mPreviewImage.setAlpha(0.0f);
        this.mPrimaryText = this.createPreviewTextView(context);
        this.mSecondaryText = this.createPreviewTextView(context);
        this.setStyle(n);
        this.mOverlay = viewGroupOverlay = absListView.getOverlay();
        viewGroupOverlay.add(this.mTrackImage);
        viewGroupOverlay.add(this.mThumbImage);
        viewGroupOverlay.add(this.mPreviewImage);
        viewGroupOverlay.add(this.mPrimaryText);
        viewGroupOverlay.add(this.mSecondaryText);
        this.getSectionsFromIndexer();
        this.updateLongList(this.mOldChildCount, this.mOldItemCount);
        this.setScrollbarPosition(absListView.getVerticalScrollbarPosition());
        this.postAutoHide();
    }

    static /* synthetic */ boolean access$102(FastScroller fastScroller, boolean bl) {
        fastScroller.mShowingPrimary = bl;
        return bl;
    }

    private static Animator animateAlpha(View view, float f) {
        return ObjectAnimator.ofFloat(view, View.ALPHA, f);
    }

    private static Animator animateBounds(View view, Rect rect) {
        Property<View, Integer> property = LEFT;
        int[] nArray = new int[]{rect.left};
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofInt(property, nArray);
        Property<View, Integer> property2 = TOP;
        int[] nArray2 = new int[]{rect.top};
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt(property2, nArray2);
        Property<View, Integer> property3 = RIGHT;
        int[] nArray3 = new int[]{rect.right};
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofInt(property3, nArray3);
        Property<View, Integer> property4 = BOTTOM;
        int[] nArray4 = new int[]{rect.bottom};
        return ObjectAnimator.ofPropertyValuesHolder(view, propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, PropertyValuesHolder.ofInt(property4, nArray4));
    }

    private static Animator animateScaleX(View view, float f) {
        return ObjectAnimator.ofFloat(view, View.SCALE_X, f);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void applyLayout(View view, Rect rect) {
        view.layout(rect.left, rect.top, rect.right, rect.bottom);
        float f = this.mLayoutFromRight ? (float)(rect.right - rect.left) : 0.0f;
        view.setPivotX(f);
    }

    private void beginDrag() {
        this.mPendingDrag = -1L;
        this.setState(2);
        if (this.mListAdapter == null && this.mList != null) {
            this.getSectionsFromIndexer();
        }
        if (this.mList != null) {
            this.mList.requestDisallowInterceptTouchEvent(true);
            this.mList.reportScrollStateChange(1);
        }
        this.cancelFling();
    }

    private void cancelFling() {
        MotionEvent motionEvent = MotionEvent.obtain(0L, 0L, 3, 0.0f, 0.0f, 0);
        this.mList.onTouchEvent(motionEvent);
        motionEvent.recycle();
    }

    private void cancelPendingDrag() {
        this.mPendingDrag = -1L;
    }

    private TextView createPreviewTextView(Context context) {
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
        TextView textView = new TextView(context);
        textView.setLayoutParams(layoutParams);
        textView.setSingleLine(true);
        textView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
        textView.setGravity(17);
        textView.setAlpha(0.0f);
        textView.setLayoutDirection(this.mList.getLayoutDirection());
        return textView;
    }

    /*
     * Enabled aggressive block sorting
     */
    private float getPosFromItemCount(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (this.mSectionIndexer == null || this.mListAdapter == null) {
            this.getSectionsFromIndexer();
        }
        boolean bl = this.mSectionIndexer != null && this.mSections != null && this.mSections.length > 0;
        if (!bl) return (float)n / (float)(n3 - n2);
        if (!this.mMatchDragPosition) {
            return (float)n / (float)(n3 - n2);
        }
        int n7 = n - this.mHeaderCount;
        if (n7 < 0) {
            return 0.0f;
        }
        int n8 = n3 - this.mHeaderCount;
        View view = this.mList.getChildAt(0);
        float f = view == null || view.getHeight() == 0 ? 0.0f : (float)(this.mList.getPaddingTop() - view.getTop()) / (float)view.getHeight();
        int n9 = this.mSectionIndexer.getSectionForPosition(n7);
        int n10 = this.mSectionIndexer.getPositionForSection(n9);
        int n11 = this.mSections.length;
        if (n9 < n11 - 1) {
            int n12 = n9 + 1 < n11 ? this.mSectionIndexer.getPositionForSection(n9 + 1) : n8 - 1;
            n6 = n12 - n10;
        } else {
            n6 = n8 - n10;
        }
        float f2 = n6 == 0 ? 0.0f : (f + (float)n7 - (float)n10) / (float)n6;
        float f3 = (f2 + (float)n9) / (float)n11;
        if (n7 <= 0) return f3;
        if (n7 + n2 != n8) return f3;
        View view2 = this.mList.getChildAt(n2 - 1);
        int n13 = this.mList.getPaddingBottom();
        if (this.mList.getClipToPadding()) {
            n5 = view2.getHeight();
            n4 = this.mList.getHeight() - n13 - view2.getTop();
        } else {
            n5 = n13 + view2.getHeight();
            n4 = this.mList.getHeight() - view2.getTop();
        }
        if (n4 <= 0) return f3;
        if (n5 <= 0) return f3;
        return f3 + (1.0f - f3) * ((float)n4 / (float)n5);
    }

    private float getPosFromMotionEvent(float f) {
        ImageView imageView = this.mTrackImage;
        float f2 = imageView.getTop();
        float f3 = (float)imageView.getBottom() - f2;
        if (f3 <= 0.0f) {
            return 0.0f;
        }
        return MathUtils.constrain((f - f2) / f3, 0.0f, 1.0f);
    }

    private void getSectionsFromIndexer() {
        this.mSectionIndexer = null;
        Object object = this.mList.getAdapter();
        if (object instanceof HeaderViewListAdapter) {
            this.mHeaderCount = ((HeaderViewListAdapter)object).getHeadersCount();
            object = ((HeaderViewListAdapter)object).getWrappedAdapter();
        }
        if (object instanceof ExpandableListConnector) {
            ExpandableListAdapter expandableListAdapter = ((ExpandableListConnector)object).getAdapter();
            if (expandableListAdapter instanceof SectionIndexer) {
                this.mSectionIndexer = (SectionIndexer)((Object)expandableListAdapter);
                this.mListAdapter = object;
                this.mSections = this.mSectionIndexer.getSections();
            }
            return;
        }
        if (object instanceof SectionIndexer) {
            this.mListAdapter = object;
            this.mSectionIndexer = (SectionIndexer)object;
            this.mSections = this.mSectionIndexer.getSections();
            return;
        }
        this.mListAdapter = object;
        this.mSections = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Animator groupAnimatorOfFloat(Property<View, Float> property, float f, View ... viewArray) {
        AnimatorSet animatorSet = new AnimatorSet();
        AnimatorSet.Builder builder = null;
        int n = -1 + viewArray.length;
        while (n >= 0) {
            ObjectAnimator objectAnimator = ObjectAnimator.ofFloat(viewArray[n], property, f);
            if (builder == null) {
                builder = animatorSet.play(objectAnimator);
            } else {
                builder.with(objectAnimator);
            }
            --n;
        }
        return animatorSet;
    }

    private boolean isPointInside(float f, float f2) {
        return this.isPointInsideX(f) && (this.mTrackDrawable != null || this.isPointInsideY(f2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isPointInsideX(float f) {
        if (this.mLayoutFromRight) {
            if (f >= (float)this.mThumbImage.getLeft()) return true;
            return false;
        }
        if (!(f <= (float)this.mThumbImage.getRight())) return false;
        return true;
    }

    private boolean isPointInsideY(float f) {
        float f2 = this.mThumbImage.getTranslationY();
        float f3 = f2 + (float)this.mThumbImage.getTop();
        float f4 = f2 + (float)this.mThumbImage.getBottom();
        return f >= f3 && f <= f4;
    }

    private void layoutThumb() {
        Rect rect = this.mTempBounds;
        this.measureViewToSide(this.mThumbImage, null, null, rect);
        this.applyLayout(this.mThumbImage, rect);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void layoutTrack() {
        ImageView imageView = this.mTrackImage;
        ImageView imageView2 = this.mThumbImage;
        Rect rect = this.mContainerRect;
        imageView.measure(View.MeasureSpec.makeMeasureSpec(rect.width(), Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(0, 0));
        int n = imageView.getMeasuredWidth();
        int n2 = 0;
        if (imageView2 != null) {
            n2 = imageView2.getHeight() / 2;
        }
        int n3 = imageView2.getLeft() + (imageView2.getWidth() - n) / 2;
        int n4 = n3 + n;
        imageView.layout(n3, n2 + rect.top, n4, rect.bottom - n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void measureFloating(View view, Rect rect, Rect rect2) {
        int n;
        int n2;
        int n3;
        if (rect == null) {
            n3 = 0;
            n2 = 0;
            n = 0;
        } else {
            n3 = rect.left;
            n2 = rect.top;
            n = rect.right;
        }
        Rect rect3 = this.mContainerRect;
        int n4 = rect3.width();
        view.measure(View.MeasureSpec.makeMeasureSpec(n4 - n3 - n, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(0, 0));
        int n5 = rect3.height();
        int n6 = view.getMeasuredWidth();
        int n7 = n2 + n5 / 10 + rect3.top;
        int n8 = n7 + view.getMeasuredHeight();
        int n9 = (n4 - n6) / 2 + rect3.left;
        rect2.set(n9, n7, n9 + n6, n8);
    }

    private void measurePreview(View view, Rect rect) {
        Rect rect2 = this.mTempMargins;
        rect2.left = this.mPreviewImage.getPaddingLeft();
        rect2.top = this.mPreviewImage.getPaddingTop();
        rect2.right = this.mPreviewImage.getPaddingRight();
        rect2.bottom = this.mPreviewImage.getPaddingBottom();
        if (this.mOverlayPosition == 0) {
            this.measureFloating(view, rect2, rect);
            return;
        }
        this.measureViewToSide(view, this.mThumbImage, rect2, rect);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void measureViewToSide(View view, View view2, Rect rect, Rect rect2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (rect == null) {
            n5 = 0;
            n4 = 0;
            n3 = 0;
        } else {
            n5 = rect.left;
            n4 = rect.top;
            n3 = rect.right;
        }
        Rect rect3 = this.mContainerRect;
        int n6 = rect3.width();
        int n7 = view2 == null ? n6 : (this.mLayoutFromRight ? view2.getLeft() : n6 - view2.getRight());
        int n8 = n7 - n5 - n3;
        view.measure(View.MeasureSpec.makeMeasureSpec(n8, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(0, 0));
        int n9 = Math.min(n8, view.getMeasuredWidth());
        if (this.mLayoutFromRight) {
            int n10 = view2 == null ? rect3.right : view2.getLeft();
            n2 = n10 - n3;
            n = n2 - n9;
        } else {
            int n11 = view2 == null ? rect3.left : view2.getRight();
            n = n11 + n5;
            n2 = n + n9;
        }
        int n12 = n4;
        rect2.set(n, n12, n2, n12 + view.getMeasuredHeight());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onStateDependencyChanged(boolean bl) {
        block5: {
            block3: {
                block4: {
                    if (!this.isEnabled()) break block3;
                    if (!this.isAlwaysShowEnabled()) break block4;
                    this.setState(1);
                    break block5;
                }
                if (this.mState == 1) {
                    this.postAutoHide();
                    break block5;
                } else if (bl) {
                    this.setState(1);
                    this.postAutoHide();
                }
                break block5;
            }
            this.stop();
        }
        this.mList.resolvePadding();
    }

    private void postAutoHide() {
        this.mList.removeCallbacks(this.mDeferHide);
        this.mList.postDelayed(this.mDeferHide, 1500L);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void refreshDrawablePressedState() {
        boolean bl = this.mState == 2;
        this.mThumbImage.setPressed(bl);
        this.mTrackImage.setPressed(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scrollTo(float f) {
        int n;
        block19: {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            block17: {
                int n9;
                int n10;
                block18: {
                    block16: {
                        this.mScrollCompleted = false;
                        n8 = this.mList.getCount();
                        Object[] objectArray = this.mSections;
                        n7 = objectArray == null ? 0 : objectArray.length;
                        if (objectArray == null || n7 <= 1) break block16;
                        n10 = n6 = MathUtils.constrain((int)(f * (float)n7), 0, n7 - 1);
                        n9 = this.mSectionIndexer.getPositionForSection(n10);
                        n = n10;
                        n5 = n8;
                        n4 = n9;
                        n3 = n10;
                        n2 = n10 + 1;
                        int n11 = n7 - 1;
                        if (n10 < n11) {
                            n5 = this.mSectionIndexer.getPositionForSection(n10 + 1);
                        }
                        if (n5 != n9) break block17;
                        break block18;
                    }
                    int n12 = MathUtils.constrain((int)(f * (float)n8), 0, n8 - 1);
                    if (this.mList instanceof ExpandableListView) {
                        ExpandableListView expandableListView = (ExpandableListView)this.mList;
                        expandableListView.setSelectionFromTop(expandableListView.getFlatListPosition(ExpandableListView.getPackedPositionForGroup(n12 + this.mHeaderCount)), 0);
                    } else if (this.mList instanceof ListView) {
                        ((ListView)this.mList).setSelectionFromTop(n12 + this.mHeaderCount, 0);
                    } else {
                        this.mList.setSelection(n12 + this.mHeaderCount);
                    }
                    n = -1;
                    break block19;
                }
                while (n10 > 0) {
                    if ((n4 = this.mSectionIndexer.getPositionForSection(--n10)) != n9) {
                        n3 = n10;
                        n = n10;
                        break;
                    }
                    if (n10 != 0) continue;
                    n = 0;
                    break;
                }
            }
            for (int i = n2 + 1; i < n7 && this.mSectionIndexer.getPositionForSection(i) == n5; ++i, ++n2) {
            }
            float f2 = (float)n3 / (float)n7;
            float f3 = (float)n2 / (float)n7;
            float f4 = n8 == 0 ? Float.MAX_VALUE : 0.125f / (float)n8;
            int n13 = n3 == n6 && f - f2 < f4 ? n4 : n4 + (int)((float)(n5 - n4) * (f - f2) / (f3 - f2));
            int n14 = n8 - 1;
            int n15 = MathUtils.constrain(n13, 0, n14);
            if (this.mList instanceof ExpandableListView) {
                ExpandableListView expandableListView = (ExpandableListView)this.mList;
                expandableListView.setSelectionFromTop(expandableListView.getFlatListPosition(ExpandableListView.getPackedPositionForGroup(n15 + this.mHeaderCount)), 0);
            } else if (this.mList instanceof ListView) {
                ((ListView)this.mList).setSelectionFromTop(n15 + this.mHeaderCount, 0);
            } else {
                this.mList.setSelection(n15 + this.mHeaderCount);
            }
        }
        if (this.mCurrentSection == n) return;
        this.mCurrentSection = n;
        boolean bl = this.transitionPreviewLayout(n);
        if (!this.mShowingPreview && bl) {
            this.transitionToDragging();
            return;
        } else {
            if (!this.mShowingPreview || bl) return;
            this.transitionToVisible();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setState(int n) {
        this.mList.removeCallbacks(this.mDeferHide);
        if (this.mAlwaysShow && n == 0) {
            n = 1;
        }
        if (n == this.mState) {
            return;
        }
        switch (n) {
            case 0: {
                this.transitionToHidden();
                break;
            }
            case 1: {
                this.transitionToVisible();
                break;
            }
            case 2: {
                if (this.transitionPreviewLayout(this.mCurrentSection)) {
                    this.transitionToDragging();
                    break;
                }
                this.transitionToVisible();
                break;
            }
        }
        this.mState = n;
        this.refreshDrawablePressedState();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setThumbPos(float f) {
        float f2;
        Rect rect = this.mContainerRect;
        int n = rect.top;
        int n2 = rect.bottom;
        ImageView imageView = this.mTrackImage;
        ImageView imageView2 = this.mThumbImage;
        float f3 = imageView.getTop();
        float f4 = f3 + f * ((float)imageView.getBottom() - f3);
        imageView2.setTranslationY(f4 - (float)(imageView2.getHeight() / 2));
        View view = this.mPreviewImage;
        float f5 = (float)view.getHeight() / 2.0f;
        switch (this.mOverlayPosition) {
            default: {
                f2 = 0.0f;
                break;
            }
            case 1: {
                f2 = f4;
                break;
            }
            case 2: {
                f2 = f4 - f5;
            }
        }
        float f6 = MathUtils.constrain(f2, f5 + (float)n, (float)n2 - f5) - f5;
        view.setTranslationY(f6);
        this.mPrimaryText.setTranslationY(f6);
        this.mSecondaryText.setTranslationY(f6);
    }

    private void startPendingDrag() {
        this.mPendingDrag = SystemClock.uptimeMillis() + TAP_TIMEOUT;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean transitionPreviewLayout(int n) {
        int n2;
        TextView textView;
        TextView textView2;
        Object[] objectArray = this.mSections;
        String string2 = null;
        if (objectArray != null) {
            string2 = null;
            if (n >= 0) {
                int n3 = objectArray.length;
                string2 = null;
                if (n < n3) {
                    Object object = objectArray[n];
                    string2 = null;
                    if (object != null) {
                        string2 = object.toString();
                    }
                }
            }
        }
        Rect rect = this.mTempBounds;
        View view = this.mPreviewImage;
        if (this.mShowingPrimary) {
            textView2 = this.mPrimaryText;
            textView = this.mSecondaryText;
        } else {
            textView2 = this.mSecondaryText;
            textView = this.mPrimaryText;
        }
        textView.setText(string2);
        this.measurePreview(textView, rect);
        this.applyLayout(textView, rect);
        if (this.mPreviewAnimation != null) {
            this.mPreviewAnimation.cancel();
        }
        Animator animator2 = FastScroller.animateAlpha(textView, 1.0f).setDuration(50L);
        Animator animator3 = FastScroller.animateAlpha(textView2, 0.0f).setDuration(50L);
        animator3.addListener(this.mSwitchPrimaryListener);
        rect.left -= view.getPaddingLeft();
        rect.top -= view.getPaddingTop();
        rect.right += view.getPaddingRight();
        rect.bottom += view.getPaddingBottom();
        Animator animator4 = FastScroller.animateBounds(view, rect);
        animator4.setDuration(100L);
        this.mPreviewAnimation = new AnimatorSet();
        AnimatorSet.Builder builder = this.mPreviewAnimation.play(animator3).with(animator2);
        builder.with(animator4);
        int n4 = view.getWidth() - view.getPaddingLeft() - view.getPaddingRight();
        int n5 = textView.getWidth();
        if (n5 > n4) {
            float f = (float)n4 / (float)n5;
            textView.setScaleX(f);
            builder.with(FastScroller.animateScaleX(textView, 1.0f).setDuration(100L));
        } else {
            textView.setScaleX(1.0f);
        }
        if ((n2 = textView2.getWidth()) > n5) {
            builder.with(FastScroller.animateScaleX(textView2, (float)n5 / (float)n2).setDuration(100L));
        }
        this.mPreviewAnimation.start();
        return !TextUtils.isEmpty(string2);
    }

    private void transitionToDragging() {
        if (this.mDecorAnimation != null) {
            this.mDecorAnimation.cancel();
        }
        Property<View, Float> property = View.ALPHA;
        View[] viewArray = new View[]{this.mThumbImage, this.mTrackImage, this.mPreviewImage};
        Animator animator2 = FastScroller.groupAnimatorOfFloat(property, 1.0f, viewArray).setDuration(150L);
        Property<View, Float> property2 = View.TRANSLATION_X;
        View[] viewArray2 = new View[]{this.mThumbImage, this.mTrackImage};
        Animator animator3 = FastScroller.groupAnimatorOfFloat(property2, 0.0f, viewArray2).setDuration(150L);
        this.mDecorAnimation = new AnimatorSet();
        this.mDecorAnimation.playTogether(animator2, animator3);
        this.mDecorAnimation.start();
        this.mShowingPreview = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void transitionToHidden() {
        if (this.mDecorAnimation != null) {
            this.mDecorAnimation.cancel();
        }
        Property<View, Float> property = View.ALPHA;
        View[] viewArray = new View[]{this.mThumbImage, this.mTrackImage, this.mPreviewImage, this.mPrimaryText, this.mSecondaryText};
        Animator animator2 = FastScroller.groupAnimatorOfFloat(property, 0.0f, viewArray).setDuration(300L);
        float f = this.mLayoutFromRight ? (float)this.mThumbImage.getWidth() : (float)(-this.mThumbImage.getWidth());
        Property<View, Float> property2 = View.TRANSLATION_X;
        View[] viewArray2 = new View[]{this.mThumbImage, this.mTrackImage};
        Animator animator3 = FastScroller.groupAnimatorOfFloat(property2, f, viewArray2).setDuration(300L);
        this.mDecorAnimation = new AnimatorSet();
        this.mDecorAnimation.playTogether(animator2, animator3);
        this.mDecorAnimation.start();
        this.mShowingPreview = false;
    }

    private void transitionToVisible() {
        if (this.mDecorAnimation != null) {
            this.mDecorAnimation.cancel();
        }
        Property<View, Float> property = View.ALPHA;
        View[] viewArray = new View[]{this.mThumbImage, this.mTrackImage};
        Animator animator2 = FastScroller.groupAnimatorOfFloat(property, 1.0f, viewArray).setDuration(150L);
        Property<View, Float> property2 = View.ALPHA;
        View[] viewArray2 = new View[]{this.mPreviewImage, this.mPrimaryText, this.mSecondaryText};
        Animator animator3 = FastScroller.groupAnimatorOfFloat(property2, 0.0f, viewArray2).setDuration(300L);
        Property<View, Float> property3 = View.TRANSLATION_X;
        View[] viewArray3 = new View[]{this.mThumbImage, this.mTrackImage};
        Animator animator4 = FastScroller.groupAnimatorOfFloat(property3, 0.0f, viewArray3).setDuration(150L);
        this.mDecorAnimation = new AnimatorSet();
        this.mDecorAnimation.playTogether(animator2, animator3, animator4);
        this.mDecorAnimation.start();
        this.mShowingPreview = false;
    }

    private void updateAppearance() {
        Context context = this.mList.getContext();
        this.mTrackImage.setImageDrawable(this.mTrackDrawable);
        Drawable drawable2 = this.mTrackDrawable;
        int n = 0;
        if (drawable2 != null) {
            n = Math.max(0, this.mTrackDrawable.getIntrinsicWidth());
        }
        this.mThumbImage.setImageDrawable(this.mThumbDrawable);
        this.mThumbImage.setMinimumWidth(this.mThumbMinWidth);
        this.mThumbImage.setMinimumHeight(this.mThumbMinHeight);
        if (this.mThumbDrawable != null) {
            n = Math.max(n, this.mThumbDrawable.getIntrinsicWidth());
        }
        this.mWidth = Math.max(n, this.mThumbMinWidth);
        this.mPreviewImage.setMinimumWidth(this.mPreviewMinWidth);
        this.mPreviewImage.setMinimumHeight(this.mPreviewMinHeight);
        if (this.mTextAppearance != 0) {
            this.mPrimaryText.setTextAppearance(context, this.mTextAppearance);
            this.mSecondaryText.setTextAppearance(context, this.mTextAppearance);
        }
        if (this.mTextColor != null) {
            this.mPrimaryText.setTextColor(this.mTextColor);
            this.mSecondaryText.setTextColor(this.mTextColor);
        }
        if (this.mTextSize > 0.0f) {
            this.mPrimaryText.setTextSize(0, this.mTextSize);
            this.mSecondaryText.setTextSize(0, this.mTextSize);
        }
        int n2 = Math.max(0, this.mPreviewMinHeight);
        this.mPrimaryText.setMinimumWidth(n2);
        this.mPrimaryText.setMinimumHeight(n2);
        this.mPrimaryText.setIncludeFontPadding(false);
        this.mSecondaryText.setMinimumWidth(n2);
        this.mSecondaryText.setMinimumHeight(n2);
        this.mSecondaryText.setIncludeFontPadding(false);
        this.refreshDrawablePressedState();
    }

    private void updateContainerRect() {
        int n;
        block3: {
            block2: {
                AbsListView absListView = this.mList;
                absListView.resolvePadding();
                Rect rect = this.mContainerRect;
                rect.left = 0;
                rect.top = 0;
                rect.right = absListView.getWidth();
                rect.bottom = absListView.getHeight();
                int n2 = this.mScrollBarStyle;
                if (n2 != 0x1000000 && n2 != 0) break block2;
                rect.left += absListView.getPaddingLeft();
                rect.top += absListView.getPaddingTop();
                rect.right -= absListView.getPaddingRight();
                rect.bottom -= absListView.getPaddingBottom();
                if (n2 != 0x1000000) break block2;
                n = this.getWidth();
                if (this.mScrollbarPosition != 2) break block3;
                rect.right = n + rect.right;
            }
            return;
        }
        rect.left -= n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateLongList(int n, int n2) {
        boolean bl = n > 0 && n2 / n >= 4;
        if (this.mLongList != bl) {
            this.mLongList = bl;
            this.onStateDependencyChanged(false);
        }
    }

    public int getWidth() {
        return this.mWidth;
    }

    public boolean isAlwaysShowEnabled() {
        return this.mAlwaysShow;
    }

    public boolean isEnabled() {
        return this.mEnabled && (this.mLongList || this.mAlwaysShow);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onInterceptHoverEvent(MotionEvent motionEvent) {
        int n;
        if (!this.isEnabled() || (n = motionEvent.getActionMasked()) != 9 && n != 7 || this.mState != 0 || !this.isPointInside(motionEvent.getX(), motionEvent.getY())) {
            return false;
        }
        this.setState(1);
        this.postAutoHide();
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (!this.isEnabled()) return false;
        switch (motionEvent.getActionMasked()) {
            default: {
                return false;
            }
            case 0: {
                if (!this.isPointInside(motionEvent.getX(), motionEvent.getY())) return false;
                if (!this.mList.isInScrollingContainer()) {
                    this.beginDrag();
                    return true;
                }
                this.mInitialTouchY = motionEvent.getY();
                this.startPendingDrag();
                return false;
            }
            case 2: {
                if (!this.isPointInside(motionEvent.getX(), motionEvent.getY())) {
                    this.cancelPendingDrag();
                    return false;
                }
                if (this.mPendingDrag < 0L || this.mPendingDrag > SystemClock.uptimeMillis()) {
                    return false;
                }
                this.beginDrag();
                this.scrollTo(this.getPosFromMotionEvent(this.mInitialTouchY));
                return this.onTouchEvent(motionEvent);
            }
            case 1: 
            case 3: 
        }
        this.cancelPendingDrag();
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onItemCountChanged(int n, int n2) {
        if (this.mOldItemCount != n2 || this.mOldChildCount != n) {
            this.mOldItemCount = n2;
            this.mOldChildCount = n;
            boolean bl = n2 - n > 0;
            if (bl && this.mState != 2) {
                this.setThumbPos(this.getPosFromItemCount(this.mList.getFirstVisiblePosition(), n, n2));
            }
            this.updateLongList(n, n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onScroll(int n, int n2, int n3) {
        if (!this.isEnabled()) {
            this.setState(0);
            return;
        } else {
            int n4 = n3 - n2;
            boolean bl = false;
            if (n4 > 0) {
                bl = true;
            }
            if (bl && this.mState != 2) {
                this.setThumbPos(this.getPosFromItemCount(n, n2, n3));
            }
            this.mScrollCompleted = true;
            if (this.mFirstVisibleItem == n) return;
            this.mFirstVisibleItem = n;
            if (this.mState == 2) return;
            this.setState(1);
            this.postAutoHide();
            return;
        }
    }

    public void onSectionsChanged() {
        this.mListAdapter = null;
    }

    public void onSizeChanged(int n, int n2, int n3, int n4) {
        this.updateLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.isEnabled()) return false;
        switch (motionEvent.getActionMasked()) {
            default: {
                return false;
            }
            case 1: {
                if (this.mPendingDrag >= 0L) {
                    this.beginDrag();
                    float f = this.getPosFromMotionEvent(motionEvent.getY());
                    this.setThumbPos(f);
                    this.scrollTo(f);
                }
                if (this.mState != 2) return false;
                if (this.mList != null) {
                    this.mList.requestDisallowInterceptTouchEvent(false);
                    this.mList.reportScrollStateChange(0);
                }
                this.setState(1);
                this.postAutoHide();
                return true;
            }
            case 2: {
                if (this.mPendingDrag >= 0L && Math.abs(motionEvent.getY() - this.mInitialTouchY) > (float)this.mScaledTouchSlop) {
                    this.beginDrag();
                }
                if (this.mState != 2) {
                    return false;
                }
                float f = this.getPosFromMotionEvent(motionEvent.getY());
                this.setThumbPos(f);
                if (!this.mScrollCompleted) return true;
                this.scrollTo(f);
                return true;
            }
            case 3: 
        }
        this.cancelPendingDrag();
        return false;
    }

    public void remove() {
        this.mOverlay.remove(this.mTrackImage);
        this.mOverlay.remove(this.mThumbImage);
        this.mOverlay.remove(this.mPreviewImage);
        this.mOverlay.remove(this.mPrimaryText);
        this.mOverlay.remove(this.mSecondaryText);
    }

    public void setAlwaysShow(boolean bl) {
        if (this.mAlwaysShow != bl) {
            this.mAlwaysShow = bl;
            this.onStateDependencyChanged(false);
        }
    }

    public void setEnabled(boolean bl) {
        if (this.mEnabled != bl) {
            this.mEnabled = bl;
            this.onStateDependencyChanged(true);
        }
    }

    public void setScrollBarStyle(int n) {
        if (this.mScrollBarStyle != n) {
            this.mScrollBarStyle = n;
            this.updateLayout();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setScrollbarPosition(int n) {
        int n2 = 1;
        if (n == 0) {
            n = this.mList.isLayoutRtl() ? n2 : 2;
        }
        if (this.mScrollbarPosition != n) {
            this.mScrollbarPosition = n;
            int n3 = n != n2 ? n2 : 0;
            this.mLayoutFromRight = n3;
            int[] nArray = this.mPreviewResId;
            if (!this.mLayoutFromRight) {
                n2 = 0;
            }
            int n4 = nArray[n2];
            this.mPreviewImage.setBackgroundResource(n4);
            Drawable drawable2 = this.mPreviewImage.getBackground();
            if (drawable2 != null) {
                Rect rect = this.mTempBounds;
                drawable2.getPadding(rect);
                rect.offset(this.mPreviewPadding, this.mPreviewPadding);
                this.mPreviewImage.setPadding(rect.left, rect.top, rect.right, rect.bottom);
            }
            this.updateLayout();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setStyle(int n) {
        TypedArray typedArray = this.mList.getContext().obtainStyledAttributes(null, R.styleable.FastScroll, 16843767, n);
        int n2 = typedArray.getIndexCount();
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                this.updateAppearance();
                return;
            }
            int n4 = typedArray.getIndex(n3);
            switch (n4) {
                case 12: {
                    this.mOverlayPosition = typedArray.getInt(n4, 0);
                    break;
                }
                case 11: {
                    this.mPreviewResId[0] = typedArray.getResourceId(n4, 0);
                    break;
                }
                case 10: {
                    this.mPreviewResId[1] = typedArray.getResourceId(n4, 0);
                    break;
                }
                case 6: {
                    this.mThumbDrawable = typedArray.getDrawable(n4);
                    break;
                }
                case 9: {
                    this.mTrackDrawable = typedArray.getDrawable(n4);
                    break;
                }
                case 0: {
                    this.mTextAppearance = typedArray.getResourceId(n4, 0);
                    break;
                }
                case 2: {
                    this.mTextColor = typedArray.getColorStateList(n4);
                    break;
                }
                case 1: {
                    this.mTextSize = typedArray.getDimensionPixelSize(n4, 0);
                    break;
                }
                case 4: {
                    this.mPreviewMinWidth = typedArray.getDimensionPixelSize(n4, 0);
                    break;
                }
                case 5: {
                    this.mPreviewMinHeight = typedArray.getDimensionPixelSize(n4, 0);
                    break;
                }
                case 7: {
                    this.mThumbMinWidth = typedArray.getDimensionPixelSize(n4, 0);
                    break;
                }
                case 8: {
                    this.mThumbMinHeight = typedArray.getDimensionPixelSize(n4, 0);
                    break;
                }
                case 3: {
                    this.mPreviewPadding = typedArray.getDimensionPixelSize(n4, 0);
                    break;
                }
            }
            ++n3;
        }
    }

    public void stop() {
        this.setState(0);
    }

    public void updateLayout() {
        if (this.mUpdatingLayout) {
            return;
        }
        this.mUpdatingLayout = true;
        this.updateContainerRect();
        this.layoutThumb();
        this.layoutTrack();
        Rect rect = this.mTempBounds;
        this.measurePreview(this.mPrimaryText, rect);
        this.applyLayout(this.mPrimaryText, rect);
        this.measurePreview(this.mSecondaryText, rect);
        this.applyLayout(this.mSecondaryText, rect);
        if (this.mPreviewImage != null) {
            rect.left -= this.mPreviewImage.getPaddingLeft();
            rect.top -= this.mPreviewImage.getPaddingTop();
            rect.right += this.mPreviewImage.getPaddingRight();
            rect.bottom += this.mPreviewImage.getPaddingBottom();
            this.applyLayout(this.mPreviewImage, rect);
        }
        this.mUpdatingLayout = false;
    }
}

