/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.R;
import android.app.Activity;
import android.app.PendingIntent;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.content.UndoManager;
import android.content.UndoOperation;
import android.content.UndoOwner;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.ExtractEditText;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.DynamicLayout;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextUtils;
import android.text.method.KeyListener;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.WordIterator;
import android.text.style.EasyEditSpan;
import android.text.style.SuggestionRangeSpan;
import android.text.style.SuggestionSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.URLSpan;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ActionMode;
import android.view.DragEvent;
import android.view.HardwareCanvas;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.RenderNode;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.CursorAnchorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.SpellChecker;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.widget.EditableInputConnection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class Editor {
    static final int BLINK = 500;
    static final boolean DEBUG_UNDO = false;
    private static int DRAG_SHADOW_MAX_TEXT_LENGTH = 0;
    static final int EXTRACT_NOTHING = -2;
    static final int EXTRACT_UNKNOWN = -1;
    private static final String LOG_TAG = "Magnifier";
    private static final String TAG = "Editor";
    private static final float[] TEMP_POSITION = new float[2];
    private int MAX_ITEM = 4;
    Blink mBlink;
    CorrectionHighlighter mCorrectionHighlighter;
    boolean mCreatedWithASelection;
    final CursorAnchorInfoNotifier mCursorAnchorInfoNotifier;
    int mCursorCount;
    final Drawable[] mCursorDrawable = new Drawable[2];
    private int mCursorHorizontalOffset;
    private boolean mCursorInLineEnd = false;
    boolean mCursorVisible = true;
    ActionMode.Callback mCustomSelectionActionModeCallback;
    boolean mDiscardNextActionUp;
    CharSequence mError;
    ErrorPopup mErrorPopup;
    boolean mErrorWasChanged;
    boolean mFrozenWithFocus;
    private HandleView mHandleShowingMagnifier;
    boolean mIgnoreActionUpEvent;
    boolean mInBatchEditControllers;
    InputContentType mInputContentType;
    InputMethodState mInputMethodState;
    int mInputType = 0;
    boolean mInsertionControllerEnabled;
    InsertionPointCursorController mInsertionPointCursorController;
    private boolean mIsFirstCall = true;
    private boolean mIsFromActionMode = false;
    KeyListener mKeyListener;
    float mLastDownPositionX;
    float mLastDownPositionY;
    private Magnifier mMagnifier;
    boolean mMagnifierEnabled = true;
    private WindowManager.LayoutParams mMagnifierLayoutParam;
    private int mOldEndLine = -1;
    private int mOldLine = -1;
    private int mOldStartLine = -1;
    private PositionListener mPositionListener;
    boolean mPreserveDetachedSelection;
    boolean mSelectAllOnFocus;
    private Drawable mSelectHandleCenter;
    private Drawable mSelectHandleLeft;
    private Drawable mSelectHandleRight;
    ActionMode mSelectionActionMode;
    boolean mSelectionControllerEnabled;
    SelectionModifierCursorController mSelectionModifierCursorController;
    boolean mSelectionMoved;
    long mShowCursor;
    boolean mShowErrorAfterAttach;
    boolean mShowSoftInputOnFocus = true;
    Runnable mShowSuggestionRunnable;
    private SpanController mSpanController;
    SpellChecker mSpellChecker;
    SuggestionRangeSpan mSuggestionRangeSpan;
    SuggestionsPopupWindow mSuggestionsPopupWindow;
    private Rect mTempRect;
    boolean mTemporaryDetach;
    TextDisplayList[] mTextDisplayLists;
    boolean mTextIsSelectable;
    private TextView mTextView;
    boolean mTouchFocusSelected;
    InputFilter mUndoInputFilter;
    UndoManager mUndoManager;
    UndoOwner mUndoOwner;
    private WindowManager mWindowManager;
    WordIterator mWordIterator;

    static {
        DRAG_SHADOW_MAX_TEXT_LENGTH = 20;
    }

    Editor(TextView textView) {
        this.mCursorAnchorInfoNotifier = new CursorAnchorInfoNotifier();
        this.mTextView = textView;
    }

    static /* synthetic */ Rect access$2502(Editor editor, Rect rect) {
        editor.mTempRect = rect;
        return rect;
    }

    static /* synthetic */ boolean access$2802(Editor editor, boolean bl) {
        editor.mIsFirstCall = bl;
        return bl;
    }

    static /* synthetic */ boolean access$2902(Editor editor, boolean bl) {
        editor.mIsFromActionMode = bl;
        return bl;
    }

    static /* synthetic */ Magnifier access$4002(Editor editor, Magnifier magnifier) {
        editor.mMagnifier = magnifier;
        return magnifier;
    }

    static /* synthetic */ Drawable access$4102(Editor editor, Drawable drawable2) {
        editor.mSelectHandleCenter = drawable2;
        return drawable2;
    }

    static /* synthetic */ Drawable access$4302(Editor editor, Drawable drawable2) {
        editor.mSelectHandleLeft = drawable2;
        return drawable2;
    }

    static /* synthetic */ Drawable access$4402(Editor editor, Drawable drawable2) {
        editor.mSelectHandleRight = drawable2;
        return drawable2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int calculateTheFakeOffset(float f, float f2) {
        boolean bl = true;
        int n = this.mTextView.getOffsetForPosition(f, f2);
        int n2 = this.mTextView.getLayout().getLineForOffset(n);
        boolean bl2 = n2 == this.mTextView.getLayout().getLineForOffset(n + 1) ? false : bl;
        boolean bl3 = f > this.mTextView.getLayout().getLineRight(n2) && bl2 ? bl : false;
        boolean bl4 = n < this.mTextView.getText().toString().length() && "\n".equals(this.mTextView.getText().toString().substring(n, n + 1)) ? bl : false;
        if (bl3 != bl || bl4) {
            bl = false;
        }
        this.mCursorInLineEnd = bl;
        if (this.mCursorInLineEnd) {
            ++n;
        }
        return n;
    }

    private boolean canSelectText() {
        return this.hasSelectionController() && this.mTextView.getText().length() != 0;
    }

    private void chooseSize(PopupWindow popupWindow, CharSequence charSequence, TextView textView) {
        int n = textView.getPaddingLeft() + textView.getPaddingRight();
        int n2 = textView.getPaddingTop() + textView.getPaddingBottom();
        int n3 = this.mTextView.getResources().getDimensionPixelSize(17104970);
        StaticLayout staticLayout = new StaticLayout(charSequence, textView.getPaint(), n3, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        float f = 0.0f;
        for (int i = 0; i < ((Layout)staticLayout).getLineCount(); ++i) {
            f = Math.max(f, staticLayout.getLineWidth(i));
        }
        popupWindow.setWidth(n + (int)Math.ceil(f));
        popupWindow.setHeight(n2 + staticLayout.getHeight());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void destroyDisplayListsData() {
        if (this.mTextDisplayLists != null) {
            for (int i = 0; i < this.mTextDisplayLists.length; ++i) {
                RenderNode renderNode = this.mTextDisplayLists[i] != null ? this.mTextDisplayLists[i].displayList : null;
                if (renderNode == null || !renderNode.isValid()) continue;
                renderNode.destroyDisplayListData();
            }
        }
    }

    private void dismissMagnifier() {
        if (this.mMagnifier != null) {
            this.mWindowManager.removeView(this.mMagnifier);
            this.mMagnifier = null;
        }
        this.mHandleShowingMagnifier = null;
    }

    private void dismissMagnifierUntilNextCursorAppearance() {
        if (this.mMagnifier != null) {
            this.mWindowManager.removeView(this.mMagnifier);
            this.mMagnifier = null;
        }
    }

    private void downgradeEasyCorrectionSpans() {
        CharSequence charSequence = this.mTextView.getText();
        if (charSequence instanceof Spannable) {
            Spannable spannable = (Spannable)charSequence;
            SuggestionSpan[] suggestionSpanArray = spannable.getSpans(0, spannable.length(), SuggestionSpan.class);
            for (int i = 0; i < suggestionSpanArray.length; ++i) {
                int n = suggestionSpanArray[i].getFlags();
                if ((n & 1) == 0 || (n & 2) != 0) continue;
                int n2 = n & 0xFFFFFFFE;
                suggestionSpanArray[i].setFlags(n2);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawCursor(Canvas canvas, int n) {
        boolean bl = n != 0;
        if (bl) {
            canvas.translate(0.0f, n);
        }
        for (int i = 0; i < this.mCursorCount; ++i) {
            this.mCursorDrawable[i].draw(canvas);
        }
        if (bl) {
            canvas.translate(0.0f, -n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void drawHardwareAccelerated(Canvas canvas, Layout layout2, Path path, Paint paint, int n) {
        HardwareCanvas hardwareCanvas;
        RenderNode renderNode;
        long l = layout2.getLineRangeForDraw(canvas);
        int n2 = TextUtils.unpackRangeStartFromLong(l);
        int n3 = TextUtils.unpackRangeEndFromLong(l);
        if (n3 < 0) {
            return;
        }
        layout2.drawBackground(canvas, path, paint, n, n2, n3);
        if (!(layout2 instanceof DynamicLayout)) {
            layout2.drawText(canvas, n2, n3);
            return;
        }
        if (this.mTextDisplayLists == null) {
            this.mTextDisplayLists = ArrayUtils.emptyArray(TextDisplayList.class);
        }
        DynamicLayout dynamicLayout = (DynamicLayout)layout2;
        int[] nArray = dynamicLayout.getBlockEndLines();
        int[] nArray2 = dynamicLayout.getBlockIndices();
        int n4 = dynamicLayout.getNumberOfBlocks();
        int n5 = dynamicLayout.getIndexFirstChangedBlock();
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        while (true) {
            if (n8 >= n4) {
                dynamicLayout.setIndexFirstChangedBlock(n4);
                return;
            }
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            boolean bl = n10 == -1;
            if (bl) {
                nArray2[n8] = n10 = this.getAvailableDisplayListIndex(nArray2, n4, n7);
                n7 = n10 + 1;
            }
            if (this.mTextDisplayLists[n10] == null) {
                this.mTextDisplayLists[n10] = new TextDisplayList("Text " + n10);
            }
            boolean bl2 = this.mTextDisplayLists[n10].needsRecord();
            renderNode = this.mTextDisplayLists[n10].displayList;
            if (n8 >= n5 || bl2) {
                int n11 = n6 + 1;
                int n12 = layout2.getLineTop(n11);
                int n13 = layout2.getLineBottom(n9);
                int n14 = this.mTextView.getWidth();
                boolean bl3 = this.mTextView.getHorizontallyScrolling();
                int n15 = 0;
                if (bl3) {
                    float f = Float.MAX_VALUE;
                    float f2 = Float.MIN_VALUE;
                    for (int i = n11; i <= n9; ++i) {
                        float f3 = layout2.getLineLeft(i);
                        f = Math.min(f, f3);
                        float f4 = layout2.getLineRight(i);
                        f2 = Math.max(f2, f4);
                    }
                    n15 = (int)f;
                    n14 = (int)(0.5f + f2);
                }
                if (bl2) {
                    hardwareCanvas = renderNode.start(n14 - n15, n13 - n12);
                    float f = -n15;
                    float f5 = -n12;
                    hardwareCanvas.translate(f, f5);
                    layout2.drawText(hardwareCanvas, n11, n9);
                }
                renderNode.setLeftTopRightBottom(n15, n12, n14, n13);
            }
            ((HardwareCanvas)canvas).drawRenderNode(renderNode, null, 0);
            n6 = n9;
            ++n8;
        }
        finally {
            renderNode.end(hardwareCanvas);
            renderNode.setClipToBounds(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean extractTextInternal(ExtractedTextRequest extractedTextRequest, int n, int n2, int n3, ExtractedText extractedText) {
        CharSequence charSequence = this.mTextView.getText();
        boolean bl = false;
        if (charSequence == null) return bl;
        if (n != -2) {
            int n4;
            int n5 = charSequence.length();
            if (n < 0) {
                extractedText.partialEndOffset = -1;
                extractedText.partialStartOffset = -1;
                n = 0;
                n4 = n5;
            } else {
                n4 = n2 + n3;
                if (charSequence instanceof Spanned) {
                    Spanned spanned = (Spanned)charSequence;
                    ParcelableSpan[] parcelableSpanArray = spanned.getSpans(n, n4, ParcelableSpan.class);
                    int n6 = parcelableSpanArray.length;
                    while (n6 > 0) {
                        int n7;
                        int n8;
                        if ((n8 = spanned.getSpanStart(parcelableSpanArray[--n6])) < n) {
                            n = n8;
                        }
                        if ((n7 = spanned.getSpanEnd(parcelableSpanArray[n6])) <= n4) continue;
                        n4 = n7;
                    }
                }
                extractedText.partialStartOffset = n;
                extractedText.partialEndOffset = n4 - n3;
                if (n > n5) {
                    n = n5;
                } else if (n < 0) {
                    n = 0;
                }
                if (n4 > n5) {
                    n4 = n5;
                } else if (n4 < 0) {
                    n4 = 0;
                }
            }
            extractedText.text = (1 & extractedTextRequest.flags) != 0 ? charSequence.subSequence(n, n4) : TextUtils.substring(charSequence, n, n4);
        } else {
            extractedText.partialStartOffset = 0;
            extractedText.partialEndOffset = 0;
            extractedText.text = "";
        }
        extractedText.flags = 0;
        if (MetaKeyKeyListener.getMetaState(charSequence, 2048) != 0) {
            extractedText.flags = 2 | extractedText.flags;
        }
        if (this.mTextView.isSingleLine()) {
            extractedText.flags = 1 | extractedText.flags;
        }
        extractedText.startOffset = 0;
        extractedText.selectionStart = this.mTextView.getSelectionStart();
        extractedText.selectionEnd = this.mTextView.getSelectionEnd();
        return true;
    }

    private boolean extractedTextModeWillBeStarted() {
        boolean bl = this.mTextView instanceof ExtractEditText;
        boolean bl2 = false;
        if (!bl) {
            InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
            bl2 = false;
            if (inputMethodManager != null) {
                boolean bl3 = inputMethodManager.isFullscreenMode();
                bl2 = false;
                if (bl3) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private WindowManager.LayoutParams generateNewMagnifierLayoutParam(int n, int n2) {
        int n3;
        if (this.mMagnifierLayoutParam != null) {
            n3 = this.mMagnifierLayoutParam.type;
            return this.generateNewMagnifierLayoutParam(n, n2, n3);
        }
        n3 = 2;
        return this.generateNewMagnifierLayoutParam(n, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private WindowManager.LayoutParams generateNewMagnifierLayoutParam(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        if (this.mMagnifier == null) {
            this.mMagnifier = new Magnifier(this.mTextView.getContext());
        }
        if ((n6 = this.mTextView.getContext().getResources().getConfiguration().orientation) != this.mMagnifier.mOrientation) {
            Magnifier.access$202(this.mMagnifier, n6);
            this.mMagnifier.updateScreenSize();
        }
        int n7 = (int)(1.7f * (float)(30 + this.mTextView.getLineHeight()));
        int n8 = (int)(1.6f * (float)n7);
        int n9 = n - this.mMagnifier.screen_width / 2;
        int n10 = this.mTextView.getLayout().getLineForOffset(this.mTextView.getSelectionStart());
        if (n10 != (n5 = this.mTextView.getLayout().getLineForOffset(this.mTextView.getSelectionEnd()))) {
            n4 = n10 != this.mOldStartLine ? n10 : (n5 != this.mOldEndLine ? n5 : this.mOldLine);
        } else {
            int n11 = (this.mTextView.getSelectionStart() + this.mTextView.getSelectionEnd()) / 2;
            n4 = this.mTextView.getLayout().getLineForOffset(n11);
        }
        this.mOldStartLine = n10;
        this.mOldEndLine = n5;
        this.mOldLine = n4;
        int n12 = this.mCursorInLineEnd && n4 > 0 ? this.mPositionListener.getPositionY() + this.mTextView.getLayout().getLineTop(n4 - 1) + this.mTextView.viewportToContentVerticalOffset() - this.mMagnifier.screen_height / 2 - 12 * this.mTextView.getLineHeight() / 5 : this.mPositionListener.getPositionY() + this.mTextView.getLayout().getLineTop(n4) + this.mTextView.viewportToContentVerticalOffset() - this.mMagnifier.screen_height / 2 - 12 * this.mTextView.getLineHeight() / 5;
        this.mMagnifierLayoutParam = new WindowManager.LayoutParams(n8, n7, n9, n12, n3, 24, -3);
        return this.mMagnifierLayoutParam;
    }

    private int getAvailableDisplayListIndex(int[] nArray, int n, int n2) {
        int n3;
        block4: {
            int n4 = this.mTextDisplayLists.length;
            block0: for (n3 = n2; n3 < n4; ++n3) {
                int n5 = 0;
                while (true) {
                    block6: {
                        boolean bl;
                        block5: {
                            bl = false;
                            if (n5 >= n) break block5;
                            if (nArray[n5] != n3) break block6;
                            bl = true;
                        }
                        if (bl) {
                            continue block0;
                        }
                        break block4;
                    }
                    ++n5;
                }
            }
            this.mTextDisplayLists = GrowingArrayUtils.append(this.mTextDisplayLists, n4, null);
            n3 = n4;
        }
        return n3;
    }

    private long getCharRange(int n) {
        int n2 = this.mTextView.getText().length();
        if (n + 1 < n2 && Character.isSurrogatePair(this.mTextView.getText().charAt(n), this.mTextView.getText().charAt(n + 1))) {
            return TextUtils.packRangeInLong(n, n + 2);
        }
        if (n < n2) {
            return TextUtils.packRangeInLong(n, n + 1);
        }
        if (n - 2 >= 0) {
            char c = this.mTextView.getText().charAt(n - 1);
            if (Character.isSurrogatePair(this.mTextView.getText().charAt(n - 2), c)) {
                return TextUtils.packRangeInLong(n - 2, n);
            }
        }
        if (n - 1 >= 0) {
            return TextUtils.packRangeInLong(n - 1, n);
        }
        return TextUtils.packRangeInLong(n, n);
    }

    private int getErrorX() {
        float f = this.mTextView.getResources().getDisplayMetrics().density;
        TextView.Drawables drawables = this.mTextView.mDrawables;
        switch (this.mTextView.getLayoutDirection()) {
            default: {
                int n = 0;
                if (drawables != null) {
                    n = drawables.mDrawableSizeRight;
                }
                return -n / 2 + (int)(0.5f + 25.0f * f) + (this.mTextView.getWidth() - this.mErrorPopup.getWidth() - this.mTextView.getPaddingRight());
            }
            case 1: 
        }
        int n = 0;
        if (drawables != null) {
            n = drawables.mDrawableSizeLeft;
        }
        return n / 2 - (int)(0.5f + 25.0f * f) + this.mTextView.getPaddingLeft();
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getErrorY() {
        int n;
        int n2 = this.mTextView.getCompoundPaddingTop();
        int n3 = this.mTextView.getBottom() - this.mTextView.getTop() - this.mTextView.getCompoundPaddingBottom() - n2;
        TextView.Drawables drawables = this.mTextView.mDrawables;
        switch (this.mTextView.getLayoutDirection()) {
            default: {
                n = 0;
                if (drawables == null) break;
                n = drawables.mDrawableHeightRight;
                break;
            }
            case 1: {
                n = 0;
                if (drawables == null) break;
                n = drawables.mDrawableHeightLeft;
            }
        }
        int n4 = n2 + (n3 - n) / 2;
        float f = this.mTextView.getResources().getDisplayMetrics().density;
        return n4 + n - this.mTextView.getHeight() - (int)(0.5f + 2.0f * f);
    }

    private static int getInverseColor(int n) {
        int n2;
        int n3;
        int n4 = -1;
        int n5 = Color.red(n);
        if ((int)(0.299 * (double)n5 + 0.587 * (double)(n3 = Color.green(n)) + 0.114 * (double)(n2 = Color.blue(n))) > 127) {
            n4 = -16777216;
        }
        return n4;
    }

    private int getLastTapPosition() {
        int n;
        if (this.mSelectionModifierCursorController != null && (n = this.mSelectionModifierCursorController.getMinTouchOffset()) >= 0) {
            if (n > this.mTextView.getText().length()) {
                n = this.mTextView.getText().length();
            }
            return n;
        }
        return -1;
    }

    private long getLastTouchOffsets() {
        SelectionModifierCursorController selectionModifierCursorController = this.getSelectionController();
        return TextUtils.packRangeInLong(selectionModifierCursorController.getMinTouchOffset(), selectionModifierCursorController.getMaxTouchOffset());
    }

    private PositionListener getPositionListener() {
        if (this.mPositionListener == null) {
            this.mPositionListener = new PositionListener();
        }
        return this.mPositionListener;
    }

    private float getPrimaryHorizontal(Layout layout2, Layout layout3, int n, boolean bl) {
        if (TextUtils.isEmpty(layout2.getText()) && layout3 != null && !TextUtils.isEmpty(layout3.getText())) {
            return layout3.getPrimaryHorizontal(n, bl);
        }
        return layout2.getPrimaryHorizontal(n, bl);
    }

    private View.DragShadowBuilder getTextThumbnailBuilder(CharSequence charSequence) {
        TextView textView = (TextView)View.inflate(this.mTextView.getContext(), 17367280, null);
        if (textView == null) {
            throw new IllegalArgumentException("Unable to inflate text drag thumbnail");
        }
        if (charSequence.length() > DRAG_SHADOW_MAX_TEXT_LENGTH) {
            charSequence = charSequence.subSequence(0, DRAG_SHADOW_MAX_TEXT_LENGTH);
        }
        textView.setText(charSequence);
        textView.setTextColor(this.mTextView.getTextColors());
        textView.setTextAppearance(this.mTextView.getContext(), 16);
        textView.setGravity(17);
        textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        int n = View.MeasureSpec.makeMeasureSpec(0, 0);
        textView.measure(n, n);
        textView.layout(0, 0, textView.getMeasuredWidth(), textView.getMeasuredHeight());
        textView.invalidate();
        return new View.DragShadowBuilder(textView);
    }

    private boolean hasPasswordTransformationMethod() {
        return this.mTextView.getTransformationMethod() instanceof PasswordTransformationMethod;
    }

    private void hideCursorControllers() {
        if (this.mSuggestionsPopupWindow != null && !this.mSuggestionsPopupWindow.isShowingUp()) {
            this.mSuggestionsPopupWindow.hide();
        }
        this.hideInsertionPointCursorController();
        this.stopSelectionActionMode();
    }

    private void hideError() {
        if (this.mErrorPopup != null && this.mErrorPopup.isShowing()) {
            this.mErrorPopup.dismiss();
        }
        this.mShowErrorAfterAttach = false;
    }

    private void hideInsertionPointCursorController() {
        if (this.mInsertionPointCursorController != null) {
            this.mInsertionPointCursorController.hide();
        }
    }

    private void hideSpanControllers() {
        if (this.mSpanController != null) {
            this.mSpanController.hide();
        }
    }

    private void invalidateMagnifierForCursorBlinking() {
        InsertionHandleView insertionHandleView;
        if (this.mInsertionControllerEnabled && this.mInsertionPointCursorController != null && (insertionHandleView = this.mInsertionPointCursorController.getHandle()) != null && insertionHandleView.isShowing()) {
            insertionHandleView.refreshMagnifier();
        }
    }

    private boolean isCursorInsideEasyCorrectionSpan() {
        SuggestionSpan[] suggestionSpanArray = ((Spannable)this.mTextView.getText()).getSpans(this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd(), SuggestionSpan.class);
        for (int i = 0; i < suggestionSpanArray.length; ++i) {
            if ((1 & suggestionSpanArray[i].getFlags()) == 0) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isCursorInsideSuggestionSpan() {
        CharSequence charSequence = this.mTextView.getText();
        return charSequence instanceof Spannable && ((Spannable)charSequence).getSpans(this.mTextView.getSelectionStart(), this.mTextView.getSelectionEnd(), SuggestionSpan.class).length > 0;
    }

    private boolean isOffsetVisible(int n) {
        Layout layout2 = this.mTextView.getLayout();
        if (layout2 == null) {
            return false;
        }
        int n2 = layout2.getLineBottom(layout2.getLineForOffset(n));
        return this.isPositionVisible((int)layout2.getPrimaryHorizontal(n) + this.mTextView.viewportToContentHorizontalOffset(), n2 + this.mTextView.viewportToContentVerticalOffset());
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isPositionOnText(float f, float f2) {
        block3: {
            block2: {
                Layout layout2 = this.mTextView.getLayout();
                if (layout2 == null) break block2;
                int n = this.mTextView.getLineAtCoordinate(f2);
                float f3 = this.mTextView.convertToLocalHorizontalCoordinate(f);
                if (!(f3 < layout2.getLineLeft(n)) && !(f3 > layout2.getLineRight(n))) break block3;
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPositionVisible(float f, float f2) {
        float[] fArray = TEMP_POSITION;
        synchronized (fArray) {
            float[] fArray2 = TEMP_POSITION;
            fArray2[0] = f;
            fArray2[1] = f2;
            View view = this.mTextView;
            while (view != null) {
                if (view != this.mTextView) {
                    fArray2[0] = fArray2[0] - (float)view.getScrollX();
                    fArray2[1] = fArray2[1] - (float)view.getScrollY();
                }
                if (fArray2[0] < 0.0f) return false;
                if (fArray2[1] < 0.0f) return false;
                if (fArray2[0] > (float)view.getWidth()) return false;
                if (fArray2[1] > (float)view.getHeight()) {
                    return false;
                }
                if (!view.getMatrix().isIdentity()) {
                    view.getMatrix().mapPoints(fArray2);
                }
                fArray2[0] = fArray2[0] + (float)view.getLeft();
                fArray2[1] = fArray2[1] + (float)view.getTop();
                ViewParent viewParent = view.getParent();
                if (!(viewParent instanceof View)) return true;
                view = (View)((Object)viewParent);
            }
            return true;
        }
    }

    private void resumeBlink() {
        if (this.mBlink != null) {
            this.mBlink.uncancel();
            this.makeBlink();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean selectCurrentWord() {
        int n;
        int n2;
        if (!this.canSelectText()) {
            return false;
        }
        if (this.hasPasswordTransformationMethod()) {
            return this.mTextView.selectAllText();
        }
        int n3 = this.mTextView.getInputType();
        int n4 = n3 & 0xF;
        int n5 = n3 & 0xFF0;
        if (n4 == 2 || n4 == 3 || n4 == 4 || n5 == 16 || n5 == 32 || n5 == 208 || n5 == 176) {
            return this.mTextView.selectAllText();
        }
        long l = this.getLastTouchOffsets();
        int n6 = TextUtils.unpackRangeStartFromLong(l);
        int n7 = TextUtils.unpackRangeEndFromLong(l);
        if (n6 < 0 || n6 >= this.mTextView.getText().length()) {
            return false;
        }
        if (n7 < 0 || n7 >= this.mTextView.getText().length()) {
            return false;
        }
        URLSpan[] uRLSpanArray = ((Spanned)this.mTextView.getText()).getSpans(n6, n7, URLSpan.class);
        if (uRLSpanArray.length >= 1) {
            URLSpan uRLSpan = uRLSpanArray[0];
            n2 = ((Spanned)this.mTextView.getText()).getSpanStart(uRLSpan);
            n = ((Spanned)this.mTextView.getText()).getSpanEnd(uRLSpan);
        } else {
            WordIterator wordIterator = this.getWordIterator();
            wordIterator.setCharSequence(this.mTextView.getText(), n6, n7);
            n2 = wordIterator.getBeginning(n6);
            n = wordIterator.getEnd(n7);
            if (n2 == -1 || n == -1 || n2 == n) {
                long l2 = this.getCharRange(n6);
                n2 = TextUtils.unpackRangeStartFromLong(l2);
                n = TextUtils.unpackRangeEndFromLong(l2);
            }
        }
        Selection.setSelection((Spannable)this.mTextView.getText(), n2, n);
        return n > n2;
    }

    private void sendUpdateSelection() {
        InputMethodManager inputMethodManager;
        if (this.mInputMethodState != null && this.mInputMethodState.mBatchEditNesting <= 0 && (inputMethodManager = InputMethodManager.peekInstance()) != null) {
            int n = this.mTextView.getSelectionStart();
            int n2 = this.mTextView.getSelectionEnd();
            int n3 = -1;
            int n4 = -1;
            if (this.mTextView.getText() instanceof Spannable) {
                Spannable spannable = (Spannable)this.mTextView.getText();
                n3 = EditableInputConnection.getComposingSpanStart(spannable);
                n4 = EditableInputConnection.getComposingSpanEnd(spannable);
            }
            inputMethodManager.updateSelection(this.mTextView, n, n2, n3, n4);
        }
    }

    private void setErrorIcon(Drawable drawable2) {
        TextView.Drawables drawables = this.mTextView.mDrawables;
        if (drawables == null) {
            TextView textView = this.mTextView;
            textView.mDrawables = drawables = new TextView.Drawables(this.mTextView.getContext());
        }
        drawables.setErrorDrawable(drawable2, this.mTextView);
        this.mTextView.resetResolvedDrawables();
        this.mTextView.invalidate();
        this.mTextView.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean shouldBlink() {
        int n;
        int n2;
        return this.isCursorVisible() && this.mTextView.isFocused() && (n2 = this.mTextView.getSelectionStart()) >= 0 && (n = this.mTextView.getSelectionEnd()) >= 0 && n2 == n;
    }

    private void showError() {
        if (this.mTextView.getWindowToken() == null) {
            this.mShowErrorAfterAttach = true;
            return;
        }
        if (this.mErrorPopup == null) {
            TextView textView = (TextView)LayoutInflater.from(this.mTextView.getContext()).inflate(17367288, null);
            float f = this.mTextView.getResources().getDisplayMetrics().density;
            this.mErrorPopup = new ErrorPopup(textView, (int)(0.5f + 200.0f * f), (int)(0.5f + 50.0f * f));
            this.mErrorPopup.setFocusable(false);
            this.mErrorPopup.setInputMethodMode(1);
        }
        TextView textView = (TextView)this.mErrorPopup.getContentView();
        this.chooseSize(this.mErrorPopup, this.mError, textView);
        textView.setText(this.mError);
        this.mErrorPopup.showAsDropDown(this.mTextView, this.getErrorX(), this.getErrorY());
        this.mErrorPopup.fixDirection(this.mErrorPopup.isAboveAnchor());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void showMagnifier(HandleView handleView, int n, int n2, int n3, int n4) {
        if (this.mWindowManager == null) {
            this.mWindowManager = (WindowManager)this.mTextView.getContext().getSystemService("window");
        }
        if (this.mHandleShowingMagnifier == null) {
            this.mHandleShowingMagnifier = handleView;
        } else if (this.mHandleShowingMagnifier != handleView) {
            Log.i(LOG_TAG, "showMagnifier - A second HandleView also wants to show magnifier, ignore it.");
            return;
        }
        this.mMagnifier = new Magnifier(this.mTextView.getContext(), n3, n4);
        try {
            Log.i(LOG_TAG, "mTextView.getContext()=" + this.mTextView.getContext());
            if (this.mTextView.getContext() instanceof Activity) {
                this.mWindowManager.addView(this.mMagnifier, this.generateNewMagnifierLayoutParam(n, n2, 2));
                Log.d(LOG_TAG, "Context instanceof Activity");
                return;
            }
        }
        catch (Exception exception) {
            Log.w(LOG_TAG, "Exception adding magnifier to WindowManager: ", exception);
            Magnifier.access$4702(this.mMagnifier, true);
            this.mMagnifier = null;
            return;
        }
        {
            this.mWindowManager.addView(this.mMagnifier, this.generateNewMagnifierLayoutParam(n, n2, 2005));
            Log.d(LOG_TAG, "Context NOT instanceof Activity");
            return;
        }
    }

    private void suspendBlink() {
        if (this.mBlink != null) {
            this.mBlink.cancel();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean touchPositionIsInSelection() {
        int n;
        int n2 = this.mTextView.getSelectionStart();
        if (n2 == (n = this.mTextView.getSelectionEnd())) {
            return false;
        }
        if (n2 > n) {
            int n3 = n2;
            n2 = n;
            n = n3;
            Selection.setSelection((Spannable)this.mTextView.getText(), n2, n);
        }
        SelectionModifierCursorController selectionModifierCursorController = this.getSelectionController();
        int n4 = selectionModifierCursorController.getMinTouchOffset();
        int n5 = selectionModifierCursorController.getMaxTouchOffset();
        if (n4 < n2) return false;
        if (n5 >= n) return false;
        return true;
    }

    private void updateCursorPosition(int n, int n2, int n3, float f) {
        if (this.mCursorDrawable[n] == null) {
            this.mCursorDrawable[n] = this.mTextView.getContext().getDrawable(this.mTextView.mCursorDrawableRes);
        }
        if (this.mTempRect == null) {
            this.mTempRect = new Rect();
        }
        this.mCursorDrawable[n].getPadding(this.mTempRect);
        int n4 = this.mCursorDrawable[n].getIntrinsicWidth();
        int n5 = (int)Math.max(0.5f, f - 0.5f) - this.mTempRect.left;
        this.mCursorDrawable[n].setBounds(n5, n2 - this.mTempRect.top, n5 + n4, n3 + this.mTempRect.bottom);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateMagnifier(HandleView handleView, int n, int n2, int n3, int n4) {
        if (this.mHandleShowingMagnifier != handleView) {
            Log.i(LOG_TAG, "updateMagnifier - A second HandleView also wants to show magnifier, ignore it.");
            return;
        } else {
            if (this.mMagnifier == null) return;
            this.mWindowManager.updateViewLayout(this.mMagnifier, this.generateNewMagnifierLayoutParam(n, n2));
            this.mMagnifier.drawMagnifier(this.mMagnifier.getHolder(), n3, n4);
            return;
        }
    }

    private void updateSpellCheckSpans(int n, int n2, boolean bl) {
        this.mTextView.removeAdjacentSuggestionSpans(n);
        this.mTextView.removeAdjacentSuggestionSpans(n2);
        if (this.mTextView.isTextEditable() && this.mTextView.isSuggestionsEnabled() && !(this.mTextView instanceof ExtractEditText)) {
            if (this.mSpellChecker == null && bl) {
                this.mSpellChecker = new SpellChecker(this.mTextView);
            }
            if (this.mSpellChecker != null) {
                this.mSpellChecker.spellCheck(n, n2);
            }
        }
    }

    public void addSpanWatchers(Spannable spannable) {
        int n = spannable.length();
        if (this.mKeyListener != null) {
            spannable.setSpan(this.mKeyListener, 0, n, 18);
        }
        if (this.mSpanController == null) {
            this.mSpanController = new SpanController();
        }
        spannable.setSpan(this.mSpanController, 0, n, 18);
    }

    /*
     * Enabled aggressive block sorting
     */
    void adjustInputType(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if ((0xF & this.mInputType) == 1) {
            if (bl || bl2) {
                this.mInputType = 0x80 | 0xFFFFF00F & this.mInputType;
            }
            if (!bl3) return;
            this.mInputType = 0xE0 | 0xFFFFF00F & this.mInputType;
            return;
        }
        if ((0xF & this.mInputType) != 2 || !bl4) return;
        this.mInputType = 0x10 | 0xFFFFF00F & this.mInputType;
    }

    boolean areSuggestionsShown() {
        return this.mSuggestionsPopupWindow != null && this.mSuggestionsPopupWindow.isShowing();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void beginBatchEdit() {
        this.mInBatchEditControllers = true;
        InputMethodState inputMethodState = this.mInputMethodState;
        if (inputMethodState != null) {
            int n;
            inputMethodState.mBatchEditNesting = n = 1 + inputMethodState.mBatchEditNesting;
            if (n == 1) {
                inputMethodState.mCursorChanged = false;
                inputMethodState.mChangedDelta = 0;
                if (inputMethodState.mContentChanged) {
                    inputMethodState.mChangedStart = 0;
                    inputMethodState.mChangedEnd = this.mTextView.getText().length();
                } else {
                    inputMethodState.mChangedStart = -1;
                    inputMethodState.mChangedEnd = -1;
                    inputMethodState.mContentChanged = false;
                }
                this.mTextView.onBeginBatchEdit();
            }
        }
    }

    void createInputContentTypeIfNeeded() {
        if (this.mInputContentType == null) {
            this.mInputContentType = new InputContentType();
        }
    }

    void createInputMethodStateIfNeeded() {
        if (this.mInputMethodState == null) {
            this.mInputMethodState = new InputMethodState();
        }
    }

    public void endBatchEdit() {
        this.mInBatchEditControllers = false;
        InputMethodState inputMethodState = this.mInputMethodState;
        if (inputMethodState != null) {
            int n;
            inputMethodState.mBatchEditNesting = n = -1 + inputMethodState.mBatchEditNesting;
            if (n == 0) {
                this.finishBatchEdit(inputMethodState);
            }
        }
    }

    void ensureEndedBatchEdit() {
        InputMethodState inputMethodState = this.mInputMethodState;
        if (inputMethodState != null && inputMethodState.mBatchEditNesting != 0) {
            inputMethodState.mBatchEditNesting = 0;
            this.finishBatchEdit(inputMethodState);
        }
    }

    boolean extractText(ExtractedTextRequest extractedTextRequest, ExtractedText extractedText) {
        return this.extractTextInternal(extractedTextRequest, -1, -1, -1, extractedText);
    }

    /*
     * Enabled aggressive block sorting
     */
    void finishBatchEdit(InputMethodState inputMethodState) {
        this.mTextView.onEndBatchEdit();
        if (inputMethodState.mContentChanged || inputMethodState.mSelectionModeChanged) {
            this.mTextView.updateAfterEdit();
            this.reportExtractedText();
        } else if (inputMethodState.mCursorChanged) {
            this.mTextView.invalidateCursor();
        }
        this.sendUpdateSelection();
    }

    InsertionPointCursorController getInsertionController() {
        if (!this.mInsertionControllerEnabled) {
            return null;
        }
        if (this.mInsertionPointCursorController == null) {
            this.mInsertionPointCursorController = new InsertionPointCursorController();
            this.mTextView.getViewTreeObserver().addOnTouchModeChangeListener(this.mInsertionPointCursorController);
        }
        return this.mInsertionPointCursorController;
    }

    public int getPositionListenerPositionX() {
        return this.getPositionListener().getPositionX();
    }

    public int getPositionListenerPositionY() {
        return this.getPositionListener().getPositionY();
    }

    SelectionModifierCursorController getSelectionController() {
        if (!this.mSelectionControllerEnabled) {
            return null;
        }
        if (this.mSelectionModifierCursorController == null) {
            this.mSelectionModifierCursorController = new SelectionModifierCursorController();
            this.mTextView.getViewTreeObserver().addOnTouchModeChangeListener(this.mSelectionModifierCursorController);
        }
        return this.mSelectionModifierCursorController;
    }

    public WordIterator getWordIterator() {
        if (this.mWordIterator == null) {
            this.mWordIterator = new WordIterator(this.mTextView.getTextServicesLocale());
        }
        return this.mWordIterator;
    }

    boolean hasInsertionController() {
        return this.mInsertionControllerEnabled;
    }

    boolean hasSelectionController() {
        return this.mSelectionControllerEnabled;
    }

    void hideControllers() {
        this.hideCursorControllers();
        this.hideSpanControllers();
    }

    void invalidateTextDisplayList() {
        if (this.mTextDisplayLists != null) {
            for (int i = 0; i < this.mTextDisplayLists.length; ++i) {
                if (this.mTextDisplayLists[i] == null) continue;
                this.mTextDisplayLists[i].isDirty = true;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void invalidateTextDisplayList(Layout layout2, int n, int n2) {
        if (this.mTextDisplayLists != null && layout2 instanceof DynamicLayout) {
            int n3;
            int n4 = layout2.getLineForOffset(n);
            int n5 = layout2.getLineForOffset(n2);
            DynamicLayout dynamicLayout = (DynamicLayout)layout2;
            int[] nArray = dynamicLayout.getBlockEndLines();
            int[] nArray2 = dynamicLayout.getBlockIndices();
            int n6 = dynamicLayout.getNumberOfBlocks();
            for (n3 = 0; n3 < n6 && nArray[n3] < n4; ++n3) {
            }
            while (n3 < n6) {
                int n7 = nArray2[n3];
                if (n7 != -1) {
                    this.mTextDisplayLists[n7].isDirty = true;
                }
                if (nArray[n3] >= n5) break;
                ++n3;
            }
        }
    }

    boolean isCursorVisible() {
        return this.mCursorVisible && this.mTextView.isTextEditable();
    }

    /*
     * Enabled aggressive block sorting
     */
    void makeBlink() {
        if (this.shouldBlink()) {
            this.mShowCursor = SystemClock.uptimeMillis();
            if (this.mBlink == null) {
                this.mBlink = new Blink();
            }
            this.mBlink.removeCallbacks(this.mBlink);
            this.mBlink.postAtTime(this.mBlink, 500L + this.mShowCursor);
            return;
        } else {
            if (this.mBlink == null) return;
            this.mBlink.removeCallbacks(this.mBlink);
            return;
        }
    }

    void onAttachedToWindow() {
        if (this.mShowErrorAfterAttach) {
            this.showError();
            this.mShowErrorAfterAttach = false;
        }
        this.mTemporaryDetach = false;
        ViewTreeObserver viewTreeObserver = this.mTextView.getViewTreeObserver();
        if (this.mInsertionPointCursorController != null) {
            viewTreeObserver.addOnTouchModeChangeListener(this.mInsertionPointCursorController);
        }
        if (this.mSelectionModifierCursorController != null) {
            this.mSelectionModifierCursorController.resetTouchOffsets();
            viewTreeObserver.addOnTouchModeChangeListener(this.mSelectionModifierCursorController);
        }
        this.updateSpellCheckSpans(0, this.mTextView.getText().length(), true);
        if (this.mTextView.hasTransientState() && this.mTextView.getSelectionStart() != this.mTextView.getSelectionEnd()) {
            this.mTextView.setHasTransientState(false);
            this.startSelectionActionMode();
        }
        this.getPositionListener().addSubscriber(this.mCursorAnchorInfoNotifier, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onCommitCorrection(CorrectionInfo correctionInfo) {
        if (this.mCorrectionHighlighter == null) {
            this.mCorrectionHighlighter = new CorrectionHighlighter();
        } else {
            this.mCorrectionHighlighter.invalidate(false);
        }
        this.mCorrectionHighlighter.highlight(correctionInfo);
    }

    void onConfigurationChanged(Configuration configuration) {
        if (this.mMagnifier != null && configuration.orientation != this.mMagnifier.mOrientation) {
            Magnifier.access$202(this.mMagnifier, configuration.orientation);
            this.mMagnifier.updateScreenSize();
        }
    }

    void onDetachedFromWindow() {
        this.getPositionListener().removeSubscriber(this.mCursorAnchorInfoNotifier);
        if (this.mError != null) {
            this.hideError();
        }
        if (this.mBlink != null) {
            this.mBlink.removeCallbacks(this.mBlink);
        }
        if (this.mInsertionPointCursorController != null) {
            this.mInsertionPointCursorController.onDetached();
        }
        if (this.mSelectionModifierCursorController != null) {
            this.mSelectionModifierCursorController.onDetached();
        }
        if (this.mShowSuggestionRunnable != null) {
            this.mTextView.removeCallbacks(this.mShowSuggestionRunnable);
        }
        this.destroyDisplayListsData();
        if (this.mSpellChecker != null) {
            this.mSpellChecker.closeSession();
            this.mSpellChecker = null;
        }
        this.mPreserveDetachedSelection = true;
        this.hideControllers();
        this.mPreserveDetachedSelection = false;
        this.mTemporaryDetach = false;
    }

    void onDraw(Canvas canvas, Layout layout2, Path path, Paint paint, int n) {
        InputMethodManager inputMethodManager;
        int n2 = this.mTextView.getSelectionStart();
        int n3 = this.mTextView.getSelectionEnd();
        InputMethodState inputMethodState = this.mInputMethodState;
        if (inputMethodState != null && inputMethodState.mBatchEditNesting == 0 && (inputMethodManager = InputMethodManager.peekInstance()) != null && inputMethodManager.isActive(this.mTextView) && (inputMethodState.mContentChanged || inputMethodState.mSelectionModeChanged)) {
            this.reportExtractedText();
        }
        if (this.mCorrectionHighlighter != null) {
            this.mCorrectionHighlighter.draw(canvas, n);
        }
        if (path != null && n2 == n3 && this.mCursorCount > 0) {
            this.drawCursor(canvas, n);
            path = null;
        }
        if (this.mTextView.canHaveDisplayList() && canvas.isHardwareAccelerated()) {
            this.drawHardwareAccelerated(canvas, layout2, path, paint, n);
            return;
        }
        layout2.draw(canvas, path, paint, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    void onDrop(DragEvent dragEvent) {
        int n;
        block7: {
            block6: {
                CharSequence charSequence;
                boolean bl;
                StringBuilder stringBuilder = new StringBuilder("");
                ClipData clipData = dragEvent.getClipData();
                int n2 = clipData.getItemCount();
                for (int i = 0; i < n2; ++i) {
                    stringBuilder.append(clipData.getItemAt(i).coerceToStyledText(this.mTextView.getContext()));
                }
                int n3 = this.calculateTheFakeOffset(this.mLastDownPositionX, this.mLastDownPositionY);
                Object object = dragEvent.getLocalState();
                boolean bl2 = object instanceof DragLocalState;
                DragLocalState dragLocalState = null;
                if (bl2) {
                    dragLocalState = (DragLocalState)object;
                }
                if ((bl = dragLocalState != null && dragLocalState.sourceTextView == this.mTextView) && n3 >= dragLocalState.start && n3 < dragLocalState.end) break block6;
                int n4 = this.mTextView.getText().length();
                Selection.setSelection((Spannable)this.mTextView.getText(), n3);
                this.mTextView.replaceText_internal(n3, n3, stringBuilder);
                if (!bl) break block6;
                int n5 = dragLocalState.start;
                int n6 = dragLocalState.end;
                if (n3 <= n5) {
                    int n7 = this.mTextView.getText().length() - n4;
                    n5 += n7;
                    n6 += n7;
                }
                this.mTextView.deleteText_internal(n5, n6);
                n = Math.max(0, n5 - 1);
                int n8 = Math.min(this.mTextView.getText().length(), n5 + 1);
                if (n8 > n + 1 && Character.isSpaceChar((charSequence = this.mTextView.getTransformedText(n, n8)).charAt(0)) && Character.isSpaceChar(charSequence.charAt(1))) break block7;
            }
            return;
        }
        this.mTextView.deleteText_internal(n, n + 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    void onFocusChanged(boolean bl, int n) {
        this.mShowCursor = SystemClock.uptimeMillis();
        this.ensureEndedBatchEdit();
        if (bl) {
            int n2 = this.mTextView.getSelectionStart();
            int n3 = this.mTextView.getSelectionEnd();
            boolean bl2 = this.mSelectAllOnFocus && n2 == 0 && n3 == this.mTextView.getText().length();
            boolean bl3 = this.mFrozenWithFocus && this.mTextView.hasSelection() && !bl2;
            this.mCreatedWithASelection = bl3;
            if (!this.mFrozenWithFocus || n2 < 0 || n3 < 0) {
                MovementMethod movementMethod;
                int n4 = this.getLastTapPosition();
                if (n4 >= 0) {
                    Selection.setSelection((Spannable)this.mTextView.getText(), n4);
                }
                if ((movementMethod = this.mTextView.getMovementMethod()) != null) {
                    movementMethod.onTakeFocus(this.mTextView, (Spannable)this.mTextView.getText(), n);
                }
                if ((this.mTextView instanceof ExtractEditText || this.mSelectionMoved) && n2 >= 0 && n3 >= 0) {
                    Selection.setSelection((Spannable)this.mTextView.getText(), n2, n3);
                }
                if (this.mSelectAllOnFocus) {
                    this.mTextView.selectAllText();
                }
                this.mTouchFocusSelected = true;
            }
            this.mFrozenWithFocus = false;
            this.mSelectionMoved = false;
            if (this.mError != null) {
                this.showError();
            }
            this.makeBlink();
            return;
        } else {
            if (this.mError != null) {
                this.hideError();
            }
            this.mTextView.onEndBatchEdit();
            if (this.mTextView instanceof ExtractEditText) {
                int n5 = this.mTextView.getSelectionStart();
                int n6 = this.mTextView.getSelectionEnd();
                this.hideControllers();
                Selection.setSelection((Spannable)this.mTextView.getText(), n5, n6);
            } else {
                if (this.mTemporaryDetach) {
                    this.mPreserveDetachedSelection = true;
                }
                this.hideControllers();
                if (this.mTemporaryDetach) {
                    this.mPreserveDetachedSelection = false;
                }
                this.downgradeEasyCorrectionSpans();
            }
            if (this.mSelectionModifierCursorController == null) return;
            this.mSelectionModifierCursorController.resetTouchOffsets();
            return;
        }
    }

    void onFocusLost() {
        this.dismissMagnifier();
    }

    void onLocaleChanged() {
        this.mWordIterator = null;
    }

    void onScreenStateChanged(int n) {
        switch (n) {
            default: {
                return;
            }
            case 1: {
                this.resumeBlink();
                return;
            }
            case 0: 
        }
        this.suspendBlink();
    }

    void onScrollChanged() {
        if (this.mPositionListener != null) {
            this.mPositionListener.onScrollChanged();
        }
    }

    void onTouchEvent(MotionEvent motionEvent) {
        if (this.hasSelectionController()) {
            this.getSelectionController().onTouchEvent(motionEvent);
        }
        if (this.mShowSuggestionRunnable != null) {
            this.mTextView.removeCallbacks(this.mShowSuggestionRunnable);
            this.mShowSuggestionRunnable = null;
        }
        if (motionEvent.getActionMasked() == 0) {
            this.mLastDownPositionX = motionEvent.getX();
            this.mLastDownPositionY = motionEvent.getY();
            this.mTouchFocusSelected = false;
            this.mIgnoreActionUpEvent = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void onTouchUpEvent(MotionEvent motionEvent) {
        boolean bl = this.mSelectAllOnFocus && this.mTextView.didTouchFocusSelect();
        this.hideControllers();
        CharSequence charSequence = this.mTextView.getText();
        if (bl || charSequence.length() <= 0) return;
        int n = this.calculateTheFakeOffset(motionEvent.getX(), motionEvent.getY());
        Selection.setSelection((Spannable)charSequence, n);
        if (this.mSpellChecker != null) {
            this.mSpellChecker.onSelectionChanged();
        }
        if (this.extractedTextModeWillBeStarted()) return;
        if (this.isCursorInsideEasyCorrectionSpan()) {
            this.mShowSuggestionRunnable = new Runnable(){

                @Override
                public void run() {
                    Editor.this.showSuggestions();
                }
            };
            this.mTextView.postDelayed(this.mShowSuggestionRunnable, ViewConfiguration.getDoubleTapTimeout());
            return;
        } else {
            if (!this.hasInsertionController()) return;
            this.getInsertionController().show();
            return;
        }
    }

    void onWindowFocusChanged(boolean bl) {
        if (bl) {
            if (this.mBlink != null) {
                this.mBlink.uncancel();
                this.makeBlink();
            }
            return;
        }
        if (this.mBlink != null) {
            this.mBlink.cancel();
        }
        if (this.mInputContentType != null) {
            this.mInputContentType.enterDown = false;
        }
        if (!this.mIsFromActionMode) {
            this.hideControllers();
        }
        if (this.mSuggestionsPopupWindow != null) {
            this.mSuggestionsPopupWindow.onParentLostFocus();
        }
        this.mIsFromActionMode = false;
        this.ensureEndedBatchEdit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performLongClick(boolean bl) {
        if (!bl && !this.isPositionOnText(this.mLastDownPositionX, this.mLastDownPositionY) && this.mInsertionControllerEnabled) {
            int n = this.calculateTheFakeOffset(this.mLastDownPositionX, this.mLastDownPositionY);
            this.stopSelectionActionMode();
            Selection.setSelection((Spannable)this.mTextView.getText(), n);
            this.getInsertionController().showWithActionPopup();
            return true;
        }
        if (bl || this.mSelectionActionMode == null) {
            if (bl) return bl;
            return this.startSelectionActionMode();
        }
        if (this.touchPositionIsInSelection()) {
            int n = this.mTextView.getSelectionStart();
            int n2 = this.mTextView.getSelectionEnd();
            CharSequence charSequence = this.mTextView.getTransformedText(n, n2);
            ClipData clipData = ClipData.newPlainText(null, charSequence);
            DragLocalState dragLocalState = new DragLocalState(this.mTextView, n, n2);
            this.mTextView.startDrag(clipData, this.getTextThumbnailBuilder(charSequence), dragLocalState, 0);
            this.stopSelectionActionMode();
            return true;
        }
        this.getSelectionController().hide();
        this.selectCurrentWord();
        this.getSelectionController().show();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    void prepareCursorControllers() {
        boolean bl = true;
        ViewGroup.LayoutParams layoutParams = this.mTextView.getRootView().getLayoutParams();
        boolean bl2 = layoutParams instanceof WindowManager.LayoutParams;
        boolean bl3 = false;
        if (bl2) {
            WindowManager.LayoutParams layoutParams2 = (WindowManager.LayoutParams)layoutParams;
            bl3 = layoutParams2.type < 1000 || layoutParams2.type > 1999 ? bl : false;
        }
        boolean bl4 = bl3 && this.mTextView.getLayout() != null ? bl : false;
        boolean bl5 = bl4 && this.isCursorVisible() ? bl : false;
        this.mInsertionControllerEnabled = bl5;
        if (!bl4 || !this.mTextView.textCanBeSelected()) {
            bl = false;
        }
        this.mSelectionControllerEnabled = bl;
        if (!this.mInsertionControllerEnabled) {
            this.hideInsertionPointCursorController();
            if (this.mInsertionPointCursorController != null) {
                this.mInsertionPointCursorController.onDetached();
                this.mInsertionPointCursorController = null;
            }
        }
        if (!this.mSelectionControllerEnabled) {
            this.stopSelectionActionMode();
            if (this.mSelectionModifierCursorController != null) {
                this.mSelectionModifierCursorController.onDetached();
                this.mSelectionModifierCursorController = null;
            }
        }
    }

    boolean reportExtractedText() {
        boolean bl;
        InputMethodState inputMethodState = this.mInputMethodState;
        if (inputMethodState != null && ((bl = inputMethodState.mContentChanged) || inputMethodState.mSelectionModeChanged)) {
            InputMethodManager inputMethodManager;
            inputMethodState.mContentChanged = false;
            inputMethodState.mSelectionModeChanged = false;
            ExtractedTextRequest extractedTextRequest = inputMethodState.mExtractedTextRequest;
            if (extractedTextRequest != null && (inputMethodManager = InputMethodManager.peekInstance()) != null) {
                if (inputMethodState.mChangedStart < 0 && !bl) {
                    inputMethodState.mChangedStart = -2;
                }
                if (this.extractTextInternal(extractedTextRequest, inputMethodState.mChangedStart, inputMethodState.mChangedEnd, inputMethodState.mChangedDelta, inputMethodState.mExtractedText)) {
                    inputMethodManager.updateExtractedText(this.mTextView, extractedTextRequest.token, inputMethodState.mExtractedText);
                    inputMethodState.mChangedStart = -1;
                    inputMethodState.mChangedEnd = -1;
                    inputMethodState.mChangedDelta = 0;
                    inputMethodState.mContentChanged = false;
                    return true;
                }
            }
        }
        return false;
    }

    void sendOnTextChanged(int n, int n2) {
        this.updateSpellCheckSpans(n, n + n2, false);
        this.hideCursorControllers();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setError(CharSequence charSequence, Drawable drawable2) {
        this.mError = TextUtils.stringOrSpannedString(charSequence);
        this.mErrorWasChanged = true;
        if (this.mError == null) {
            this.setErrorIcon(null);
            if (this.mErrorPopup != null) {
                if (this.mErrorPopup.isShowing()) {
                    this.mErrorPopup.dismiss();
                }
                this.mErrorPopup = null;
            }
            this.mShowErrorAfterAttach = false;
            return;
        } else {
            this.setErrorIcon(drawable2);
            if (!this.mTextView.isFocused()) return;
            this.showError();
            return;
        }
    }

    void setFrame() {
        if (this.mErrorPopup != null) {
            TextView textView = (TextView)this.mErrorPopup.getContentView();
            this.chooseSize(this.mErrorPopup, this.mError, textView);
            this.mErrorPopup.update(this.mTextView, this.getErrorX(), this.getErrorY(), this.mErrorPopup.getWidth(), this.mErrorPopup.getHeight());
        }
    }

    void showSuggestions() {
        if (this.mSuggestionsPopupWindow == null) {
            this.mSuggestionsPopupWindow = new SuggestionsPopupWindow();
        }
        this.hideControllers();
        this.mSuggestionsPopupWindow.show();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean startSelectionActionMode() {
        if (this.mSelectionActionMode != null) {
            return false;
        }
        if (!this.canSelectText() || !this.mTextView.requestFocus()) {
            Log.w("TextView", "TextView does not support text selection. Action mode cancelled.");
            return false;
        }
        if (!this.mTextView.hasSelection() && !this.selectCurrentWord()) {
            return false;
        }
        boolean bl = this.extractedTextModeWillBeStarted();
        if (!bl) {
            SelectionActionModeCallback selectionActionModeCallback = new SelectionActionModeCallback();
            this.mSelectionActionMode = this.mTextView.startActionMode(selectionActionModeCallback);
        }
        if (this.mSelectionActionMode == null) {
            if (!bl) return false;
        }
        boolean bl2 = true;
        if (!bl2) return bl2;
        if (this.mTextView.isTextSelectable()) return bl2;
        if (!this.mShowSoftInputOnFocus) return bl2;
        InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
        if (inputMethodManager == null) return bl2;
        inputMethodManager.showSoftInput(this.mTextView, 0, null);
        return bl2;
    }

    protected void stopSelectionActionMode() {
        if (this.mSelectionActionMode != null) {
            this.mSelectionActionMode.finish();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateCursorsPositions() {
        if (this.mTextView.mCursorDrawableRes == 0) {
            this.mCursorCount = 0;
            return;
        } else {
            Layout layout2 = this.mTextView.getLayout();
            Layout layout3 = this.mTextView.getHintLayout();
            int n = this.mTextView.getSelectionStart();
            int n2 = layout2.getLineForOffset(n);
            int n3 = layout2.getLineTop(n2);
            int n4 = layout2.getLineTop(n2 + 1);
            int n5 = layout2.isLevelBoundary(n) ? 2 : 1;
            this.mCursorCount = n5;
            boolean bl = this.mTextView.getResetCursorFlag() ? false : this.mCursorInLineEnd;
            this.mCursorInLineEnd = bl;
            this.mTextView.setResetCursorFlag(false);
            int n6 = this.mCursorInLineEnd && n > 0 ? n - 1 : n;
            int n7 = this.mCursorInLineEnd && n2 > 0 ? n2 - 1 : n2;
            int n8 = this.mCursorInLineEnd ? layout2.getLineTop(n7) : n3;
            int n9 = this.mCursorInLineEnd ? layout2.getLineTop(n7 + 1) : n4;
            int n10 = n9;
            int n11 = this.mCursorInLineEnd ? (int)this.mTextView.getPaint().measureText(this.mTextView.getText().toString().substring(n6, n6 + 1)) : 0;
            this.mCursorHorizontalOffset = n11;
            if (this.mCursorCount == 2) {
                n10 = n8 + n9 >> 1;
            }
            if (this.mCursorCount == 2) {
                int cfr_ignored_0 = n3 + n4 >> 1;
            }
            boolean bl2 = layout2.shouldClampCursor(n2);
            this.updateCursorPosition(0, n8, n10, this.getPrimaryHorizontal(layout2, layout3, n6, bl2) + (float)this.mCursorHorizontalOffset);
            if (this.mCursorCount != 2) return;
            this.updateCursorPosition(1, n10, n9, layout2.getSecondaryHorizontal(n6, bl2) + (float)this.mCursorHorizontalOffset);
            return;
        }
    }

    private class ActionPopupWindow
    extends PinnedPopupWindow
    implements View.OnClickListener {
        private static final int POPUP_TEXT_LAYOUT = 17367281;
        private TextView mPasteTextView;
        private TextView mReplaceTextView;

        private ActionPopupWindow() {
        }

        @Override
        protected int clipVertically(int n) {
            if (n < 0) {
                int n2 = this.getTextOffset();
                Layout layout2 = Editor.this.mTextView.getLayout();
                int n3 = layout2.getLineForOffset(n2);
                n = n + (layout2.getLineBottom(n3) - layout2.getLineTop(n3)) + this.mContentView.getMeasuredHeight() + Editor.this.mTextView.getContext().getDrawable(((Editor)Editor.this).mTextView.mTextSelectHandleRes).getIntrinsicHeight();
            }
            return n;
        }

        @Override
        protected void createPopupWindow() {
            this.mPopupWindow = new PopupWindow(Editor.this.mTextView.getContext(), null, 16843464);
            this.mPopupWindow.setClippingEnabled(true);
        }

        @Override
        protected int getTextOffset() {
            int n = Editor.this.mTextView.getSelectionStart();
            int n2 = Editor.this.mTextView.getSelectionEnd();
            if (Editor.this.mCursorInLineEnd && n == n2) {
                --n;
                --n2;
            }
            return (n + n2) / 2;
        }

        @Override
        protected int getVerticalLocalPosition(int n) {
            return Editor.this.mTextView.getLayout().getLineTop(n) - this.mContentView.getMeasuredHeight();
        }

        @Override
        protected void initContentView() {
            LinearLayout linearLayout = new LinearLayout(Editor.this.mTextView.getContext());
            linearLayout.setOrientation(0);
            this.mContentView = linearLayout;
            this.mContentView.setBackgroundResource(17303525);
            LayoutInflater layoutInflater = (LayoutInflater)Editor.this.mTextView.getContext().getSystemService("layout_inflater");
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
            this.mPasteTextView = (TextView)layoutInflater.inflate(17367281, null);
            this.mPasteTextView.setLayoutParams(layoutParams);
            this.mContentView.addView(this.mPasteTextView);
            this.mPasteTextView.setText(17039371);
            this.mPasteTextView.setOnClickListener(this);
            this.mReplaceTextView = (TextView)layoutInflater.inflate(17367281, null);
            this.mReplaceTextView.setLayoutParams(layoutParams);
            this.mContentView.addView(this.mReplaceTextView);
            this.mReplaceTextView.setText(17040469);
            this.mReplaceTextView.setOnClickListener(this);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onClick(View view) {
            if (view == this.mPasteTextView && Editor.this.mTextView.canPaste()) {
                Editor.this.mTextView.onTextContextMenuItem(0x1020022);
                this.hide();
                return;
            } else {
                if (view != this.mReplaceTextView) return;
                int n = (Editor.this.mTextView.getSelectionStart() + Editor.this.mTextView.getSelectionEnd()) / 2;
                Editor.this.stopSelectionActionMode();
                Selection.setSelection((Spannable)Editor.this.mTextView.getText(), n);
                Editor.this.showSuggestions();
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void show() {
            boolean bl = Editor.this.mTextView.canPaste();
            boolean bl2 = Editor.this.mTextView.isSuggestionsEnabled() && Editor.this.isCursorInsideSuggestionSpan();
            TextView textView = this.mPasteTextView;
            int n = bl ? 0 : 8;
            textView.setVisibility(n);
            TextView textView2 = this.mReplaceTextView;
            int n2 = 0;
            if (!bl2) {
                n2 = 8;
            }
            textView2.setVisibility(n2);
            if (!bl && !bl2) {
                return;
            }
            super.show();
        }
    }

    private class Blink
    extends Handler
    implements Runnable {
        private boolean mCancelled;

        private Blink() {
        }

        void cancel() {
            if (!this.mCancelled) {
                this.removeCallbacks(this);
                this.mCancelled = true;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            block5: {
                block4: {
                    if (this.mCancelled) break block4;
                    this.removeCallbacks(this);
                    if (Editor.this.shouldBlink()) break block5;
                }
                return;
            }
            if (Editor.this.mTextView.getLayout() != null) {
                Editor.this.mTextView.invalidateCursorPath();
                Editor.this.invalidateMagnifierForCursorBlinking();
            }
            this.postAtTime(this, 500L + SystemClock.uptimeMillis());
        }

        void uncancel() {
            this.mCancelled = false;
        }
    }

    private class CorrectionHighlighter {
        private static final int FADE_OUT_DURATION = 400;
        private int mEnd;
        private long mFadingStartTime;
        private final Paint mPaint;
        private final Path mPath = new Path();
        private int mStart;
        private RectF mTempRectF;

        public CorrectionHighlighter() {
            this.mPaint = new Paint(1);
            this.mPaint.setCompatibilityScaling(((Editor)Editor.this).mTextView.getResources().getCompatibilityInfo().applicationScale);
            this.mPaint.setStyle(Paint.Style.FILL);
        }

        private void invalidate(boolean bl) {
            if (Editor.this.mTextView.getLayout() == null) {
                return;
            }
            if (this.mTempRectF == null) {
                this.mTempRectF = new RectF();
            }
            this.mPath.computeBounds(this.mTempRectF, false);
            int n = Editor.this.mTextView.getCompoundPaddingLeft();
            int n2 = Editor.this.mTextView.getExtendedPaddingTop() + Editor.this.mTextView.getVerticalOffset(true);
            if (bl) {
                Editor.this.mTextView.postInvalidateOnAnimation(n + (int)this.mTempRectF.left, n2 + (int)this.mTempRectF.top, n + (int)this.mTempRectF.right, n2 + (int)this.mTempRectF.bottom);
                return;
            }
            Editor.this.mTextView.postInvalidate((int)this.mTempRectF.left, (int)this.mTempRectF.top, (int)this.mTempRectF.right, (int)this.mTempRectF.bottom);
        }

        private void stopAnimation() {
            Editor.this.mCorrectionHighlighter = null;
        }

        private boolean updatePaint() {
            long l = SystemClock.uptimeMillis() - this.mFadingStartTime;
            if (l > 400L) {
                return false;
            }
            float f = 1.0f - (float)l / 400.0f;
            int n = Color.alpha(((Editor)Editor.this).mTextView.mHighlightColor);
            int n2 = (0xFFFFFF & ((Editor)Editor.this).mTextView.mHighlightColor) + ((int)(f * (float)n) << 24);
            this.mPaint.setColor(n2);
            return true;
        }

        private boolean updatePath() {
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 == null) {
                return false;
            }
            int n = Editor.this.mTextView.getText().length();
            int n2 = Math.min(n, this.mStart);
            int n3 = Math.min(n, this.mEnd);
            this.mPath.reset();
            layout2.getSelectionPath(n2, n3, this.mPath);
            return true;
        }

        public void draw(Canvas canvas, int n) {
            if (this.updatePath() && this.updatePaint()) {
                if (n != 0) {
                    canvas.translate(0.0f, n);
                }
                canvas.drawPath(this.mPath, this.mPaint);
                if (n != 0) {
                    canvas.translate(0.0f, -n);
                }
                this.invalidate(true);
                return;
            }
            this.stopAnimation();
            this.invalidate(false);
        }

        public void highlight(CorrectionInfo correctionInfo) {
            this.mStart = correctionInfo.getOffset();
            this.mEnd = this.mStart + correctionInfo.getNewText().length();
            this.mFadingStartTime = SystemClock.uptimeMillis();
            if (this.mStart < 0 || this.mEnd < 0) {
                this.stopAnimation();
            }
        }
    }

    private final class CursorAnchorInfoNotifier
    implements TextViewPositionListener {
        final CursorAnchorInfo.Builder mSelectionInfoBuilder = new CursorAnchorInfo.Builder();
        final int[] mTmpIntOffset = new int[2];
        final Matrix mViewToScreenMatrix = new Matrix();

        private CursorAnchorInfoNotifier() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void updatePosition(int n, int n2, boolean bl, boolean bl2) {
            CursorAnchorInfo.Builder builder;
            InputMethodManager inputMethodManager;
            block26: {
                int n3;
                boolean bl3;
                boolean bl4;
                float f;
                float f2;
                float f3;
                float f4;
                int n4;
                Layout layout2;
                block28: {
                    block27: {
                        float f5;
                        float f6;
                        block23: {
                            boolean bl5;
                            InputMethodState inputMethodState = Editor.this.mInputMethodState;
                            if (inputMethodState == null || inputMethodState.mBatchEditNesting > 0 || (inputMethodManager = InputMethodManager.peekInstance()) == null || !inputMethodManager.isActive(Editor.this.mTextView) || !inputMethodManager.isCursorAnchorInfoEnabled() || (layout2 = Editor.this.mTextView.getLayout()) == null) {
                                return;
                            }
                            builder = this.mSelectionInfoBuilder;
                            builder.reset();
                            n4 = Editor.this.mTextView.getSelectionStart();
                            builder.setSelectionRange(n4, Editor.this.mTextView.getSelectionEnd());
                            this.mViewToScreenMatrix.set(Editor.this.mTextView.getMatrix());
                            Editor.this.mTextView.getLocationOnScreen(this.mTmpIntOffset);
                            this.mViewToScreenMatrix.postTranslate(this.mTmpIntOffset[0], this.mTmpIntOffset[1]);
                            builder.setMatrix(this.mViewToScreenMatrix);
                            f6 = Editor.this.mTextView.viewportToContentHorizontalOffset();
                            f5 = Editor.this.mTextView.viewportToContentVerticalOffset();
                            CharSequence charSequence = Editor.this.mTextView.getText();
                            if (!(charSequence instanceof Spannable)) break block23;
                            Spannable spannable = (Spannable)charSequence;
                            int n5 = EditableInputConnection.getComposingSpanStart(spannable);
                            int n6 = EditableInputConnection.getComposingSpanEnd(spannable);
                            if (n6 < n5) {
                                int n7 = n6;
                                n6 = n5;
                                n5 = n7;
                            }
                            if (!(bl5 = n5 >= 0 && n5 < n6)) break block23;
                            CharSequence charSequence2 = charSequence.subSequence(n5, n6);
                            builder.setComposingText(n5, charSequence2);
                            int n8 = layout2.getLineForOffset(n5);
                            int n9 = layout2.getLineForOffset(n6 - 1);
                            for (int i = n8; i <= n9; ++i) {
                                int n10 = layout2.getLineStart(i);
                                int n11 = layout2.getLineEnd(i);
                                int n12 = Math.max(n10, n5);
                                int n13 = Math.min(n11, n6);
                                boolean bl6 = layout2.getParagraphDirection(i) == 1;
                                float[] fArray = new float[n13 - n12];
                                layout2.getPaint().getTextWidths(charSequence, n12, n13, fArray);
                                float f7 = layout2.getLineTop(i);
                                float f8 = layout2.getLineBottom(i);
                                for (int j = n12; j < n13; ++j) {
                                    int n14;
                                    boolean bl7;
                                    float f9;
                                    float f10;
                                    float f11;
                                    float f12;
                                    boolean bl8;
                                    block25: {
                                        block24: {
                                            float f13;
                                            float f14;
                                            float f15 = fArray[j - n12];
                                            bl8 = layout2.isRtlCharAt(j);
                                            float f16 = layout2.getPrimaryHorizontal(j);
                                            float f17 = layout2.getSecondaryHorizontal(j);
                                            if (bl6) {
                                                if (bl8) {
                                                    f14 = f17 - f15;
                                                    f13 = f17;
                                                } else {
                                                    f14 = f16;
                                                    f13 = f16 + f15;
                                                }
                                            } else if (!bl8) {
                                                f14 = f17;
                                                f13 = f17 + f15;
                                            } else {
                                                f14 = f16 - f15;
                                                f13 = f16;
                                            }
                                            f12 = f14 + f6;
                                            f11 = f13 + f6;
                                            f10 = f7 + f5;
                                            f9 = f8 + f5;
                                            bl7 = Editor.this.isPositionVisible(f12, f10);
                                            boolean bl9 = Editor.this.isPositionVisible(f11, f9);
                                            if (bl7) break block24;
                                            n14 = 0;
                                            if (!bl9) break block25;
                                        }
                                        n14 = 0 | 1;
                                    }
                                    if (!bl7 || !bl7) {
                                        n14 |= 2;
                                    }
                                    if (bl8) {
                                        n14 |= 4;
                                    }
                                    builder.addCharacterBounds(j, f12, f10, f11, f9, n14);
                                }
                            }
                        }
                        if (n4 < 0) break block26;
                        int n15 = layout2.getLineForOffset(n4);
                        f4 = f6 + layout2.getPrimaryHorizontal(n4);
                        f3 = f5 + (float)layout2.getLineTop(n15);
                        f2 = f5 + (float)layout2.getLineBaseline(n15);
                        f = f5 + (float)layout2.getLineBottom(n15);
                        bl4 = Editor.this.isPositionVisible(f4, f3);
                        bl3 = Editor.this.isPositionVisible(f4, f);
                        if (bl4) break block27;
                        n3 = 0;
                        if (!bl3) break block28;
                    }
                    n3 = 0 | 1;
                }
                if (!bl4 || !bl3) {
                    n3 |= 2;
                }
                if (layout2.isRtlCharAt(n4)) {
                    n3 |= 4;
                }
                builder.setInsertionMarkerLocation(f4, f3, f2, f, n3);
            }
            inputMethodManager.updateCursorAnchorInfo(Editor.this.mTextView, builder.build());
        }
    }

    private static interface CursorController
    extends ViewTreeObserver.OnTouchModeChangeListener {
        public HandleView getStartHandle();

        public void hide();

        public void onDetached();

        public void show();
    }

    private static class DragLocalState {
        public int end;
        public TextView sourceTextView;
        public int start;

        public DragLocalState(TextView textView, int n, int n2) {
            this.sourceTextView = textView;
            this.start = n;
            this.end = n2;
        }
    }

    private static interface EasyEditDeleteListener {
        public void onDeleteClick(EasyEditSpan var1);
    }

    private class EasyEditPopupWindow
    extends PinnedPopupWindow
    implements View.OnClickListener {
        private static final int POPUP_TEXT_LAYOUT = 17367281;
        private TextView mDeleteTextView;
        private EasyEditSpan mEasyEditSpan;
        private EasyEditDeleteListener mOnDeleteListener;

        private EasyEditPopupWindow() {
        }

        private void setOnDeleteListener(EasyEditDeleteListener easyEditDeleteListener) {
            this.mOnDeleteListener = easyEditDeleteListener;
        }

        @Override
        protected int clipVertically(int n) {
            return n;
        }

        @Override
        protected void createPopupWindow() {
            this.mPopupWindow = new PopupWindow(Editor.this.mTextView.getContext(), null, 16843464);
            this.mPopupWindow.setInputMethodMode(2);
            this.mPopupWindow.setClippingEnabled(true);
        }

        @Override
        protected int getTextOffset() {
            return ((Editable)Editor.this.mTextView.getText()).getSpanEnd(this.mEasyEditSpan);
        }

        @Override
        protected int getVerticalLocalPosition(int n) {
            return Editor.this.mTextView.getLayout().getLineBottom(n);
        }

        @Override
        public void hide() {
            if (this.mEasyEditSpan != null) {
                this.mEasyEditSpan.setDeleteEnabled(false);
            }
            this.mOnDeleteListener = null;
            super.hide();
        }

        @Override
        protected void initContentView() {
            LinearLayout linearLayout = new LinearLayout(Editor.this.mTextView.getContext());
            linearLayout.setOrientation(0);
            this.mContentView = linearLayout;
            this.mContentView.setBackgroundResource(17303526);
            LayoutInflater layoutInflater = (LayoutInflater)Editor.this.mTextView.getContext().getSystemService("layout_inflater");
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
            this.mDeleteTextView = (TextView)layoutInflater.inflate(17367281, null);
            this.mDeleteTextView.setLayoutParams(layoutParams);
            this.mDeleteTextView.setText(17040470);
            this.mDeleteTextView.setOnClickListener(this);
            this.mContentView.addView(this.mDeleteTextView);
        }

        @Override
        public void onClick(View view) {
            if (view == this.mDeleteTextView && this.mEasyEditSpan != null && this.mEasyEditSpan.isDeleteEnabled() && this.mOnDeleteListener != null) {
                this.mOnDeleteListener.onDeleteClick(this.mEasyEditSpan);
            }
        }

        public void setEasyEditSpan(EasyEditSpan easyEditSpan) {
            this.mEasyEditSpan = easyEditSpan;
        }
    }

    private static class ErrorPopup
    extends PopupWindow {
        private boolean mAbove = false;
        private int mPopupInlineErrorAboveBackgroundId = 0;
        private int mPopupInlineErrorBackgroundId = 0;
        private final TextView mView;

        ErrorPopup(TextView textView, int n, int n2) {
            super(textView, n, n2);
            this.mView = textView;
            this.mPopupInlineErrorBackgroundId = this.getResourceId(this.mPopupInlineErrorBackgroundId, 230);
            this.mView.setBackgroundResource(this.mPopupInlineErrorBackgroundId);
        }

        private int getResourceId(int n, int n2) {
            if (n == 0) {
                TypedArray typedArray = this.mView.getContext().obtainStyledAttributes(R.styleable.Theme);
                n = typedArray.getResourceId(n2, 0);
                typedArray.recycle();
            }
            return n;
        }

        /*
         * Enabled aggressive block sorting
         */
        void fixDirection(boolean bl) {
            this.mAbove = bl;
            if (bl) {
                this.mPopupInlineErrorAboveBackgroundId = this.getResourceId(this.mPopupInlineErrorAboveBackgroundId, 231);
            } else {
                this.mPopupInlineErrorBackgroundId = this.getResourceId(this.mPopupInlineErrorBackgroundId, 230);
            }
            TextView textView = this.mView;
            int n = bl ? this.mPopupInlineErrorAboveBackgroundId : this.mPopupInlineErrorBackgroundId;
            textView.setBackgroundResource(n);
        }

        @Override
        public void update(int n, int n2, int n3, int n4, boolean bl) {
            super.update(n, n2, n3, n4, bl);
            boolean bl2 = this.isAboveAnchor();
            if (bl2 != this.mAbove) {
                this.fixDirection(bl2);
            }
        }
    }

    private abstract class HandleView
    extends View
    implements TextViewPositionListener {
        private static final int HISTORY_SIZE = 5;
        private static final int TOUCH_UP_FILTER_DELAY_AFTER = 150;
        private static final int TOUCH_UP_FILTER_DELAY_BEFORE = 350;
        private Runnable mActionPopupShower;
        protected ActionPopupWindow mActionPopupWindow;
        private final PopupWindow mContainer;
        private float mDownPositionX;
        private float mDownPositionY;
        protected Drawable mDrawable;
        protected Drawable mDrawableLtr;
        protected Drawable mDrawableRtl;
        protected int mHorizontalGravity;
        protected int mHotspotX;
        private float mIdealVerticalOffset;
        private boolean mIsDragging;
        private int mLastParentX;
        private int mLastParentY;
        private int mLocalXCorrection;
        private int mMinSize;
        private int mNumberPreviousOffsets;
        private int mOldPositionY;
        private int mOldX;
        private int mOldY;
        private boolean mPositionHasChanged;
        private int mPositionX;
        private int mPositionY;
        private int mPreviousOffset;
        private int mPreviousOffsetIndex;
        private final int[] mPreviousOffsets;
        private final long[] mPreviousOffsetsTimes;
        private float mTouchOffsetY;
        private float mTouchToWindowOffsetX;
        private float mTouchToWindowOffsetY;

        public HandleView(Drawable drawable2, Drawable drawable3) {
            super(Editor.this.mTextView.getContext());
            this.mPreviousOffset = -1;
            this.mPositionHasChanged = true;
            this.mPreviousOffsetsTimes = new long[5];
            this.mPreviousOffsets = new int[5];
            this.mPreviousOffsetIndex = 0;
            this.mNumberPreviousOffsets = 0;
            this.mLocalXCorrection = 0;
            this.mContainer = new PopupWindow(Editor.this.mTextView.getContext(), null, 16843464);
            this.mContainer.setSplitTouchEnabled(true);
            this.mContainer.setClippingEnabled(false);
            this.mContainer.setWindowLayoutType(1002);
            this.mContainer.setContentView(this);
            this.mDrawableLtr = drawable2;
            this.mDrawableRtl = drawable3;
            this.mMinSize = Editor.this.mTextView.getContext().getResources().getDimensionPixelSize(17105052);
            this.updateDrawable();
            int n = this.getPreferredHeight();
            this.mTouchOffsetY = -0.3f * (float)n;
            this.mIdealVerticalOffset = 0.7f * (float)n;
        }

        private void addPositionToTouchUpFilter(int n) {
            this.mPreviousOffsetIndex = (1 + this.mPreviousOffsetIndex) % 5;
            this.mPreviousOffsets[this.mPreviousOffsetIndex] = n;
            this.mPreviousOffsetsTimes[this.mPreviousOffsetIndex] = SystemClock.uptimeMillis();
            this.mNumberPreviousOffsets = 1 + this.mNumberPreviousOffsets;
        }

        private void filterOnTouchUp() {
            long l = SystemClock.uptimeMillis();
            int n = 0;
            int n2 = this.mPreviousOffsetIndex;
            int n3 = Math.min(this.mNumberPreviousOffsets, 5);
            while (n < n3 && l - this.mPreviousOffsetsTimes[n2] < 150L) {
                n2 = (5 + (this.mPreviousOffsetIndex - ++n)) % 5;
            }
            if (n > 0 && n < n3 && l - this.mPreviousOffsetsTimes[n2] > 350L) {
                this.positionAtCursorOffset(this.mPreviousOffsets[n2], false);
            }
        }

        private int getHorizontalOffset() {
            int n = this.getPreferredWidth();
            int n2 = this.mDrawable.getIntrinsicWidth();
            switch (this.mHorizontalGravity) {
                default: {
                    return (n - n2) / 2;
                }
                case 3: {
                    return 0;
                }
                case 5: 
            }
            return n - n2;
        }

        private int getPreferredHeight() {
            return Math.max(this.mDrawable.getIntrinsicHeight(), this.mMinSize);
        }

        private int getPreferredWidth() {
            return Math.max(this.mDrawable.getIntrinsicWidth(), this.mMinSize);
        }

        private boolean isVisible() {
            if (this.mIsDragging) {
                return true;
            }
            if (Editor.this.mTextView.isInBatchEditMode()) {
                return false;
            }
            return Editor.this.isPositionVisible(this.mPositionX + this.mHotspotX, this.mPositionY);
        }

        private void startTouchUpFilter(int n) {
            this.mNumberPreviousOffsets = 0;
            this.addPositionToTouchUpFilter(n);
        }

        protected void dismiss() {
            this.mIsDragging = false;
            this.mContainer.dismiss();
            this.onDetached();
        }

        public abstract int getCurrentCursorOffset();

        protected int getCursorOffset() {
            return 0;
        }

        protected abstract int getHorizontalGravity(boolean var1);

        protected abstract int getHotspotX(Drawable var1, boolean var2);

        public void hide() {
            this.dismiss();
            Editor.this.dismissMagnifierUntilNextCursorAppearance();
            Editor.this.getPositionListener().removeSubscriber(this);
        }

        protected void hideActionPopupWindow() {
            if (this.mActionPopupShower != null) {
                Editor.this.mTextView.removeCallbacks(this.mActionPopupShower);
            }
            if (this.mActionPopupWindow != null) {
                this.mActionPopupWindow.hide();
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public Boolean isAtEdgeOfLine(int n, int n2) {
            boolean bl;
            if (!Editor.this.isPositionOnText(n, n2)) {
                bl = true;
                return bl;
            }
            if (Editor.this.mTextView.getSelectionStart() == 0 && this instanceof SelectionStartHandleView) {
                bl = true;
                return bl;
            }
            int n3 = Editor.this.calculateTheFakeOffset(n, n2);
            int n4 = Editor.this.mTextView.getLineAtCoordinate(n2);
            int n5 = Editor.this.mTextView.getLayout().getLineStart(n4);
            bl = false;
            if (n3 != n5) return bl;
            bl = true;
            return bl;
        }

        public boolean isDragging() {
            return this.mIsDragging;
        }

        public boolean isShowing() {
            return this.mContainer.isShowing();
        }

        public boolean offsetHasBeenChanged() {
            return this.mNumberPreviousOffsets > 1;
        }

        public void onDetached() {
            this.hideActionPopupWindow();
        }

        @Override
        protected void onDraw(Canvas canvas) {
            int n = this.mDrawable.getIntrinsicWidth();
            int n2 = this.getHorizontalOffset();
            this.mDrawable.setBounds(n2, 0, n2 + n, this.mDrawable.getIntrinsicHeight());
            this.mDrawable.draw(canvas);
        }

        void onHandleMoved() {
            this.hideActionPopupWindow();
        }

        @Override
        protected void onMeasure(int n, int n2) {
            this.setMeasuredDimension(this.getPreferredWidth(), this.getPreferredHeight());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTouchEvent(MotionEvent motionEvent) {
            switch (motionEvent.getActionMasked()) {
                case 0: {
                    int n;
                    this.startTouchUpFilter(this.getCurrentCursorOffset());
                    this.mTouchToWindowOffsetX = motionEvent.getRawX() - (float)this.mPositionX;
                    this.mTouchToWindowOffsetY = motionEvent.getRawY() - (float)this.mPositionY;
                    PositionListener positionListener = Editor.this.getPositionListener();
                    this.mLastParentX = positionListener.getPositionX();
                    this.mLastParentY = positionListener.getPositionY();
                    this.mIsDragging = true;
                    if (!Editor.this.mMagnifierEnabled) return true;
                    this.mDownPositionX = motionEvent.getRawX();
                    this.mDownPositionY = motionEvent.getRawY();
                    this.mOldX = (int)this.mDownPositionX;
                    this.mOldY = n = (int)motionEvent.getRawY();
                    this.mOldPositionY = this.mPositionY;
                    int n2 = 15 + Editor.this.mTextView.getLayout().getLineBottom(0);
                    Editor.this.showMagnifier(this, (int)this.mDownPositionX, n, this.mPositionX + this.mHotspotX, this.mPositionY - n2);
                    return true;
                }
                case 2: {
                    float f = motionEvent.getRawX();
                    float f2 = motionEvent.getRawY();
                    float f3 = this.mTouchToWindowOffsetY - (float)this.mLastParentY;
                    float f4 = f2 - (float)this.mPositionY - (float)this.mLastParentY;
                    float f5 = f3 < this.mIdealVerticalOffset ? Math.max(Math.min(f4, this.mIdealVerticalOffset), f3) : Math.min(Math.max(f4, this.mIdealVerticalOffset), f3);
                    this.mTouchToWindowOffsetY = f5 + (float)this.mLastParentY;
                    float f6 = f - this.mTouchToWindowOffsetX + (float)this.mHotspotX;
                    float f7 = f2 - this.mTouchToWindowOffsetY + this.mTouchOffsetY;
                    this.updatePosition(f6, f7);
                    if (!Editor.this.mMagnifierEnabled) return true;
                    int n = this.mOldY;
                    if (this.mOldPositionY != this.mPositionY) {
                        this.mOldY = n = (int)motionEvent.getRawY();
                        this.mOldPositionY = this.mPositionY;
                    }
                    int n3 = (int)f;
                    if (this.isAtEdgeOfLine(Math.round(f6), Math.round(f7)).booleanValue()) {
                        n3 = this.mOldX;
                    } else {
                        this.mOldX = n3;
                    }
                    int n4 = 15 + Editor.this.mTextView.getLayout().getLineBottom(0);
                    Editor.this.updateMagnifier(this, n3, n, this.mPositionX + this.mHotspotX, this.mPositionY - n4);
                    return true;
                }
                case 1: {
                    this.filterOnTouchUp();
                    this.mIsDragging = false;
                    Editor.this.dismissMagnifier();
                    return true;
                }
                case 3: {
                    this.mIsDragging = false;
                    return true;
                }
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void positionAtCursorOffset(int n, boolean bl) {
            int n2;
            int n3;
            Layout layout2 = Editor.this.mTextView.getLayout();
            if (layout2 == null) {
                Editor.this.prepareCursorControllers();
                return;
            } else {
                boolean bl2 = n != this.mPreviousOffset;
                if (!bl2 && !bl) return;
                if (bl2) {
                    this.updateSelection(n);
                    this.addPositionToTouchUpFilter(n);
                }
                n3 = layout2.getLineForOffset(n);
                this.mPositionX = (int)(layout2.getPrimaryHorizontal(n) - 0.5f - (float)this.mHotspotX - (float)this.getHorizontalOffset() + (float)this.getCursorOffset());
                this.mPositionY = layout2.getLineBottom(n3);
                n2 = Editor.this.mCursorInLineEnd && n > 0 ? n - 1 : n;
            }
            boolean bl3 = Editor.this.mCursorInLineEnd;
            int n4 = 0;
            if (bl3) {
                n4 = (int)Editor.this.mTextView.getPaint().measureText(Editor.this.mTextView.getText().toString().substring(n2, n2 + 1));
            }
            int n5 = Editor.this.mCursorInLineEnd ? n - 1 : n;
            this.mPositionX = (int)(layout2.getPrimaryHorizontal(n5) - 0.5f - (float)this.mHotspotX - (float)this.getHorizontalOffset() + (float)this.getCursorOffset());
            this.mPositionX = n4 + this.mPositionX;
            if (Editor.this.mCursorInLineEnd) {
                --n3;
            }
            this.mPositionY = layout2.getLineBottom(n3);
            this.mPositionX += Editor.this.mTextView.viewportToContentHorizontalOffset();
            this.mPositionY += Editor.this.mTextView.viewportToContentVerticalOffset();
            this.mPreviousOffset = n;
            this.mPositionHasChanged = true;
        }

        public void refreshMagnifier() {
            if (Editor.this.mMagnifier != null) {
                Editor.this.mMagnifier.surfaceChanged(Editor.this.mMagnifier.getHolder(), 0, 0, 0);
            }
        }

        public void show() {
            if (this.isShowing()) {
                return;
            }
            Editor.this.getPositionListener().addSubscriber(this, true);
            this.mPreviousOffset = -1;
            this.positionAtCursorOffset(this.getCurrentCursorOffset(), false);
            this.hideActionPopupWindow();
        }

        /*
         * Enabled aggressive block sorting
         */
        void showActionPopupWindow(int n) {
            if (this.mActionPopupWindow == null) {
                this.mActionPopupWindow = new ActionPopupWindow();
            }
            if (this.mActionPopupShower == null) {
                this.mActionPopupShower = new Runnable(){

                    @Override
                    public void run() {
                        HandleView.this.mActionPopupWindow.show();
                    }
                };
            } else {
                Editor.this.mTextView.removeCallbacks(this.mActionPopupShower);
            }
            Editor.this.mTextView.postDelayed(this.mActionPopupShower, n);
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void updateDrawable() {
            int n = this.getCurrentCursorOffset();
            boolean bl = Editor.this.mTextView.getLayout().isRtlCharAt(n);
            Drawable drawable2 = bl ? this.mDrawableRtl : this.mDrawableLtr;
            this.mDrawable = drawable2;
            this.mHotspotX = this.getHotspotX(this.mDrawable, bl);
            this.mHorizontalGravity = this.getHorizontalGravity(bl);
        }

        public abstract void updatePosition(float var1, float var2);

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void updatePosition(int n, int n2, boolean bl, boolean bl2) {
            this.positionAtCursorOffset(this.getCurrentCursorOffset(), bl2);
            if (bl || this.mPositionHasChanged) {
                if (this.mIsDragging) {
                    if (n != this.mLastParentX || n2 != this.mLastParentY) {
                        this.mTouchToWindowOffsetX += (float)(n - this.mLastParentX);
                        this.mTouchToWindowOffsetY += (float)(n2 - this.mLastParentY);
                        this.mLastParentX = n;
                        this.mLastParentY = n2;
                    }
                    this.onHandleMoved();
                }
                if (this.isVisible()) {
                    int n3 = n + this.mPositionX;
                    int n4 = n2 + this.mPositionY;
                    if (this.isShowing()) {
                        this.mContainer.update(n3, n4, -1, -1);
                    } else {
                        this.mContainer.showAtLocation(Editor.this.mTextView, 0, n3, n4);
                    }
                } else if (this.isShowing()) {
                    this.dismiss();
                }
                this.mPositionHasChanged = false;
            }
        }

        protected abstract void updateSelection(int var1);
    }

    static class InputContentType {
        boolean enterDown;
        Bundle extras;
        int imeActionId;
        CharSequence imeActionLabel;
        int imeOptions = 0;
        TextView.OnEditorActionListener onEditorActionListener;
        String privateImeOptions;

        InputContentType() {
        }
    }

    static class InputMethodState {
        int mBatchEditNesting;
        int mChangedDelta;
        int mChangedEnd;
        int mChangedStart;
        boolean mContentChanged;
        boolean mCursorChanged;
        Rect mCursorRectInWindow = new Rect();
        final ExtractedText mExtractedText;
        ExtractedTextRequest mExtractedTextRequest;
        boolean mSelectionModeChanged;
        float[] mTmpOffset = new float[2];

        InputMethodState() {
            this.mExtractedText = new ExtractedText();
        }
    }

    private class InsertionHandleView
    extends HandleView {
        private static final int DELAY_BEFORE_HANDLE_FADES_OUT = 4000;
        private static final int RECENT_CUT_COPY_DURATION = 15000;
        private float mDownPositionX;
        private float mDownPositionY;
        private Runnable mHider;

        public InsertionHandleView(Drawable drawable2) {
            super(drawable2, drawable2);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void hideAfterDelay() {
            if (this.mHider == null) {
                this.mHider = new Runnable(){

                    @Override
                    public void run() {
                        InsertionHandleView.this.hide();
                    }
                };
            } else {
                this.removeHiderCallback();
            }
            Editor.this.mTextView.postDelayed(this.mHider, 4000L);
        }

        private void removeHiderCallback() {
            if (this.mHider != null) {
                Editor.this.mTextView.removeCallbacks(this.mHider);
            }
        }

        @Override
        public int getCurrentCursorOffset() {
            return Editor.this.mTextView.getSelectionStart();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected int getCursorOffset() {
            int n = super.getCursorOffset();
            Drawable drawable2 = Editor.this.mCursorCount > 0 ? Editor.this.mCursorDrawable[0] : null;
            if (drawable2 != null) {
                drawable2.getPadding(Editor.this.mTempRect);
                n += (drawable2.getIntrinsicWidth() - ((Editor)Editor.this).mTempRect.left - ((Editor)Editor.this).mTempRect.right) / 2;
            }
            return n;
        }

        @Override
        protected int getHorizontalGravity(boolean bl) {
            return 1;
        }

        @Override
        protected int getHotspotX(Drawable drawable2, boolean bl) {
            return drawable2.getIntrinsicWidth() / 2;
        }

        @Override
        public void onDetached() {
            super.onDetached();
            this.removeHiderCallback();
        }

        @Override
        void onHandleMoved() {
            super.onHandleMoved();
            this.removeHiderCallback();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTouchEvent(MotionEvent motionEvent) {
            boolean bl = super.onTouchEvent(motionEvent);
            switch (motionEvent.getActionMasked()) {
                default: {
                    return bl;
                }
                case 0: {
                    this.mDownPositionX = motionEvent.getRawX();
                    this.mDownPositionY = motionEvent.getRawY();
                    return bl;
                }
                case 1: {
                    int n;
                    float f;
                    float f2;
                    float f3;
                    if (!this.offsetHasBeenChanged() && (f3 = (f2 = this.mDownPositionX - motionEvent.getRawX()) * f2 + (f = this.mDownPositionY - motionEvent.getRawY()) * f) < (float)((n = ViewConfiguration.get(Editor.this.mTextView.getContext()).getScaledTouchSlop()) * n)) {
                        if (this.mActionPopupWindow != null && this.mActionPopupWindow.isShowing()) {
                            this.mActionPopupWindow.hide();
                        } else {
                            this.showWithActionPopup();
                        }
                    }
                    this.hideAfterDelay();
                    return bl;
                }
                case 3: 
            }
            this.hideAfterDelay();
            return bl;
        }

        @Override
        public void show() {
            super.show();
            if (SystemClock.uptimeMillis() - TextView.LAST_CUT_OR_COPY_TIME < 15000L) {
                this.showActionPopupWindow(0);
            }
            this.hideAfterDelay();
        }

        public void showWithActionPopup() {
            this.show();
            this.showActionPopupWindow(0);
        }

        @Override
        public void updatePosition(float f, float f2) {
            this.positionAtCursorOffset(Editor.this.calculateTheFakeOffset(f, f2), false);
        }

        @Override
        public void updateSelection(int n) {
            Selection.setSelection((Spannable)Editor.this.mTextView.getText(), n);
        }
    }

    private class InsertionPointCursorController
    implements CursorController {
        private InsertionHandleView mHandle;

        private InsertionPointCursorController() {
        }

        private InsertionHandleView getHandle() {
            if (Editor.this.mSelectHandleCenter == null) {
                Editor.access$4102(Editor.this, Editor.this.mTextView.getContext().getDrawable(((Editor)Editor.this).mTextView.mTextSelectHandleRes));
            }
            if (this.mHandle == null) {
                this.mHandle = new InsertionHandleView(Editor.this.mSelectHandleCenter);
            }
            return this.mHandle;
        }

        @Override
        public HandleView getStartHandle() {
            return null;
        }

        @Override
        public void hide() {
            if (this.mHandle != null) {
                this.mHandle.hide();
            }
        }

        @Override
        public void onDetached() {
            Editor.this.mTextView.getViewTreeObserver().removeOnTouchModeChangeListener(this);
            if (this.mHandle != null) {
                this.mHandle.onDetached();
            }
        }

        @Override
        public void onTouchModeChanged(boolean bl) {
            if (!bl) {
                this.hide();
            }
        }

        @Override
        public void show() {
            this.getHandle().show();
        }

        public void showWithActionPopup() {
            this.getHandle().showWithActionPopup();
        }
    }

    private class Magnifier
    extends SurfaceView
    implements SurfaceHolder.Callback {
        public static final float MAGNIFIER_FRAME_THICKNESS = 6.0f;
        public static final int MAGNIFIER_PADDING = 15;
        public static final float MAGNIFIER_RATIO_WIDTH_HEIGHT = 1.6f;
        public static final float MAGNIFIER_ZOOM_LEVEL = 1.7f;
        private boolean mDisabled;
        private Paint mFramePaint;
        private int mLocalX;
        private int mLocalY;
        private int mOrientation;
        private SurfaceHolder mSurfaceHolder;
        public int screen_height;
        public int screen_width;
        private Bitmap snapshot;

        public Magnifier(Context context) {
            this(context, 0, 0);
        }

        public Magnifier(Context context, int n, int n2) {
            super(context);
            this.mLocalX = n;
            this.mLocalY = n2;
            this.screen_width = context.getResources().getDisplayMetrics().widthPixels;
            this.screen_height = context.getResources().getDisplayMetrics().heightPixels;
            this.mOrientation = context.getResources().getConfiguration().orientation;
            this.mDisabled = false;
            SurfaceHolder surfaceHolder = this.getHolder();
            surfaceHolder.addCallback(this);
            surfaceHolder.setType(0);
            surfaceHolder.setFormat(-3);
            this.mFramePaint = new Paint();
            this.mFramePaint.setAntiAlias(true);
            this.mFramePaint.setARGB(255, 226, 150, 35);
            this.mFramePaint.setStyle(Paint.Style.STROKE);
            this.mFramePaint.setStrokeWidth(6.0f);
        }

        static /* synthetic */ int access$202(Magnifier magnifier, int n) {
            magnifier.mOrientation = n;
            return n;
        }

        static /* synthetic */ boolean access$4702(Magnifier magnifier, boolean bl) {
            magnifier.mDisabled = bl;
            return bl;
        }

        public void disable() {
            if (Editor.this.mMagnifier != null) {
                Editor.this.mWindowManager.removeView(Editor.this.mMagnifier);
                Editor.access$4002(Editor.this, null);
            }
            this.mDisabled = true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void drawMagnifier(SurfaceHolder surfaceHolder, int n, int n2) {
            synchronized (this) {
                block14: {
                    if (surfaceHolder != null && !this.mDisabled) {
                        block13: {
                            this.mLocalX = n;
                            this.mLocalY = n2;
                            Editor.this.mTextView.getPaint().getTextSize();
                            Editor.this.mTextView.getSelectionStart();
                            Editor.this.mTextView.getSelectionEnd();
                            try {
                                Canvas canvas = surfaceHolder.lockCanvas();
                                if (canvas != null) {
                                    RectF rectF = new RectF(canvas.getClipBounds());
                                    rectF.inset(3.0f, 3.0f);
                                    canvas.drawRoundRect(rectF, 6.0f, 6.0f, this.mFramePaint);
                                    rectF.inset(3.0f, 3.0f);
                                    canvas.clipRect(rectF, Region.Op.REPLACE);
                                    int n3 = Editor.this.mTextView.getTextColors().getColorForState(this.getDrawableState(), 0);
                                    int n4 = Editor.getInverseColor(n3);
                                    Log.i(Editor.LOG_TAG, "drawMagnifier - text_color = " + n3 + ". bg_color = " + n4);
                                    canvas.drawColor(n4);
                                    canvas.scale(1.7f, 1.7f);
                                    canvas.translate((float)(-this.mLocalX) - (float)Editor.this.mTextView.getScrollX() + rectF.width() / 1.7f / 2.0f, (float)(-this.mLocalY) - (float)Editor.this.mTextView.getScrollY());
                                    Drawable drawable2 = Editor.this.mTextView.getBackground();
                                    if (drawable2 != null) {
                                        int n5;
                                        int n6 = Editor.this.mTextView.getScrollX();
                                        if ((n6 | (n5 = Editor.this.mTextView.getScrollY())) == 0) {
                                            drawable2.draw(canvas);
                                        } else {
                                            float f = n6;
                                            float f2 = n5;
                                            canvas.translate(f, f2);
                                            drawable2.draw(canvas);
                                            canvas.translate(-n6, -n5);
                                        }
                                    }
                                    Editor.this.mTextView.onDraw(canvas);
                                    surfaceHolder.unlockCanvasAndPost(canvas);
                                }
                                break block13;
                            }
                            catch (Exception exception) {
                                Log.w(Editor.LOG_TAG, "Exception drawing magnifier in Canvas", exception);
                            }
                            break block14;
                        }
                        Log.w(Editor.LOG_TAG, "Canvas cannot be locked, drawing skipped.");
                    }
                }
                return;
            }
        }

        @Override
        protected void onAttachedToWindow() {
            if (this.getParent() != null) {
                super.onAttachedToWindow();
            }
        }

        @Override
        public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
            this.mSurfaceHolder = surfaceHolder;
            this.drawMagnifier(surfaceHolder, this.mLocalX, this.mLocalY);
        }

        @Override
        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            Log.v(Editor.LOG_TAG, "surfaceCreated");
            this.mSurfaceHolder = surfaceHolder;
        }

        @Override
        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            Log.v(Editor.LOG_TAG, "surfaceDestroyed");
            this.mSurfaceHolder = null;
        }

        public void updateScreenSize() {
            Log.i(Editor.LOG_TAG, "Magnifier - updateScreenSize");
            this.screen_width = ((Editor)Editor.this).mTextView.getContext().getResources().getDisplayMetrics().widthPixels;
            this.screen_height = ((Editor)Editor.this).mTextView.getContext().getResources().getDisplayMetrics().heightPixels;
        }
    }

    private abstract class PinnedPopupWindow
    implements TextViewPositionListener {
        protected ViewGroup mContentView;
        protected PopupWindow mPopupWindow;
        int mPositionX;
        int mPositionY;

        public PinnedPopupWindow() {
            this.createPopupWindow();
            this.mPopupWindow.setWindowLayoutType(1002);
            this.mPopupWindow.setWidth(-2);
            this.mPopupWindow.setHeight(-2);
            this.initContentView();
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -2);
            this.mContentView.setLayoutParams(layoutParams);
            this.mPopupWindow.setContentView(this.mContentView);
        }

        private void computeLocalPosition() {
            this.measureContent();
            int n = this.mContentView.getMeasuredWidth();
            int n2 = this.getTextOffset();
            this.mPositionX = (int)(Editor.this.mTextView.getLayout().getPrimaryHorizontal(n2) - (float)n / 2.0f);
            this.mPositionX += Editor.this.mTextView.viewportToContentHorizontalOffset();
            this.mPositionY = this.getVerticalLocalPosition(Editor.this.mTextView.getLayout().getLineForOffset(n2));
            this.mPositionY += Editor.this.mTextView.viewportToContentVerticalOffset();
        }

        private void updatePosition(int n, int n2) {
            int n3 = n + this.mPositionX;
            int n4 = this.clipVertically(n2 + this.mPositionY);
            DisplayMetrics displayMetrics = Editor.this.mTextView.getResources().getDisplayMetrics();
            int n5 = this.mContentView.getMeasuredWidth();
            int n6 = Math.max(0, Math.min(displayMetrics.widthPixels - n5, n3));
            if (this.isShowing()) {
                this.mPopupWindow.update(n6, n4, -1, -1);
                return;
            }
            this.mPopupWindow.showAtLocation(Editor.this.mTextView, 0, n6, n4);
        }

        protected abstract int clipVertically(int var1);

        protected abstract void createPopupWindow();

        protected abstract int getTextOffset();

        protected abstract int getVerticalLocalPosition(int var1);

        public void hide() {
            this.mPopupWindow.dismiss();
            Editor.this.getPositionListener().removeSubscriber(this);
        }

        protected abstract void initContentView();

        public boolean isShowing() {
            return this.mPopupWindow.isShowing();
        }

        protected void measureContent() {
            DisplayMetrics displayMetrics = Editor.this.mTextView.getResources().getDisplayMetrics();
            this.mContentView.measure(View.MeasureSpec.makeMeasureSpec(displayMetrics.widthPixels, Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec(displayMetrics.heightPixels, Integer.MIN_VALUE));
        }

        public void show() {
            Editor.this.getPositionListener().addSubscriber(this, false);
            this.computeLocalPosition();
            PositionListener positionListener = Editor.this.getPositionListener();
            this.updatePosition(positionListener.getPositionX(), positionListener.getPositionY());
        }

        @Override
        public void updatePosition(int n, int n2, boolean bl, boolean bl2) {
            if (this.isShowing() && Editor.this.isOffsetVisible(this.getTextOffset())) {
                if (bl2) {
                    this.computeLocalPosition();
                }
                this.updatePosition(n, n2);
                return;
            }
            this.hide();
        }
    }

    private class PositionListener
    implements ViewTreeObserver.OnPreDrawListener {
        private final int MAXIMUM_NUMBER_OF_LISTENERS;
        private boolean[] mCanMove;
        private int mNumberOfListeners;
        private boolean mPositionHasChanged = true;
        private TextViewPositionListener[] mPositionListeners = new TextViewPositionListener[7];
        private int mPositionX;
        private int mPositionY;
        private boolean mScrollHasChanged;
        final int[] mTempCoords;

        private PositionListener() {
            this.MAXIMUM_NUMBER_OF_LISTENERS = 7;
            this.mCanMove = new boolean[7];
            this.mTempCoords = new int[2];
        }

        /*
         * Enabled aggressive block sorting
         */
        private void updatePosition() {
            Editor.this.mTextView.getLocationInWindow(this.mTempCoords);
            boolean bl = this.mTempCoords[0] != this.mPositionX || this.mTempCoords[1] != this.mPositionY;
            this.mPositionHasChanged = bl;
            this.mPositionX = this.mTempCoords[0];
            this.mPositionY = this.mTempCoords[1];
        }

        public void addSubscriber(TextViewPositionListener textViewPositionListener, boolean bl) {
            if (this.mNumberOfListeners == 0) {
                this.updatePosition();
                Editor.this.mTextView.getViewTreeObserver().addOnPreDrawListener(this);
            }
            int n = -1;
            for (int i = 0; i < 7; ++i) {
                TextViewPositionListener textViewPositionListener2 = this.mPositionListeners[i];
                if (textViewPositionListener2 == textViewPositionListener) {
                    return;
                }
                if (n >= 0 || textViewPositionListener2 != null) continue;
                n = i;
            }
            this.mPositionListeners[n] = textViewPositionListener;
            this.mCanMove[n] = bl;
            this.mNumberOfListeners = 1 + this.mNumberOfListeners;
        }

        public int getPositionX() {
            return this.mPositionX;
        }

        public int getPositionY() {
            return this.mPositionY;
        }

        @Override
        public boolean onPreDraw() {
            this.updatePosition();
            for (int i = 0; i < 7; ++i) {
                TextViewPositionListener textViewPositionListener;
                if (!this.mPositionHasChanged && !this.mScrollHasChanged && !this.mCanMove[i] || (textViewPositionListener = this.mPositionListeners[i]) == null) continue;
                textViewPositionListener.updatePosition(this.mPositionX, this.mPositionY, this.mPositionHasChanged, this.mScrollHasChanged);
            }
            this.mScrollHasChanged = false;
            return true;
        }

        public void onScrollChanged() {
            this.mScrollHasChanged = true;
        }

        public void removeSubscriber(TextViewPositionListener textViewPositionListener) {
            int n = 0;
            while (true) {
                block6: {
                    block5: {
                        if (n >= 7) break block5;
                        if (this.mPositionListeners[n] != textViewPositionListener) break block6;
                        this.mPositionListeners[n] = null;
                        this.mNumberOfListeners = -1 + this.mNumberOfListeners;
                    }
                    if (this.mNumberOfListeners == 0) {
                        Editor.this.mTextView.getViewTreeObserver().removeOnPreDrawListener(this);
                    }
                    return;
                }
                ++n;
            }
        }
    }

    private class SelectionActionModeCallback
    implements ActionMode.Callback {
        private SelectionActionModeCallback() {
        }

        @Override
        public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
            if (Editor.this.mCustomSelectionActionModeCallback != null && Editor.this.mCustomSelectionActionModeCallback.onActionItemClicked(actionMode, menuItem)) {
                return true;
            }
            return Editor.this.mTextView.onTextContextMenuItem(menuItem.getItemId());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onCreateActionMode(ActionMode actionMode, Menu menu2) {
            boolean bl = ((Editor)Editor.this).mTextView.getContext().getApplicationInfo().targetSdkVersion < 21;
            Context context = !bl && menu2 instanceof MenuBuilder ? ((MenuBuilder)menu2).getContext() : Editor.this.mTextView.getContext();
            TypedArray typedArray = context.obtainStyledAttributes(R.styleable.SelectionModeDrawables);
            TypedArray typedArray2 = Editor.this.mTextView.getContext().obtainStyledAttributes(R.styleable.Theme);
            actionMode.setTitle(Editor.this.mTextView.getContext().getString(17040471));
            actionMode.setSubtitle(null);
            actionMode.setTitleOptionalHint(true);
            int n = 0 + 1;
            menu2.add(0, 16908319, 0, 17039373).setIcon(typedArray.getResourceId(3, 0)).setAlphabeticShortcut('a').setShowAsAction(6);
            if (Editor.this.mTextView.canCut()) {
                ++n;
                menu2.add(0, 0x1020020, 0, 17039363).setIcon(typedArray.getResourceId(0, 0)).setAlphabeticShortcut('x').setShowAsAction(6);
            }
            if (Editor.this.mTextView.canCopy()) {
                ++n;
                menu2.add(0, 0x1020021, 0, 0x1040001).setIcon(typedArray.getResourceId(1, 0)).setAlphabeticShortcut('c').setShowAsAction(6);
            }
            if (Editor.this.mTextView.canPaste()) {
                ++n;
                menu2.add(0, 0x1020022, 0, 17039371).setIcon(typedArray.getResourceId(2, 0)).setAlphabeticShortcut('v').setShowAsAction(6);
            }
            if (Editor.this.mTextView.canTranslate()) {
                if (++n > Editor.this.MAX_ITEM && (0xF & ((Editor)Editor.this).mTextView.getResources().getConfiguration().screenLayout) != 4) {
                    Editor.this.mTextView;
                    menu2.addSubMenu(0, 17041119, 0, 17041119).setIcon(typedArray2.getResourceId(341, 0));
                } else {
                    Editor.this.mTextView;
                    menu2.add(0, 17041119, 0, 17041119).setIcon(typedArray2.getResourceId(341, 0)).setAlphabeticShortcut('d').setShowAsAction(6);
                }
            }
            if (Editor.this.mTextView.canSearch()) {
                if (++n > Editor.this.MAX_ITEM && (0xF & ((Editor)Editor.this).mTextView.getResources().getConfiguration().screenLayout) != 4) {
                    menu2.addSubMenu(0, 17041118, 0, 17039372).setIcon(typedArray2.getResourceId(273, 0));
                } else {
                    menu2.add(0, 17041118, 0, 17039372).setIcon(typedArray2.getResourceId(273, 0)).setAlphabeticShortcut('s').setShowAsAction(6);
                }
            }
            if (Editor.this.mTextView.canShare()) {
                if (n > Editor.this.MAX_ITEM && (0xF & ((Editor)Editor.this).mTextView.getResources().getConfiguration().screenLayout) != 4) {
                    menu2.addSubMenu(0, 17041117, 0, 17040732).setIcon(typedArray2.getResourceId(271, 0));
                } else {
                    menu2.add(0, 17041117, 0, 17040732).setIcon(typedArray2.getResourceId(271, 0)).setAlphabeticShortcut('t').setShowAsAction(6);
                }
            }
            typedArray2.recycle();
            typedArray.recycle();
            if (Editor.this.mCustomSelectionActionModeCallback != null && !Editor.this.mCustomSelectionActionModeCallback.onCreateActionMode(actionMode, menu2)) {
                return false;
            }
            if (!menu2.hasVisibleItems() && actionMode.getCustomView() == null) {
                return false;
            }
            Editor.this.getSelectionController().show();
            Editor.this.mTextView.setHasTransientState(true);
            return true;
        }

        @Override
        public void onDestroyActionMode(ActionMode actionMode) {
            if (Editor.this.mCustomSelectionActionModeCallback != null) {
                Editor.this.mCustomSelectionActionModeCallback.onDestroyActionMode(actionMode);
            }
            if (!Editor.this.mPreserveDetachedSelection) {
                Selection.setSelection((Spannable)Editor.this.mTextView.getText(), Editor.this.mTextView.getSelectionEnd());
                Editor.this.mTextView.setHasTransientState(false);
            }
            if (Editor.this.mSelectionModifierCursorController != null) {
                Editor.this.mSelectionModifierCursorController.hide();
            }
            Editor.access$2902(Editor.this, false);
            Editor.access$2802(Editor.this, true);
            Editor.this.mSelectionActionMode = null;
        }

        @Override
        public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
            if (Editor.this.mCustomSelectionActionModeCallback != null) {
                return Editor.this.mCustomSelectionActionModeCallback.onPrepareActionMode(actionMode, menu2);
            }
            if (!Editor.this.mIsFirstCall) {
                Editor.access$2902(Editor.this, true);
            }
            Editor.access$2802(Editor.this, false);
            return true;
        }
    }

    private class SelectionEndHandleView
    extends HandleView {
        public SelectionEndHandleView(Drawable drawable2, Drawable drawable3) {
            super(drawable2, drawable3);
        }

        @Override
        public int getCurrentCursorOffset() {
            return Editor.this.mTextView.getSelectionEnd();
        }

        @Override
        protected int getHorizontalGravity(boolean bl) {
            if (bl) {
                return 3;
            }
            return 5;
        }

        @Override
        protected int getHotspotX(Drawable drawable2, boolean bl) {
            if (bl) {
                return 3 * drawable2.getIntrinsicWidth() / 4;
            }
            return drawable2.getIntrinsicWidth() / 4;
        }

        public void setActionPopupWindow(ActionPopupWindow actionPopupWindow) {
            this.mActionPopupWindow = actionPopupWindow;
        }

        @Override
        public void updatePosition(float f, float f2) {
            int n;
            int n2 = Editor.this.calculateTheFakeOffset(f, f2);
            if (n2 <= (n = Editor.this.mTextView.getSelectionStart())) {
                n2 = Math.min(n + 1, Editor.this.mTextView.getText().length());
            }
            this.positionAtCursorOffset(n2, false);
        }

        @Override
        public void updateSelection(int n) {
            Selection.setSelection((Spannable)Editor.this.mTextView.getText(), Editor.this.mTextView.getSelectionStart(), n);
            this.updateDrawable();
        }
    }

    class SelectionModifierCursorController
    implements CursorController {
        private static final int DELAY_BEFORE_REPLACE_ACTION = 200;
        private float mDownPositionX;
        private float mDownPositionY;
        private SelectionEndHandleView mEndHandle;
        private boolean mGestureStayedInTapRegion;
        private int mMaxTouchOffset;
        private int mMinTouchOffset;
        private long mPreviousTapUpTime = 0L;
        private SelectionStartHandleView mStartHandle;

        SelectionModifierCursorController() {
            this.resetTouchOffsets();
        }

        private void initDrawables() {
            if (Editor.this.mSelectHandleLeft == null) {
                Editor.access$4302(Editor.this, Editor.this.mTextView.getContext().getDrawable(((Editor)Editor.this).mTextView.mTextSelectHandleLeftRes));
            }
            if (Editor.this.mSelectHandleRight == null) {
                Editor.access$4402(Editor.this, Editor.this.mTextView.getContext().getDrawable(((Editor)Editor.this).mTextView.mTextSelectHandleRightRes));
            }
        }

        private void initHandles() {
            if (this.mStartHandle == null) {
                this.mStartHandle = new SelectionStartHandleView(Editor.this.mSelectHandleLeft, Editor.this.mSelectHandleRight);
            }
            if (this.mEndHandle == null) {
                this.mEndHandle = new SelectionEndHandleView(Editor.this.mSelectHandleRight, Editor.this.mSelectHandleLeft);
            }
            this.mStartHandle.show();
            this.mEndHandle.show();
            this.mStartHandle.showActionPopupWindow(200);
            this.mEndHandle.setActionPopupWindow(this.mStartHandle.getActionPopupWindow());
            Editor.this.hideInsertionPointCursorController();
        }

        private void updateMinAndMaxOffsets(MotionEvent motionEvent) {
            int n = motionEvent.getPointerCount();
            for (int i = 0; i < n; ++i) {
                int n2 = Editor.this.calculateTheFakeOffset(motionEvent.getX(i), motionEvent.getY(i));
                if (n2 < this.mMinTouchOffset) {
                    this.mMinTouchOffset = n2;
                }
                if (n2 <= this.mMaxTouchOffset) continue;
                this.mMaxTouchOffset = n2;
            }
        }

        public int getMaxTouchOffset() {
            return this.mMaxTouchOffset;
        }

        public int getMinTouchOffset() {
            return this.mMinTouchOffset;
        }

        @Override
        public HandleView getStartHandle() {
            return this.mStartHandle;
        }

        @Override
        public void hide() {
            if (this.mStartHandle != null) {
                this.mStartHandle.hide();
            }
            if (this.mEndHandle != null) {
                this.mEndHandle.hide();
            }
        }

        public boolean isSelectionStartDragged() {
            return this.mStartHandle != null && this.mStartHandle.isDragging();
        }

        @Override
        public void onDetached() {
            Editor.this.mTextView.getViewTreeObserver().removeOnTouchModeChangeListener(this);
            if (this.mStartHandle != null) {
                this.mStartHandle.onDetached();
            }
            if (this.mEndHandle != null) {
                this.mEndHandle.onDetached();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        public void onTouchEvent(MotionEvent motionEvent) {
            switch (motionEvent.getActionMasked()) {
                default: {
                    return;
                }
                case 0: {
                    int n;
                    float f;
                    float f2;
                    float f3;
                    boolean bl;
                    int n2;
                    float f4 = motionEvent.getX();
                    float f5 = motionEvent.getY();
                    this.mMaxTouchOffset = n2 = Editor.this.calculateTheFakeOffset(f4, f5);
                    this.mMinTouchOffset = n2;
                    if (this.mGestureStayedInTapRegion && SystemClock.uptimeMillis() - this.mPreviousTapUpTime <= (long)ViewConfiguration.getDoubleTapTimeout() && (bl = (f3 = (f2 = f4 - this.mDownPositionX) * f2 + (f = f5 - this.mDownPositionY) * f) < (float)((n = ViewConfiguration.get(Editor.this.mTextView.getContext()).getScaledDoubleTapSlop()) * n)) && Editor.this.isPositionOnText(f4, f5)) {
                        Editor.this.startSelectionActionMode();
                        Editor.this.mDiscardNextActionUp = true;
                    }
                    this.mDownPositionX = f4;
                    this.mDownPositionY = f5;
                    this.mGestureStayedInTapRegion = true;
                    return;
                }
                case 5: 
                case 6: {
                    if (!Editor.this.mTextView.getContext().getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch.distinct")) return;
                    this.updateMinAndMaxOffsets(motionEvent);
                    return;
                }
                case 2: {
                    int n;
                    float f;
                    if (!this.mGestureStayedInTapRegion) return;
                    float f6 = motionEvent.getX() - this.mDownPositionX;
                    float f7 = f6 * f6 + (f = motionEvent.getY() - this.mDownPositionY) * f;
                    if (!(f7 > (float)((n = ViewConfiguration.get(Editor.this.mTextView.getContext()).getScaledDoubleTapTouchSlop()) * n))) return;
                    this.mGestureStayedInTapRegion = false;
                    return;
                }
                case 1: 
            }
            this.mPreviousTapUpTime = SystemClock.uptimeMillis();
        }

        @Override
        public void onTouchModeChanged(boolean bl) {
            if (!bl) {
                this.hide();
            }
        }

        public void resetTouchOffsets() {
            this.mMaxTouchOffset = -1;
            this.mMinTouchOffset = -1;
        }

        @Override
        public void show() {
            if (Editor.this.mTextView.isInBatchEditMode()) {
                return;
            }
            this.initDrawables();
            this.initHandles();
            Editor.this.hideInsertionPointCursorController();
        }
    }

    private class SelectionStartHandleView
    extends HandleView {
        public SelectionStartHandleView(Drawable drawable2, Drawable drawable3) {
            super(drawable2, drawable3);
        }

        public ActionPopupWindow getActionPopupWindow() {
            return this.mActionPopupWindow;
        }

        @Override
        public int getCurrentCursorOffset() {
            return Editor.this.mTextView.getSelectionStart();
        }

        @Override
        protected int getHorizontalGravity(boolean bl) {
            if (bl) {
                return 5;
            }
            return 3;
        }

        @Override
        protected int getHotspotX(Drawable drawable2, boolean bl) {
            if (bl) {
                return drawable2.getIntrinsicWidth() / 4;
            }
            return 3 * drawable2.getIntrinsicWidth() / 4;
        }

        @Override
        public void updatePosition(float f, float f2) {
            int n;
            int n2 = Editor.this.calculateTheFakeOffset(f, f2);
            if (n2 >= (n = Editor.this.mTextView.getSelectionEnd())) {
                n2 = Math.max(0, n - 1);
            }
            this.positionAtCursorOffset(n2, false);
        }

        @Override
        public void updateSelection(int n) {
            Selection.setSelection((Spannable)Editor.this.mTextView.getText(), n, Editor.this.mTextView.getSelectionEnd());
            this.updateDrawable();
        }
    }

    class SpanController
    implements SpanWatcher {
        private static final int DISPLAY_TIMEOUT_MS = 3000;
        private Runnable mHidePopup;
        private EasyEditPopupWindow mPopupWindow;

        SpanController() {
        }

        private boolean isNonIntermediateSelectionSpan(Spannable spannable, Object object) {
            return (Selection.SELECTION_START == object || Selection.SELECTION_END == object) && (0x200 & spannable.getSpanFlags(object)) == 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void sendEasySpanNotification(int n, EasyEditSpan easyEditSpan) {
            PendingIntent pendingIntent;
            try {
                pendingIntent = easyEditSpan.getPendingIntent();
                if (pendingIntent == null) return;
            }
            catch (PendingIntent.CanceledException canceledException) {
                Log.w(Editor.TAG, "PendingIntent for notification cannot be sent", canceledException);
                return;
            }
            Intent intent = new Intent();
            intent.putExtra("android.text.style.EXTRA_TEXT_CHANGED_TYPE", n);
            pendingIntent.send(Editor.this.mTextView.getContext(), 0, intent);
        }

        public void hide() {
            if (this.mPopupWindow != null) {
                this.mPopupWindow.hide();
                Editor.this.mTextView.removeCallbacks(this.mHidePopup);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onSpanAdded(Spannable spannable, Object object, int n, int n2) {
            if (this.isNonIntermediateSelectionSpan(spannable, object)) {
                Editor.this.sendUpdateSelection();
                return;
            } else {
                if (!(object instanceof EasyEditSpan)) return;
                if (this.mPopupWindow == null) {
                    this.mPopupWindow = new EasyEditPopupWindow();
                    this.mHidePopup = new Runnable(){

                        @Override
                        public void run() {
                            SpanController.this.hide();
                        }
                    };
                }
                if (this.mPopupWindow.mEasyEditSpan != null) {
                    this.mPopupWindow.mEasyEditSpan.setDeleteEnabled(false);
                }
                this.mPopupWindow.setEasyEditSpan((EasyEditSpan)object);
                this.mPopupWindow.setOnDeleteListener(new EasyEditDeleteListener(){

                    @Override
                    public void onDeleteClick(EasyEditSpan easyEditSpan) {
                        Editable editable = (Editable)Editor.this.mTextView.getText();
                        int n = editable.getSpanStart(easyEditSpan);
                        int n2 = editable.getSpanEnd(easyEditSpan);
                        if (n >= 0 && n2 >= 0) {
                            SpanController.this.sendEasySpanNotification(1, easyEditSpan);
                            Editor.this.mTextView.deleteText_internal(n, n2);
                        }
                        editable.removeSpan(easyEditSpan);
                    }
                });
                if (Editor.this.mTextView.getWindowVisibility() != 0 || Editor.this.mTextView.getLayout() == null || Editor.this.extractedTextModeWillBeStarted()) return;
                this.mPopupWindow.show();
                Editor.this.mTextView.removeCallbacks(this.mHidePopup);
                Editor.this.mTextView.postDelayed(this.mHidePopup, 3000L);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onSpanChanged(Spannable spannable, Object object, int n, int n2, int n3, int n4) {
            if (this.isNonIntermediateSelectionSpan(spannable, object)) {
                Editor.this.sendUpdateSelection();
                return;
            } else {
                if (this.mPopupWindow == null || !(object instanceof EasyEditSpan)) return;
                EasyEditSpan easyEditSpan = (EasyEditSpan)object;
                this.sendEasySpanNotification(2, easyEditSpan);
                spannable.removeSpan(easyEditSpan);
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onSpanRemoved(Spannable spannable, Object object, int n, int n2) {
            if (this.isNonIntermediateSelectionSpan(spannable, object)) {
                Editor.this.sendUpdateSelection();
                return;
            } else {
                if (this.mPopupWindow == null || object != this.mPopupWindow.mEasyEditSpan) return;
                this.hide();
                return;
            }
        }
    }

    private class SuggestionsPopupWindow
    extends PinnedPopupWindow
    implements AdapterView.OnItemClickListener {
        private static final int ADD_TO_DICTIONARY = -1;
        private static final int DELETE_TEXT = -2;
        private static final int MAX_NUMBER_SUGGESTIONS = 5;
        private boolean mCursorWasVisibleBeforeSuggestions;
        private boolean mIsShowingUp = false;
        private int mNumberOfSuggestions;
        private final HashMap<SuggestionSpan, Integer> mSpansLengths;
        private SuggestionInfo[] mSuggestionInfos;
        private final Comparator<SuggestionSpan> mSuggestionSpanComparator;
        private SuggestionAdapter mSuggestionsAdapter;

        public SuggestionsPopupWindow() {
            this.mCursorWasVisibleBeforeSuggestions = Editor.this.mCursorVisible;
            this.mSuggestionSpanComparator = new SuggestionSpanComparator();
            this.mSpansLengths = new HashMap();
        }

        private SuggestionSpan[] getSuggestionSpans() {
            int n = Editor.this.mTextView.getSelectionStart();
            Spannable spannable = (Spannable)Editor.this.mTextView.getText();
            SuggestionSpan[] suggestionSpanArray = spannable.getSpans(n, n, SuggestionSpan.class);
            this.mSpansLengths.clear();
            int n2 = suggestionSpanArray.length;
            for (int i = 0; i < n2; ++i) {
                SuggestionSpan suggestionSpan = suggestionSpanArray[i];
                int n3 = spannable.getSpanStart(suggestionSpan);
                int n4 = spannable.getSpanEnd(suggestionSpan);
                this.mSpansLengths.put(suggestionSpan, n4 - n3);
            }
            Arrays.sort(suggestionSpanArray, this.mSuggestionSpanComparator);
            return suggestionSpanArray;
        }

        private void highlightTextDifferences(SuggestionInfo suggestionInfo, int n, int n2) {
            Spannable spannable = (Spannable)Editor.this.mTextView.getText();
            int n3 = spannable.getSpanStart(suggestionInfo.suggestionSpan);
            int n4 = spannable.getSpanEnd(suggestionInfo.suggestionSpan);
            suggestionInfo.suggestionStart = n3 - n;
            suggestionInfo.suggestionEnd = suggestionInfo.suggestionStart + suggestionInfo.text.length();
            suggestionInfo.text.setSpan(suggestionInfo.highlightSpan, 0, suggestionInfo.text.length(), 33);
            String string2 = spannable.toString();
            suggestionInfo.text.insert(0, string2.substring(n, n3));
            suggestionInfo.text.append(string2.substring(n4, n2));
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean updateSuggestions() {
            Spannable spannable = (Spannable)Editor.this.mTextView.getText();
            SuggestionSpan[] suggestionSpanArray = this.getSuggestionSpans();
            int n = suggestionSpanArray.length;
            if (n == 0) {
                return false;
            }
            this.mNumberOfSuggestions = 0;
            int n2 = Editor.this.mTextView.getText().length();
            int n3 = 0;
            SuggestionSpan suggestionSpan = null;
            int n4 = 0;
            int n5 = 0;
            while (true) {
                int n6;
                String[] stringArray;
                int n7;
                int n8;
                SuggestionSpan suggestionSpan2;
                if (n5 < n) {
                    suggestionSpan2 = suggestionSpanArray[n5];
                    n8 = spannable.getSpanStart(suggestionSpan2);
                    n7 = spannable.getSpanEnd(suggestionSpan2);
                    n2 = Math.min(n8, n2);
                    n3 = Math.max(n7, n3);
                    if ((2 & suggestionSpan2.getFlags()) != 0) {
                        suggestionSpan = suggestionSpan2;
                    }
                    if (n5 == 0) {
                        n4 = suggestionSpan2.getUnderlineColor();
                    }
                    stringArray = suggestionSpan2.getSuggestions();
                    n6 = stringArray.length;
                } else {
                    for (int i = 0; i < this.mNumberOfSuggestions; ++i) {
                        this.highlightTextDifferences(this.mSuggestionInfos[i], n2, n3);
                    }
                    if (suggestionSpan != null) {
                        int n9 = spannable.getSpanStart(suggestionSpan);
                        int n10 = spannable.getSpanEnd(suggestionSpan);
                        if (n9 >= 0 && n10 > n9) {
                            SuggestionInfo suggestionInfo = this.mSuggestionInfos[this.mNumberOfSuggestions];
                            suggestionInfo.suggestionSpan = suggestionSpan;
                            suggestionInfo.suggestionIndex = -1;
                            suggestionInfo.text.replace(0, suggestionInfo.text.length(), Editor.this.mTextView.getContext().getString(17040472));
                            suggestionInfo.text.setSpan(suggestionInfo.highlightSpan, 0, 0, 33);
                            this.mNumberOfSuggestions = 1 + this.mNumberOfSuggestions;
                        }
                    }
                    SuggestionInfo suggestionInfo = this.mSuggestionInfos[this.mNumberOfSuggestions];
                    suggestionInfo.suggestionSpan = null;
                    suggestionInfo.suggestionIndex = -2;
                    suggestionInfo.text.replace(0, suggestionInfo.text.length(), Editor.this.mTextView.getContext().getString(17040473));
                    suggestionInfo.text.setSpan(suggestionInfo.highlightSpan, 0, 0, 33);
                    this.mNumberOfSuggestions = 1 + this.mNumberOfSuggestions;
                    if (Editor.this.mSuggestionRangeSpan == null) {
                        Editor.this.mSuggestionRangeSpan = new SuggestionRangeSpan();
                    }
                    if (n4 == 0) {
                        Editor.this.mSuggestionRangeSpan.setBackgroundColor(((Editor)Editor.this).mTextView.mHighlightColor);
                    } else {
                        int n11 = (int)(0.4f * (float)Color.alpha(n4));
                        Editor.this.mSuggestionRangeSpan.setBackgroundColor((0xFFFFFF & n4) + (n11 << 24));
                    }
                    spannable.setSpan(Editor.this.mSuggestionRangeSpan, n2, n3, 33);
                    this.mSuggestionsAdapter.notifyDataSetChanged();
                    return true;
                }
                block2: for (int i = 0; i < n6; ++i) {
                    String string2 = stringArray[i];
                    int n12 = 0;
                    while (true) {
                        block18: {
                            boolean bl;
                            block17: {
                                int n13 = this.mNumberOfSuggestions;
                                bl = false;
                                if (n12 >= n13) break block17;
                                if (!this.mSuggestionInfos[n12].text.toString().equals(string2)) break block18;
                                SuggestionSpan suggestionSpan3 = this.mSuggestionInfos[n12].suggestionSpan;
                                int n14 = spannable.getSpanStart(suggestionSpan3);
                                int n15 = spannable.getSpanEnd(suggestionSpan3);
                                if (n8 != n14 || n7 != n15) break block18;
                                bl = true;
                            }
                            if (bl) continue block2;
                            SuggestionInfo suggestionInfo = this.mSuggestionInfos[this.mNumberOfSuggestions];
                            suggestionInfo.suggestionSpan = suggestionSpan2;
                            suggestionInfo.suggestionIndex = i;
                            suggestionInfo.text.replace(0, suggestionInfo.text.length(), string2);
                            this.mNumberOfSuggestions = 1 + this.mNumberOfSuggestions;
                            if (this.mNumberOfSuggestions != 5) continue block2;
                            n5 = n;
                            break block2;
                        }
                        ++n12;
                    }
                }
                ++n5;
            }
        }

        @Override
        protected int clipVertically(int n) {
            int n2 = this.mContentView.getMeasuredHeight();
            return Math.min(n, ((Editor)Editor.this).mTextView.getResources().getDisplayMetrics().heightPixels - n2);
        }

        @Override
        protected void createPopupWindow() {
            this.mPopupWindow = new CustomPopupWindow(Editor.this.mTextView.getContext(), 16843635);
            this.mPopupWindow.setInputMethodMode(2);
            this.mPopupWindow.setFocusable(true);
            this.mPopupWindow.setClippingEnabled(false);
        }

        @Override
        protected int getTextOffset() {
            return Editor.this.mTextView.getSelectionStart();
        }

        @Override
        protected int getVerticalLocalPosition(int n) {
            return Editor.this.mTextView.getLayout().getLineBottom(n);
        }

        @Override
        public void hide() {
            super.hide();
        }

        @Override
        protected void initContentView() {
            ListView listView = new ListView(Editor.this.mTextView.getContext());
            this.mSuggestionsAdapter = new SuggestionAdapter();
            listView.setAdapter(this.mSuggestionsAdapter);
            listView.setOnItemClickListener(this);
            this.mContentView = listView;
            this.mSuggestionInfos = new SuggestionInfo[7];
            for (int i = 0; i < this.mSuggestionInfos.length; ++i) {
                this.mSuggestionInfos[i] = new SuggestionInfo();
            }
        }

        public boolean isShowingUp() {
            return this.mIsShowingUp;
        }

        @Override
        protected void measureContent() {
            DisplayMetrics displayMetrics = Editor.this.mTextView.getResources().getDisplayMetrics();
            int n = View.MeasureSpec.makeMeasureSpec(displayMetrics.widthPixels, Integer.MIN_VALUE);
            int n2 = View.MeasureSpec.makeMeasureSpec(displayMetrics.heightPixels, Integer.MIN_VALUE);
            int n3 = 0;
            View view = null;
            for (int i = 0; i < this.mNumberOfSuggestions; ++i) {
                view = this.mSuggestionsAdapter.getView(i, view, this.mContentView);
                view.getLayoutParams().width = -2;
                view.measure(n, n2);
                n3 = Math.max(n3, view.getMeasuredWidth());
            }
            this.mContentView.measure(View.MeasureSpec.makeMeasureSpec(n3, 0x40000000), n2);
            Drawable drawable2 = this.mPopupWindow.getBackground();
            if (drawable2 != null) {
                if (Editor.this.mTempRect == null) {
                    Editor.access$2502(Editor.this, new Rect());
                }
                drawable2.getPadding(Editor.this.mTempRect);
                n3 += ((Editor)Editor.this).mTempRect.left + ((Editor)Editor.this).mTempRect.right;
            }
            this.mPopupWindow.setWidth(n3);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
            Editable editable = (Editable)Editor.this.mTextView.getText();
            SuggestionInfo suggestionInfo = this.mSuggestionInfos[n];
            if (suggestionInfo.suggestionIndex == -2) {
                int n2 = editable.getSpanStart(Editor.this.mSuggestionRangeSpan);
                int n3 = editable.getSpanEnd(Editor.this.mSuggestionRangeSpan);
                if (n2 >= 0 && n3 > n2) {
                    if (n3 < editable.length() && Character.isSpaceChar(editable.charAt(n3)) && (n2 == 0 || Character.isSpaceChar(editable.charAt(n2 - 1)))) {
                        ++n3;
                    }
                    Editor.this.mTextView.deleteText_internal(n2, n3);
                }
                this.hide();
                return;
            }
            int n4 = editable.getSpanStart(suggestionInfo.suggestionSpan);
            int n5 = editable.getSpanEnd(suggestionInfo.suggestionSpan);
            if (n4 < 0 || n5 <= n4) {
                this.hide();
                return;
            }
            String string2 = editable.toString().substring(n4, n5);
            if (suggestionInfo.suggestionIndex == -1) {
                Intent intent = new Intent("com.android.settings.USER_DICTIONARY_INSERT");
                intent.putExtra("word", string2);
                intent.putExtra("locale", Editor.this.mTextView.getTextServicesLocale().toString());
                intent.setFlags(0x10000000 | intent.getFlags());
                Editor.this.mTextView.getContext().startActivity(intent);
                editable.removeSpan(suggestionInfo.suggestionSpan);
                Selection.setSelection(editable, n5);
                Editor.this.updateSpellCheckSpans(n4, n5, false);
            } else {
                SuggestionSpan[] suggestionSpanArray = editable.getSpans(n4, n5, SuggestionSpan.class);
                int n6 = suggestionSpanArray.length;
                int[] nArray = new int[n6];
                int[] nArray2 = new int[n6];
                int[] nArray3 = new int[n6];
                for (int i = 0; i < n6; ++i) {
                    SuggestionSpan suggestionSpan = suggestionSpanArray[i];
                    nArray[i] = editable.getSpanStart(suggestionSpan);
                    nArray2[i] = editable.getSpanEnd(suggestionSpan);
                    nArray3[i] = editable.getSpanFlags(suggestionSpan);
                    int n7 = suggestionSpan.getFlags();
                    if ((n7 & 2) <= 0) continue;
                    suggestionSpan.setFlags(0xFFFFFFFE & (n7 & 0xFFFFFFFD));
                }
                int n8 = suggestionInfo.suggestionStart;
                int n9 = suggestionInfo.suggestionEnd;
                String string3 = suggestionInfo.text.subSequence(n8, n9).toString();
                Editor.this.mTextView.replaceText_internal(n4, n5, string3);
                suggestionInfo.suggestionSpan.notifySelection(Editor.this.mTextView.getContext(), string2, suggestionInfo.suggestionIndex);
                suggestionInfo.suggestionSpan.getSuggestions()[suggestionInfo.suggestionIndex] = string2;
                int n10 = string3.length() - (n5 - n4);
                for (int i = 0; i < n6; ++i) {
                    if (nArray[i] > n4 || nArray2[i] < n5) continue;
                    Editor.this.mTextView.setSpan_internal(suggestionSpanArray[i], nArray[i], Math.min(n10 + nArray2[i], editable.length()), nArray3[i]);
                }
                int n11 = Math.min(n5 + n10, editable.length());
                Editor.this.mTextView.setCursorPosition_internal(n11, n11);
            }
            this.hide();
        }

        public void onParentLostFocus() {
            this.mIsShowingUp = false;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void show() {
            if (!(Editor.this.mTextView.getText() instanceof Editable) || !this.updateSuggestions()) {
                return;
            }
            this.mCursorWasVisibleBeforeSuggestions = Editor.this.mCursorVisible;
            Editor.this.mTextView.setCursorVisible(false);
            this.mIsShowingUp = true;
            super.show();
        }

        private class CustomPopupWindow
        extends PopupWindow {
            public CustomPopupWindow(Context context, int n) {
                super(context, null, n);
            }

            @Override
            public void dismiss() {
                super.dismiss();
                Editor.this.getPositionListener().removeSubscriber(SuggestionsPopupWindow.this);
                ((Spannable)Editor.this.mTextView.getText()).removeSpan(Editor.this.mSuggestionRangeSpan);
                Editor.this.mTextView.setCursorVisible(SuggestionsPopupWindow.this.mCursorWasVisibleBeforeSuggestions);
                if (Editor.this.hasInsertionController()) {
                    Editor.this.getInsertionController().show();
                }
            }
        }

        private class SuggestionAdapter
        extends BaseAdapter {
            private LayoutInflater mInflater;

            private SuggestionAdapter() {
                this.mInflater = (LayoutInflater)Editor.this.mTextView.getContext().getSystemService("layout_inflater");
            }

            @Override
            public int getCount() {
                return SuggestionsPopupWindow.this.mNumberOfSuggestions;
            }

            @Override
            public Object getItem(int n) {
                return SuggestionsPopupWindow.this.mSuggestionInfos[n];
            }

            @Override
            public long getItemId(int n) {
                return n;
            }

            @Override
            public View getView(int n, View view, ViewGroup viewGroup) {
                TextView textView = (TextView)view;
                if (textView == null) {
                    textView = (TextView)this.mInflater.inflate(((Editor)Editor.this).mTextView.mTextEditSuggestionItemLayout, viewGroup, false);
                }
                SuggestionInfo suggestionInfo = SuggestionsPopupWindow.this.mSuggestionInfos[n];
                textView.setText(suggestionInfo.text);
                if (suggestionInfo.suggestionIndex == -1 || suggestionInfo.suggestionIndex == -2) {
                    textView.setBackgroundColor(0);
                    return textView;
                }
                textView.setBackgroundColor(-1);
                return textView;
            }
        }

        private class SuggestionInfo {
            TextAppearanceSpan highlightSpan;
            int suggestionEnd;
            int suggestionIndex;
            SuggestionSpan suggestionSpan;
            int suggestionStart;
            SpannableStringBuilder text = new SpannableStringBuilder();

            private SuggestionInfo() {
                this.highlightSpan = new TextAppearanceSpan(Editor.this.mTextView.getContext(), 16974104);
            }
        }

        private class SuggestionSpanComparator
        implements Comparator<SuggestionSpan> {
            private SuggestionSpanComparator() {
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public int compare(SuggestionSpan suggestionSpan, SuggestionSpan suggestionSpan2) {
                block6: {
                    boolean bl;
                    block8: {
                        block7: {
                            int n;
                            int n2 = suggestionSpan.getFlags();
                            if (n2 == (n = suggestionSpan2.getFlags())) break block6;
                            boolean bl2 = (n2 & 1) != 0;
                            boolean bl3 = (n & 1) != 0;
                            boolean bl4 = (n2 & 2) != 0;
                            int n3 = n & 2;
                            bl = false;
                            if (n3 != 0) {
                                bl = true;
                            }
                            if (bl2 && !bl4) break block7;
                            if (bl3 && !bl) {
                                return 1;
                            }
                            if (!bl4) break block8;
                        }
                        return -1;
                    }
                    if (bl) {
                        return 1;
                    }
                }
                return (Integer)SuggestionsPopupWindow.this.mSpansLengths.get(suggestionSpan) - (Integer)SuggestionsPopupWindow.this.mSpansLengths.get(suggestionSpan2);
            }
        }
    }

    private static class TextDisplayList {
        RenderNode displayList;
        boolean isDirty = true;

        public TextDisplayList(String string2) {
            this.displayList = RenderNode.create(string2, null);
        }

        boolean needsRecord() {
            return this.isDirty || !this.displayList.isValid();
        }
    }

    public static class TextModifyOperation
    extends UndoOperation<TextView> {
        public static final Parcelable.ClassLoaderCreator<TextModifyOperation> CREATOR = new Parcelable.ClassLoaderCreator<TextModifyOperation>(){

            @Override
            public TextModifyOperation createFromParcel(Parcel parcel) {
                return new TextModifyOperation(parcel, null);
            }

            @Override
            public TextModifyOperation createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new TextModifyOperation(parcel, classLoader);
            }

            public TextModifyOperation[] newArray(int n) {
                return new TextModifyOperation[n];
            }
        };
        CharSequence mOldText;
        int mRangeEnd;
        int mRangeStart;

        public TextModifyOperation(UndoOwner undoOwner) {
            super(undoOwner);
        }

        public TextModifyOperation(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.mRangeStart = parcel.readInt();
            this.mRangeEnd = parcel.readInt();
            this.mOldText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void swapText() {
            Editable editable = (Editable)((TextView)this.getOwnerData()).getText();
            CharSequence charSequence = this.mRangeStart >= this.mRangeEnd ? null : editable.subSequence(this.mRangeStart, this.mRangeEnd);
            if (this.mOldText == null) {
                editable.delete(this.mRangeStart, this.mRangeEnd);
                this.mRangeEnd = this.mRangeStart;
            } else {
                editable.replace(this.mRangeStart, this.mRangeEnd, this.mOldText);
                this.mRangeEnd = this.mRangeStart + this.mOldText.length();
            }
            this.mOldText = charSequence;
        }

        @Override
        public void commit() {
        }

        @Override
        public void redo() {
            this.swapText();
        }

        @Override
        public void undo() {
            this.swapText();
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.mRangeStart);
            parcel.writeInt(this.mRangeEnd);
            TextUtils.writeToParcel(this.mOldText, parcel, n);
        }
    }

    private static interface TextViewPositionListener {
        public void updatePosition(int var1, int var2, boolean var3, boolean var4);
    }

    public static class UndoInputFilter
    implements InputFilter {
        final Editor mEditor;

        public UndoInputFilter(Editor editor) {
            this.mEditor = editor;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
            UndoManager undoManager = this.mEditor.mUndoManager;
            if (undoManager.isInUndo()) {
                return null;
            }
            undoManager.beginUpdate("Edit text");
            TextModifyOperation textModifyOperation = undoManager.getLastOperation(TextModifyOperation.class, this.mEditor.mUndoOwner, 1);
            if (textModifyOperation != null) {
                if (textModifyOperation.mOldText == null) {
                    if (n < n2 && (n3 >= textModifyOperation.mRangeStart && n4 <= textModifyOperation.mRangeEnd || n3 == textModifyOperation.mRangeEnd && n4 == textModifyOperation.mRangeEnd)) {
                        textModifyOperation.mRangeEnd = n3 + (n2 - n);
                        undoManager.endUpdate();
                        return null;
                    }
                } else if (n == n2 && n4 == -1 + textModifyOperation.mRangeStart) {
                    SpannableStringBuilder spannableStringBuilder = textModifyOperation.mOldText instanceof SpannableString ? (SpannableStringBuilder)textModifyOperation.mOldText : new SpannableStringBuilder(textModifyOperation.mOldText);
                    spannableStringBuilder.insert(0, spanned, n3, n4);
                    textModifyOperation.mRangeStart = n3;
                    textModifyOperation.mOldText = spannableStringBuilder;
                    undoManager.endUpdate();
                    return null;
                }
                undoManager.commitState(null);
                undoManager.setUndoLabel("Edit text");
            }
            TextModifyOperation textModifyOperation2 = new TextModifyOperation(this.mEditor.mUndoOwner);
            textModifyOperation2.mRangeStart = n3;
            textModifyOperation2.mRangeEnd = n < n2 ? n3 + (n2 - n) : n3;
            if (n3 < n4) {
                textModifyOperation2.mOldText = spanned.subSequence(n3, n4);
            }
            undoManager.addOperation(textModifyOperation2, 0);
            undoManager.endUpdate();
            return null;
        }
    }
}

