/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.graphics.Rect;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.text.method.DialerKeyListener;
import android.text.method.KeyListener;
import android.text.method.TextKeyListener;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;

public class DialerFilter
extends RelativeLayout {
    public static final int DIGITS_AND_LETTERS = 1;
    public static final int DIGITS_AND_LETTERS_NO_DIGITS = 2;
    public static final int DIGITS_AND_LETTERS_NO_LETTERS = 3;
    public static final int DIGITS_ONLY = 4;
    public static final int LETTERS_ONLY = 5;
    EditText mDigits;
    EditText mHint;
    ImageView mIcon;
    InputFilter[] mInputFilters;
    private boolean mIsQwerty;
    EditText mLetters;
    int mMode;
    EditText mPrimary;

    public DialerFilter(Context context) {
        super(context);
    }

    public DialerFilter(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    private void makeDigitsPrimary() {
        if (this.mPrimary == this.mLetters) {
            this.swapPrimaryAndHint(false);
        }
    }

    private void makeLettersPrimary() {
        if (this.mPrimary == this.mDigits) {
            this.swapPrimaryAndHint(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void swapPrimaryAndHint(boolean bl) {
        Editable editable = this.mLetters.getText();
        Editable editable2 = this.mDigits.getText();
        KeyListener keyListener = this.mLetters.getKeyListener();
        KeyListener keyListener2 = this.mDigits.getKeyListener();
        if (bl) {
            this.mLetters = this.mPrimary;
            this.mDigits = this.mHint;
        } else {
            this.mLetters = this.mHint;
            this.mDigits = this.mPrimary;
        }
        this.mLetters.setKeyListener(keyListener);
        this.mLetters.setText(editable);
        Editable editable3 = this.mLetters.getText();
        Selection.setSelection(editable3, editable3.length());
        this.mDigits.setKeyListener(keyListener2);
        this.mDigits.setText(editable2);
        Editable editable4 = this.mDigits.getText();
        Selection.setSelection(editable4, editable4.length());
        this.mPrimary.setFilters(this.mInputFilters);
        this.mHint.setFilters(this.mInputFilters);
    }

    public void append(String string2) {
        switch (this.mMode) {
            default: {
                return;
            }
            case 1: {
                this.mDigits.getText().append(string2);
                this.mLetters.getText().append(string2);
                return;
            }
            case 3: 
            case 4: {
                this.mDigits.getText().append(string2);
                return;
            }
            case 2: 
            case 5: 
        }
        this.mLetters.getText().append(string2);
    }

    public void clearText() {
        this.mLetters.getText().clear();
        this.mDigits.getText().clear();
        if (this.mIsQwerty) {
            this.setMode(1);
            return;
        }
        this.setMode(4);
    }

    public CharSequence getDigits() {
        if (this.mDigits.getVisibility() == 0) {
            return this.mDigits.getText();
        }
        return "";
    }

    public CharSequence getFilterText() {
        if (this.mMode != 4) {
            return this.getLetters();
        }
        return this.getDigits();
    }

    public CharSequence getLetters() {
        if (this.mLetters.getVisibility() == 0) {
            return this.mLetters.getText();
        }
        return "";
    }

    public int getMode() {
        return this.mMode;
    }

    public boolean isQwertyKeyboard() {
        return this.mIsQwerty;
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        InputFilter[] inputFilterArray = new InputFilter[]{new InputFilter.AllCaps()};
        this.mInputFilters = inputFilterArray;
        this.mHint = (EditText)this.findViewById(16908293);
        if (this.mHint == null) {
            throw new IllegalStateException("DialerFilter must have a child EditText named hint");
        }
        this.mHint.setFilters(this.mInputFilters);
        this.mLetters = this.mHint;
        this.mLetters.setKeyListener(TextKeyListener.getInstance());
        this.mLetters.setMovementMethod(null);
        this.mLetters.setFocusable(false);
        this.mPrimary = (EditText)this.findViewById(16908300);
        if (this.mPrimary == null) {
            throw new IllegalStateException("DialerFilter must have a child EditText named primary");
        }
        this.mPrimary.setFilters(this.mInputFilters);
        this.mDigits = this.mPrimary;
        this.mDigits.setKeyListener(DialerKeyListener.getInstance());
        this.mDigits.setMovementMethod(null);
        this.mDigits.setFocusable(false);
        this.mIcon = (ImageView)this.findViewById(16908294);
        this.setFocusable(true);
        this.mIsQwerty = true;
        this.setMode(1);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        if (this.mIcon != null) {
            ImageView imageView = this.mIcon;
            int n2 = bl ? 0 : 8;
            imageView.setVisibility(n2);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean onKeyDown(int var1_1, KeyEvent var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[CASE]], but top level block is 4[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        boolean bl = this.mLetters.onKeyUp(n, keyEvent);
        boolean bl2 = this.mDigits.onKeyUp(n, keyEvent);
        return bl || bl2;
    }

    protected void onModeChange(int n, int n2) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeFilterWatcher(TextWatcher textWatcher) {
        Editable editable = this.mMode != 4 ? this.mLetters.getText() : this.mDigits.getText();
        editable.removeSpan(textWatcher);
    }

    public void setDigitsWatcher(TextWatcher textWatcher) {
        Editable editable = this.mDigits.getText();
        ((Spannable)editable).setSpan(textWatcher, 0, editable.length(), 18);
    }

    public void setFilterWatcher(TextWatcher textWatcher) {
        if (this.mMode != 4) {
            this.setLettersWatcher(textWatcher);
            return;
        }
        this.setDigitsWatcher(textWatcher);
    }

    public void setLettersWatcher(TextWatcher textWatcher) {
        Editable editable = this.mLetters.getText();
        ((Spannable)editable).setSpan(textWatcher, 0, editable.length(), 18);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setMode(int n) {
        switch (n) {
            case 1: {
                this.makeDigitsPrimary();
                this.mLetters.setVisibility(0);
                this.mDigits.setVisibility(0);
                break;
            }
            case 4: {
                this.makeDigitsPrimary();
                this.mLetters.setVisibility(8);
                this.mDigits.setVisibility(0);
                break;
            }
            case 5: {
                this.makeLettersPrimary();
                this.mLetters.setVisibility(0);
                this.mDigits.setVisibility(8);
                break;
            }
            case 3: {
                this.makeDigitsPrimary();
                this.mLetters.setVisibility(4);
                this.mDigits.setVisibility(0);
                break;
            }
            case 2: {
                this.makeLettersPrimary();
                this.mLetters.setVisibility(0);
                this.mDigits.setVisibility(4);
                break;
            }
        }
        int n2 = this.mMode;
        this.mMode = n;
        this.onModeChange(n2, n);
    }
}

