/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.ViewDebug;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Checkable;
import android.widget.TextView;
import com.android.internal.R;

public class CheckedTextView
extends TextView
implements Checkable {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private int mBasePadding;
    private Drawable mCheckMarkDrawable;
    private int mCheckMarkGravity = 0x800005;
    private int mCheckMarkResource;
    private ColorStateList mCheckMarkTintList = null;
    private PorterDuff.Mode mCheckMarkTintMode = null;
    private int mCheckMarkWidth;
    private boolean mChecked;
    private boolean mHasCheckMarkTint = false;
    private boolean mHasCheckMarkTintMode = false;
    private boolean mNeedRequestlayout;

    public CheckedTextView(Context context) {
        this(context, null);
    }

    public CheckedTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843720);
    }

    public CheckedTextView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public CheckedTextView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.CheckedTextView, n, n2);
        Drawable drawable2 = typedArray.getDrawable(1);
        if (drawable2 != null) {
            this.setCheckMarkDrawable(drawable2);
        }
        if (typedArray.hasValue(3)) {
            this.mCheckMarkTintMode = Drawable.parseTintMode(typedArray.getInt(3, -1), this.mCheckMarkTintMode);
            this.mHasCheckMarkTintMode = true;
        }
        if (typedArray.hasValue(2)) {
            this.mCheckMarkTintList = typedArray.getColorStateList(2);
            this.mHasCheckMarkTint = true;
        }
        this.mCheckMarkGravity = typedArray.getInt(4, 0x800005);
        this.setChecked(typedArray.getBoolean(0, false));
        typedArray.recycle();
        this.applyCheckMarkTint();
    }

    private void applyCheckMarkTint() {
        if (this.mCheckMarkDrawable != null && (this.mHasCheckMarkTint || this.mHasCheckMarkTintMode)) {
            this.mCheckMarkDrawable = this.mCheckMarkDrawable.mutate();
            if (this.mHasCheckMarkTint) {
                this.mCheckMarkDrawable.setTintList(this.mCheckMarkTintList);
            }
            if (this.mHasCheckMarkTintMode) {
                this.mCheckMarkDrawable.setTintMode(this.mCheckMarkTintMode);
            }
        }
    }

    private boolean isCheckMarkAtStart() {
        return (7 & Gravity.getAbsoluteGravity(this.mCheckMarkGravity, this.getLayoutDirection())) == 3;
    }

    private void setBasePadding(boolean bl) {
        if (bl) {
            this.mBasePadding = this.mPaddingLeft;
            return;
        }
        this.mBasePadding = this.mPaddingRight;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updatePadding() {
        boolean bl = true;
        this.resetPaddingToInitialValues();
        int n = this.mCheckMarkDrawable != null ? this.mCheckMarkWidth + this.mBasePadding : this.mBasePadding;
        if (this.isCheckMarkAtStart()) {
            boolean bl2 = this.mNeedRequestlayout;
            if (this.mPaddingLeft == n) {
                bl = false;
            }
            this.mNeedRequestlayout = bl | bl2;
            this.mPaddingLeft = n;
        } else {
            boolean bl3 = this.mNeedRequestlayout;
            if (this.mPaddingRight == n) {
                bl = false;
            }
            this.mNeedRequestlayout = bl | bl3;
            this.mPaddingRight = n;
        }
        if (this.mNeedRequestlayout) {
            this.requestLayout();
            this.mNeedRequestlayout = false;
        }
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        super.drawableHotspotChanged(f, f2);
        if (this.mCheckMarkDrawable != null) {
            this.mCheckMarkDrawable.setHotspot(f, f2);
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mCheckMarkDrawable != null) {
            int[] nArray = this.getDrawableState();
            this.mCheckMarkDrawable.setState(nArray);
            this.invalidate();
        }
    }

    public Drawable getCheckMarkDrawable() {
        return this.mCheckMarkDrawable;
    }

    public ColorStateList getCheckMarkTintList() {
        return this.mCheckMarkTintList;
    }

    public PorterDuff.Mode getCheckMarkTintMode() {
        return this.mCheckMarkTintMode;
    }

    @Override
    protected void internalSetPadding(int n, int n2, int n3, int n4) {
        super.internalSetPadding(n, n2, n3, n4);
        this.setBasePadding(this.isCheckMarkAtStart());
    }

    @Override
    @ViewDebug.ExportedProperty
    public boolean isChecked() {
        return this.mChecked;
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mCheckMarkDrawable != null) {
            this.mCheckMarkDrawable.jumpToCurrentState();
        }
    }

    @Override
    protected int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 1);
        if (this.isChecked()) {
            CheckedTextView.mergeDrawableStates(nArray, CHECKED_STATE_SET);
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Drawable drawable2 = this.mCheckMarkDrawable;
        if (drawable2 != null) {
            int n;
            int n2;
            int n3 = 0x70 & this.getGravity();
            int n4 = drawable2.getIntrinsicHeight();
            int n5 = 0;
            switch (n3) {
                case 80: {
                    n5 = this.getHeight() - n4;
                    break;
                }
                case 16: {
                    n5 = (this.getHeight() - n4) / 2;
                }
            }
            boolean bl = this.isCheckMarkAtStart();
            int n6 = this.getWidth();
            int n7 = n5;
            int n8 = n7 + n4;
            if (bl) {
                n2 = this.mBasePadding;
                n = n2 + this.mCheckMarkWidth;
            } else {
                n = n6 - this.mBasePadding;
                n2 = n - this.mCheckMarkWidth;
            }
            drawable2.setBounds(n2 + this.mScrollX, n7, n + this.mScrollX, n8);
            drawable2.draw(canvas);
            Drawable drawable3 = this.getBackground();
            if (drawable3 != null) {
                drawable3.setHotspotBounds(n2 + this.mScrollX, n7, n + this.mScrollX, n8);
            }
        }
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(CheckedTextView.class.getName());
        accessibilityEvent.setChecked(this.mChecked);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(CheckedTextView.class.getName());
        accessibilityNodeInfo.setCheckable(true);
        accessibilityNodeInfo.setChecked(this.mChecked);
    }

    @Override
    public void onRtlPropertiesChanged(int n) {
        super.onRtlPropertiesChanged(n);
        this.updatePadding();
    }

    public void setCheckMarkDrawable(int n) {
        if (n != 0 && n == this.mCheckMarkResource) {
            return;
        }
        int n2 = this.mCheckMarkResource = n;
        Drawable drawable2 = null;
        if (n2 != 0) {
            drawable2 = this.getContext().getDrawable(this.mCheckMarkResource);
        }
        this.setCheckMarkDrawable(drawable2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCheckMarkDrawable(Drawable drawable2) {
        boolean bl = true;
        if (this.mCheckMarkDrawable != null) {
            this.mCheckMarkDrawable.setCallback(null);
            this.unscheduleDrawable(this.mCheckMarkDrawable);
        }
        boolean bl2 = drawable2 != this.mCheckMarkDrawable ? bl : false;
        this.mNeedRequestlayout = bl2;
        if (drawable2 != null) {
            drawable2.setCallback(this);
            if (this.getVisibility() != 0) {
                bl = false;
            }
            drawable2.setVisible(bl, false);
            drawable2.setState(CHECKED_STATE_SET);
            this.setMinHeight(drawable2.getIntrinsicHeight());
            this.mCheckMarkWidth = drawable2.getIntrinsicWidth();
            drawable2.setState(this.getDrawableState());
            this.applyCheckMarkTint();
        } else {
            this.mCheckMarkWidth = 0;
        }
        this.mCheckMarkDrawable = drawable2;
        this.resolvePadding();
    }

    public void setCheckMarkTintList(ColorStateList colorStateList) {
        this.mCheckMarkTintList = colorStateList;
        this.mHasCheckMarkTint = true;
        this.applyCheckMarkTint();
    }

    public void setCheckMarkTintMode(PorterDuff.Mode mode) {
        this.mCheckMarkTintMode = mode;
        this.mHasCheckMarkTintMode = true;
        this.applyCheckMarkTint();
    }

    @Override
    public void setChecked(boolean bl) {
        if (this.mChecked != bl) {
            this.mChecked = bl;
            this.refreshDrawableState();
            this.notifyViewAccessibilityStateChangedIfNeeded(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @RemotableViewMethod
    public void setVisibility(int n) {
        super.setVisibility(n);
        if (this.mCheckMarkDrawable != null) {
            Drawable drawable2 = this.mCheckMarkDrawable;
            boolean bl = n == 0;
            drawable2.setVisible(bl, false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void toggle() {
        boolean bl = !this.mChecked;
        this.setChecked(bl);
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return drawable2 == this.mCheckMarkDrawable || super.verifyDrawable(drawable2);
    }
}

