/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ArrayAdapter<T>
extends BaseAdapter
implements Filterable {
    private Context mContext;
    private int mDropDownResource;
    private int mFieldId = 0;
    private ArrayFilter mFilter;
    private LayoutInflater mInflater;
    private final Object mLock = new Object();
    private boolean mNotifyOnChange = true;
    private List<T> mObjects;
    private ArrayList<T> mOriginalValues;
    private int mResource;

    public ArrayAdapter(Context context, int n) {
        this.init(context, n, 0, new ArrayList());
    }

    public ArrayAdapter(Context context, int n, int n2) {
        this.init(context, n, n2, new ArrayList());
    }

    public ArrayAdapter(Context context, int n, int n2, List<T> list) {
        this.init(context, n, n2, list);
    }

    public ArrayAdapter(Context context, int n, int n2, T[] TArray) {
        this.init(context, n, n2, Arrays.asList(TArray));
    }

    public ArrayAdapter(Context context, int n, List<T> list) {
        this.init(context, n, 0, list);
    }

    public ArrayAdapter(Context context, int n, T[] TArray) {
        this.init(context, n, 0, Arrays.asList(TArray));
    }

    static /* synthetic */ ArrayList access$100(ArrayAdapter arrayAdapter) {
        return arrayAdapter.mOriginalValues;
    }

    static /* synthetic */ ArrayList access$102(ArrayAdapter arrayAdapter, ArrayList arrayList) {
        arrayAdapter.mOriginalValues = arrayList;
        return arrayList;
    }

    static /* synthetic */ Object access$200(ArrayAdapter arrayAdapter) {
        return arrayAdapter.mLock;
    }

    static /* synthetic */ List access$300(ArrayAdapter arrayAdapter) {
        return arrayAdapter.mObjects;
    }

    static /* synthetic */ List access$302(ArrayAdapter arrayAdapter, List list) {
        arrayAdapter.mObjects = list;
        return list;
    }

    public static ArrayAdapter<CharSequence> createFromResource(Context context, int n, int n2) {
        return new ArrayAdapter<CharSequence>(context, n2, context.getResources().getTextArray(n));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private View createViewFromResource(int n, View view, ViewGroup viewGroup, int n2) {
        T t;
        TextView textView;
        View view2 = view == null ? this.mInflater.inflate(n2, viewGroup, false) : view;
        try {
            if (this.mFieldId != 0) {
                textView = (TextView)view2.findViewById(this.mFieldId);
            }
            textView = (TextView)view2;
        }
        catch (ClassCastException classCastException) {
            Log.e("ArrayAdapter", "You must supply a resource ID for a TextView");
            throw new IllegalStateException("ArrayAdapter requires the resource ID to be a TextView", classCastException);
        }
        if ((t = this.getItem(n)) instanceof CharSequence) {
            textView.setText((CharSequence)t);
            return view2;
        }
        textView.setText(t.toString());
        return view2;
    }

    private void init(Context context, int n, int n2, List<T> list) {
        this.mContext = context;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mDropDownResource = n;
        this.mResource = n;
        this.mObjects = list;
        this.mFieldId = n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void add(T t) {
        Object object = this.mLock;
        // MONITORENTER : object
        if (this.mOriginalValues != null) {
            this.mOriginalValues.add(t);
        } else {
            this.mObjects.add(t);
        }
        // MONITOREXIT : object
        if (!this.mNotifyOnChange) return;
        this.notifyDataSetChanged();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void addAll(Collection<? extends T> collection) {
        Object object = this.mLock;
        // MONITORENTER : object
        if (this.mOriginalValues != null) {
            this.mOriginalValues.addAll(collection);
        } else {
            this.mObjects.addAll(collection);
        }
        // MONITOREXIT : object
        if (!this.mNotifyOnChange) return;
        this.notifyDataSetChanged();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void addAll(T ... TArray) {
        Object object = this.mLock;
        // MONITORENTER : object
        if (this.mOriginalValues != null) {
            Collections.addAll(this.mOriginalValues, TArray);
        } else {
            Collections.addAll(this.mObjects, TArray);
        }
        // MONITOREXIT : object
        if (!this.mNotifyOnChange) return;
        this.notifyDataSetChanged();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void clear() {
        Object object = this.mLock;
        // MONITORENTER : object
        if (this.mOriginalValues != null) {
            this.mOriginalValues.clear();
        } else {
            this.mObjects.clear();
        }
        // MONITOREXIT : object
        if (!this.mNotifyOnChange) return;
        this.notifyDataSetChanged();
    }

    public Context getContext() {
        return this.mContext;
    }

    @Override
    public int getCount() {
        return this.mObjects.size();
    }

    @Override
    public View getDropDownView(int n, View view, ViewGroup viewGroup) {
        return this.createViewFromResource(n, view, viewGroup, this.mDropDownResource);
    }

    @Override
    public Filter getFilter() {
        if (this.mFilter == null) {
            this.mFilter = new ArrayFilter();
        }
        return this.mFilter;
    }

    public T getItem(int n) {
        return this.mObjects.get(n);
    }

    @Override
    public long getItemId(int n) {
        return n;
    }

    public int getPosition(T t) {
        return this.mObjects.indexOf(t);
    }

    @Override
    public View getView(int n, View view, ViewGroup viewGroup) {
        return this.createViewFromResource(n, view, viewGroup, this.mResource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void insert(T t, int n) {
        Object object = this.mLock;
        // MONITORENTER : object
        if (this.mOriginalValues != null) {
            this.mOriginalValues.add(n, t);
        } else {
            this.mObjects.add(n, t);
        }
        // MONITOREXIT : object
        if (!this.mNotifyOnChange) return;
        this.notifyDataSetChanged();
    }

    @Override
    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.mNotifyOnChange = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void remove(T t) {
        Object object = this.mLock;
        // MONITORENTER : object
        if (this.mOriginalValues != null) {
            this.mOriginalValues.remove(t);
        } else {
            this.mObjects.remove(t);
        }
        // MONITOREXIT : object
        if (!this.mNotifyOnChange) return;
        this.notifyDataSetChanged();
    }

    public void setDropDownViewResource(int n) {
        this.mDropDownResource = n;
    }

    public void setNotifyOnChange(boolean bl) {
        this.mNotifyOnChange = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void sort(Comparator<? super T> comparator) {
        Object object = this.mLock;
        // MONITORENTER : object
        if (this.mOriginalValues != null) {
            Collections.sort(this.mOriginalValues, comparator);
        } else {
            Collections.sort(this.mObjects, comparator);
        }
        // MONITOREXIT : object
        if (!this.mNotifyOnChange) return;
        this.notifyDataSetChanged();
    }

    private class ArrayFilter
    extends Filter {
        private ArrayFilter() {
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected Filter.FilterResults performFiltering(CharSequence var1_1) {
            var2_2 = new Filter.FilterResults();
            if (ArrayAdapter.access$100(ArrayAdapter.this) == null) {
                var20_3 = ArrayAdapter.access$200(ArrayAdapter.this);
                synchronized (var20_3) {
                    ArrayAdapter.access$102(ArrayAdapter.this, new ArrayList<E>(ArrayAdapter.access$300(ArrayAdapter.this)));
                }
            }
            if (var1_1 == null || var1_1.length() == 0) {
                var3_4 = ArrayAdapter.access$200(ArrayAdapter.this);
                synchronized (var3_4) {
                    var4_5 = new ArrayList<E>(ArrayAdapter.access$100(ArrayAdapter.this));
                }
                var2_2.values = var4_5;
                var2_2.count = var4_5.size();
                return var2_2;
            }
            var6_6 = var1_1.toString().toLowerCase();
            var7_7 = ArrayAdapter.access$200(ArrayAdapter.this);
            synchronized (var7_7) {
                var8_8 = new ArrayList<E>(ArrayAdapter.access$100(ArrayAdapter.this));
            }
            var10_9 = var8_8.size();
            var11_10 = new ArrayList<E>();
            var12_11 = 0;
            block9: while (true) {
                block19: {
                    if (var12_11 >= var10_9) {
                        var2_2.values = var11_10;
                        var2_2.count = var11_10.size();
                        return var2_2;
                    }
                    var13_12 = var8_8.get(var12_11);
                    var14_13 = var13_12.toString().toLowerCase();
                    if (!var14_13.startsWith(var6_6)) break block19;
                    var11_10.add(var13_12);
                    ** GOTO lbl38
                }
                var15_14 = var14_13.split(" ");
                var16_15 = var15_14.length;
                var17_16 = 0;
                while (true) {
                    block20: {
                        if (var17_16 < var16_15) break block20;
lbl38:
                        // 3 sources

                        while (true) {
                            ++var12_11;
                            continue block9;
                            break;
                        }
                    }
                    if (var15_14[var17_16].startsWith(var6_6)) {
                        var11_10.add(var13_12);
                        ** continue;
                    }
                    ++var17_16;
                }
                break;
            }
        }

        @Override
        protected void publishResults(CharSequence charSequence, Filter.FilterResults filterResults) {
            ArrayAdapter.access$302(ArrayAdapter.this, (List)filterResults.values);
            if (filterResults.count > 0) {
                ArrayAdapter.this.notifyDataSetChanged();
                return;
            }
            ArrayAdapter.this.notifyDataSetInvalidated();
        }
    }
}

