/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AppSecurityPermissions {
    private static final String TAG = "AppSecurityPermissions";
    public static final int WHICH_ALL = 65535;
    public static final int WHICH_DEVICE = 2;
    public static final int WHICH_NEW = 4;
    public static final int WHICH_PERSONAL = 1;
    private static final boolean localLOGV;
    private final Context mContext;
    private final LayoutInflater mInflater;
    private final CharSequence mNewPermPrefix;
    private String mPackageName;
    private final PermissionInfoComparator mPermComparator;
    private final PermissionGroupInfoComparator mPermGroupComparator;
    private final Map<String, MyPermissionGroupInfo> mPermGroups = new HashMap<String, MyPermissionGroupInfo>();
    private final List<MyPermissionGroupInfo> mPermGroupsList = new ArrayList<MyPermissionGroupInfo>();
    private final List<MyPermissionInfo> mPermsList;
    private final PackageManager mPm;

    private AppSecurityPermissions(Context context) {
        this.mPermGroupComparator = new PermissionGroupInfoComparator();
        this.mPermComparator = new PermissionInfoComparator();
        this.mPermsList = new ArrayList<MyPermissionInfo>();
        this.mContext = context;
        this.mInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mPm = this.mContext.getPackageManager();
        this.mNewPermPrefix = this.mContext.getText(17040596);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AppSecurityPermissions(Context context, PackageInfo packageInfo) {
        this(context);
        HashSet<MyPermissionInfo> hashSet = new HashSet<MyPermissionInfo>();
        if (packageInfo == null) {
            return;
        }
        this.mPackageName = packageInfo.packageName;
        if (packageInfo.requestedPermissions != null) {
            PackageInfo packageInfo2;
            try {
                PackageInfo packageInfo3;
                packageInfo2 = packageInfo3 = this.mPm.getPackageInfo(packageInfo.packageName, 4096);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                packageInfo2 = null;
            }
            this.extractPerms(packageInfo, hashSet, packageInfo2);
        }
        if (packageInfo.sharedUserId != null) {
            try {
                this.getAllUsedPermissions(this.mPm.getUidForSharedUser(packageInfo.sharedUserId), hashSet);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w(TAG, "Couldn't retrieve shared user id for: " + packageInfo.packageName);
            }
        }
        this.mPermsList.addAll(hashSet);
        this.setPermissions(this.mPermsList);
    }

    public AppSecurityPermissions(Context context, String string2) {
        this(context);
        this.mPackageName = string2;
        HashSet<MyPermissionInfo> hashSet = new HashSet<MyPermissionInfo>();
        try {
            PackageInfo packageInfo = this.mPm.getPackageInfo(string2, 4096);
            if (packageInfo.applicationInfo != null && packageInfo.applicationInfo.uid != -1) {
                this.getAllUsedPermissions(packageInfo.applicationInfo.uid, hashSet);
            }
            this.mPermsList.addAll(hashSet);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w(TAG, "Couldn't retrieve permissions for package:" + string2);
            return;
        }
        this.setPermissions(this.mPermsList);
    }

    private void addPermToList(List<MyPermissionInfo> list, MyPermissionInfo myPermissionInfo) {
        int n;
        if (myPermissionInfo.mLabel == null) {
            myPermissionInfo.mLabel = myPermissionInfo.loadLabel(this.mPm);
        }
        if ((n = Collections.binarySearch(list, myPermissionInfo, this.mPermComparator)) < 0) {
            list.add(-1 + -n, myPermissionInfo);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void displayPermissions(List<MyPermissionGroupInfo> list, LinearLayout linearLayout, int n, boolean bl) {
        linearLayout.removeAllViews();
        int n2 = (int)(8.0f * this.mContext.getResources().getDisplayMetrics().density);
        int n3 = 0;
        while (n3 < list.size()) {
            MyPermissionGroupInfo myPermissionGroupInfo = list.get(n3);
            List<MyPermissionInfo> list2 = this.getPermissionList(myPermissionGroupInfo, n);
            for (int i = 0; i < list2.size(); ++i) {
                MyPermissionInfo myPermissionInfo = list2.get(i);
                boolean bl2 = i == 0;
                CharSequence charSequence = n != 4 ? this.mNewPermPrefix : null;
                PermissionItemView permissionItemView = this.getPermissionItemView(myPermissionGroupInfo, myPermissionInfo, bl2, charSequence, bl);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
                if (i == 0) {
                    layoutParams.topMargin = n2;
                }
                if (i == -1 + myPermissionGroupInfo.mAllPermissions.size()) {
                    layoutParams.bottomMargin = n2;
                }
                if (linearLayout.getChildCount() == 0) {
                    layoutParams.topMargin = 2 * layoutParams.topMargin;
                }
                linearLayout.addView((View)permissionItemView, layoutParams);
            }
            ++n3;
        }
        return;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void extractPerms(PackageInfo var1_1, Set<MyPermissionInfo> var2_2, PackageInfo var3_3) {
        block15: {
            var4_4 = var1_1.requestedPermissions;
            var5_5 = var1_1.requestedPermissionsFlags;
            if (var4_4 == null) return;
            if (var4_4.length == 0) {
                return;
            }
            var6_6 = 0;
            block3: while (var6_6 < var4_4.length) {
                var7_7 = var4_4[var6_6];
                if (var3_3 != null && var1_1 == var3_3 && (2 & var5_5[var6_6]) == 0) ** GOTO lbl16
                var10_9 = this.mPm.getPermissionInfo(var7_7, 0);
                if (var10_9 != null) {
                    var11_10 = -1;
                    if (var3_3 == null || var3_3.requestedPermissions == null) break block13;
                    ** break block14
                }
lbl16:
                // 6 sources

                while (true) {
                    ++var6_6;
                    continue block3;
                    break;
                }
            }
            return;
lbl-1000:
            // 1 sources

            {
                block13: {
                    for (var12_11 = 0; var12_11 < var3_3.requestedPermissions.length; ++var12_11) {
                        if (!var7_7.equals(var3_3.requestedPermissions[var12_11])) continue;
                        var11_10 = var12_11;
                        break;
                    }
                }
                if (!this.isDisplayablePermission(var10_9, var5_5[var6_6], var13_12 = var11_10 >= 0 ? var3_3.requestedPermissionsFlags[var11_10] : 0)) ** GOTO lbl16
                var14_13 = var10_9.group;
                var15_14 = var14_13;
                if (var15_14 == null) {
                    var10_9.group = var15_14 = var10_9.packageName;
                }
                if (this.mPermGroups.get(var15_14) != null) break block15;
                var16_15 = null;
                if (var14_13 != null) {
                    var16_15 = this.mPm.getPermissionGroupInfo(var14_13, 0);
                }
                if (var16_15 != null) {
                    var17_16 = new MyPermissionGroupInfo(var16_15);
                } else {
                    var10_9.group = var10_9.packageName;
                    if (this.mPermGroups.get(var10_9.group) == null) {
                        new MyPermissionGroupInfo(var10_9);
                    }
                    var17_16 = new MyPermissionGroupInfo(var10_9);
                }
                this.mPermGroups.put(var10_9.group, var17_16);
            }
            catch (PackageManager.NameNotFoundException var8_8) {
                Log.i("AppSecurityPermissions", "Ignoring unknown permission:" + var7_7);
            }
        }
        var19_17 = var3_3 != null && (var13_12 & 2) == 0;
        var20_18 = new MyPermissionInfo(var10_9);
        var20_18.mNewReqFlags = var5_5[var6_6];
        var20_18.mExistingReqFlags = var13_12;
        var20_18.mNew = var19_17;
        var2_2.add(var20_18);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getAllUsedPermissions(int n, Set<MyPermissionInfo> set) {
        String[] stringArray = this.mPm.getPackagesForUid(n);
        if (stringArray != null && stringArray.length != 0) {
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                this.getPermissionsForPackage(stringArray[i], set);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static View getPermissionItemView(Context context, CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        int n;
        LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        if (bl) {
            n = 17302550;
            return AppSecurityPermissions.getPermissionItemViewOld(context, layoutInflater, charSequence, charSequence2, bl, context.getDrawable(n));
        }
        n = 17302817;
        return AppSecurityPermissions.getPermissionItemViewOld(context, layoutInflater, charSequence, charSequence2, bl, context.getDrawable(n));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static PermissionItemView getPermissionItemView(Context context, LayoutInflater layoutInflater, MyPermissionGroupInfo myPermissionGroupInfo, MyPermissionInfo myPermissionInfo, boolean bl, CharSequence charSequence, String string2, boolean bl2) {
        int n = (1 & myPermissionInfo.flags) != 0 ? 17367091 : 17367090;
        PermissionItemView permissionItemView = (PermissionItemView)layoutInflater.inflate(n, null);
        permissionItemView.setPermission(myPermissionGroupInfo, myPermissionInfo, bl, charSequence, string2, bl2);
        return permissionItemView;
    }

    private PermissionItemView getPermissionItemView(MyPermissionGroupInfo myPermissionGroupInfo, MyPermissionInfo myPermissionInfo, boolean bl, CharSequence charSequence, boolean bl2) {
        return AppSecurityPermissions.getPermissionItemView(this.mContext, this.mInflater, myPermissionGroupInfo, myPermissionInfo, bl, charSequence, this.mPackageName, bl2);
    }

    private static View getPermissionItemViewOld(Context context, LayoutInflater layoutInflater, CharSequence charSequence, CharSequence charSequence2, boolean bl, Drawable drawable2) {
        View view = layoutInflater.inflate(17367092, null);
        TextView textView = (TextView)view.findViewById(16909036);
        TextView textView2 = (TextView)view.findViewById(16909037);
        ((ImageView)view.findViewById(16909032)).setImageDrawable(drawable2);
        if (charSequence != null) {
            textView.setText(charSequence);
            textView2.setText(charSequence2);
            return view;
        }
        textView.setText(charSequence2);
        textView2.setVisibility(8);
        return view;
    }

    private List<MyPermissionInfo> getPermissionList(MyPermissionGroupInfo myPermissionGroupInfo, int n) {
        if (n == 4) {
            return myPermissionGroupInfo.mNewPermissions;
        }
        if (n == 1) {
            return myPermissionGroupInfo.mPersonalPermissions;
        }
        if (n == 2) {
            return myPermissionGroupInfo.mDevicePermissions;
        }
        return myPermissionGroupInfo.mAllPermissions;
    }

    private void getPermissionsForPackage(String string2, Set<MyPermissionInfo> set) {
        try {
            PackageInfo packageInfo = this.mPm.getPackageInfo(string2, 4096);
            this.extractPerms(packageInfo, set, packageInfo);
            return;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w(TAG, "Couldn't retrieve permissions for package: " + string2);
            return;
        }
    }

    private View getPermissionsView(int n, boolean bl) {
        LinearLayout linearLayout = (LinearLayout)this.mInflater.inflate(17367093, null);
        LinearLayout linearLayout2 = (LinearLayout)linearLayout.findViewById(16909039);
        View view = linearLayout.findViewById(16909038);
        this.displayPermissions(this.mPermGroupsList, linearLayout2, n, bl);
        if (linearLayout2.getChildCount() <= 0) {
            view.setVisibility(0);
        }
        return linearLayout;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isDisplayablePermission(PermissionInfo permissionInfo, int n, int n2) {
        int n3 = 0xF & permissionInfo.protectionLevel;
        boolean bl = n3 == 0;
        boolean bl2 = n3 == 1;
        boolean bl3 = (n & 1) != 0;
        boolean bl4 = (0x20 & permissionInfo.protectionLevel) != 0;
        boolean bl5 = (n2 & 2) != 0;
        boolean bl6 = (n & 2) != 0;
        return (bl || bl2) && (bl3 || bl5 || bl6) || bl4 && bl5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setPermissions(List<MyPermissionInfo> list) {
        if (list != null) {
            for (MyPermissionInfo myPermissionInfo : list) {
                MyPermissionGroupInfo myPermissionGroupInfo;
                if (!this.isDisplayablePermission(myPermissionInfo, myPermissionInfo.mNewReqFlags, myPermissionInfo.mExistingReqFlags) || (myPermissionGroupInfo = this.mPermGroups.get(myPermissionInfo.group)) == null) continue;
                myPermissionInfo.mLabel = myPermissionInfo.loadLabel(this.mPm);
                this.addPermToList(myPermissionGroupInfo.mAllPermissions, myPermissionInfo);
                if (myPermissionInfo.mNew) {
                    this.addPermToList(myPermissionGroupInfo.mNewPermissions, myPermissionInfo);
                }
                if ((1 & myPermissionGroupInfo.flags) != 0) {
                    this.addPermToList(myPermissionGroupInfo.mPersonalPermissions, myPermissionInfo);
                    continue;
                }
                this.addPermToList(myPermissionGroupInfo.mDevicePermissions, myPermissionInfo);
            }
        }
        Iterator<MyPermissionGroupInfo> iterator = this.mPermGroups.values().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                Collections.sort(this.mPermGroupsList, this.mPermGroupComparator);
                return;
            }
            MyPermissionGroupInfo myPermissionGroupInfo = iterator.next();
            if (myPermissionGroupInfo.labelRes != 0 || myPermissionGroupInfo.nonLocalizedLabel != null) {
                myPermissionGroupInfo.mLabel = myPermissionGroupInfo.loadLabel(this.mPm);
            } else {
                try {
                    myPermissionGroupInfo.mLabel = this.mPm.getApplicationInfo(myPermissionGroupInfo.packageName, 0).loadLabel(this.mPm);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    myPermissionGroupInfo.mLabel = myPermissionGroupInfo.loadLabel(this.mPm);
                }
            }
            this.mPermGroupsList.add(myPermissionGroupInfo);
        }
    }

    public int getPermissionCount() {
        return this.getPermissionCount(65535);
    }

    public int getPermissionCount(int n) {
        int n2 = 0;
        for (int i = 0; i < this.mPermGroupsList.size(); ++i) {
            n2 += this.getPermissionList(this.mPermGroupsList.get(i), n).size();
        }
        return n2;
    }

    public View getPermissionsView() {
        return this.getPermissionsView(65535, false);
    }

    public View getPermissionsView(int n) {
        return this.getPermissionsView(n, false);
    }

    public View getPermissionsViewWithRevokeButtons() {
        return this.getPermissionsView(65535, true);
    }

    static class MyPermissionGroupInfo
    extends PermissionGroupInfo {
        final ArrayList<MyPermissionInfo> mAllPermissions;
        final ArrayList<MyPermissionInfo> mDevicePermissions;
        CharSequence mLabel;
        final ArrayList<MyPermissionInfo> mNewPermissions = new ArrayList();
        final ArrayList<MyPermissionInfo> mPersonalPermissions = new ArrayList();

        MyPermissionGroupInfo(PermissionGroupInfo permissionGroupInfo) {
            super(permissionGroupInfo);
            this.mDevicePermissions = new ArrayList();
            this.mAllPermissions = new ArrayList();
        }

        MyPermissionGroupInfo(PermissionInfo permissionInfo) {
            this.mDevicePermissions = new ArrayList();
            this.mAllPermissions = new ArrayList();
            this.name = permissionInfo.packageName;
            this.packageName = permissionInfo.packageName;
        }

        public Drawable loadGroupIcon(PackageManager packageManager) {
            if (this.icon != 0) {
                return this.loadIcon(packageManager);
            }
            try {
                Drawable drawable2 = packageManager.getApplicationInfo(this.packageName, 0).loadIcon(packageManager);
                return drawable2;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return null;
            }
        }
    }

    private static class MyPermissionInfo
    extends PermissionInfo {
        int mExistingReqFlags;
        CharSequence mLabel;
        boolean mNew;
        int mNewReqFlags;

        MyPermissionInfo(PermissionInfo permissionInfo) {
            super(permissionInfo);
        }
    }

    private static class PermissionGroupInfoComparator
    implements Comparator<MyPermissionGroupInfo> {
        private final Collator sCollator = Collator.getInstance();

        PermissionGroupInfoComparator() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public final int compare(MyPermissionGroupInfo myPermissionGroupInfo, MyPermissionGroupInfo myPermissionGroupInfo2) {
            if ((1 & (myPermissionGroupInfo.flags ^ myPermissionGroupInfo2.flags)) != 0) {
                if ((1 & myPermissionGroupInfo.flags) != 0) return -1;
                return 1;
            }
            if (myPermissionGroupInfo.priority == myPermissionGroupInfo2.priority) {
                return this.sCollator.compare(myPermissionGroupInfo.mLabel, myPermissionGroupInfo2.mLabel);
            }
            if (myPermissionGroupInfo.priority <= myPermissionGroupInfo2.priority) return 1;
            return -1;
        }
    }

    private static class PermissionInfoComparator
    implements Comparator<MyPermissionInfo> {
        private final Collator sCollator = Collator.getInstance();

        PermissionInfoComparator() {
        }

        @Override
        public final int compare(MyPermissionInfo myPermissionInfo, MyPermissionInfo myPermissionInfo2) {
            return this.sCollator.compare(myPermissionInfo.mLabel, myPermissionInfo2.mLabel);
        }
    }

    public static class PermissionItemView
    extends LinearLayout
    implements View.OnClickListener {
        AlertDialog mDialog;
        MyPermissionGroupInfo mGroup;
        private String mPackageName;
        MyPermissionInfo mPerm;
        private boolean mShowRevokeUI = false;

        public PermissionItemView(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.setClickable(true);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void addRevokeUIIfNecessary(AlertDialog.Builder builder) {
            if (!this.mShowRevokeUI) return;
            if ((1 & this.mPerm.mExistingReqFlags) != 0) {
                return;
            }
            boolean bl = false;
            if (bl) {
                return;
            }
            builder.setNegativeButton(17040896, new DialogInterface.OnClickListener(){

                @Override
                public void onClick(DialogInterface dialogInterface, int n) {
                    PermissionItemView.this.getContext().getPackageManager().revokePermission(PermissionItemView.this.mPackageName, PermissionItemView.this.mPerm.name);
                    PermissionItemView.this.setVisibility(8);
                }
            });
            builder.setPositiveButton(17039370, null);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onClick(View view) {
            if (this.mGroup != null && this.mPerm != null) {
                if (this.mDialog != null) {
                    this.mDialog.dismiss();
                }
                PackageManager packageManager = this.getContext().getPackageManager();
                AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
                builder.setTitle(this.mGroup.mLabel);
                if (this.mPerm.descriptionRes != 0) {
                    builder.setMessage(this.mPerm.loadDescription(packageManager));
                } else {
                    void var6_6;
                    try {
                        CharSequence charSequence;
                        CharSequence charSequence2 = charSequence = packageManager.getApplicationInfo(this.mPerm.packageName, 0).loadLabel(packageManager);
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        String string2 = this.mPerm.packageName;
                    }
                    StringBuilder stringBuilder = new StringBuilder(128);
                    stringBuilder.append(this.getContext().getString(17040597, var6_6));
                    stringBuilder.append("\n\n");
                    stringBuilder.append(this.mPerm.name);
                    builder.setMessage(stringBuilder.toString());
                }
                builder.setCancelable(true);
                builder.setIcon(this.mGroup.loadGroupIcon(packageManager));
                this.addRevokeUIIfNecessary(builder);
                this.mDialog = builder.show();
                this.mDialog.setCanceledOnTouchOutside(true);
            }
        }

        @Override
        protected void onDetachedFromWindow() {
            super.onDetachedFromWindow();
            if (this.mDialog != null) {
                this.mDialog.dismiss();
            }
        }

        public void setPermission(MyPermissionGroupInfo myPermissionGroupInfo, MyPermissionInfo myPermissionInfo, boolean bl, CharSequence charSequence, String string2, boolean bl2) {
            this.mGroup = myPermissionGroupInfo;
            this.mPerm = myPermissionInfo;
            this.mShowRevokeUI = bl2;
            this.mPackageName = string2;
            ImageView imageView = (ImageView)this.findViewById(16909032);
            TextView textView = (TextView)this.findViewById(16909033);
            PackageManager packageManager = this.getContext().getPackageManager();
            Drawable drawable2 = null;
            if (bl) {
                drawable2 = myPermissionGroupInfo.loadGroupIcon(packageManager);
            }
            CharSequence charSequence2 = myPermissionInfo.mLabel;
            if (myPermissionInfo.mNew && charSequence != null) {
                SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder();
                Parcel parcel = Parcel.obtain();
                TextUtils.writeToParcel(charSequence, parcel, 0);
                parcel.setDataPosition(0);
                CharSequence charSequence3 = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
                parcel.recycle();
                spannableStringBuilder.append(charSequence3);
                spannableStringBuilder.append(charSequence2);
                charSequence2 = spannableStringBuilder;
            }
            imageView.setImageDrawable(drawable2);
            textView.setText(charSequence2);
            this.setOnClickListener(this);
        }
    }
}

