/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Adapter;
import android.widget.AdapterViewAnimator;
import android.widget.RemoteViews;
import com.android.internal.R;

@RemoteViews.RemoteView
public class AdapterViewFlipper
extends AdapterViewAnimator {
    private static final int DEFAULT_INTERVAL = 10000;
    private static final boolean LOGD = false;
    private static final String TAG = "ViewFlipper";
    private final int FLIP_MSG;
    private boolean mAdvancedByHost = false;
    private boolean mAutoStart = false;
    private int mFlipInterval = 10000;
    private final Handler mHandler;
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String string2 = intent.getAction();
            if ("android.intent.action.SCREEN_OFF".equals(string2)) {
                AdapterViewFlipper.access$002(AdapterViewFlipper.this, false);
                AdapterViewFlipper.this.updateRunning();
                return;
            } else {
                if (!"android.intent.action.USER_PRESENT".equals(string2)) return;
                AdapterViewFlipper.access$002(AdapterViewFlipper.this, true);
                AdapterViewFlipper.this.updateRunning(false);
                return;
            }
        }
    };
    private boolean mRunning = false;
    private boolean mStarted = false;
    private boolean mUserPresent = true;
    private boolean mVisible = false;

    public AdapterViewFlipper(Context context) {
        super(context);
        this.FLIP_MSG = 1;
        this.mHandler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                if (message.what == 1 && AdapterViewFlipper.this.mRunning) {
                    AdapterViewFlipper.this.showNext();
                }
            }
        };
    }

    public AdapterViewFlipper(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public AdapterViewFlipper(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public AdapterViewFlipper(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.FLIP_MSG = 1;
        this.mHandler = new /* invalid duplicate definition of identical inner class */;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.AdapterViewFlipper, n, n2);
        this.mFlipInterval = typedArray.getInt(0, 10000);
        this.mAutoStart = typedArray.getBoolean(1, false);
        this.mLoopViews = true;
        typedArray.recycle();
    }

    static /* synthetic */ boolean access$002(AdapterViewFlipper adapterViewFlipper, boolean bl) {
        adapterViewFlipper.mUserPresent = bl;
        return bl;
    }

    private void updateRunning() {
        this.updateRunning(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateRunning(boolean bl) {
        boolean bl2 = !this.mAdvancedByHost && this.mVisible && this.mStarted && this.mUserPresent && this.mAdapter != null;
        if (bl2 != this.mRunning) {
            if (bl2) {
                this.showOnly(this.mWhichChild, bl);
                Message message = this.mHandler.obtainMessage(1);
                this.mHandler.sendMessageDelayed(message, this.mFlipInterval);
            } else {
                this.mHandler.removeMessages(1);
            }
            this.mRunning = bl2;
        }
    }

    @Override
    public void fyiWillBeAdvancedByHostKThx() {
        this.mAdvancedByHost = true;
        this.updateRunning(false);
    }

    public int getFlipInterval() {
        return this.mFlipInterval;
    }

    public boolean isAutoStart() {
        return this.mAutoStart;
    }

    public boolean isFlipping() {
        return this.mStarted;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        this.getContext().registerReceiverAsUser(this.mReceiver, Process.myUserHandle(), intentFilter, null, this.mHandler);
        if (this.mAutoStart) {
            this.startFlipping();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mVisible = false;
        this.getContext().unregisterReceiver(this.mReceiver);
        this.updateRunning();
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(AdapterViewFlipper.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(AdapterViewFlipper.class.getName());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onWindowVisibilityChanged(int n) {
        super.onWindowVisibilityChanged(n);
        boolean bl = n == 0;
        this.mVisible = bl;
        this.updateRunning(false);
    }

    @Override
    public void setAdapter(Adapter adapter) {
        super.setAdapter(adapter);
        this.updateRunning();
    }

    public void setAutoStart(boolean bl) {
        this.mAutoStart = bl;
    }

    public void setFlipInterval(int n) {
        this.mFlipInterval = n;
    }

    @Override
    @RemotableViewMethod
    public void showNext() {
        if (this.mRunning) {
            this.mHandler.removeMessages(1);
            Message message = this.mHandler.obtainMessage(1);
            this.mHandler.sendMessageDelayed(message, this.mFlipInterval);
        }
        super.showNext();
    }

    @Override
    @RemotableViewMethod
    public void showPrevious() {
        if (this.mRunning) {
            this.mHandler.removeMessages(1);
            Message message = this.mHandler.obtainMessage(1);
            this.mHandler.sendMessageDelayed(message, this.mFlipInterval);
        }
        super.showPrevious();
    }

    public void startFlipping() {
        this.mStarted = true;
        this.updateRunning();
    }

    public void stopFlipping() {
        this.mStarted = false;
        this.updateRunning();
    }
}

