/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseBooleanArray;
import android.view.ActionProvider;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ActionMenuView;
import android.widget.ImageButton;
import android.widget.ListPopupWindow;
import com.android.internal.transition.ActionBarTransition;
import com.android.internal.view.ActionBarPolicy;
import com.android.internal.view.menu.ActionMenuItemView;
import com.android.internal.view.menu.BaseMenuPresenter;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPopupHelper;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.MenuView;
import com.android.internal.view.menu.SubMenuBuilder;
import java.util.ArrayList;

public class ActionMenuPresenter
extends BaseMenuPresenter
implements ActionProvider.SubUiVisibilityListener {
    private static final String TAG = "ActionMenuPresenter";
    private final SparseBooleanArray mActionButtonGroups = new SparseBooleanArray();
    private ActionButtonSubmenu mActionButtonPopup;
    private int mActionItemWidthLimit;
    private boolean mExpandedActionViewsExclusive;
    private int mMaxItems;
    private boolean mMaxItemsSet;
    private int mMinCellSize;
    int mOpenSubMenuId;
    private View mOverflowButton;
    private OverflowPopup mOverflowPopup;
    private ActionMenuPopupCallback mPopupCallback;
    final PopupPresenterCallback mPopupPresenterCallback = new PopupPresenterCallback();
    private OpenOverflowRunnable mPostedOpenRunnable;
    private boolean mReserveOverflow;
    private boolean mReserveOverflowSet;
    private View mScrapActionButtonView;
    private boolean mStrictWidthLimit;
    private int mWidthLimit;
    private boolean mWidthLimitSet;

    public ActionMenuPresenter(Context context) {
        super(context, 17367069, 17367068);
    }

    static /* synthetic */ OverflowPopup access$202(ActionMenuPresenter actionMenuPresenter, OverflowPopup overflowPopup) {
        actionMenuPresenter.mOverflowPopup = overflowPopup;
        return overflowPopup;
    }

    static /* synthetic */ OpenOverflowRunnable access$302(ActionMenuPresenter actionMenuPresenter, OpenOverflowRunnable openOverflowRunnable) {
        actionMenuPresenter.mPostedOpenRunnable = openOverflowRunnable;
        return openOverflowRunnable;
    }

    static /* synthetic */ ActionButtonSubmenu access$702(ActionMenuPresenter actionMenuPresenter, ActionButtonSubmenu actionButtonSubmenu) {
        actionMenuPresenter.mActionButtonPopup = actionButtonSubmenu;
        return actionButtonSubmenu;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private View findViewForItem(MenuItem menuItem) {
        ViewGroup viewGroup = (ViewGroup)((Object)this.mMenuView);
        if (viewGroup == null) {
            return null;
        }
        int n = viewGroup.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            View view = viewGroup.getChildAt(n2);
            if (view instanceof MenuView.ItemView) {
                if (((MenuView.ItemView)((Object)view)).getItemData() == menuItem) return view;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void bindItemView(MenuItemImpl menuItemImpl, MenuView.ItemView itemView) {
        itemView.initialize(menuItemImpl, 0);
        ActionMenuView actionMenuView = (ActionMenuView)this.mMenuView;
        ActionMenuItemView actionMenuItemView = (ActionMenuItemView)itemView;
        actionMenuItemView.setItemInvoker(actionMenuView);
        if (this.mPopupCallback == null) {
            this.mPopupCallback = new ActionMenuPopupCallback();
        }
        actionMenuItemView.setPopupCallback(this.mPopupCallback);
    }

    public boolean dismissPopupMenus() {
        return this.hideOverflowMenu() | this.hideSubMenus();
    }

    @Override
    public boolean filterLeftoverView(ViewGroup viewGroup, int n) {
        if (viewGroup.getChildAt(n) == this.mOverflowButton) {
            return false;
        }
        return super.filterLeftoverView(viewGroup, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean flagActionItems() {
        ArrayList<MenuItemImpl> arrayList = this.mMenu.getVisibleItems();
        int n = arrayList.size();
        int n2 = this.mMaxItems;
        int n3 = this.mActionItemWidthLimit;
        int n4 = View.MeasureSpec.makeMeasureSpec(0, 0);
        ViewGroup viewGroup = (ViewGroup)((Object)this.mMenuView);
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            MenuItemImpl menuItemImpl = arrayList.get(i);
            if (menuItemImpl.requiresActionButton()) {
                ++n5;
            } else if (menuItemImpl.requestsActionButton()) {
                ++n6;
            } else {
                bl = true;
            }
            if (!this.mExpandedActionViewsExclusive || !menuItemImpl.isActionViewExpanded()) continue;
            n2 = 0;
        }
        if (this.mReserveOverflow && (bl || n5 + n6 > n2)) {
            --n2;
        }
        int n8 = n2 - n5;
        SparseBooleanArray sparseBooleanArray = this.mActionButtonGroups;
        sparseBooleanArray.clear();
        boolean bl2 = this.mStrictWidthLimit;
        int n9 = 0;
        int n10 = 0;
        if (bl2) {
            n10 = n3 / this.mMinCellSize;
            int n11 = n3 % this.mMinCellSize;
            n9 = this.mMinCellSize + n11 / n10;
        }
        int n12 = 0;
        while (n12 < n) {
            MenuItemImpl menuItemImpl = arrayList.get(n12);
            if (menuItemImpl.requiresActionButton()) {
                int n13;
                View view = this.getItemView(menuItemImpl, this.mScrapActionButtonView, viewGroup);
                if (this.mScrapActionButtonView == null) {
                    this.mScrapActionButtonView = view;
                }
                if (this.mStrictWidthLimit) {
                    n10 -= ActionMenuView.measureChildForCells(view, n9, n10, n4, 0);
                } else {
                    view.measure(n4, n4);
                }
                int n14 = view.getMeasuredWidth();
                n3 -= n14;
                if (n7 == 0) {
                    n7 = n14;
                }
                if ((n13 = menuItemImpl.getGroupId()) != 0) {
                    sparseBooleanArray.put(n13, true);
                }
                menuItemImpl.setIsActionButton(true);
            } else if (menuItemImpl.requestsActionButton()) {
                int n15 = menuItemImpl.getGroupId();
                boolean bl3 = sparseBooleanArray.get(n15);
                boolean bl4 = !(n8 <= 0 && !bl3 || n3 <= 0 || this.mStrictWidthLimit && n10 <= 0);
                if (bl4) {
                    View view = this.getItemView(menuItemImpl, this.mScrapActionButtonView, viewGroup);
                    if (this.mScrapActionButtonView == null) {
                        this.mScrapActionButtonView = view;
                    }
                    if (this.mStrictWidthLimit) {
                        int n16 = ActionMenuView.measureChildForCells(view, n9, n10, n4, 0);
                        n10 -= n16;
                        if (n16 == 0) {
                            bl4 = false;
                        }
                    } else {
                        view.measure(n4, n4);
                    }
                    int n17 = view.getMeasuredWidth();
                    n3 -= n17;
                    if (n7 == 0) {
                        n7 = n17;
                    }
                    if (this.mStrictWidthLimit) {
                        boolean bl5 = n3 >= 0;
                        bl4 &= bl5;
                    } else {
                        boolean bl6 = n3 + n7 > 0;
                        bl4 &= bl6;
                    }
                }
                if (bl4 && n15 != 0) {
                    sparseBooleanArray.put(n15, true);
                } else if (bl3) {
                    sparseBooleanArray.put(n15, false);
                    for (int i = 0; i < n12; ++i) {
                        MenuItemImpl menuItemImpl2 = arrayList.get(i);
                        if (menuItemImpl2.getGroupId() != n15) continue;
                        if (menuItemImpl2.isActionButton()) {
                            ++n8;
                        }
                        menuItemImpl2.setIsActionButton(false);
                    }
                }
                if (bl4) {
                    --n8;
                }
                menuItemImpl.setIsActionButton(bl4);
            } else {
                menuItemImpl.setIsActionButton(false);
            }
            ++n12;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public View getItemView(MenuItemImpl menuItemImpl, View view, ViewGroup viewGroup) {
        View view2 = menuItemImpl.getActionView();
        if (view2 == null || menuItemImpl.hasCollapsibleActionView()) {
            view2 = super.getItemView(menuItemImpl, view, viewGroup);
        }
        int n = menuItemImpl.isActionViewExpanded() ? 8 : 0;
        view2.setVisibility(n);
        ActionMenuView actionMenuView = (ActionMenuView)viewGroup;
        ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
        if (!actionMenuView.checkLayoutParams(layoutParams)) {
            view2.setLayoutParams(actionMenuView.generateLayoutParams(layoutParams));
        }
        return view2;
    }

    @Override
    public MenuView getMenuView(ViewGroup viewGroup) {
        MenuView menuView = super.getMenuView(viewGroup);
        ((ActionMenuView)menuView).setPresenter(this);
        return menuView;
    }

    public boolean hideOverflowMenu() {
        if (this.mPostedOpenRunnable != null && this.mMenuView != null) {
            ((View)((Object)this.mMenuView)).removeCallbacks(this.mPostedOpenRunnable);
            this.mPostedOpenRunnable = null;
            return true;
        }
        OverflowPopup overflowPopup = this.mOverflowPopup;
        if (overflowPopup != null) {
            overflowPopup.dismiss();
            return true;
        }
        return false;
    }

    public boolean hideSubMenus() {
        if (this.mActionButtonPopup != null) {
            this.mActionButtonPopup.dismiss();
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initForMenu(Context context, MenuBuilder menuBuilder) {
        super.initForMenu(context, menuBuilder);
        Resources resources = context.getResources();
        ActionBarPolicy actionBarPolicy = ActionBarPolicy.get(context);
        if (!this.mReserveOverflowSet) {
            this.mReserveOverflow = actionBarPolicy.showsOverflowMenuButton();
        }
        if (!this.mWidthLimitSet) {
            this.mWidthLimit = actionBarPolicy.getEmbeddedMenuWidthLimit();
        }
        if (!this.mMaxItemsSet) {
            this.mMaxItems = actionBarPolicy.getMaxActionButtons();
        }
        int n = this.mWidthLimit;
        if (this.mReserveOverflow) {
            if (this.mOverflowButton == null) {
                this.mOverflowButton = new OverflowMenuButton(this.mSystemContext);
                int n2 = View.MeasureSpec.makeMeasureSpec(0, 0);
                this.mOverflowButton.measure(n2, n2);
            }
            n -= this.mOverflowButton.getMeasuredWidth();
        } else {
            this.mOverflowButton = null;
        }
        this.mActionItemWidthLimit = n;
        this.mMinCellSize = (int)(56.0f * resources.getDisplayMetrics().density);
        this.mScrapActionButtonView = null;
    }

    public boolean isOverflowMenuShowPending() {
        return this.mPostedOpenRunnable != null || this.isOverflowMenuShowing();
    }

    public boolean isOverflowMenuShowing() {
        return this.mOverflowPopup != null && this.mOverflowPopup.isShowing();
    }

    public boolean isOverflowReserved() {
        return this.mReserveOverflow;
    }

    @Override
    public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
        this.dismissPopupMenus();
        super.onCloseMenu(menuBuilder, bl);
    }

    public void onConfigurationChanged(Configuration configuration) {
        if (!this.mMaxItemsSet) {
            this.mMaxItems = this.mContext.getResources().getInteger(17694840);
        }
        if (this.mMenu != null) {
            this.mMenu.onItemsChanged(true);
        }
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        MenuItem menuItem;
        SavedState savedState = (SavedState)parcelable;
        if (savedState.openSubMenuId > 0 && (menuItem = this.mMenu.findItem(savedState.openSubMenuId)) != null) {
            this.onSubMenuSelected((SubMenuBuilder)menuItem.getSubMenu());
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState();
        savedState.openSubMenuId = this.mOpenSubMenuId;
        return savedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onSubMenuSelected(SubMenuBuilder subMenuBuilder) {
        View view;
        block4: {
            block5: {
                block3: {
                    if (!subMenuBuilder.hasVisibleItems()) break block3;
                    SubMenuBuilder subMenuBuilder2 = subMenuBuilder;
                    while (subMenuBuilder2.getParentMenu() != this.mMenu) {
                        subMenuBuilder2 = (SubMenuBuilder)subMenuBuilder2.getParentMenu();
                    }
                    view = this.findViewForItem(subMenuBuilder2.getItem());
                    if (view != null) break block4;
                    if (this.mOverflowButton != null) break block5;
                }
                return false;
            }
            view = this.mOverflowButton;
        }
        this.mOpenSubMenuId = subMenuBuilder.getItem().getItemId();
        this.mActionButtonPopup = new ActionButtonSubmenu(this.mContext, subMenuBuilder);
        this.mActionButtonPopup.setAnchorView(view);
        this.mActionButtonPopup.show();
        super.onSubMenuSelected(subMenuBuilder);
        return true;
    }

    @Override
    public void onSubUiVisibilityChanged(boolean bl) {
        if (bl) {
            super.onSubMenuSelected(null);
            return;
        }
        this.mMenu.close(false);
    }

    public void setExpandedActionViewsExclusive(boolean bl) {
        this.mExpandedActionViewsExclusive = bl;
    }

    public void setItemLimit(int n) {
        this.mMaxItems = n;
        this.mMaxItemsSet = true;
    }

    public void setMenuView(ActionMenuView actionMenuView) {
        this.mMenuView = actionMenuView;
        actionMenuView.initialize(this.mMenu);
    }

    public void setReserveOverflow(boolean bl) {
        this.mReserveOverflow = bl;
        this.mReserveOverflowSet = true;
    }

    public void setWidthLimit(int n, boolean bl) {
        this.mWidthLimit = n;
        this.mStrictWidthLimit = bl;
        this.mWidthLimitSet = true;
    }

    @Override
    public boolean shouldIncludeItem(int n, MenuItemImpl menuItemImpl) {
        return menuItemImpl.isActionButton();
    }

    public boolean showOverflowMenu() {
        if (this.mReserveOverflow && !this.isOverflowMenuShowing() && this.mMenu != null && this.mMenuView != null && this.mPostedOpenRunnable == null && !this.mMenu.getNonActionItems().isEmpty()) {
            this.mPostedOpenRunnable = new OpenOverflowRunnable(new OverflowPopup(this.mContext, this.mMenu, this.mOverflowButton, true));
            ((View)((Object)this.mMenuView)).post(this.mPostedOpenRunnable);
            super.onSubMenuSelected(null);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateMenuView(boolean bl) {
        ViewGroup viewGroup = (ViewGroup)((View)((Object)this.mMenuView)).getParent();
        if (viewGroup != null) {
            ActionBarTransition.beginDelayedTransition(viewGroup);
        }
        super.updateMenuView(bl);
        ((View)((Object)this.mMenuView)).requestLayout();
        if (this.mMenu != null) {
            ArrayList<MenuItemImpl> arrayList = this.mMenu.getActionItems();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ActionProvider actionProvider = arrayList.get(i).getActionProvider();
                if (actionProvider == null) continue;
                actionProvider.setSubUiVisibilityListener(this);
            }
        }
        ArrayList<MenuItemImpl> arrayList = this.mMenu != null ? this.mMenu.getNonActionItems() : null;
        boolean bl2 = this.mReserveOverflow;
        boolean bl3 = false;
        if (bl2) {
            bl3 = false;
            if (arrayList != null) {
                int n = arrayList.size();
                bl3 = n == 1 ? !arrayList.get(0).isActionViewExpanded() : n > 0;
            }
        }
        if (bl3) {
            ViewGroup viewGroup2;
            if (this.mOverflowButton == null) {
                this.mOverflowButton = new OverflowMenuButton(this.mSystemContext);
            }
            if ((viewGroup2 = (ViewGroup)this.mOverflowButton.getParent()) != this.mMenuView) {
                if (viewGroup2 != null) {
                    viewGroup2.removeView(this.mOverflowButton);
                }
                ActionMenuView actionMenuView = (ActionMenuView)this.mMenuView;
                actionMenuView.addView(this.mOverflowButton, actionMenuView.generateOverflowButtonLayoutParams());
            }
        } else if (this.mOverflowButton != null && this.mOverflowButton.getParent() == this.mMenuView) {
            ((ViewGroup)((Object)this.mMenuView)).removeView(this.mOverflowButton);
        }
        ((ActionMenuView)this.mMenuView).setOverflowReserved(this.mReserveOverflow);
    }

    private class ActionButtonSubmenu
    extends MenuPopupHelper {
        private SubMenuBuilder mSubMenu;

        /*
         * Enabled aggressive block sorting
         */
        public ActionButtonSubmenu(Context context, SubMenuBuilder subMenuBuilder) {
            super(context, subMenuBuilder, null, false, 0x1010444);
            this.mSubMenu = subMenuBuilder;
            if (!((MenuItemImpl)subMenuBuilder.getItem()).isActionButton()) {
                View view = ActionMenuPresenter.this.mOverflowButton == null ? (View)((Object)ActionMenuPresenter.this.mMenuView) : ActionMenuPresenter.this.mOverflowButton;
                this.setAnchorView(view);
            }
            this.setCallback(ActionMenuPresenter.this.mPopupPresenterCallback);
            int n = subMenuBuilder.size();
            int n2 = 0;
            while (true) {
                block6: {
                    boolean bl;
                    block5: {
                        bl = false;
                        if (n2 >= n) break block5;
                        MenuItem menuItem = subMenuBuilder.getItem(n2);
                        if (!menuItem.isVisible() || menuItem.getIcon() == null) break block6;
                        bl = true;
                    }
                    this.setForceShowIcon(bl);
                    return;
                }
                ++n2;
            }
        }

        @Override
        public void onDismiss() {
            super.onDismiss();
            ActionMenuPresenter.access$702(ActionMenuPresenter.this, null);
            ActionMenuPresenter.this.mOpenSubMenuId = 0;
        }
    }

    private class ActionMenuPopupCallback
    extends ActionMenuItemView.PopupCallback {
        private ActionMenuPopupCallback() {
        }

        @Override
        public ListPopupWindow getPopup() {
            if (ActionMenuPresenter.this.mActionButtonPopup != null) {
                return ActionMenuPresenter.this.mActionButtonPopup.getPopup();
            }
            return null;
        }
    }

    private class OpenOverflowRunnable
    implements Runnable {
        private OverflowPopup mPopup;

        public OpenOverflowRunnable(OverflowPopup overflowPopup) {
            this.mPopup = overflowPopup;
        }

        @Override
        public void run() {
            ActionMenuPresenter.this.mMenu.changeMenuMode();
            View view = (View)((Object)ActionMenuPresenter.this.mMenuView);
            if (view != null && view.getWindowToken() != null && this.mPopup.tryShow()) {
                ActionMenuPresenter.access$202(ActionMenuPresenter.this, this.mPopup);
            }
            ActionMenuPresenter.access$302(ActionMenuPresenter.this, null);
        }
    }

    private class OverflowMenuButton
    extends ImageButton
    implements ActionMenuView.ActionMenuChildView {
        private final float[] mTempPts;

        public OverflowMenuButton(Context context) {
            super(context, null, 16843510);
            this.mTempPts = new float[2];
            this.setClickable(true);
            this.setFocusable(true);
            this.setVisibility(0);
            this.setEnabled(true);
            this.setOnTouchListener(new ListPopupWindow.ForwardingListener(this){

                @Override
                public ListPopupWindow getPopup() {
                    if (ActionMenuPresenter.this.mOverflowPopup == null) {
                        return null;
                    }
                    return ActionMenuPresenter.this.mOverflowPopup.getPopup();
                }

                @Override
                public boolean onForwardingStarted() {
                    ActionMenuPresenter.this.showOverflowMenu();
                    return true;
                }

                @Override
                public boolean onForwardingStopped() {
                    if (ActionMenuPresenter.this.mPostedOpenRunnable != null) {
                        return false;
                    }
                    ActionMenuPresenter.this.hideOverflowMenu();
                    return true;
                }
            });
        }

        @Override
        public boolean needsDividerAfter() {
            return false;
        }

        @Override
        public boolean needsDividerBefore() {
            return false;
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
            super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
            accessibilityNodeInfo.setCanOpenPopup(true);
        }

        @Override
        public boolean performClick() {
            if (super.performClick()) {
                return true;
            }
            this.playSoundEffect(0);
            ActionMenuPresenter.this.showOverflowMenu();
            return true;
        }

        @Override
        protected boolean setFrame(int n, int n2, int n3, int n4) {
            boolean bl = super.setFrame(n, n2, n3, n4);
            Drawable drawable2 = this.getDrawable();
            Drawable drawable3 = this.getBackground();
            if (drawable2 != null && drawable3 != null) {
                float[] fArray = this.mTempPts;
                fArray[0] = drawable2.getBounds().centerX();
                this.getImageMatrix().mapPoints(fArray);
                int n5 = (int)fArray[0] - this.getWidth() / 2;
                drawable3.setHotspotBounds(n5, 0, n5 + this.getWidth(), this.getHeight());
            }
            return bl;
        }
    }

    private class OverflowPopup
    extends MenuPopupHelper {
        public OverflowPopup(Context context, MenuBuilder menuBuilder, View view, boolean bl) {
            super(context, menuBuilder, view, bl, 0x1010444);
            this.setGravity(0x800005);
            this.setCallback(ActionMenuPresenter.this.mPopupPresenterCallback);
        }

        @Override
        public void onDismiss() {
            super.onDismiss();
            ActionMenuPresenter.this.mMenu.close();
            ActionMenuPresenter.access$202(ActionMenuPresenter.this, null);
        }
    }

    private class PopupPresenterCallback
    implements MenuPresenter.Callback {
        private PopupPresenterCallback() {
        }

        @Override
        public void onCloseMenu(MenuBuilder menuBuilder, boolean bl) {
            MenuPresenter.Callback callback;
            if (menuBuilder instanceof SubMenuBuilder) {
                ((SubMenuBuilder)menuBuilder).getRootMenu().close(false);
            }
            if ((callback = ActionMenuPresenter.this.getCallback()) != null) {
                callback.onCloseMenu(menuBuilder, bl);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean onOpenSubMenu(MenuBuilder menuBuilder) {
            if (menuBuilder == null) {
                return false;
            }
            ActionMenuPresenter.this.mOpenSubMenuId = ((SubMenuBuilder)menuBuilder).getItem().getItemId();
            MenuPresenter.Callback callback = ActionMenuPresenter.this.getCallback();
            if (callback == null) return false;
            return callback.onOpenSubMenu(menuBuilder);
        }
    }

    private static class SavedState
    implements Parcelable {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        public int openSubMenuId;

        SavedState() {
        }

        SavedState(Parcel parcel) {
            this.openSubMenuId = parcel.readInt();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.openSubMenuId);
        }
    }
}

