/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.graphics.Rect;
import android.text.Layout;
import android.text.Spannable;
import android.view.AccessibilityIterators;
import android.widget.TextView;

final class AccessibilityIterators {
    AccessibilityIterators() {
    }

    static class LineTextSegmentIterator
    extends AccessibilityIterators.AbstractTextSegmentIterator {
        protected static final int DIRECTION_END = 1;
        protected static final int DIRECTION_START = -1;
        private static LineTextSegmentIterator sLineInstance;
        protected Layout mLayout;

        LineTextSegmentIterator() {
        }

        public static LineTextSegmentIterator getInstance() {
            if (sLineInstance == null) {
                sLineInstance = new LineTextSegmentIterator();
            }
            return sLineInstance;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int[] following(int n) {
            int n2;
            int n3;
            if (this.mText.length() <= 0 || n >= this.mText.length() || (n3 = n < 0 ? this.mLayout.getLineForOffset(0) : (this.getLineEdgeIndex(n2 = this.mLayout.getLineForOffset(n), -1) == n ? n2 : n2 + 1)) >= this.mLayout.getLineCount()) {
                return null;
            }
            return this.getRange(this.getLineEdgeIndex(n3, -1), 1 + this.getLineEdgeIndex(n3, 1));
        }

        protected int getLineEdgeIndex(int n, int n2) {
            if (n2 * this.mLayout.getParagraphDirection(n) < 0) {
                return this.mLayout.getLineStart(n);
            }
            return -1 + this.mLayout.getLineEnd(n);
        }

        public void initialize(Spannable spannable, Layout layout2) {
            this.mText = spannable.toString();
            this.mLayout = layout2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int[] preceding(int n) {
            int n2;
            int n3;
            if (this.mText.length() <= 0 || n <= 0 || (n3 = n > this.mText.length() ? this.mLayout.getLineForOffset(this.mText.length()) : (1 + this.getLineEdgeIndex(n2 = this.mLayout.getLineForOffset(n), 1) == n ? n2 : n2 - 1)) < 0) {
                return null;
            }
            return this.getRange(this.getLineEdgeIndex(n3, -1), 1 + this.getLineEdgeIndex(n3, 1));
        }
    }

    static class PageTextSegmentIterator
    extends LineTextSegmentIterator {
        private static PageTextSegmentIterator sPageInstance;
        private final Rect mTempRect = new Rect();
        private TextView mView;

        PageTextSegmentIterator() {
        }

        public static PageTextSegmentIterator getInstance() {
            if (sPageInstance == null) {
                sPageInstance = new PageTextSegmentIterator();
            }
            return sPageInstance;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int[] following(int n) {
            int n2;
            if (this.mText.length() <= 0) {
                return null;
            }
            if (n >= this.mText.length()) return null;
            if (!this.mView.getGlobalVisibleRect(this.mTempRect)) return null;
            int n3 = Math.max(0, n);
            int n4 = this.mLayout.getLineForOffset(n3);
            int n5 = this.mLayout.getLineTop(n4) + (this.mTempRect.height() - this.mView.getTotalPaddingTop() - this.mView.getTotalPaddingBottom());
            if (n5 < this.mLayout.getLineTop(-1 + this.mLayout.getLineCount())) {
                n2 = -1 + this.mLayout.getLineForVertical(n5);
                return this.getRange(n3, 1 + this.getLineEdgeIndex(n2, 1));
            }
            n2 = -1 + this.mLayout.getLineCount();
            return this.getRange(n3, 1 + this.getLineEdgeIndex(n2, 1));
        }

        public void initialize(TextView textView) {
            super.initialize((Spannable)textView.getIterableTextForAccessibility(), textView.getLayout());
            this.mView = textView;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int[] preceding(int n) {
            int n2;
            if (this.mText.length() <= 0) {
                return null;
            }
            if (n <= 0) return null;
            if (!this.mView.getGlobalVisibleRect(this.mTempRect)) return null;
            int n3 = Math.min(this.mText.length(), n);
            int n4 = this.mLayout.getLineForOffset(n3);
            int n5 = this.mLayout.getLineTop(n4) - (this.mTempRect.height() - this.mView.getTotalPaddingTop() - this.mView.getTotalPaddingBottom());
            if (n5 > 0) {
                n2 = 1 + this.mLayout.getLineForVertical(n5);
                return this.getRange(this.getLineEdgeIndex(n2, -1), n3);
            }
            n2 = 0;
            return this.getRange(this.getLineEdgeIndex(n2, -1), n3);
        }
    }
}

