/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.os.Trace;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.StateSet;
import android.view.ActionMode;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.EdgeEffect;
import android.widget.EditText;
import android.widget.FastScroller;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListAdapter;
import android.widget.OverScroller;
import android.widget.PopupWindow;
import android.widget.RemoteViews;
import android.widget.RemoteViewsAdapter;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.List;

public abstract class AbsListView
extends AdapterView<ListAdapter>
implements TextWatcher,
ViewTreeObserver.OnGlobalLayoutListener,
Filter.FilterListener,
ViewTreeObserver.OnTouchModeChangeListener,
RemoteViewsAdapter.RemoteAdapterConnectionCallback {
    private static final int CHECK_POSITION_SEARCH_DISTANCE = 20;
    public static final int CHOICE_MODE_MULTIPLE = 2;
    public static final int CHOICE_MODE_MULTIPLE_MODAL = 3;
    public static final int CHOICE_MODE_NONE = 0;
    public static final int CHOICE_MODE_SINGLE = 1;
    private static final int INVALID_POINTER = -1;
    static final int LAYOUT_FORCE_BOTTOM = 3;
    static final int LAYOUT_FORCE_TOP = 1;
    static final int LAYOUT_MOVE_SELECTION = 6;
    static final int LAYOUT_NORMAL = 0;
    static final int LAYOUT_SET_SELECTION = 2;
    static final int LAYOUT_SPECIFIC = 4;
    static final int LAYOUT_SYNC = 5;
    static final int OVERSCROLL_LIMIT_DIVISOR = 3;
    private static final boolean PROFILE_FLINGING = false;
    private static final boolean PROFILE_SCROLLING = false;
    private static final String TAG = "AbsListView";
    static final int TOUCH_MODE_DONE_WAITING = 2;
    static final int TOUCH_MODE_DOWN = 0;
    static final int TOUCH_MODE_FLING = 4;
    private static final int TOUCH_MODE_OFF = 1;
    private static final int TOUCH_MODE_ON = 0;
    static final int TOUCH_MODE_OVERFLING = 6;
    static final int TOUCH_MODE_OVERSCROLL = 5;
    static final int TOUCH_MODE_REST = -1;
    static final int TOUCH_MODE_SCROLL = 3;
    static final int TOUCH_MODE_TAP = 1;
    private static final int TOUCH_MODE_UNKNOWN = -1;
    public static final int TRANSCRIPT_MODE_ALWAYS_SCROLL = 2;
    public static final int TRANSCRIPT_MODE_DISABLED = 0;
    public static final int TRANSCRIPT_MODE_NORMAL = 1;
    static final Interpolator sLinearInterpolator = new LinearInterpolator();
    private ListItemAccessibilityDelegate mAccessibilityDelegate;
    private int mActivePointerId = -1;
    ListAdapter mAdapter;
    boolean mAdapterHasStableIds;
    private int mCacheColorHint;
    boolean mCachingActive;
    boolean mCachingStarted;
    SparseBooleanArray mCheckStates;
    LongSparseArray<Integer> mCheckedIdStates;
    int mCheckedItemCount;
    ActionMode mChoiceActionMode;
    int mChoiceMode = 0;
    private Runnable mClearScrollingCache;
    private ContextMenu.ContextMenuInfo mContextMenuInfo = null;
    AdapterDataSetObserver mDataSetObserver;
    private InputConnection mDefInputConnection;
    private boolean mDeferNotifyDataSetChanged = false;
    private float mDensityScale;
    private int mDirection = 0;
    boolean mDrawSelectorOnTop = false;
    private EdgeEffect mEdgeGlowBottom;
    private EdgeEffect mEdgeGlowTop;
    private FastScroller mFastScroll;
    boolean mFastScrollAlwaysVisible;
    boolean mFastScrollEnabled;
    private int mFastScrollStyle;
    private boolean mFiltered;
    private int mFirstPositionDistanceGuess;
    private boolean mFlingProfilingStarted = false;
    private FlingRunnable mFlingRunnable;
    private StrictMode.Span mFlingStrictSpan = null;
    private boolean mForceTranscriptScroll;
    private boolean mGlobalLayoutListenerAddedFilter;
    private int mGlowPaddingLeft;
    private int mGlowPaddingRight;
    private boolean mIsChildViewEnabled;
    private boolean mIsDetaching;
    final boolean[] mIsScrap;
    private int mLastAccessibilityScrollEventFromIndex;
    private int mLastAccessibilityScrollEventToIndex;
    private int mLastHandledItemCount;
    private int mLastPositionDistanceGuess;
    private int mLastScrollState = 0;
    private int mLastTouchMode = -1;
    int mLastY;
    int mLayoutMode = 0;
    Rect mListPadding;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    int mMotionCorrection;
    int mMotionPosition;
    int mMotionViewNewTop;
    int mMotionViewOriginalTop;
    int mMotionX;
    int mMotionY;
    MultiChoiceModeWrapper mMultiChoiceModeCallback;
    private int mNestedYOffset = 0;
    private OnScrollListener mOnScrollListener;
    int mOverflingDistance;
    int mOverscrollDistance;
    int mOverscrollMax;
    private final Thread mOwnerThread;
    private CheckForKeyLongPress mPendingCheckForKeyLongPress;
    private CheckForLongPress mPendingCheckForLongPress;
    private CheckForTap mPendingCheckForTap;
    private SavedState mPendingSync;
    private PerformClick mPerformClick;
    PopupWindow mPopup;
    private boolean mPopupHidden;
    Runnable mPositionScrollAfterLayout;
    AbsPositionScroller mPositionScroller;
    private InputConnectionWrapper mPublicInputConnection;
    final RecycleBin mRecycler;
    private RemoteViewsAdapter mRemoteAdapter;
    int mResurrectToPosition = -1;
    private final int[] mScrollConsumed;
    View mScrollDown;
    private final int[] mScrollOffset;
    private boolean mScrollProfilingStarted = false;
    private StrictMode.Span mScrollStrictSpan = null;
    View mScrollUp;
    boolean mScrollingCacheEnabled;
    int mSelectedTop = 0;
    int mSelectionBottomPadding = 0;
    int mSelectionLeftPadding = 0;
    int mSelectionRightPadding = 0;
    int mSelectionTopPadding = 0;
    Drawable mSelector;
    int mSelectorPosition = -1;
    Rect mSelectorRect = new Rect();
    private boolean mSmoothScrollbarEnabled = true;
    boolean mStackFromBottom;
    EditText mTextFilter;
    private boolean mTextFilterEnabled;
    private Rect mTouchFrame;
    int mTouchMode = -1;
    private Runnable mTouchModeReset;
    private int mTouchSlop;
    private int mTranscriptMode;
    private float mVelocityScale = 1.0f;
    private VelocityTracker mVelocityTracker;
    int mWidthMeasureSpec = 0;

    public AbsListView(Context context) {
        super(context);
        this.mRecycler = new RecycleBin();
        this.mListPadding = new Rect();
        this.mIsScrap = new boolean[1];
        this.mScrollOffset = new int[2];
        this.mScrollConsumed = new int[2];
        this.initAbsListView();
        this.mOwnerThread = Thread.currentThread();
        this.setVerticalScrollBarEnabled(true);
        TypedArray typedArray = context.obtainStyledAttributes(R.styleable.View);
        this.initializeScrollbarsInternal(typedArray);
        typedArray.recycle();
    }

    public AbsListView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842858);
    }

    public AbsListView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public AbsListView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mRecycler = new RecycleBin();
        this.mListPadding = new Rect();
        this.mIsScrap = new boolean[1];
        this.mScrollOffset = new int[2];
        this.mScrollConsumed = new int[2];
        this.initAbsListView();
        this.mOwnerThread = Thread.currentThread();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.AbsListView, n, n2);
        Drawable drawable2 = typedArray.getDrawable(0);
        if (drawable2 != null) {
            this.setSelector(drawable2);
        }
        this.mDrawSelectorOnTop = typedArray.getBoolean(1, false);
        this.setStackFromBottom(typedArray.getBoolean(2, false));
        this.setScrollingCacheEnabled(typedArray.getBoolean(3, true));
        this.setTextFilterEnabled(typedArray.getBoolean(4, false));
        this.setTranscriptMode(typedArray.getInt(5, 0));
        this.setCacheColorHint(typedArray.getColor(6, 0));
        this.setFastScrollEnabled(typedArray.getBoolean(8, false));
        this.setFastScrollStyle(typedArray.getResourceId(11, 0));
        this.setSmoothScrollbarEnabled(typedArray.getBoolean(9, true));
        this.setChoiceMode(typedArray.getInt(7, 0));
        this.setFastScrollAlwaysVisible(typedArray.getBoolean(10, false));
        typedArray.recycle();
    }

    private boolean acceptFilter() {
        return this.mTextFilterEnabled && this.getAdapter() instanceof Filterable && ((Filterable)this.getAdapter()).getFilter() != null;
    }

    static /* synthetic */ Runnable access$1102(AbsListView absListView, Runnable runnable) {
        absListView.mTouchModeReset = runnable;
        return runnable;
    }

    static /* synthetic */ StrictMode.Span access$1802(AbsListView absListView, StrictMode.Span span) {
        absListView.mFlingStrictSpan = span;
        return span;
    }

    static /* synthetic */ CheckForLongPress access$702(AbsListView absListView, CheckForLongPress checkForLongPress) {
        absListView.mPendingCheckForLongPress = checkForLongPress;
        return checkForLongPress;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean canScrollDown() {
        int n = this.getChildCount();
        if (n + this.mFirstPosition < this.mItemCount) {
            return true;
        }
        boolean bl = false;
        if (bl) return bl;
        if (n <= 0) return bl;
        if (this.getChildAt(n - 1).getBottom() > this.mBottom - this.mListPadding.bottom) return true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean canScrollUp() {
        if (this.mFirstPosition > 0) {
            return true;
        }
        boolean bl = false;
        if (bl) return bl;
        if (this.getChildCount() <= 0) return bl;
        if (this.getChildAt(0).getTop() < this.mListPadding.top) return true;
        return false;
    }

    private void clearScrollingCache() {
        if (!this.isHardwareAccelerated()) {
            if (this.mClearScrollingCache == null) {
                this.mClearScrollingCache = new Runnable(){

                    @Override
                    public void run() {
                        if (AbsListView.this.mCachingStarted) {
                            AbsListView absListView = AbsListView.this;
                            AbsListView.this.mCachingActive = false;
                            absListView.mCachingStarted = false;
                            AbsListView.this.setChildrenDrawnWithCacheEnabled(false);
                            if ((2 & AbsListView.this.mPersistentDrawingCache) == 0) {
                                AbsListView.this.setChildrenDrawingCacheEnabled(false);
                            }
                            if (!AbsListView.this.isAlwaysDrawnWithCacheEnabled()) {
                                AbsListView.this.invalidate();
                            }
                        }
                    }
                };
            }
            this.post(this.mClearScrollingCache);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean contentFits() {
        block5: {
            block4: {
                int n = this.getChildCount();
                if (n == 0) break block4;
                if (n != this.mItemCount) {
                    return false;
                }
                if (this.getChildAt(0).getTop() < this.mListPadding.top || this.getChildAt(n - 1).getBottom() > this.getHeight() - this.mListPadding.bottom) break block5;
            }
            return true;
        }
        return false;
    }

    private void createScrollingCache() {
        if (this.mScrollingCacheEnabled && !this.mCachingStarted && !this.isHardwareAccelerated()) {
            this.setChildrenDrawnWithCacheEnabled(true);
            this.setChildrenDrawingCacheEnabled(true);
            this.mCachingActive = true;
            this.mCachingStarted = true;
        }
    }

    private void createTextFilter(boolean bl) {
        if (this.mPopup == null) {
            PopupWindow popupWindow = new PopupWindow(this.getContext());
            popupWindow.setFocusable(false);
            popupWindow.setTouchable(false);
            popupWindow.setInputMethodMode(2);
            popupWindow.setContentView(this.getTextFilterInput());
            popupWindow.setWidth(-2);
            popupWindow.setHeight(-2);
            popupWindow.setBackgroundDrawable(null);
            this.mPopup = popupWindow;
            this.getViewTreeObserver().addOnGlobalLayoutListener(this);
            this.mGlobalLayoutListenerAddedFilter = true;
        }
        if (bl) {
            this.mPopup.setAnimationStyle(16974553);
            return;
        }
        this.mPopup.setAnimationStyle(16974554);
    }

    private void dismissPopup() {
        if (this.mPopup != null) {
            this.mPopup.dismiss();
        }
    }

    private void drawSelector(Canvas canvas) {
        if (!this.mSelectorRect.isEmpty()) {
            Drawable drawable2 = this.mSelector;
            drawable2.setBounds(this.mSelectorRect);
            drawable2.draw(canvas);
        }
    }

    private void finishGlows() {
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.finish();
            this.mEdgeGlowBottom.finish();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static int getDistance(Rect rect, Rect rect2, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        switch (n) {
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT, FOCUS_FORWARD, FOCUS_BACKWARD}.");
            }
            case 66: {
                n5 = rect.right;
                n4 = rect.top + rect.height() / 2;
                n3 = rect2.left;
                n2 = rect2.top + rect2.height() / 2;
                break;
            }
            case 130: {
                n5 = rect.left + rect.width() / 2;
                n4 = rect.bottom;
                n3 = rect2.left + rect2.width() / 2;
                n2 = rect2.top;
                break;
            }
            case 17: {
                n5 = rect.left;
                n4 = rect.top + rect.height() / 2;
                n3 = rect2.right;
                n2 = rect2.top + rect2.height() / 2;
                break;
            }
            case 33: {
                n5 = rect.left + rect.width() / 2;
                n4 = rect.top;
                n3 = rect2.left + rect2.width() / 2;
                n2 = rect2.bottom;
                break;
            }
            case 1: 
            case 2: {
                n5 = rect.right + rect.width() / 2;
                n4 = rect.top + rect.height() / 2;
                n3 = rect2.left + rect2.width() / 2;
                n2 = rect2.top + rect2.height() / 2;
            }
        }
        int n6 = n3 - n5;
        int n7 = n2 - n4;
        return n7 * n7 + n6 * n6;
    }

    private EditText getTextFilterInput() {
        if (this.mTextFilter == null) {
            this.mTextFilter = (EditText)LayoutInflater.from(this.getContext()).inflate(0x1090100, null);
            this.mTextFilter.setRawInputType(177);
            this.mTextFilter.setImeOptions(0x10000000);
            this.mTextFilter.addTextChangedListener(this);
        }
        return this.mTextFilter;
    }

    private void initAbsListView() {
        this.setClickable(true);
        this.setFocusableInTouchMode(true);
        this.setWillNotDraw(false);
        this.setAlwaysDrawnWithCacheEnabled(false);
        this.setScrollingCacheEnabled(true);
        ViewConfiguration viewConfiguration = ViewConfiguration.get(this.mContext);
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
        this.mMinimumVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mOverscrollDistance = viewConfiguration.getScaledOverscrollDistance();
        this.mOverflingDistance = viewConfiguration.getScaledOverflingDistance();
        this.mDensityScale = this.getContext().getResources().getDisplayMetrics().density;
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
            return;
        }
        this.mVelocityTracker.clear();
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private boolean isOwnerThread() {
        return this.mOwnerThread == Thread.currentThread();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        int n = (0xFF00 & motionEvent.getAction()) >> 8;
        if (motionEvent.getPointerId(n) == this.mActivePointerId) {
            int n2 = n == 0 ? 1 : 0;
            this.mMotionX = (int)motionEvent.getX(n2);
            this.mMotionY = (int)motionEvent.getY(n2);
            this.mMotionCorrection = 0;
            this.mActivePointerId = motionEvent.getPointerId(n2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onTouchCancel() {
        switch (this.mTouchMode) {
            default: {
                this.mTouchMode = -1;
                this.setPressed(false);
                View view = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                if (view != null) {
                    view.setPressed(false);
                }
                this.clearScrollingCache();
                this.removeCallbacks(this.mPendingCheckForLongPress);
                this.recycleVelocityTracker();
            }
            case 6: {
                break;
            }
            case 5: {
                if (this.mFlingRunnable == null) {
                    this.mFlingRunnable = new FlingRunnable();
                }
                this.mFlingRunnable.startSpringback();
            }
        }
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
        }
        this.mActivePointerId = -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onTouchDown(MotionEvent motionEvent) {
        this.mActivePointerId = motionEvent.getPointerId(0);
        boolean bl = (2 & motionEvent.getButtonState()) != 0 && motionEvent.getSource() == 8194;
        if (this.mTouchMode == 6) {
            this.mFlingRunnable.endFling();
            if (this.mPositionScroller != null) {
                this.mPositionScroller.stop();
            }
            this.mTouchMode = 5;
            this.mMotionX = (int)motionEvent.getX();
            this.mLastY = this.mMotionY = (int)motionEvent.getY();
            this.mMotionCorrection = 0;
            this.mDirection = 0;
        } else {
            int n = (int)motionEvent.getX();
            int n2 = (int)motionEvent.getY();
            int n3 = this.pointToPosition(n, n2);
            if (!this.mDataChanged) {
                if (this.mTouchMode == 4) {
                    this.createScrollingCache();
                    this.mTouchMode = 3;
                    this.mMotionCorrection = 0;
                    n3 = this.findMotionRow(n2);
                    this.mFlingRunnable.flywheelTouch();
                } else if (n3 >= 0 && ((ListAdapter)this.getAdapter()).isEnabled(n3)) {
                    this.mTouchMode = 0;
                    if (this.mPendingCheckForTap == null) {
                        this.mPendingCheckForTap = new CheckForTap();
                    }
                    this.mPendingCheckForTap.x = motionEvent.getX();
                    this.mPendingCheckForTap.y = motionEvent.getY();
                    this.mPendingCheckForTap.isMouseButtonSecondary = false;
                    if (bl) {
                        this.mPendingCheckForTap.isMouseButtonSecondary = true;
                        this.post(this.mPendingCheckForTap);
                    } else {
                        this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                    }
                }
            }
            if (n3 >= 0) {
                this.mMotionViewOriginalTop = this.getChildAt(n3 - this.mFirstPosition).getTop();
            }
            this.mMotionX = n;
            this.mMotionY = n2;
            this.mMotionPosition = n3;
            this.mLastY = Integer.MIN_VALUE;
        }
        if (this.mTouchMode == 0 && this.mMotionPosition != -1 && !bl && this.performButtonActionOnTouchDown(motionEvent)) {
            this.removeCallbacks(this.mPendingCheckForTap);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void onTouchMove(MotionEvent motionEvent, MotionEvent motionEvent2) {
        int n = motionEvent.findPointerIndex(this.mActivePointerId);
        if (n == -1) {
            n = 0;
            this.mActivePointerId = motionEvent.getPointerId(0);
        }
        if (this.mDataChanged) {
            this.layoutChildren();
        }
        int n2 = (int)motionEvent.getY(n);
        switch (this.mTouchMode) {
            default: {
                return;
            }
            case 0: 
            case 1: 
            case 2: {
                void var6_7;
                if (this.startScrollIfNeeded((int)motionEvent.getX(n), n2, motionEvent2)) return;
                if (this.pointInView(motionEvent.getX(n), n2, this.mTouchSlop)) return;
                this.setPressed(false);
                View view = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                if (view != null) {
                    view.setPressed(false);
                }
                if (this.mTouchMode == 0) {
                    CheckForTap checkForTap = this.mPendingCheckForTap;
                } else {
                    CheckForLongPress checkForLongPress = this.mPendingCheckForLongPress;
                }
                this.removeCallbacks((Runnable)var6_7);
                this.mTouchMode = 2;
                this.updateSelectorState();
                return;
            }
            case 3: 
            case 5: 
        }
        this.scrollIfNeeded((int)motionEvent.getX(n), n2, motionEvent2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void onTouchUp(MotionEvent motionEvent) {
        switch (this.mTouchMode) {
            case 0: 
            case 1: 
            case 2: {
                int n = this.mMotionPosition;
                final View view = this.getChildAt(n - this.mFirstPosition);
                if (view != null) {
                    float f;
                    boolean bl;
                    if (this.mTouchMode != 0) {
                        view.setPressed(false);
                    }
                    if ((bl = (f = motionEvent.getX()) > (float)this.mListPadding.left && f < (float)(this.getWidth() - this.mListPadding.right)) && !view.hasFocusable()) {
                        if (this.mPerformClick == null) {
                            PerformClick performClick;
                            this.mPerformClick = performClick = new PerformClick();
                        }
                        final PerformClick performClick = this.mPerformClick;
                        performClick.mClickMotionPosition = n;
                        performClick.rememberWindowAttachCount();
                        this.mResurrectToPosition = n;
                        if (this.mTouchMode == 0 || this.mTouchMode == 1) {
                            void var23_9;
                            if (this.mTouchMode == 0) {
                                CheckForTap checkForTap = this.mPendingCheckForTap;
                            } else {
                                CheckForLongPress checkForLongPress = this.mPendingCheckForLongPress;
                            }
                            this.removeCallbacks((Runnable)var23_9);
                            this.mLayoutMode = 0;
                            if (!this.mDataChanged && this.mAdapter.isEnabled(n)) {
                                Runnable runnable;
                                this.mTouchMode = 1;
                                this.setSelectedPositionInt(this.mMotionPosition);
                                this.layoutChildren();
                                view.setPressed(true);
                                this.positionSelector(this.mMotionPosition, view);
                                this.setPressed(true);
                                if (this.mSelector != null) {
                                    Drawable drawable2 = this.mSelector.getCurrent();
                                    if (drawable2 != null && drawable2 instanceof TransitionDrawable) {
                                        ((TransitionDrawable)drawable2).resetTransition();
                                    }
                                    this.mSelector.setHotspot(f, motionEvent.getY());
                                }
                                if (this.mTouchModeReset != null) {
                                    this.removeCallbacks(this.mTouchModeReset);
                                }
                                this.mTouchModeReset = runnable = new Runnable(){

                                    @Override
                                    public void run() {
                                        AbsListView.access$1102(AbsListView.this, null);
                                        AbsListView.this.mTouchMode = -1;
                                        view.setPressed(false);
                                        AbsListView.this.setPressed(false);
                                        if (!AbsListView.this.mDataChanged && !AbsListView.this.mIsDetaching && AbsListView.this.isAttachedToWindow()) {
                                            performClick.run();
                                        }
                                    }
                                };
                                this.postDelayed(this.mTouchModeReset, ViewConfiguration.getPressedStateDuration());
                                return;
                            }
                            this.mTouchMode = -1;
                            this.updateSelectorState();
                            return;
                        }
                        if (!this.mDataChanged && this.mAdapter.isEnabled(n)) {
                            performClick.run();
                        }
                    }
                }
                this.mTouchMode = -1;
                this.updateSelectorState();
                break;
            }
            case 3: {
                int n = this.getChildCount();
                if (n > 0) {
                    int n2 = this.getChildAt(0).getTop();
                    int n3 = this.getChildAt(n - 1).getBottom();
                    int n4 = this.mListPadding.top;
                    int n5 = this.getHeight() - this.mListPadding.bottom;
                    if (this.mFirstPosition == 0 && n2 >= n4 && n + this.mFirstPosition < this.mItemCount && n3 <= this.getHeight() - n5) {
                        this.mTouchMode = -1;
                        this.reportScrollStateChange(0);
                        break;
                    }
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                    int n6 = (int)(velocityTracker.getYVelocity(this.mActivePointerId) * this.mVelocityScale);
                    boolean bl = Math.abs(n6) > this.mMinimumVelocity;
                    if (!(!bl || this.mFirstPosition == 0 && n2 == n4 - this.mOverscrollDistance || n + this.mFirstPosition == this.mItemCount && n3 == n5 + this.mOverscrollDistance)) {
                        if (!this.dispatchNestedPreFling(0.0f, -n6)) {
                            if (this.mFlingRunnable == null) {
                                FlingRunnable flingRunnable;
                                this.mFlingRunnable = flingRunnable = new FlingRunnable();
                            }
                            this.reportScrollStateChange(2);
                            this.mFlingRunnable.start(-n6);
                            this.dispatchNestedFling(0.0f, -n6, true);
                            break;
                        }
                        this.mTouchMode = -1;
                        this.reportScrollStateChange(0);
                        break;
                    }
                    this.mTouchMode = -1;
                    this.reportScrollStateChange(0);
                    if (this.mFlingRunnable != null) {
                        this.mFlingRunnable.endFling();
                    }
                    if (this.mPositionScroller != null) {
                        this.mPositionScroller.stop();
                    }
                    if (!bl || this.dispatchNestedPreFling(0.0f, -n6)) break;
                    this.dispatchNestedFling(0.0f, -n6, false);
                    break;
                }
                this.mTouchMode = -1;
                this.reportScrollStateChange(0);
                break;
            }
            case 5: {
                if (this.mFlingRunnable == null) {
                    FlingRunnable flingRunnable;
                    this.mFlingRunnable = flingRunnable = new FlingRunnable();
                }
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                int n = (int)velocityTracker.getYVelocity(this.mActivePointerId);
                this.reportScrollStateChange(2);
                if (Math.abs(n) > this.mMinimumVelocity) {
                    this.mFlingRunnable.startOverfling(-n);
                    break;
                }
                this.mFlingRunnable.startSpringback();
                break;
            }
        }
        this.setPressed(false);
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
        }
        this.invalidate();
        this.removeCallbacks(this.mPendingCheckForLongPress);
        this.recycleVelocityTracker();
        this.mActivePointerId = -1;
        if (this.mScrollStrictSpan != null) {
            this.mScrollStrictSpan.finish();
            this.mScrollStrictSpan = null;
        }
    }

    private void positionPopup() {
        int n = this.getResources().getDisplayMetrics().heightPixels;
        int[] nArray = new int[2];
        this.getLocationOnScreen(nArray);
        int n2 = n - nArray[1] - this.getHeight() + (int)(20.0f * this.mDensityScale);
        if (!this.mPopup.isShowing()) {
            this.mPopup.showAtLocation(this, 81, nArray[0], n2);
            return;
        }
        this.mPopup.update(nArray[0], n2, -1, -1);
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scrollIfNeeded(int n, int n2, MotionEvent motionEvent) {
        int n3;
        int n4;
        int n5;
        int n6;
        block32: {
            int n7;
            block33: {
                block34: {
                    boolean bl;
                    int n8;
                    block36: {
                        int n9;
                        block35: {
                            ViewParent viewParent;
                            n6 = n2 - this.mMotionY;
                            if (this.mLastY == Integer.MIN_VALUE) {
                                n6 -= this.mMotionCorrection;
                            }
                            int n10 = this.mLastY != Integer.MIN_VALUE ? this.mLastY - n2 : -n6;
                            boolean bl2 = this.dispatchNestedPreScroll(0, n10, this.mScrollConsumed, this.mScrollOffset);
                            int n11 = 0;
                            n5 = 0;
                            if (bl2) {
                                n6 += this.mScrollConsumed[1];
                                n5 = -this.mScrollOffset[1];
                                n11 = this.mScrollConsumed[1];
                                if (motionEvent != null) {
                                    motionEvent.offsetLocation(0.0f, this.mScrollOffset[1]);
                                    this.mNestedYOffset += this.mScrollOffset[1];
                                }
                            }
                            int n12 = n6;
                            n4 = this.mLastY != Integer.MIN_VALUE ? n11 + (n2 - this.mLastY) : n12;
                            if (this.mTouchMode != 3) break block32;
                            if (this.mScrollStrictSpan == null) {
                                this.mScrollStrictSpan = StrictMode.enterCriticalSpan("AbsListView-scroll");
                            }
                            if (n2 == this.mLastY) return;
                            if ((0x80000 & this.mGroupFlags) == 0 && Math.abs(n6) > this.mTouchSlop && (viewParent = this.getParent()) != null) {
                                viewParent.requestDisallowInterceptTouchEvent(true);
                            }
                            int n13 = this.mMotionPosition >= 0 ? this.mMotionPosition - this.mFirstPosition : this.getChildCount() / 2;
                            View view = this.getChildAt(n13);
                            int n14 = 0;
                            if (view != null) {
                                n14 = view.getTop();
                            }
                            boolean bl3 = false;
                            if (n4 != 0) {
                                bl3 = this.trackMotionScroll(n12, n4);
                            }
                            View view2 = this.getChildAt(n13);
                            n7 = 0;
                            if (view2 == null) break block33;
                            int n15 = view2.getTop();
                            n7 = 0;
                            if (!bl3) break block34;
                            n8 = -n4 - (n15 - n14);
                            if (!this.dispatchNestedScroll(0, n8 - n4, 0, n8, this.mScrollOffset)) break block35;
                            n7 = 0 - this.mScrollOffset[1];
                            if (motionEvent != null) {
                                motionEvent.offsetLocation(0.0f, this.mScrollOffset[1]);
                                this.mNestedYOffset += this.mScrollOffset[1];
                            }
                            break block34;
                        }
                        bl = this.overScrollBy(0, n8, 0, this.mScrollY, 0, 0, 0, this.mOverscrollDistance, true);
                        if (bl && this.mVelocityTracker != null) {
                            this.mVelocityTracker.clear();
                        }
                        if ((n9 = this.getOverScrollMode()) == 0) break block36;
                        n7 = 0;
                        if (n9 != 1) break block34;
                        boolean bl4 = this.contentFits();
                        n7 = 0;
                        if (bl4) break block34;
                    }
                    if (!bl) {
                        this.mDirection = 0;
                        this.mTouchMode = 5;
                    }
                    if (n4 > 0) {
                        this.mEdgeGlowTop.onPull((float)(-n8) / (float)this.getHeight(), (float)n / (float)this.getWidth());
                        if (!this.mEdgeGlowBottom.isFinished()) {
                            this.mEdgeGlowBottom.onRelease();
                        }
                        this.invalidate(0, 0, this.getWidth(), this.mEdgeGlowTop.getMaxHeight() + this.getPaddingTop());
                        n7 = 0;
                    } else {
                        n7 = 0;
                        if (n4 < 0) {
                            this.mEdgeGlowBottom.onPull((float)n8 / (float)this.getHeight(), 1.0f - (float)n / (float)this.getWidth());
                            if (!this.mEdgeGlowTop.isFinished()) {
                                this.mEdgeGlowTop.onRelease();
                            }
                            this.invalidate(0, this.getHeight() - this.getPaddingBottom() - this.mEdgeGlowBottom.getMaxHeight(), this.getWidth(), this.getHeight());
                            n7 = 0;
                        }
                    }
                }
                this.mMotionY = n5 + (n2 + n7);
            }
            this.mLastY = n5 + (n2 + n7);
            return;
        }
        if (this.mTouchMode != 5 || n2 == this.mLastY) return;
        int n16 = this.mScrollY;
        int n17 = n16 - n4;
        int n18 = n2 > this.mLastY ? 1 : -1;
        if (this.mDirection == 0) {
            this.mDirection = n18;
        }
        int n19 = -n4;
        if (n17 < 0 && n16 >= 0 || n17 > 0 && n16 <= 0) {
            n19 = -n16;
            n3 = n4 + n19;
        } else {
            n3 = 0;
        }
        if (n19 != 0) {
            this.overScrollBy(0, n19, 0, this.mScrollY, 0, 0, 0, this.mOverscrollDistance, true);
            int n20 = this.getOverScrollMode();
            if (n20 == 0 || n20 == 1 && !this.contentFits()) {
                if (n6 > 0) {
                    this.mEdgeGlowTop.onPull((float)n19 / (float)this.getHeight(), (float)n / (float)this.getWidth());
                    if (!this.mEdgeGlowBottom.isFinished()) {
                        this.mEdgeGlowBottom.onRelease();
                    }
                    this.invalidate(0, 0, this.getWidth(), this.mEdgeGlowTop.getMaxHeight() + this.getPaddingTop());
                } else if (n6 < 0) {
                    this.mEdgeGlowBottom.onPull((float)n19 / (float)this.getHeight(), 1.0f - (float)n / (float)this.getWidth());
                    if (!this.mEdgeGlowTop.isFinished()) {
                        this.mEdgeGlowTop.onRelease();
                    }
                    this.invalidate(0, this.getHeight() - this.getPaddingBottom() - this.mEdgeGlowBottom.getMaxHeight(), this.getWidth(), this.getHeight());
                }
            }
        }
        if (n3 != 0) {
            if (this.mScrollY != 0) {
                this.mScrollY = 0;
                this.invalidateParentIfNeeded();
            }
            this.trackMotionScroll(n3, n3);
            this.mTouchMode = 3;
            int n21 = this.findClosestMotionRow(n2);
            this.mMotionCorrection = 0;
            View view = this.getChildAt(n21 - this.mFirstPosition);
            int n22 = view != null ? view.getTop() : 0;
            this.mMotionViewOriginalTop = n22;
            this.mMotionY = n2 + n5;
            this.mMotionPosition = n21;
        }
        this.mLastY = n5 + (n2 + 0);
        this.mDirection = n18;
    }

    private void setFastScrollerAlwaysVisibleUiThread(boolean bl) {
        if (this.mFastScroll != null) {
            this.mFastScroll.setAlwaysShow(bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setFastScrollerEnabledUiThread(boolean bl) {
        if (this.mFastScroll != null) {
            this.mFastScroll.setEnabled(bl);
        } else if (bl) {
            this.mFastScroll = new FastScroller(this, this.mFastScrollStyle);
            this.mFastScroll.setEnabled(true);
        }
        this.resolvePadding();
        if (this.mFastScroll != null) {
            this.mFastScroll.updateLayout();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setItemViewLayoutParams(View view, int n) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        LayoutParams layoutParams2 = layoutParams == null ? (LayoutParams)this.generateDefaultLayoutParams() : (!this.checkLayoutParams(layoutParams) ? (LayoutParams)this.generateLayoutParams(layoutParams) : (LayoutParams)layoutParams);
        if (this.mAdapterHasStableIds) {
            layoutParams2.itemId = this.mAdapter.getItemId(n);
        }
        layoutParams2.viewType = this.mAdapter.getItemViewType(n);
        view.setLayoutParams(layoutParams2);
    }

    private void showPopup() {
        if (this.getWindowVisibility() == 0) {
            this.createTextFilter(true);
            this.positionPopup();
            this.checkFocus();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean startScrollIfNeeded(int n, int n2, MotionEvent motionEvent) {
        int n3 = n2 - this.mMotionY;
        int n4 = Math.abs(n3);
        boolean bl = this.mScrollY != 0;
        if ((bl || n4 > this.mTouchSlop) && (2 & this.getNestedScrollAxes()) == 0) {
            this.createScrollingCache();
            if (bl) {
                this.mTouchMode = 5;
                this.mMotionCorrection = 0;
            } else {
                this.mTouchMode = 3;
                int n5 = n3 > 0 ? this.mTouchSlop : -this.mTouchSlop;
                this.mMotionCorrection = n5;
            }
            this.removeCallbacks(this.mPendingCheckForLongPress);
            this.setPressed(false);
            View view = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
            if (view != null) {
                view.setPressed(false);
            }
            this.reportScrollStateChange(1);
            ViewParent viewParent = this.getParent();
            if (viewParent != null) {
                viewParent.requestDisallowInterceptTouchEvent(true);
            }
            this.scrollIfNeeded(n, n2, motionEvent);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateOnScreenCheckedViews() {
        int n = this.mFirstPosition;
        int n2 = this.getChildCount();
        boolean bl = this.getContext().getApplicationInfo().targetSdkVersion >= 11;
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getChildAt(n3);
            int n4 = n + n3;
            if (view instanceof Checkable) {
                ((Checkable)((Object)view)).setChecked(this.mCheckStates.get(n4));
            } else if (bl) {
                view.setActivated(this.mCheckStates.get(n4));
            }
            ++n3;
        }
        return;
    }

    private void useDefaultSelector() {
        this.setSelector(this.getContext().getDrawable(17301602));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void addTouchables(ArrayList<View> arrayList) {
        int n = this.getChildCount();
        int n2 = this.mFirstPosition;
        ListAdapter listAdapter = this.mAdapter;
        if (listAdapter != null) {
            for (int i = 0; i < n; ++i) {
                View view = this.getChildAt(i);
                if (listAdapter.isEnabled(n2 + i)) {
                    arrayList.add(view);
                }
                view.addTouchables(arrayList);
            }
        }
    }

    @Override
    public void afterTextChanged(Editable editable) {
    }

    @Override
    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean canScrollList(int n) {
        int n2 = this.getChildCount();
        if (n2 == 0) return false;
        int n3 = this.mFirstPosition;
        Rect rect = this.mListPadding;
        if (n > 0) {
            int n4 = this.getChildAt(n2 - 1).getBottom();
            if (n3 + n2 >= this.mItemCount && n4 <= this.getHeight() - rect.bottom) return false;
            return true;
        }
        int n5 = this.getChildAt(0).getTop();
        if (n3 > 0 || n5 < rect.top) return true;
        return false;
    }

    @Override
    public boolean checkInputConnectionProxy(View view) {
        return view == this.mTextFilter;
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    public void clearChoices() {
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
        this.mCheckedItemCount = 0;
    }

    public void clearTextFilter() {
        if (this.mFiltered) {
            this.getTextFilterInput().setText("");
            this.mFiltered = false;
            if (this.mPopup != null && this.mPopup.isShowing()) {
                this.dismissPopup();
            }
        }
    }

    @Override
    protected int computeVerticalScrollExtent() {
        int n = this.getChildCount();
        if (n > 0) {
            if (this.mSmoothScrollbarEnabled) {
                int n2 = n * 100;
                View view = this.getChildAt(0);
                int n3 = view.getTop();
                int n4 = view.getHeight();
                if (n4 > 0) {
                    n2 += n3 * 100 / n4;
                }
                View view2 = this.getChildAt(n - 1);
                int n5 = view2.getBottom();
                int n6 = view2.getHeight();
                if (n6 > 0) {
                    n2 -= 100 * (n5 - this.getHeight()) / n6;
                }
                return n2;
            }
            return 1;
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int computeVerticalScrollOffset() {
        int n;
        int n2 = this.mFirstPosition;
        int n3 = this.getChildCount();
        int n4 = 0;
        if (n2 < 0) return n4;
        n4 = 0;
        if (n3 <= 0) return n4;
        if (this.mSmoothScrollbarEnabled) {
            View view = this.getChildAt(0);
            int n5 = view.getTop();
            int n6 = view.getHeight();
            n4 = 0;
            if (n6 <= 0) return n4;
            return Math.max(n2 * 100 - n5 * 100 / n6 + (int)(100.0f * ((float)this.mScrollY / (float)this.getHeight() * (float)this.mItemCount)), 0);
        }
        int n7 = this.mItemCount;
        if (n2 == 0) {
            n = 0;
            return (int)((float)n2 + (float)n3 * ((float)n / (float)n7));
        }
        if (n2 + n3 == n7) {
            n = n7;
            return (int)((float)n2 + (float)n3 * ((float)n / (float)n7));
        }
        n = n2 + n3 / 2;
        return (int)((float)n2 + (float)n3 * ((float)n / (float)n7));
    }

    @Override
    protected int computeVerticalScrollRange() {
        if (this.mSmoothScrollbarEnabled) {
            int n = Math.max(100 * this.mItemCount, 0);
            if (this.mScrollY != 0) {
                n += Math.abs((int)(100.0f * ((float)this.mScrollY / (float)this.getHeight() * (float)this.mItemCount)));
            }
            return n;
        }
        return this.mItemCount;
    }

    /*
     * Enabled aggressive block sorting
     */
    void confirmCheckedPositionsById() {
        this.mCheckStates.clear();
        boolean bl = false;
        int n = 0;
        while (true) {
            block8: {
                boolean bl2;
                int n2;
                long l;
                block5: {
                    block7: {
                        block6: {
                            if (n >= this.mCheckedIdStates.size()) break block6;
                            l = this.mCheckedIdStates.keyAt(n);
                            if (l != this.mAdapter.getItemId(n2 = this.mCheckedIdStates.valueAt(n).intValue())) break block7;
                            this.mCheckStates.put(n2, true);
                            break block8;
                        }
                        if (bl && this.mChoiceActionMode != null) {
                            this.mChoiceActionMode.invalidate();
                        }
                        return;
                    }
                    int n3 = Math.max(0, n2 - 20);
                    int n4 = Math.min(n2 + 20, this.mItemCount);
                    int n5 = n3;
                    do {
                        int n6 = ++n5;
                        bl2 = false;
                        if (n6 >= n4) break block5;
                    } while (l != this.mAdapter.getItemId(n5));
                    bl2 = true;
                    this.mCheckStates.put(n5, true);
                    this.mCheckedIdStates.setValueAt(n, n5);
                }
                if (!bl2) {
                    this.mCheckedIdStates.delete(l);
                    --n;
                    this.mCheckedItemCount = -1 + this.mCheckedItemCount;
                    bl = true;
                    if (this.mChoiceActionMode != null && this.mMultiChoiceModeCallback != null) {
                        this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, n2, l, false);
                    }
                }
            }
            ++n;
        }
    }

    ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int n, long l) {
        return new AdapterView.AdapterContextMenuInfo(view, n, l);
    }

    AbsPositionScroller createPositionScroller() {
        return new PositionScroller();
    }

    @Override
    public void deferNotifyDataSetChanged() {
        this.mDeferNotifyDataSetChanged = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void dispatchDraw(Canvas canvas) {
        boolean bl;
        boolean bl2 = (0x22 & this.mGroupFlags) == 34;
        int n = 0;
        if (bl2) {
            n = canvas.save();
            int n2 = this.mScrollX;
            int n3 = this.mScrollY;
            canvas.clipRect(n2 + this.mPaddingLeft, n3 + this.mPaddingTop, n2 + this.mRight - this.mLeft - this.mPaddingRight, n3 + this.mBottom - this.mTop - this.mPaddingBottom);
            this.mGroupFlags = 0xFFFFFFDD & this.mGroupFlags;
        }
        if (!(bl = this.mDrawSelectorOnTop)) {
            this.drawSelector(canvas);
        }
        super.dispatchDraw(canvas);
        if (bl) {
            this.drawSelector(canvas);
        }
        if (bl2) {
            canvas.restoreToCount(n);
            this.mGroupFlags = 0x22 | this.mGroupFlags;
        }
    }

    @Override
    protected void dispatchSetPressed(boolean bl) {
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mEdgeGlowTop != null) {
            int n = this.mScrollY;
            if (!this.mEdgeGlowTop.isFinished()) {
                int n2 = canvas.save();
                int n3 = this.getWidth();
                canvas.translate(0.0f, Math.min(0, n + this.mFirstPositionDistanceGuess));
                this.mEdgeGlowTop.setSize(n3, this.getHeight());
                if (this.mEdgeGlowTop.draw(canvas)) {
                    this.invalidate(0, 0, this.getWidth(), this.mEdgeGlowTop.getMaxHeight() + this.getPaddingTop());
                }
                canvas.restoreToCount(n2);
            }
            if (!this.mEdgeGlowBottom.isFinished()) {
                int n4 = canvas.save();
                int n5 = this.getWidth();
                int n6 = this.getHeight();
                int n7 = -n5;
                int n8 = Math.max(n6, n + this.mLastPositionDistanceGuess);
                canvas.translate(n7, n8);
                canvas.rotate(180.0f, n5, 0.0f);
                this.mEdgeGlowBottom.setSize(n5, n6);
                if (this.mEdgeGlowBottom.draw(canvas)) {
                    this.invalidate(0, this.getHeight() - this.getPaddingBottom() - this.mEdgeGlowBottom.getMaxHeight(), this.getWidth(), this.getHeight());
                }
                canvas.restoreToCount(n4);
            }
        }
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateSelectorState();
    }

    abstract void fillGap(boolean var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int findClosestMotionRow(int n) {
        int n2 = this.getChildCount();
        if (n2 == 0) {
            return -1;
        }
        int n3 = this.findMotionRow(n);
        if (n3 != -1) return n3;
        return -1 + (n2 + this.mFirstPosition);
    }

    abstract int findMotionRow(int var1);

    @Override
    public View findViewByAccessibilityIdTraversal(int n) {
        if (n == this.getAccessibilityViewId()) {
            return this;
        }
        if (this.mDataChanged) {
            return null;
        }
        return super.findViewByAccessibilityIdTraversal(n);
    }

    public void fling(int n) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable();
        }
        this.reportScrollStateChange(2);
        this.mFlingRunnable.start(n);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2, 0);
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    View getAccessibilityFocusedChild(View view) {
        ViewParent viewParent;
        for (viewParent = view.getParent(); viewParent instanceof View && viewParent != this; viewParent = viewParent.getParent()) {
            view = (View)((Object)viewParent);
        }
        if (!(viewParent instanceof View)) {
            view = null;
        }
        return view;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected float getBottomFadingEdgeStrength() {
        float f;
        int n;
        int n2;
        block5: {
            float f2;
            block4: {
                int n3 = this.getChildCount();
                f2 = super.getBottomFadingEdgeStrength();
                if (n3 == 0) break block4;
                if (-1 + (n3 + this.mFirstPosition) < -1 + this.mItemCount) {
                    return 1.0f;
                }
                n2 = this.getChildAt(n3 - 1).getBottom();
                n = this.getHeight();
                f = this.getVerticalFadingEdgeLength();
                if (n2 > n - this.mPaddingBottom) break block5;
            }
            return f2;
        }
        return (float)(n2 - n + this.mPaddingBottom) / f;
    }

    @Override
    protected int getBottomPaddingOffset() {
        if ((0x22 & this.mGroupFlags) == 34) {
            return 0;
        }
        return this.mPaddingBottom;
    }

    @ViewDebug.ExportedProperty(category="drawing")
    public int getCacheColorHint() {
        return this.mCacheColorHint;
    }

    public int getCheckedItemCount() {
        return this.mCheckedItemCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long[] getCheckedItemIds() {
        if (this.mChoiceMode == 0) return new long[0];
        if (this.mCheckedIdStates == null) return new long[0];
        if (this.mAdapter == null) {
            return new long[0];
        }
        LongSparseArray<Integer> longSparseArray = this.mCheckedIdStates;
        int n = longSparseArray.size();
        long[] lArray = new long[n];
        int n2 = 0;
        while (n2 < n) {
            lArray[n2] = longSparseArray.keyAt(n2);
            ++n2;
        }
        return lArray;
    }

    public int getCheckedItemPosition() {
        if (this.mChoiceMode == 1 && this.mCheckStates != null && this.mCheckStates.size() == 1) {
            return this.mCheckStates.keyAt(0);
        }
        return -1;
    }

    public SparseBooleanArray getCheckedItemPositions() {
        if (this.mChoiceMode != 0) {
            return this.mCheckStates;
        }
        return null;
    }

    public int getChoiceMode() {
        return this.mChoiceMode;
    }

    @Override
    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    @Override
    public void getFocusedRect(Rect rect) {
        View view = this.getSelectedView();
        if (view != null && view.getParent() == this) {
            view.getFocusedRect(rect);
            this.offsetDescendantRectToMyCoords(view, rect);
            return;
        }
        super.getFocusedRect(rect);
    }

    int getFooterViewsCount() {
        return 0;
    }

    int getHeaderViewsCount() {
        return 0;
    }

    int getHeightForPosition(int n) {
        int n2 = this.getFirstVisiblePosition();
        int n3 = this.getChildCount();
        int n4 = n - n2;
        if (n4 >= 0 && n4 < n3) {
            return this.getChildAt(n4).getHeight();
        }
        View view = this.obtainView(n, this.mIsScrap);
        view.measure(this.mWidthMeasureSpec, 0);
        int n5 = view.getMeasuredHeight();
        this.mRecycler.addScrapView(view, n);
        return n5;
    }

    @Override
    protected int getLeftPaddingOffset() {
        if ((0x22 & this.mGroupFlags) == 34) {
            return 0;
        }
        return -this.mPaddingLeft;
    }

    public int getListPaddingBottom() {
        return this.mListPadding.bottom;
    }

    public int getListPaddingLeft() {
        return this.mListPadding.left;
    }

    public int getListPaddingRight() {
        return this.mListPadding.right;
    }

    public int getListPaddingTop() {
        return this.mListPadding.top;
    }

    @Override
    protected int getRightPaddingOffset() {
        if ((0x22 & this.mGroupFlags) == 34) {
            return 0;
        }
        return this.mPaddingRight;
    }

    @Override
    @ViewDebug.ExportedProperty
    public View getSelectedView() {
        if (this.mItemCount > 0 && this.mSelectedPosition >= 0) {
            return this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
        }
        return null;
    }

    int getSelectionModeForAccessibility() {
        switch (this.getChoiceMode()) {
            default: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
            case 3: 
        }
        return 2;
    }

    public Drawable getSelector() {
        return this.mSelector;
    }

    @Override
    public int getSolidColor() {
        return this.mCacheColorHint;
    }

    public CharSequence getTextFilter() {
        if (this.mTextFilterEnabled && this.mTextFilter != null) {
            return this.mTextFilter.getText();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected float getTopFadingEdgeStrength() {
        float f;
        int n;
        block5: {
            float f2;
            block4: {
                int n2 = this.getChildCount();
                f2 = super.getTopFadingEdgeStrength();
                if (n2 == 0) break block4;
                if (this.mFirstPosition > 0) {
                    return 1.0f;
                }
                n = this.getChildAt(0).getTop();
                f = this.getVerticalFadingEdgeLength();
                if (n < this.mPaddingTop) break block5;
            }
            return f2;
        }
        return (float)(-(n - this.mPaddingTop)) / f;
    }

    @Override
    protected int getTopPaddingOffset() {
        if ((0x22 & this.mGroupFlags) == 34) {
            return 0;
        }
        return -this.mPaddingTop;
    }

    public int getTranscriptMode() {
        return this.mTranscriptMode;
    }

    @Override
    public int getVerticalScrollbarWidth() {
        if (this.mFastScroll != null && this.mFastScroll.isEnabled()) {
            return Math.max(super.getVerticalScrollbarWidth(), this.mFastScroll.getWidth());
        }
        return super.getVerticalScrollbarWidth();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void handleDataChanged() {
        block19: {
            block23: {
                block20: {
                    block22: {
                        block21: {
                            var1_1 = 3;
                            var2_2 = this.mItemCount;
                            var3_3 = this.mLastHandledItemCount;
                            this.mLastHandledItemCount = this.mItemCount;
                            if (this.mChoiceMode != 0 && this.mAdapter != null && this.mAdapter.hasStableIds()) {
                                this.confirmCheckedPositionsById();
                            }
                            this.mRecycler.clearTransientStateViews();
                            if (var2_2 <= 0) break block19;
                            if (!this.mNeedSync) ** GOTO lbl-1000
                            this.mNeedSync = false;
                            this.mPendingSync = null;
                            if (this.mTranscriptMode == 2) {
                                this.mLayoutMode = var1_1;
lbl14:
                                // 2 sources

                                return;
                            }
                            if (this.mTranscriptMode != 1) break block20;
                            if (this.mForceTranscriptScroll) {
                                this.mForceTranscriptScroll = false;
                                this.mLayoutMode = var1_1;
                                return;
                            }
                            var8_4 = this.getChildCount();
                            var9_5 = this.getHeight() - this.getPaddingBottom();
                            var10_6 = this.getChildAt(var8_4 - 1);
                            if (var10_6 == null) break block21;
                            var11_7 = var10_6.getBottom();
lbl26:
                            // 2 sources

                            while (var8_4 + this.mFirstPosition >= var3_3 && var11_7 <= var9_5) {
                                this.mLayoutMode = var1_1;
                                return;
                            }
                            break block22;
                        }
                        var11_7 = var9_5;
                        ** GOTO lbl26
                    }
                    this.awakenScrollBars();
                }
                switch (this.mSyncMode) lbl-1000:
                // 2 sources

                {
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (!this.isInTouchMode()) {
                            var4_8 = this.getSelectedItemPosition();
                            if (var4_8 >= var2_2) {
                                var4_8 = var2_2 - 1;
                            }
                            if (var4_8 < 0) {
                                var4_8 = 0;
                            }
                            if ((var5_9 = this.lookForSelectablePosition(var4_8, true)) < 0) break;
                            this.setNextSelectedPositionInt(var5_9);
                            return;
                        }
                        break block23;
                    }
                    case 0: {
                        if (this.isInTouchMode()) {
                            this.mLayoutMode = 5;
                            this.mSyncPosition = Math.min(Math.max(0, this.mSyncPosition), var2_2 - 1);
                            return;
                        }
                        var7_10 = this.findSyncPosition();
                        if (var7_10 < 0 || this.lookForSelectablePosition(var7_10, true) != var7_10) ** GOTO lbl-1000
                        this.mSyncPosition = var7_10;
                        if (this.mSyncHeight == (long)this.getHeight()) {
                            this.mLayoutMode = 5;
lbl59:
                            // 2 sources

                            while (true) {
                                this.setNextSelectedPositionInt(var7_10);
                                return;
                            }
                        }
                        this.mLayoutMode = 2;
                        ** continue;
                    }
                    case 1: {
                        this.mLayoutMode = 5;
                        this.mSyncPosition = Math.min(Math.max(0, this.mSyncPosition), var2_2 - 1);
                        return;
                    }
                }
                var6_11 = this.lookForSelectablePosition(var4_8, false);
                if (var6_11 >= 0) {
                    this.setNextSelectedPositionInt(var6_11);
                    return;
                }
                break block19;
            }
            ** while (this.mResurrectToPosition >= 0)
        }
        if (this.mStackFromBottom) lbl-1000:
        // 2 sources

        {
            while (true) {
                this.mLayoutMode = var1_1;
                this.mSelectedPosition = -1;
                this.mSelectedRowId = -9223372036854775808L;
                this.mNextSelectedPosition = -1;
                this.mNextSelectedRowId = -9223372036854775808L;
                this.mNeedSync = false;
                this.mPendingSync = null;
                this.mSelectorPosition = -1;
                this.checkSelectionChanged();
                return;
            }
        }
        var1_1 = 1;
        ** while (true)
    }

    public boolean hasTextFilter() {
        return this.mFiltered;
    }

    void hideSelector() {
        if (this.mSelectedPosition != -1) {
            if (this.mLayoutMode != 4) {
                this.mResurrectToPosition = this.mSelectedPosition;
            }
            if (this.mNextSelectedPosition >= 0 && this.mNextSelectedPosition != this.mSelectedPosition) {
                this.mResurrectToPosition = this.mNextSelectedPosition;
            }
            this.setSelectedPositionInt(-1);
            this.setNextSelectedPositionInt(-1);
            this.mSelectedTop = 0;
        }
    }

    public void invalidateViews() {
        this.mDataChanged = true;
        this.rememberSyncState();
        this.requestLayout();
        this.invalidate();
    }

    void invokeOnItemScrollListener() {
        if (this.mFastScroll != null) {
            this.mFastScroll.onScroll(this.mFirstPosition, this.getChildCount(), this.mItemCount);
        }
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll(this, this.mFirstPosition, this.getChildCount(), this.mItemCount);
        }
        this.onScrollChanged(0, 0, 0, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean isFastScrollAlwaysVisible() {
        if (this.mFastScroll == null) {
            if (this.mFastScrollEnabled && this.mFastScrollAlwaysVisible) return true;
            return false;
        }
        if (!this.mFastScroll.isEnabled() || !this.mFastScroll.isAlwaysShowEnabled()) return false;
        return true;
    }

    @ViewDebug.ExportedProperty
    public boolean isFastScrollEnabled() {
        if (this.mFastScroll == null) {
            return this.mFastScrollEnabled;
        }
        return this.mFastScroll.isEnabled();
    }

    @Override
    protected boolean isInFilterMode() {
        return this.mFiltered;
    }

    public boolean isItemChecked(int n) {
        if (this.mChoiceMode != 0 && this.mCheckStates != null) {
            return this.mCheckStates.get(n);
        }
        return false;
    }

    @Override
    protected boolean isPaddingOffsetRequired() {
        return (0x22 & this.mGroupFlags) != 34;
    }

    @ViewDebug.ExportedProperty
    public boolean isScrollingCacheEnabled() {
        return this.mScrollingCacheEnabled;
    }

    @ViewDebug.ExportedProperty
    public boolean isSmoothScrollbarEnabled() {
        return this.mSmoothScrollbarEnabled;
    }

    @ViewDebug.ExportedProperty
    public boolean isStackFromBottom() {
        return this.mStackFromBottom;
    }

    @ViewDebug.ExportedProperty
    public boolean isTextFilterEnabled() {
        return this.mTextFilterEnabled;
    }

    @Override
    protected boolean isVerticalScrollBarHidden() {
        return this.isFastScrollEnabled();
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mSelector != null) {
            this.mSelector.jumpToCurrentState();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void keyPressed() {
        block9: {
            block7: {
                Drawable drawable2;
                block8: {
                    if (!this.isEnabled() || !this.isClickable()) break block7;
                    drawable2 = this.mSelector;
                    Rect rect = this.mSelectorRect;
                    if (drawable2 == null || !this.isFocused() && !this.touchModeDrawsInPressedState() || rect.isEmpty()) break block7;
                    View view = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
                    if (view == null) break block8;
                    if (view.hasFocusable()) break block7;
                    view.setPressed(true);
                }
                this.setPressed(true);
                boolean bl = this.isLongClickable();
                Drawable drawable3 = drawable2.getCurrent();
                if (drawable3 != null && drawable3 instanceof TransitionDrawable) {
                    if (bl) {
                        ((TransitionDrawable)drawable3).startTransition(ViewConfiguration.getLongPressTimeout());
                    } else {
                        ((TransitionDrawable)drawable3).resetTransition();
                    }
                }
                if (bl && !this.mDataChanged) break block9;
            }
            return;
        }
        if (this.mPendingCheckForKeyLongPress == null) {
            this.mPendingCheckForKeyLongPress = new CheckForKeyLongPress();
        }
        this.mPendingCheckForKeyLongPress.rememberWindowAttachCount();
        this.postDelayed(this.mPendingCheckForKeyLongPress, ViewConfiguration.getLongPressTimeout());
    }

    protected void layoutChildren() {
    }

    /*
     * Enabled aggressive block sorting
     */
    View obtainView(int n, boolean[] blArray) {
        Trace.traceBegin(8L, "obtainView");
        blArray[0] = false;
        View view = this.mRecycler.getTransientStateView(n);
        if (view != null) {
            View view2;
            if (((LayoutParams)view.getLayoutParams()).viewType == this.mAdapter.getItemViewType(n) && (view2 = this.mAdapter.getView(n, view, this)) != view) {
                this.setItemViewLayoutParams(view2, n);
                this.mRecycler.addScrapView(view2, n);
            }
            blArray[0] = true;
            return view;
        }
        View view3 = this.mRecycler.getScrapView(n);
        View view4 = this.mAdapter.getView(n, view3, this);
        if (view3 != null) {
            if (view4 != view3) {
                this.mRecycler.addScrapView(view3, n);
            } else {
                blArray[0] = true;
                view4.dispatchFinishTemporaryDetach();
            }
        }
        if (this.mCacheColorHint != 0) {
            view4.setDrawingCacheBackgroundColor(this.mCacheColorHint);
        }
        if (view4.getImportantForAccessibility() == 0) {
            view4.setImportantForAccessibility(1);
        }
        this.setItemViewLayoutParams(view4, n);
        if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            if (this.mAccessibilityDelegate == null) {
                this.mAccessibilityDelegate = new ListItemAccessibilityDelegate();
            }
            if (view4.getAccessibilityDelegate() == null) {
                view4.setAccessibilityDelegate(this.mAccessibilityDelegate);
            }
        }
        Trace.traceEnd(8L);
        return view4;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        viewTreeObserver.addOnTouchModeChangeListener(this);
        if (this.mTextFilterEnabled && this.mPopup != null && !this.mGlobalLayoutListenerAddedFilter) {
            viewTreeObserver.addOnGlobalLayoutListener(this);
        }
        if (this.mAdapter != null && this.mDataSetObserver == null) {
            this.mDataSetObserver = new AdapterDataSetObserver();
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            this.mDataChanged = true;
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
        }
    }

    @Override
    public void onCancelPendingInputEvents() {
        super.onCancelPendingInputEvents();
        if (this.mPerformClick != null) {
            this.removeCallbacks(this.mPerformClick);
        }
        if (this.mPendingCheckForTap != null) {
            this.removeCallbacks(this.mPendingCheckForTap);
        }
        if (this.mPendingCheckForLongPress != null) {
            this.removeCallbacks(this.mPendingCheckForLongPress);
        }
        if (this.mPendingCheckForKeyLongPress != null) {
            this.removeCallbacks(this.mPendingCheckForKeyLongPress);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected int[] onCreateDrawableState(int n) {
        if (this.mIsChildViewEnabled) {
            return super.onCreateDrawableState(n);
        }
        int n2 = ENABLED_STATE_SET[0];
        int[] nArray = super.onCreateDrawableState(n + 1);
        int n3 = -1;
        int n4 = -1 + nArray.length;
        while (true) {
            block6: {
                block5: {
                    if (n4 < 0) break block5;
                    if (nArray[n4] != n2) break block6;
                    n3 = n4;
                }
                if (n3 < 0) return nArray;
                System.arraycopy((int[])nArray, (int)(n3 + 1), (int[])nArray, (int)n3, (int)(-1 + (nArray.length - n3)));
                return nArray;
            }
            --n4;
        }
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo editorInfo) {
        if (this.isTextFilterEnabled()) {
            if (this.mPublicInputConnection == null) {
                this.mDefInputConnection = new BaseInputConnection(this, false);
                this.mPublicInputConnection = new InputConnectionWrapper(editorInfo);
            }
            editorInfo.inputType = 177;
            editorInfo.imeOptions = 6;
            return this.mPublicInputConnection;
        }
        return null;
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIsDetaching = true;
        this.dismissPopup();
        this.mRecycler.clear();
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        viewTreeObserver.removeOnTouchModeChangeListener(this);
        if (this.mTextFilterEnabled && this.mPopup != null) {
            viewTreeObserver.removeOnGlobalLayoutListener(this);
            this.mGlobalLayoutListenerAddedFilter = false;
        }
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
            this.mDataSetObserver = null;
        }
        if (this.mScrollStrictSpan != null) {
            this.mScrollStrictSpan.finish();
            this.mScrollStrictSpan = null;
        }
        if (this.mFlingStrictSpan != null) {
            this.mFlingStrictSpan.finish();
            this.mFlingStrictSpan = null;
        }
        if (this.mFlingRunnable != null) {
            this.removeCallbacks(this.mFlingRunnable);
        }
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        if (this.mClearScrollingCache != null) {
            this.removeCallbacks(this.mClearScrollingCache);
        }
        if (this.mPerformClick != null) {
            this.removeCallbacks(this.mPerformClick);
        }
        if (this.mTouchModeReset != null) {
            this.removeCallbacks(this.mTouchModeReset);
            this.mTouchModeReset.run();
        }
        this.mIsDetaching = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onDisplayHint(int n) {
        super.onDisplayHint(n);
        switch (n) {
            case 4: {
                if (this.mPopup == null || !this.mPopup.isShowing()) break;
                this.dismissPopup();
                break;
            }
            case 0: {
                if (!this.mFiltered || this.mPopup == null || this.mPopup.isShowing()) break;
                this.showPopup();
            }
        }
        boolean bl = n == 4;
        this.mPopupHidden = bl;
    }

    @Override
    public void onFilterComplete(int n) {
        if (this.mSelectedPosition < 0 && n > 0) {
            this.mResurrectToPosition = -1;
            this.resurrectSelection();
        }
    }

    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        super.onFocusChanged(bl, n, rect);
        if (bl && this.mSelectedPosition < 0 && !this.isInTouchMode()) {
            if (!this.isAttachedToWindow() && this.mAdapter != null) {
                this.mDataChanged = true;
                this.mOldItemCount = this.mItemCount;
                this.mItemCount = this.mAdapter.getCount();
            }
            this.resurrectSelection();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if ((2 & motionEvent.getSource()) == 0) return super.onGenericMotionEvent(motionEvent);
        switch (motionEvent.getAction()) {
            default: {
                return super.onGenericMotionEvent(motionEvent);
            }
            case 8: {
                int n;
                float f;
                if (this.mTouchMode != -1 || (f = motionEvent.getAxisValue(9)) == 0.0f || this.trackMotionScroll(n = (int)(f * this.getVerticalScrollFactor()), n)) return super.onGenericMotionEvent(motionEvent);
                return true;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onGlobalLayout() {
        if (this.isShown()) {
            if (!this.mFiltered || this.mPopup == null || this.mPopup.isShowing() || this.mPopupHidden) return;
            this.showPopup();
            return;
        }
        if (this.mPopup == null || !this.mPopup.isShowing()) return;
        this.dismissPopup();
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        accessibilityEvent.setClassName(AbsListView.class.getName());
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
        accessibilityNodeInfo.setClassName(AbsListView.class.getName());
        if (this.isEnabled()) {
            if (this.canScrollUp()) {
                accessibilityNodeInfo.addAction(8192);
                accessibilityNodeInfo.setScrollable(true);
            }
            if (this.canScrollDown()) {
                accessibilityNodeInfo.addAction(4096);
                accessibilityNodeInfo.setScrollable(true);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onInitializeAccessibilityNodeInfoForItem(View view, int n, AccessibilityNodeInfo accessibilityNodeInfo) {
        block8: {
            block7: {
                ListAdapter listAdapter = (ListAdapter)this.getAdapter();
                if (n == -1 || listAdapter == null) break block7;
                if (!this.isEnabled() || !listAdapter.isEnabled(n)) {
                    accessibilityNodeInfo.setEnabled(false);
                    return;
                }
                if (n == this.getSelectedItemPosition()) {
                    accessibilityNodeInfo.setSelected(true);
                    accessibilityNodeInfo.addAction(8);
                } else {
                    accessibilityNodeInfo.addAction(4);
                }
                if (this.isClickable()) {
                    accessibilityNodeInfo.addAction(16);
                    accessibilityNodeInfo.setClickable(true);
                }
                if (this.isLongClickable()) break block8;
            }
            return;
        }
        accessibilityNodeInfo.addAction(32);
        accessibilityNodeInfo.setLongClickable(true);
    }

    @Override
    public boolean onInterceptHoverEvent(MotionEvent motionEvent) {
        if (this.mFastScroll != null && this.mFastScroll.onInterceptHoverEvent(motionEvent)) {
            return true;
        }
        return super.onInterceptHoverEvent(motionEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        boolean bl = true;
        int n = motionEvent.getActionMasked();
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        if (this.mIsDetaching) return false;
        if (!this.isAttachedToWindow()) {
            return false;
        }
        if (this.mFastScroll != null) {
            if (this.mFastScroll.onInterceptTouchEvent(motionEvent)) return bl;
        }
        switch (n) {
            case 0: {
                int n2 = this.mTouchMode;
                if (n2 == 6 || n2 == 5) {
                    this.mMotionCorrection = 0;
                    return bl;
                }
                int n3 = (int)motionEvent.getX();
                int n4 = (int)motionEvent.getY();
                this.mActivePointerId = motionEvent.getPointerId(0);
                int n5 = this.findMotionRow(n4);
                if (n2 != 4 && n5 >= 0) {
                    this.mMotionViewOriginalTop = this.getChildAt(n5 - this.mFirstPosition).getTop();
                    this.mMotionX = n3;
                    this.mMotionY = n4;
                    this.mMotionPosition = n5;
                    this.mTouchMode = 0;
                    this.clearScrollingCache();
                }
                this.mLastY = Integer.MIN_VALUE;
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(motionEvent);
                this.mNestedYOffset = 0;
                this.startNestedScroll(2);
                if (n2 != 4) return false;
                return bl;
            }
            case 2: {
                switch (this.mTouchMode) {
                    default: {
                        return false;
                    }
                    case 0: 
                }
                int n6 = motionEvent.findPointerIndex(this.mActivePointerId);
                if (n6 == -1) {
                    n6 = 0;
                    this.mActivePointerId = motionEvent.getPointerId(0);
                }
                int n7 = (int)motionEvent.getY(n6);
                this.initVelocityTrackerIfNotExists();
                this.mVelocityTracker.addMovement(motionEvent);
                if (!this.startScrollIfNeeded((int)motionEvent.getX(n6), n7, null)) return false;
                return bl;
            }
            case 1: 
            case 3: {
                this.mTouchMode = -1;
                this.mActivePointerId = -1;
                this.recycleVelocityTracker();
                this.reportScrollStateChange(0);
                this.stopNestedScroll();
                return false;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return false;
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (KeyEvent.isConfirmKey(n)) {
            if (!this.isEnabled()) {
                return true;
            }
            if (this.isClickable() && this.isPressed() && this.mSelectedPosition >= 0 && this.mAdapter != null && this.mSelectedPosition < this.mAdapter.getCount()) {
                View view = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
                if (view != null) {
                    this.performItemClick(view, this.mSelectedPosition, this.mSelectedRowId);
                    view.setPressed(false);
                }
                this.setPressed(false);
                return true;
            }
        }
        return super.onKeyUp(n, keyEvent);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        super.onLayout(bl, n, n2, n3, n4);
        this.mInLayout = true;
        int n5 = this.getChildCount();
        if (bl) {
            for (int i = 0; i < n5; ++i) {
                this.getChildAt(i).forceLayout();
            }
            this.mRecycler.markChildrenDirty();
        }
        this.layoutChildren();
        this.mInLayout = false;
        this.mOverscrollMax = (n4 - n2) / 3;
        if (this.mFastScroll != null) {
            this.mFastScroll.onItemCountChanged(this.getChildCount(), this.mItemCount);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3 = 1;
        if (this.mSelector == null) {
            this.useDefaultSelector();
        }
        Rect rect = this.mListPadding;
        rect.left = this.mSelectionLeftPadding + this.mPaddingLeft;
        rect.top = this.mSelectionTopPadding + this.mPaddingTop;
        rect.right = this.mSelectionRightPadding + this.mPaddingRight;
        rect.bottom = this.mSelectionBottomPadding + this.mPaddingBottom;
        if (this.mTranscriptMode == n3) {
            int n4 = this.getChildCount();
            int n5 = this.getHeight() - this.getPaddingBottom();
            View view = this.getChildAt(n4 - 1);
            int n6 = view != null ? view.getBottom() : n5;
            if (n4 + this.mFirstPosition < this.mLastHandledItemCount || n6 > n5) {
                n3 = 0;
            }
            this.mForceTranscriptScroll = n3;
        }
    }

    @Override
    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        int n = this.getChildCount();
        if (!bl && n > 0 && this.canScrollList((int)f2) && Math.abs(f2) > (float)this.mMinimumVelocity) {
            this.reportScrollStateChange(2);
            if (this.mFlingRunnable == null) {
                this.mFlingRunnable = new FlingRunnable();
            }
            if (!this.dispatchNestedPreFling(0.0f, f2)) {
                this.mFlingRunnable.start((int)f2);
            }
            return true;
        }
        return this.dispatchNestedFling(f, f2, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onNestedScroll(View view, int n, int n2, int n3, int n4) {
        View view2 = this.getChildAt(this.getChildCount() / 2);
        int n5 = view2 != null ? view2.getTop() : 0;
        if (view2 == null || this.trackMotionScroll(-n4, -n4)) {
            int n6 = n4;
            int n7 = 0;
            if (view2 != null) {
                n7 = view2.getTop() - n5;
                n6 -= n7;
            }
            this.dispatchNestedScroll(0, n7, 0, n6, null);
        }
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n) {
        super.onNestedScrollAccepted(view, view2, n);
        this.startNestedScroll(2);
    }

    @Override
    protected void onOverScrolled(int n, int n2, boolean bl, boolean bl2) {
        if (this.mScrollY != n2) {
            this.onScrollChanged(this.mScrollX, n2, this.mScrollX, this.mScrollY);
            this.mScrollY = n2;
            this.invalidateParentIfNeeded();
            this.awakenScrollBars();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onRemoteAdapterConnected() {
        if (this.mRemoteAdapter != this.mAdapter) {
            this.setAdapter(this.mRemoteAdapter);
            if (!this.mDeferNotifyDataSetChanged) return false;
            this.mRemoteAdapter.notifyDataSetChanged();
            this.mDeferNotifyDataSetChanged = false;
            return false;
        }
        if (this.mRemoteAdapter == null) return false;
        this.mRemoteAdapter.superNotifyDataSetChanged();
        return true;
    }

    @Override
    public void onRemoteAdapterDisconnected() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mDataChanged = true;
        this.mSyncHeight = savedState.height;
        if (savedState.selectedId >= 0L) {
            this.mNeedSync = true;
            this.mPendingSync = savedState;
            this.mSyncRowId = savedState.selectedId;
            this.mSyncPosition = savedState.position;
            this.mSpecificTop = savedState.viewTop;
            this.mSyncMode = 0;
        } else if (savedState.firstId >= 0L) {
            this.setSelectedPositionInt(-1);
            this.setNextSelectedPositionInt(-1);
            this.mSelectorPosition = -1;
            this.mNeedSync = true;
            this.mPendingSync = savedState;
            this.mSyncRowId = savedState.firstId;
            this.mSyncPosition = savedState.position;
            this.mSpecificTop = savedState.viewTop;
            this.mSyncMode = 1;
        }
        this.setFilterText(savedState.filter);
        if (savedState.checkState != null) {
            this.mCheckStates = savedState.checkState;
        }
        if (savedState.checkIdState != null) {
            this.mCheckedIdStates = savedState.checkIdState;
        }
        this.mCheckedItemCount = savedState.checkedItemCount;
        if (savedState.inActionMode && this.mChoiceMode == 3 && this.mMultiChoiceModeCallback != null) {
            this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback);
        }
        this.requestLayout();
    }

    @Override
    public void onRtlPropertiesChanged(int n) {
        super.onRtlPropertiesChanged(n);
        if (this.mFastScroll != null) {
            this.mFastScroll.setScrollbarPosition(this.getVerticalScrollbarPosition());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Parcelable onSaveInstanceState() {
        this.dismissPopup();
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        if (this.mPendingSync != null) {
            savedState.selectedId = this.mPendingSync.selectedId;
            savedState.firstId = this.mPendingSync.firstId;
            savedState.viewTop = this.mPendingSync.viewTop;
            savedState.position = this.mPendingSync.position;
            savedState.height = this.mPendingSync.height;
            savedState.filter = this.mPendingSync.filter;
            savedState.inActionMode = this.mPendingSync.inActionMode;
            savedState.checkedItemCount = this.mPendingSync.checkedItemCount;
            savedState.checkState = this.mPendingSync.checkState;
            savedState.checkIdState = this.mPendingSync.checkIdState;
            return savedState;
        } else {
            Editable editable;
            EditText editText;
            long l;
            boolean bl = this.getChildCount() > 0 && this.mItemCount > 0;
            savedState.selectedId = l = this.getSelectedItemId();
            savedState.height = this.getHeight();
            if (l >= 0L) {
                savedState.viewTop = this.mSelectedTop;
                savedState.position = this.getSelectedItemPosition();
                savedState.firstId = -1L;
            } else if (bl && this.mFirstPosition > 0) {
                savedState.viewTop = this.getChildAt(0).getTop();
                int n = this.mFirstPosition;
                if (n >= this.mItemCount) {
                    n = -1 + this.mItemCount;
                }
                savedState.position = n;
                savedState.firstId = this.mAdapter.getItemId(n);
            } else {
                savedState.viewTop = 0;
                savedState.firstId = -1L;
                savedState.position = 0;
            }
            savedState.filter = null;
            if (this.mFiltered && (editText = this.mTextFilter) != null && (editable = editText.getText()) != null) {
                savedState.filter = editable.toString();
            }
            boolean bl2 = this.mChoiceMode == 3 && this.mChoiceActionMode != null;
            savedState.inActionMode = bl2;
            if (this.mCheckStates != null) {
                savedState.checkState = this.mCheckStates.clone();
            }
            if (this.mCheckedIdStates != null) {
                LongSparseArray<Integer> longSparseArray = new LongSparseArray<Integer>();
                int n = this.mCheckedIdStates.size();
                for (int i = 0; i < n; ++i) {
                    longSparseArray.put(this.mCheckedIdStates.keyAt(i), this.mCheckedIdStates.valueAt(i));
                }
                savedState.checkIdState = longSparseArray;
            }
            savedState.checkedItemCount = this.mCheckedItemCount;
            if (this.mRemoteAdapter == null) return savedState;
            this.mRemoteAdapter.saveRemoteViewsCache();
            return savedState;
        }
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        if (this.getChildCount() > 0) {
            this.mDataChanged = true;
            this.rememberSyncState();
        }
        if (this.mFastScroll != null) {
            this.mFastScroll.onSizeChanged(n, n2, n3, n4);
        }
    }

    @Override
    public boolean onStartNestedScroll(View view, View view2, int n) {
        return (n & 2) != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        if (this.isTextFilterEnabled()) {
            this.createTextFilter(true);
            int n4 = charSequence.length();
            boolean bl = this.mPopup.isShowing();
            if (!bl && n4 > 0) {
                this.showPopup();
                this.mFiltered = true;
            } else if (bl && n4 == 0) {
                this.dismissPopup();
                this.mFiltered = false;
            }
            if (this.mAdapter instanceof Filterable) {
                Filter filter = ((Filterable)((Object)this.mAdapter)).getFilter();
                if (filter == null) {
                    throw new IllegalStateException("You cannot call onTextChanged with a non filterable adapter");
                }
                filter.filter(charSequence, this);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl;
        if (!this.isEnabled()) {
            if (this.isClickable()) return true;
            boolean bl2 = this.isLongClickable();
            bl = false;
            if (!bl2) return bl;
            return true;
        }
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        boolean bl3 = this.mIsDetaching;
        bl = false;
        if (bl3) return bl;
        boolean bl4 = this.isAttachedToWindow();
        bl = false;
        if (!bl4) return bl;
        this.startNestedScroll(2);
        if (this.mFastScroll != null && this.mFastScroll.onTouchEvent(motionEvent)) {
            return true;
        }
        this.initVelocityTrackerIfNotExists();
        MotionEvent motionEvent2 = MotionEvent.obtain(motionEvent);
        int n = motionEvent.getActionMasked();
        if (n == 0) {
            this.mNestedYOffset = 0;
        }
        motionEvent2.offsetLocation(0.0f, this.mNestedYOffset);
        switch (n) {
            case 0: {
                this.onTouchDown(motionEvent);
                break;
            }
            case 2: {
                this.onTouchMove(motionEvent, motionEvent2);
                break;
            }
            case 1: {
                this.onTouchUp(motionEvent);
                break;
            }
            case 3: {
                this.onTouchCancel();
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                int n2 = this.mMotionX;
                int n3 = this.mMotionY;
                int n4 = this.pointToPosition(n2, n3);
                if (n4 >= 0) {
                    this.mMotionViewOriginalTop = this.getChildAt(n4 - this.mFirstPosition).getTop();
                    this.mMotionPosition = n4;
                }
                this.mLastY = n3;
                break;
            }
            case 5: {
                int n5 = motionEvent.getActionIndex();
                int n6 = motionEvent.getPointerId(n5);
                int n7 = (int)motionEvent.getX(n5);
                int n8 = (int)motionEvent.getY(n5);
                this.mMotionCorrection = 0;
                this.mActivePointerId = n6;
                this.mMotionX = n7;
                this.mMotionY = n8;
                int n9 = this.pointToPosition(n7, n8);
                if (n9 >= 0) {
                    this.mMotionViewOriginalTop = this.getChildAt(n9 - this.mFirstPosition).getTop();
                    this.mMotionPosition = n9;
                }
                this.mLastY = n8;
                break;
            }
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(motionEvent2);
        }
        motionEvent2.recycle();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onTouchModeChanged(boolean bl) {
        if (bl) {
            this.hideSelector();
            if (this.getHeight() > 0 && this.getChildCount() > 0) {
                this.layoutChildren();
            }
            this.updateSelectorState();
            return;
        } else {
            int n = this.mTouchMode;
            if (n != 5 && n != 6) return;
            if (this.mFlingRunnable != null) {
                this.mFlingRunnable.endFling();
            }
            if (this.mPositionScroller != null) {
                this.mPositionScroller.stop();
            }
            if (this.mScrollY == 0) return;
            this.mScrollY = 0;
            this.invalidateParentCaches();
            this.finishGlows();
            this.invalidate();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        int n = this.isInTouchMode() ? 0 : 1;
        if (!bl) {
            this.setChildrenDrawingCacheEnabled(false);
            if (this.mFlingRunnable != null) {
                this.removeCallbacks(this.mFlingRunnable);
                this.mFlingRunnable.endFling();
                if (this.mPositionScroller != null) {
                    this.mPositionScroller.stop();
                }
                if (this.mScrollY != 0) {
                    this.mScrollY = 0;
                    this.invalidateParentCaches();
                    this.finishGlows();
                    this.invalidate();
                }
            }
            this.dismissPopup();
            if (n == 1) {
                this.mResurrectToPosition = this.mSelectedPosition;
            }
        } else {
            if (this.mFiltered && !this.mPopupHidden) {
                this.showPopup();
            }
            if (n != this.mLastTouchMode && this.mLastTouchMode != -1) {
                if (n == 1) {
                    this.resurrectSelection();
                } else {
                    this.hideSelector();
                    this.mLayoutMode = 0;
                    this.layoutChildren();
                }
            }
        }
        this.mLastTouchMode = n;
    }

    @Override
    public boolean performAccessibilityAction(int n, Bundle bundle) {
        if (super.performAccessibilityAction(n, bundle)) {
            return true;
        }
        switch (n) {
            default: {
                return false;
            }
            case 4096: {
                if (this.isEnabled() && this.getLastVisiblePosition() < -1 + this.getCount()) {
                    this.smoothScrollBy(this.getHeight() - this.mListPadding.top - this.mListPadding.bottom, 200);
                    return true;
                }
                return false;
            }
            case 8192: 
        }
        if (this.isEnabled() && this.mFirstPosition > 0) {
            this.smoothScrollBy(-(this.getHeight() - this.mListPadding.top - this.mListPadding.bottom), 200);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean performItemClick(View view, int n, long l) {
        boolean bl = true;
        int n2 = this.mChoiceMode;
        boolean bl2 = false;
        if (n2 != 0) {
            boolean bl3;
            bl2 = true;
            if (this.mChoiceMode == 2 || this.mChoiceMode == 3 && this.mChoiceActionMode != null) {
                boolean bl4 = !this.mCheckStates.get(n, false);
                this.mCheckStates.put(n, bl4);
                if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                    if (bl4) {
                        this.mCheckedIdStates.put(this.mAdapter.getItemId(n), n);
                    } else {
                        this.mCheckedIdStates.delete(this.mAdapter.getItemId(n));
                    }
                }
                this.mCheckedItemCount = bl4 ? 1 + this.mCheckedItemCount : -1 + this.mCheckedItemCount;
                if (this.mChoiceActionMode != null) {
                    this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, n, l, bl4);
                    bl = false;
                }
                bl3 = true;
            } else {
                int n3 = this.mChoiceMode;
                bl3 = false;
                if (n3 == 1) {
                    boolean bl5 = !this.mCheckStates.get(n, false);
                    if (bl5) {
                        this.mCheckStates.clear();
                        this.mCheckStates.put(n, true);
                        if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                            this.mCheckedIdStates.clear();
                            this.mCheckedIdStates.put(this.mAdapter.getItemId(n), n);
                        }
                        this.mCheckedItemCount = 1;
                    } else if (this.mCheckStates.size() == 0 || !this.mCheckStates.valueAt(0)) {
                        this.mCheckedItemCount = 0;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                this.updateOnScreenCheckedViews();
            }
        }
        if (bl) {
            bl2 |= super.performItemClick(view, n, l);
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean performLongPress(View view, int n, long l) {
        boolean bl = true;
        if (this.mChoiceMode == 3) {
            ActionMode actionMode;
            if (this.mChoiceActionMode != null) return bl;
            this.mChoiceActionMode = actionMode = this.startActionMode(this.mMultiChoiceModeCallback);
            if (actionMode == null) return bl;
            this.setItemChecked(n, bl);
            this.performHapticFeedback(0);
            return bl;
        }
        AdapterView.OnItemLongClickListener onItemLongClickListener = this.mOnItemLongClickListener;
        bl = false;
        if (onItemLongClickListener != null) {
            bl = this.mOnItemLongClickListener.onItemLongClick(this, view, n, l);
        }
        if (!bl) {
            this.mContextMenuInfo = this.createContextMenuInfo(view, n, l);
            bl = super.showContextMenuForChild(this);
        }
        if (!bl) return bl;
        this.performHapticFeedback(0);
        return bl;
    }

    public int pointToPosition(int n, int n2) {
        Rect rect = this.mTouchFrame;
        if (rect == null) {
            rect = this.mTouchFrame = new Rect();
        }
        for (int i = -1 + this.getChildCount(); i >= 0; --i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() != 0) continue;
            view.getHitRect(rect);
            if (!rect.contains(n, n2)) continue;
            return i + this.mFirstPosition;
        }
        return -1;
    }

    public long pointToRowId(int n, int n2) {
        int n3 = this.pointToPosition(n, n2);
        if (n3 >= 0) {
            return this.mAdapter.getItemId(n3);
        }
        return Long.MIN_VALUE;
    }

    /*
     * Enabled aggressive block sorting
     */
    void positionSelector(int n, View view) {
        if (n != -1) {
            this.mSelectorPosition = n;
        }
        Rect rect = this.mSelectorRect;
        rect.set(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        if (view instanceof SelectionBoundsAdjuster) {
            ((SelectionBoundsAdjuster)((Object)view)).adjustListItemSelectionBounds(rect);
        }
        rect.left -= this.mSelectionLeftPadding;
        rect.top -= this.mSelectionTopPadding;
        rect.right += this.mSelectionRightPadding;
        rect.bottom += this.mSelectionBottomPadding;
        Drawable drawable2 = this.mSelector;
        if (drawable2 != null) {
            drawable2.setBounds(rect);
        }
        boolean bl = this.mIsChildViewEnabled;
        if (view.isEnabled() != bl) {
            boolean bl2 = !bl;
            this.mIsChildViewEnabled = bl2;
            if (this.getSelectedItemPosition() != -1) {
                this.refreshDrawableState();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void positionSelectorLikeFocus(int n, View view) {
        boolean bl = true;
        Drawable drawable2 = this.mSelector;
        boolean bl2 = drawable2 != null && this.mSelectorPosition != n && n != -1 ? bl : false;
        if (bl2) {
            drawable2.setVisible(false, false);
        }
        this.positionSelector(n, view);
        if (bl2) {
            Rect rect = this.mSelectorRect;
            float f = rect.exactCenterX();
            float f2 = rect.exactCenterY();
            if (this.getVisibility() != 0) {
                bl = false;
            }
            drawable2.setVisible(bl, false);
            drawable2.setHotspot(f, f2);
        }
    }

    void positionSelectorLikeTouch(int n, View view, float f, float f2) {
        this.positionSelectorLikeFocus(n, view);
        if (this.mSelector != null && n != -1) {
            this.mSelector.setHotspot(f, f2);
        }
    }

    public void reclaimViews(List<View> list) {
        int n = this.getChildCount();
        RecyclerListener recyclerListener = this.mRecycler.mRecyclerListener;
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (layoutParams == null || !this.mRecycler.shouldRecycleViewType(layoutParams.viewType)) continue;
            list.add(view);
            view.setAccessibilityDelegate(null);
            if (recyclerListener == null) continue;
            recyclerListener.onMovedToScrapHeap(view);
        }
        this.mRecycler.reclaimScrapViews(list);
        this.removeAllViewsInLayout();
    }

    int reconcileSelectedPosition() {
        int n = this.mSelectedPosition;
        if (n < 0) {
            n = this.mResurrectToPosition;
        }
        return Math.min(Math.max(0, n), -1 + this.mItemCount);
    }

    void reportScrollStateChange(int n) {
        if (n != this.mLastScrollState && this.mOnScrollListener != null) {
            this.mLastScrollState = n;
            this.mOnScrollListener.onScrollStateChanged(this, n);
        }
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean bl) {
        if (bl) {
            this.recycleVelocityTracker();
        }
        super.requestDisallowInterceptTouchEvent(bl);
    }

    @Override
    public void requestLayout() {
        if (!this.mBlockLayoutRequests && !this.mInLayout) {
            super.requestLayout();
        }
    }

    void requestLayoutIfNecessary() {
        if (this.getChildCount() > 0) {
            this.resetList();
            this.requestLayout();
            this.invalidate();
        }
    }

    void resetList() {
        this.removeAllViewsInLayout();
        this.mFirstPosition = 0;
        this.mDataChanged = false;
        this.mPositionScrollAfterLayout = null;
        this.mNeedSync = false;
        this.mPendingSync = null;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        this.setSelectedPositionInt(-1);
        this.setNextSelectedPositionInt(-1);
        this.mSelectedTop = 0;
        this.mSelectorPosition = -1;
        this.mSelectorRect.setEmpty();
        this.invalidate();
    }

    /*
     * Unable to fully structure code
     */
    boolean resurrectSelection() {
        block14: {
            block16: {
                block15: {
                    var1_1 = this.getChildCount();
                    if (var1_1 <= 0) {
                        return false;
                    }
                    var2_2 = 0;
                    var3_3 = this.mListPadding.top;
                    var4_4 = this.mBottom - this.mTop - this.mListPadding.bottom;
                    var5_5 = this.mFirstPosition;
                    var6_6 = this.mResurrectToPosition;
                    var7_7 = true;
                    if (var6_6 < var5_5 || var6_6 >= var5_5 + var1_1) break block15;
                    var9_8 = var6_6;
                    var18_9 = this.getChildAt(var9_8 - this.mFirstPosition);
                    var2_2 = var18_9.getTop();
                    var19_10 = var18_9.getBottom();
                    if (var2_2 < var3_3) {
                        var2_2 = var3_3 + this.getVerticalFadingEdgeLength();
lbl17:
                        // 6 sources

                        while (true) {
                            this.mResurrectToPosition = -1;
                            this.removeCallbacks(this.mFlingRunnable);
                            if (this.mPositionScroller != null) {
                                this.mPositionScroller.stop();
                            }
                            this.mTouchMode = -1;
                            this.clearScrollingCache();
                            this.mSpecificTop = var2_2;
                            var15_11 = this.lookForSelectablePosition(var9_8, var7_7);
                            if (var15_11 >= var5_5 && var15_11 <= this.getLastVisiblePosition()) {
                                this.mLayoutMode = 4;
                                this.updateSelectorState();
                                this.setSelectionInt(var15_11);
                                this.invokeOnItemScrollListener();
lbl32:
                                // 2 sources

                                while (true) {
                                    this.reportScrollStateChange(0);
                                    return var15_11 >= 0;
                                }
                            }
                            break block14;
                            break;
                        }
                    }
                    if (var19_10 > var4_4) {
                        var2_2 = var4_4 - var18_9.getMeasuredHeight() - this.getVerticalFadingEdgeLength();
                    }
                    ** GOTO lbl17
                }
                if (var6_6 >= var5_5) break block16;
                var9_8 = var5_5;
                var16_12 = 0;
                while (true) {
                    block17: {
                        if (var16_12 >= var1_1) ** GOTO lbl17
                        var17_13 = this.getChildAt(var16_12).getTop();
                        if (var16_12 == 0) {
                            var2_2 = var17_13;
                            if (var5_5 > 0 || var17_13 < var3_3) {
                                var3_3 += this.getVerticalFadingEdgeLength();
                            }
                        }
                        if (var17_13 < var3_3) break block17;
                        var9_8 = var5_5 + var16_12;
                        var2_2 = var17_13;
                        ** GOTO lbl17
                    }
                    ++var16_12;
                }
            }
            var8_14 = this.mItemCount;
            var9_8 = -1 + (var5_5 + var1_1);
            var10_15 = var1_1 - 1;
            while (true) {
                var7_7 = false;
                if (var10_15 < 0) ** GOTO lbl17
                var11_16 = this.getChildAt(var10_15);
                var12_17 = var11_16.getTop();
                var13_18 = var11_16.getBottom();
                if (var10_15 == var1_1 - 1) {
                    var2_2 = var12_17;
                    if (var5_5 + var1_1 < var8_14 || var13_18 > var4_4) {
                        var4_4 -= this.getVerticalFadingEdgeLength();
                    }
                }
                if (var13_18 <= var4_4) {
                    var9_8 = var5_5 + var10_15;
                    var2_2 = var12_17;
                    var7_7 = false;
                    ** continue;
                }
                --var10_15;
            }
        }
        var15_11 = -1;
        ** while (true)
    }

    boolean resurrectSelectionIfNeeded() {
        if (this.mSelectedPosition < 0 && this.resurrectSelection()) {
            this.updateSelectorState();
            return true;
        }
        return false;
    }

    public void scrollListBy(int n) {
        this.trackMotionScroll(-n, -n);
    }

    @Override
    public void sendAccessibilityEvent(int n) {
        if (n == 4096) {
            int n2 = this.getFirstVisiblePosition();
            int n3 = this.getLastVisiblePosition();
            if (this.mLastAccessibilityScrollEventFromIndex == n2 && this.mLastAccessibilityScrollEventToIndex == n3) {
                return;
            }
            this.mLastAccessibilityScrollEventFromIndex = n2;
            this.mLastAccessibilityScrollEventToIndex = n3;
        }
        super.sendAccessibilityEvent(n);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    boolean sendToTextFilter(int var1_1, int var2_2, KeyEvent var3_3) {
        block21: {
            if (!this.acceptFilter()) {
                return false;
            }
            var4_5 = true;
            var5_4 = false;
            switch (var1_1) {
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 66: {
                    var5_4 = false;
                    var4_5 = false;
                    ** break;
                }
                case 4: {
                    var7_7 = this.mFiltered;
                    var5_4 = false;
                    if (var7_7) {
                        var8_8 = this.mPopup;
                        var5_4 = false;
                        if (var8_8 != null) {
                            var9_9 = this.mPopup.isShowing();
                            var5_4 = false;
                            if (var9_9) {
                                if (var3_3.getAction() == 0 && var3_3.getRepeatCount() == 0) {
                                    var13_10 = this.getKeyDispatcherState();
                                    if (var13_10 != null) {
                                        var13_10.startTracking(var3_3, this);
                                    }
                                    var5_4 = true;
                                } else {
                                    var10_11 = var3_3.getAction();
                                    var5_4 = false;
                                    if (var10_11 == 1) {
                                        var11_12 = var3_3.isTracking();
                                        var5_4 = false;
                                        if (var11_12) {
                                            var12_13 = var3_3.isCanceled();
                                            var5_4 = false;
                                            if (!var12_13) {
                                                var5_4 = true;
                                                this.mTextFilter.setText("");
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    var4_5 = false;
                }
lbl38:
                // 3 sources

                default: {
                    break block21;
                }
                case 62: 
            }
            var4_5 = this.mFiltered;
            var5_4 = false;
        }
        if (var4_5 == false) return var5_4;
        this.createTextFilter(true);
        var6_6 = var3_3;
        if (var6_6.getRepeatCount() > 0) {
            var6_6 = KeyEvent.changeTimeRepeat(var3_3, var3_3.getEventTime(), 0);
        }
        switch (var3_3.getAction()) {
            default: {
                return var5_4;
            }
            case 0: {
                return this.mTextFilter.onKeyDown(var1_1, var6_6);
            }
            case 1: {
                return this.mTextFilter.onKeyUp(var1_1, var6_6);
            }
            case 2: 
        }
        return this.mTextFilter.onKeyMultiple(var1_1, var2_2, var3_3);
    }

    @Override
    public void setAdapter(ListAdapter listAdapter) {
        if (listAdapter != null) {
            this.mAdapterHasStableIds = this.mAdapter.hasStableIds();
            if (this.mChoiceMode != 0 && this.mAdapterHasStableIds && this.mCheckedIdStates == null) {
                this.mCheckedIdStates = new LongSparseArray();
            }
        }
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
    }

    public void setCacheColorHint(int n) {
        if (n != this.mCacheColorHint) {
            this.mCacheColorHint = n;
            int n2 = this.getChildCount();
            for (int i = 0; i < n2; ++i) {
                this.getChildAt(i).setDrawingCacheBackgroundColor(n);
            }
            this.mRecycler.setCacheColorHint(n);
        }
    }

    public void setChoiceMode(int n) {
        this.mChoiceMode = n;
        if (this.mChoiceActionMode != null) {
            this.mChoiceActionMode.finish();
            this.mChoiceActionMode = null;
        }
        if (this.mChoiceMode != 0) {
            if (this.mCheckStates == null) {
                this.mCheckStates = new SparseBooleanArray(0);
            }
            if (this.mCheckedIdStates == null && this.mAdapter != null && this.mAdapter.hasStableIds()) {
                this.mCheckedIdStates = new LongSparseArray(0);
            }
            if (this.mChoiceMode == 3) {
                this.clearChoices();
                this.setLongClickable(true);
            }
        }
    }

    public void setDrawSelectorOnTop(boolean bl) {
        this.mDrawSelectorOnTop = bl;
    }

    public void setFastScrollAlwaysVisible(final boolean bl) {
        block5: {
            block4: {
                if (this.mFastScrollAlwaysVisible == bl) break block4;
                if (bl && !this.mFastScrollEnabled) {
                    this.setFastScrollEnabled(true);
                }
                this.mFastScrollAlwaysVisible = bl;
                if (!this.isOwnerThread()) break block5;
                this.setFastScrollerAlwaysVisibleUiThread(bl);
            }
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                AbsListView.this.setFastScrollerAlwaysVisibleUiThread(bl);
            }
        });
    }

    public void setFastScrollEnabled(final boolean bl) {
        block3: {
            block2: {
                if (this.mFastScrollEnabled == bl) break block2;
                this.mFastScrollEnabled = bl;
                if (!this.isOwnerThread()) break block3;
                this.setFastScrollerEnabledUiThread(bl);
            }
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                AbsListView.this.setFastScrollerEnabledUiThread(bl);
            }
        });
    }

    public void setFastScrollStyle(int n) {
        if (this.mFastScroll == null) {
            this.mFastScrollStyle = n;
            return;
        }
        this.mFastScroll.setStyle(n);
    }

    public void setFilterText(String string2) {
        if (this.mTextFilterEnabled && !TextUtils.isEmpty(string2)) {
            this.createTextFilter(false);
            this.mTextFilter.setText(string2);
            this.mTextFilter.setSelection(string2.length());
            if (this.mAdapter instanceof Filterable) {
                if (this.mPopup == null) {
                    ((Filterable)((Object)this.mAdapter)).getFilter().filter(string2);
                }
                this.mFiltered = true;
                this.mDataSetObserver.clearSavedState();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean setFrame(int n, int n2, int n3, int n4) {
        boolean bl = super.setFrame(n, n2, n3, n4);
        if (bl) {
            boolean bl2 = this.getWindowVisibility() == 0;
            if (this.mFiltered && bl2 && this.mPopup != null && this.mPopup.isShowing()) {
                this.positionPopup();
            }
        }
        return bl;
    }

    public void setFriction(float f) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable();
        }
        this.mFlingRunnable.mScroller.setFriction(f);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setItemChecked(int n, boolean bl) {
        block21: {
            block20: {
                if (this.mChoiceMode == 0) break block20;
                if (bl && this.mChoiceMode == 3 && this.mChoiceActionMode == null) {
                    if (this.mMultiChoiceModeCallback == null || !this.mMultiChoiceModeCallback.hasWrappedCallback()) {
                        throw new IllegalStateException("AbsListView: attempted to start selection mode for CHOICE_MODE_MULTIPLE_MODAL but no choice mode callback was supplied. Call setMultiChoiceModeListener to set a callback.");
                    }
                    this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback);
                }
                if (this.mChoiceMode == 2 || this.mChoiceMode == 3) {
                    boolean bl2 = this.mCheckStates.get(n);
                    this.mCheckStates.put(n, bl);
                    if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                        if (bl) {
                            this.mCheckedIdStates.put(this.mAdapter.getItemId(n), n);
                        } else {
                            this.mCheckedIdStates.delete(this.mAdapter.getItemId(n));
                        }
                    }
                    if (bl2 != bl) {
                        this.mCheckedItemCount = bl ? 1 + this.mCheckedItemCount : -1 + this.mCheckedItemCount;
                    }
                    if (this.mChoiceActionMode != null) {
                        long l = this.mAdapter.getItemId(n);
                        this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, n, l, bl);
                    }
                } else {
                    boolean bl3 = this.mCheckedIdStates != null && this.mAdapter.hasStableIds();
                    if (bl || this.isItemChecked(n)) {
                        this.mCheckStates.clear();
                        if (bl3) {
                            this.mCheckedIdStates.clear();
                        }
                    }
                    if (bl) {
                        this.mCheckStates.put(n, true);
                        if (bl3) {
                            this.mCheckedIdStates.put(this.mAdapter.getItemId(n), n);
                        }
                        this.mCheckedItemCount = 1;
                    } else if (this.mCheckStates.size() == 0 || !this.mCheckStates.valueAt(0)) {
                        this.mCheckedItemCount = 0;
                    }
                }
                if (!this.mInLayout && !this.mBlockLayoutRequests) break block21;
            }
            return;
        }
        this.mDataChanged = true;
        this.rememberSyncState();
        this.requestLayout();
    }

    public void setMultiChoiceModeListener(MultiChoiceModeListener multiChoiceModeListener) {
        if (this.mMultiChoiceModeCallback == null) {
            this.mMultiChoiceModeCallback = new MultiChoiceModeWrapper();
        }
        this.mMultiChoiceModeCallback.setWrapped(multiChoiceModeListener);
    }

    public void setOnScrollListener(OnScrollListener onScrollListener) {
        this.mOnScrollListener = onScrollListener;
        this.invokeOnItemScrollListener();
    }

    public void setOverScrollEffectPadding(int n, int n2) {
        this.mGlowPaddingLeft = n;
        this.mGlowPaddingRight = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setOverScrollMode(int n) {
        if (n != 2) {
            if (this.mEdgeGlowTop == null) {
                Context context = this.getContext();
                this.mEdgeGlowTop = new EdgeEffect(context);
                this.mEdgeGlowBottom = new EdgeEffect(context);
            }
        } else {
            this.mEdgeGlowTop = null;
            this.mEdgeGlowBottom = null;
        }
        super.setOverScrollMode(n);
    }

    public void setRecyclerListener(RecyclerListener recyclerListener) {
        RecycleBin.access$3902(this.mRecycler, recyclerListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setRemoteViewsAdapter(Intent intent) {
        block3: {
            block2: {
                if (this.mRemoteAdapter != null && new Intent.FilterComparison(intent).equals(new Intent.FilterComparison(this.mRemoteAdapter.getRemoteViewsServiceIntent()))) break block2;
                this.mDeferNotifyDataSetChanged = false;
                this.mRemoteAdapter = new RemoteViewsAdapter(this.getContext(), intent, this);
                if (this.mRemoteAdapter.isDataReady()) break block3;
            }
            return;
        }
        this.setAdapter(this.mRemoteAdapter);
    }

    public void setRemoteViewsOnClickHandler(RemoteViews.OnClickHandler onClickHandler) {
        if (this.mRemoteAdapter != null) {
            this.mRemoteAdapter.setRemoteViewsOnClickHandler(onClickHandler);
        }
    }

    @Override
    public void setScrollBarStyle(int n) {
        super.setScrollBarStyle(n);
        if (this.mFastScroll != null) {
            this.mFastScroll.setScrollBarStyle(n);
        }
    }

    public void setScrollIndicators(View view, View view2) {
        this.mScrollUp = view;
        this.mScrollDown = view2;
    }

    public void setScrollingCacheEnabled(boolean bl) {
        if (this.mScrollingCacheEnabled && !bl) {
            this.clearScrollingCache();
        }
        this.mScrollingCacheEnabled = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setSelectionFromTop(int n, int n2) {
        block11: {
            block10: {
                if (this.mAdapter == null) break block10;
                if (!this.isInTouchMode()) {
                    if ((n = this.lookForSelectablePosition(n, true)) >= 0) {
                        this.setNextSelectedPositionInt(n);
                    }
                } else {
                    this.mResurrectToPosition = n;
                }
                if (n >= 0) break block11;
            }
            return;
        }
        this.mLayoutMode = 4;
        this.mSpecificTop = n2 + this.mListPadding.top;
        if (this.mNeedSync) {
            this.mSyncPosition = n;
            this.mSyncRowId = this.mAdapter.getItemId(n);
        }
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        this.requestLayout();
    }

    abstract void setSelectionInt(int var1);

    public void setSelector(int n) {
        this.setSelector(this.getContext().getDrawable(n));
    }

    public void setSelector(Drawable drawable2) {
        if (this.mSelector != null) {
            this.mSelector.setCallback(null);
            this.unscheduleDrawable(this.mSelector);
        }
        this.mSelector = drawable2;
        Rect rect = new Rect();
        drawable2.getPadding(rect);
        this.mSelectionLeftPadding = rect.left;
        this.mSelectionTopPadding = rect.top;
        this.mSelectionRightPadding = rect.right;
        this.mSelectionBottomPadding = rect.bottom;
        drawable2.setCallback(this);
        this.updateSelectorState();
    }

    public void setSmoothScrollbarEnabled(boolean bl) {
        this.mSmoothScrollbarEnabled = bl;
    }

    public void setStackFromBottom(boolean bl) {
        if (this.mStackFromBottom != bl) {
            this.mStackFromBottom = bl;
            this.requestLayoutIfNecessary();
        }
    }

    public void setTextFilterEnabled(boolean bl) {
        this.mTextFilterEnabled = bl;
    }

    public void setTranscriptMode(int n) {
        this.mTranscriptMode = n;
    }

    public void setVelocityScale(float f) {
        this.mVelocityScale = f;
    }

    @Override
    public void setVerticalScrollbarPosition(int n) {
        super.setVerticalScrollbarPosition(n);
        if (this.mFastScroll != null) {
            this.mFastScroll.setScrollbarPosition(n);
        }
    }

    void setVisibleRangeHint(int n, int n2) {
        if (this.mRemoteAdapter != null) {
            this.mRemoteAdapter.setVisibleRangeHint(n, n2);
        }
    }

    boolean shouldShowSelector() {
        return !this.isInTouchMode() || this.touchModeDrawsInPressedState() && this.isPressed();
    }

    @Override
    public boolean showContextMenu(float f, float f2, int n) {
        int n2 = this.pointToPosition((int)f, (int)f2);
        if (n2 != -1) {
            long l = this.mAdapter.getItemId(n2);
            View view = this.getChildAt(n2 - this.mFirstPosition);
            if (view != null) {
                this.mContextMenuInfo = this.createContextMenuInfo(view, n2, l);
                return super.showContextMenuForChild(this);
            }
        }
        return super.showContextMenu(f, f2, n);
    }

    @Override
    public boolean showContextMenuForChild(View view) {
        int n = this.getPositionForView(view);
        if (n >= 0) {
            long l = this.mAdapter.getItemId(n);
            AdapterView.OnItemLongClickListener onItemLongClickListener = this.mOnItemLongClickListener;
            boolean bl = false;
            if (onItemLongClickListener != null) {
                bl = this.mOnItemLongClickListener.onItemLongClick(this, view, n, l);
            }
            if (!bl) {
                this.mContextMenuInfo = this.createContextMenuInfo(this.getChildAt(n - this.mFirstPosition), n, l);
                bl = super.showContextMenuForChild(view);
            }
            return bl;
        }
        return false;
    }

    public void smoothScrollBy(int n, int n2) {
        this.smoothScrollBy(n, n2, false);
    }

    void smoothScrollBy(int n, int n2, boolean bl) {
        if (this.mFlingRunnable == null) {
            this.mFlingRunnable = new FlingRunnable();
        }
        int n3 = this.mFirstPosition;
        int n4 = this.getChildCount();
        int n5 = n3 + n4;
        int n6 = this.getPaddingTop();
        int n7 = this.getHeight() - this.getPaddingBottom();
        if (n == 0 || this.mItemCount == 0 || n4 == 0 || n3 == 0 && this.getChildAt(0).getTop() == n6 && n < 0 || n5 == this.mItemCount && this.getChildAt(n4 - 1).getBottom() == n7 && n > 0) {
            this.mFlingRunnable.endFling();
            if (this.mPositionScroller != null) {
                this.mPositionScroller.stop();
            }
            return;
        }
        this.reportScrollStateChange(2);
        this.mFlingRunnable.startScroll(n, n2, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    void smoothScrollByOffset(int n) {
        View view;
        int n2 = -1;
        if (n < 0) {
            n2 = this.getFirstVisiblePosition();
        } else if (n > 0) {
            n2 = this.getLastVisiblePosition();
        }
        if (n2 > -1 && (view = this.getChildAt(n2 - this.getFirstVisiblePosition())) != null) {
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                int n3 = view.getWidth() * view.getHeight();
                float f = (float)(rect.width() * rect.height()) / (float)n3;
                if (n < 0 && f < 0.75f) {
                    ++n2;
                } else if (n > 0 && f < 0.75f) {
                    --n2;
                }
            }
            this.smoothScrollToPosition(Math.max(0, Math.min(this.getCount(), n2 + n)));
        }
    }

    public void smoothScrollToPosition(int n) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = this.createPositionScroller();
        }
        this.mPositionScroller.start(n);
    }

    public void smoothScrollToPosition(int n, int n2) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = this.createPositionScroller();
        }
        this.mPositionScroller.start(n, n2);
    }

    public void smoothScrollToPositionFromTop(int n, int n2) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = this.createPositionScroller();
        }
        this.mPositionScroller.startWithOffset(n, n2, n2);
    }

    public void smoothScrollToPositionFromTop(int n, int n2, int n3) {
        if (this.mPositionScroller == null) {
            this.mPositionScroller = this.createPositionScroller();
        }
        this.mPositionScroller.startWithOffset(n, n2, n3);
    }

    boolean touchModeDrawsInPressedState() {
        switch (this.mTouchMode) {
            default: {
                return false;
            }
            case 1: 
            case 2: 
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    boolean trackMotionScroll(int var1_1, int var2_2) {
        block39: {
            block36: {
                block34: {
                    block35: {
                        block29: {
                            block30: {
                                block31: {
                                    block32: {
                                        block33: {
                                            block38: {
                                                block37: {
                                                    var3_3 = this.getChildCount();
                                                    if (var3_3 == 0) {
                                                        return true;
                                                    }
                                                    var4_4 = this.getChildAt(0).getTop();
                                                    var5_5 = this.getChildAt(var3_3 - 1).getBottom();
                                                    var6_6 = this.mListPadding;
                                                    var7_7 = 34 & this.mGroupFlags;
                                                    var8_8 = 0;
                                                    var9_9 = 0;
                                                    if (var7_7 == 34) {
                                                        var9_9 = var6_6.top;
                                                        var8_8 = var6_6.bottom;
                                                    }
                                                    var10_10 = var9_9 - var4_4;
                                                    var11_11 = var5_5 - (this.getHeight() - var8_8);
                                                    var12_12 = this.getHeight() - this.mPaddingBottom - this.mPaddingTop;
                                                    if (var1_1 >= 0) break block37;
                                                    var13_13 = Math.max(-(var12_12 - 1), var1_1);
lbl18:
                                                    // 2 sources

                                                    while (var2_2 < 0) {
                                                        var14_14 = Math.max(-(var12_12 - 1), var2_2);
lbl20:
                                                        // 2 sources

                                                        while ((var15_15 = this.mFirstPosition) == 0) {
                                                            this.mFirstPositionDistanceGuess = var4_4 - var6_6.top;
lbl22:
                                                            // 2 sources

                                                            while (var15_15 + var3_3 == this.mItemCount) {
                                                                this.mLastPositionDistanceGuess = var5_5 + var6_6.bottom;
lbl24:
                                                                // 2 sources

                                                                while (var15_15 == 0 && var4_4 >= var6_6.top && var14_14 >= 0) {
                                                                    var16_16 = true;
lbl26:
                                                                    // 2 sources

                                                                    while (var15_15 + var3_3 == this.mItemCount && var5_5 <= this.getHeight() - var6_6.bottom && var14_14 <= 0) {
                                                                        var17_17 = true;
lbl28:
                                                                        // 2 sources

                                                                        while (var16_16 || var17_17) {
                                                                            return var14_14 != 0;
                                                                        }
                                                                        break block29;
                                                                    }
                                                                    break block30;
                                                                }
                                                                break block31;
                                                            }
                                                            break block32;
                                                        }
                                                        break block33;
                                                    }
                                                    break block38;
                                                }
                                                var13_13 = Math.min(var12_12 - 1, var1_1);
                                                ** GOTO lbl18
                                            }
                                            var14_14 = Math.min(var12_12 - 1, var2_2);
                                            ** GOTO lbl20
                                        }
                                        this.mFirstPositionDistanceGuess = var14_14 + this.mFirstPositionDistanceGuess;
                                        ** GOTO lbl22
                                    }
                                    this.mLastPositionDistanceGuess = var14_14 + this.mLastPositionDistanceGuess;
                                    ** GOTO lbl24
                                }
                                var16_16 = false;
                                ** GOTO lbl26
                            }
                            var17_17 = false;
                            ** GOTO lbl28
                        }
                        if (var14_14 < 0) {
                            var18_18 = true;
lbl57:
                            // 2 sources

                            while (true) {
                                var19_19 = this.isInTouchMode();
                                if (var19_19) {
                                    this.hideSelector();
                                }
                                var20_20 = this.getHeaderViewsCount();
                                var21_21 = this.mItemCount - this.getFooterViewsCount();
                                var22_22 = 0;
                                var23_23 = 0;
                                if (!var18_18) break block34;
                                var31_24 = -var14_14;
                                if ((34 & this.mGroupFlags) == 34) {
                                    var31_24 += var6_6.top;
                                }
                                var32_25 = 0;
lbl70:
                                // 2 sources

                                while (true) {
                                    var33_26 = ++var32_25;
                                    var22_22 = 0;
                                    if (var33_26 < var3_3) {
                                        var34_27 = this.getChildAt(var32_25);
                                        var35_28 = var34_27.getBottom();
                                        var36_29 = var31_24;
                                        var22_22 = 0;
                                        if (var35_28 < var36_29) break block35;
                                    }
                                    while (true) {
                                        this.mMotionViewNewTop = var13_13 + this.mMotionViewOriginalTop;
                                        this.mBlockLayoutRequests = true;
                                        if (var23_23 > 0) {
                                            this.detachViewsFromParent(var22_22, var23_23);
                                            this.mRecycler.removeSkippedScrap();
                                        }
                                        if (!this.awakenScrollBars()) {
                                            this.invalidate();
                                        }
                                        this.offsetChildrenTopAndBottom(var14_14);
                                        if (var18_18) {
                                            this.mFirstPosition = var23_23 + this.mFirstPosition;
                                        }
                                        if (var10_10 < (var28_31 = Math.abs(var14_14)) || var11_11 < var28_31) {
                                            this.fillGap(var18_18);
                                        }
                                        if (!var19_19 && this.mSelectedPosition != -1) {
                                            var30_32 = this.mSelectedPosition - this.mFirstPosition;
                                            if (var30_32 >= 0 && var30_32 < this.getChildCount()) {
                                                this.positionSelector(this.mSelectedPosition, this.getChildAt(var30_32));
                                            }
lbl96:
                                            // 5 sources

                                            while (true) {
                                                this.mBlockLayoutRequests = false;
                                                this.invokeOnItemScrollListener();
                                                return false;
                                            }
                                        }
                                        break block36;
                                        break;
                                    }
                                    break;
                                }
                                break;
                            }
                        }
                        var18_18 = false;
                        ** while (true)
                    }
                    ++var23_23;
                    var37_30 = var15_15 + var32_25;
                    if (var37_30 >= var20_20 && var37_30 < var21_21) {
                        if (var34_27.isAccessibilityFocused()) {
                            var34_27.clearAccessibilityFocus();
                        }
                        this.mRecycler.addScrapView(var34_27, var37_30);
                    }
                    ** while (true)
                }
                var24_33 = this.getHeight() - var14_14;
                if ((34 & this.mGroupFlags) == 34) {
                    var24_33 -= var6_6.bottom;
                }
                var25_34 = var3_3 - 1;
                while (true) {
                    if (var25_34 < 0 || (var26_35 = this.getChildAt(var25_34)).getTop() <= var24_33) ** continue;
                    var22_22 = var25_34;
                    ++var23_23;
                    var27_36 = var15_15 + var25_34;
                    if (var27_36 >= var20_20 && var27_36 < var21_21) {
                        if (var26_35.isAccessibilityFocused()) {
                            var26_35.clearAccessibilityFocus();
                        }
                        this.mRecycler.addScrapView(var26_35, var27_36);
                    }
                    --var25_34;
                }
            }
            if (this.mSelectorPosition == -1) break block39;
            var29_37 = this.mSelectorPosition - this.mFirstPosition;
            if (var29_37 >= 0 && var29_37 < this.getChildCount()) {
                this.positionSelector(-1, this.getChildAt(var29_37));
            }
            ** GOTO lbl96
        }
        this.mSelectorRect.setEmpty();
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    void updateScrollIndicators() {
        if (this.mScrollUp != null) {
            View view = this.mScrollUp;
            int n = this.canScrollUp() ? 0 : 4;
            view.setVisibility(n);
        }
        if (this.mScrollDown != null) {
            View view = this.mScrollDown;
            boolean bl = this.canScrollDown();
            int n = 0;
            if (!bl) {
                n = 4;
            }
            view.setVisibility(n);
        }
    }

    void updateSelectorState() {
        block3: {
            block2: {
                if (this.mSelector == null) break block2;
                if (!this.shouldShowSelector()) break block3;
                this.mSelector.setState(this.getDrawableState());
            }
            return;
        }
        this.mSelector.setState(StateSet.NOTHING);
    }

    @Override
    public boolean verifyDrawable(Drawable drawable2) {
        return this.mSelector == drawable2 || super.verifyDrawable(drawable2);
    }

    static abstract class AbsPositionScroller {
        AbsPositionScroller() {
        }

        public abstract void start(int var1);

        public abstract void start(int var1, int var2);

        public abstract void startWithOffset(int var1, int var2);

        public abstract void startWithOffset(int var1, int var2, int var3);

        public abstract void stop();
    }

    class AdapterDataSetObserver
    extends AdapterView.AdapterDataSetObserver {
        AdapterDataSetObserver() {
            super(AbsListView.this);
        }

        @Override
        public void onChanged() {
            super.onChanged();
            if (AbsListView.this.mFastScroll != null) {
                AbsListView.this.mFastScroll.onSectionsChanged();
            }
        }

        @Override
        public void onInvalidated() {
            super.onInvalidated();
            if (AbsListView.this.mFastScroll != null) {
                AbsListView.this.mFastScroll.onSectionsChanged();
            }
        }
    }

    private class CheckForKeyLongPress
    extends WindowRunnnable
    implements Runnable {
        private CheckForKeyLongPress() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            if (!AbsListView.this.isPressed() || AbsListView.this.mSelectedPosition < 0) return;
            int n = AbsListView.this.mSelectedPosition - AbsListView.this.mFirstPosition;
            View view = AbsListView.this.getChildAt(n);
            if (!AbsListView.this.mDataChanged) {
                boolean bl = this.sameWindow();
                boolean bl2 = false;
                if (bl) {
                    bl2 = AbsListView.this.performLongPress(view, AbsListView.this.mSelectedPosition, AbsListView.this.mSelectedRowId);
                }
                if (!bl2) return;
                AbsListView.this.setPressed(false);
                view.setPressed(false);
                return;
            }
            AbsListView.this.setPressed(false);
            if (view == null) return;
            view.setPressed(false);
        }
    }

    private class CheckForLongPress
    extends WindowRunnnable
    implements Runnable {
        private CheckForLongPress() {
        }

        @Override
        public void run() {
            block6: {
                block5: {
                    int n = AbsListView.this.mMotionPosition;
                    View view = AbsListView.this.getChildAt(n - AbsListView.this.mFirstPosition);
                    if (view == null) break block5;
                    int n2 = AbsListView.this.mMotionPosition;
                    long l = AbsListView.this.mAdapter.getItemId(AbsListView.this.mMotionPosition);
                    boolean bl = this.sameWindow();
                    boolean bl2 = false;
                    if (bl) {
                        boolean bl3 = AbsListView.this.mDataChanged;
                        bl2 = false;
                        if (!bl3) {
                            bl2 = AbsListView.this.performLongPress(view, n2, l);
                        }
                    }
                    if (!bl2) break block6;
                    AbsListView.this.mTouchMode = -1;
                    AbsListView.this.setPressed(false);
                    view.setPressed(false);
                }
                return;
            }
            AbsListView.this.mTouchMode = 2;
        }
    }

    private final class CheckForTap
    implements Runnable {
        boolean isMouseButtonSecondary = false;
        float x;
        float y;

        private CheckForTap() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            if (AbsListView.this.mTouchMode == 0) {
                AbsListView.this.mTouchMode = 1;
                View view = AbsListView.this.getChildAt(AbsListView.this.mMotionPosition - AbsListView.this.mFirstPosition);
                if (view != null && !view.hasFocusable()) {
                    AbsListView.this.mLayoutMode = 0;
                    if (AbsListView.this.mDataChanged) {
                        AbsListView.this.mTouchMode = 2;
                        return;
                    }
                    view.setPressed(true);
                    AbsListView.this.setPressed(true);
                    AbsListView.this.layoutChildren();
                    AbsListView.this.positionSelector(AbsListView.this.mMotionPosition, view);
                    AbsListView.this.refreshDrawableState();
                    int n = ViewConfiguration.getLongPressTimeout();
                    boolean bl = AbsListView.this.isLongClickable();
                    if (AbsListView.this.mSelector != null) {
                        Drawable drawable2 = AbsListView.this.mSelector.getCurrent();
                        if (drawable2 != null && drawable2 instanceof TransitionDrawable) {
                            if (bl) {
                                ((TransitionDrawable)drawable2).startTransition(n);
                            } else {
                                ((TransitionDrawable)drawable2).resetTransition();
                            }
                        }
                        AbsListView.this.mSelector.setHotspot(this.x, this.y);
                    }
                    if (!bl) {
                        AbsListView.this.mTouchMode = 2;
                        return;
                    }
                    if (AbsListView.this.mPendingCheckForLongPress == null) {
                        AbsListView.access$702(AbsListView.this, new CheckForLongPress());
                    }
                    AbsListView.this.mPendingCheckForLongPress.rememberWindowAttachCount();
                    if (!this.isMouseButtonSecondary) {
                        AbsListView.this.postDelayed(AbsListView.this.mPendingCheckForLongPress, n);
                        return;
                    }
                    AbsListView.this.post(AbsListView.this.mPendingCheckForLongPress);
                }
            }
        }
    }

    private class FlingRunnable
    implements Runnable {
        private static final int FLYWHEEL_TIMEOUT = 40;
        private final Runnable mCheckFlywheel = new Runnable(){

            @Override
            public void run() {
                int n = AbsListView.this.mActivePointerId;
                VelocityTracker velocityTracker = AbsListView.this.mVelocityTracker;
                OverScroller overScroller = FlingRunnable.this.mScroller;
                if (velocityTracker == null || n == -1) {
                    return;
                }
                velocityTracker.computeCurrentVelocity(1000, AbsListView.this.mMaximumVelocity);
                float f = -velocityTracker.getYVelocity(n);
                if (Math.abs(f) >= (float)AbsListView.this.mMinimumVelocity && overScroller.isScrollingInDirection(0.0f, f)) {
                    AbsListView.this.postDelayed(this, 40L);
                    return;
                }
                FlingRunnable.this.endFling();
                AbsListView.this.mTouchMode = 3;
                AbsListView.this.reportScrollStateChange(1);
            }
        };
        private int mLastFlingY;
        private final OverScroller mScroller;

        FlingRunnable() {
            this.mScroller = new OverScroller(AbsListView.this.getContext());
        }

        /*
         * Enabled aggressive block sorting
         */
        void edgeReached(int n) {
            this.mScroller.notifyVerticalEdgeReached(AbsListView.this.mScrollY, 0, AbsListView.this.mOverflingDistance);
            int n2 = AbsListView.this.getOverScrollMode();
            if (n2 == 0 || n2 == 1 && !AbsListView.this.contentFits()) {
                AbsListView.this.mTouchMode = 6;
                int n3 = (int)this.mScroller.getCurrVelocity();
                if (n > 0) {
                    AbsListView.this.mEdgeGlowTop.onAbsorb(n3);
                } else {
                    AbsListView.this.mEdgeGlowBottom.onAbsorb(n3);
                }
            } else {
                AbsListView.this.mTouchMode = -1;
                if (AbsListView.this.mPositionScroller != null) {
                    AbsListView.this.mPositionScroller.stop();
                }
            }
            AbsListView.this.invalidate();
            AbsListView.this.postOnAnimation(this);
        }

        void endFling() {
            AbsListView.this.mTouchMode = -1;
            AbsListView.this.removeCallbacks(this);
            AbsListView.this.removeCallbacks(this.mCheckFlywheel);
            AbsListView.this.reportScrollStateChange(0);
            AbsListView.this.clearScrollingCache();
            this.mScroller.abortAnimation();
            if (AbsListView.this.mFlingStrictSpan != null) {
                AbsListView.this.mFlingStrictSpan.finish();
                AbsListView.access$1802(AbsListView.this, null);
            }
        }

        void flywheelTouch() {
            AbsListView.this.postDelayed(this.mCheckFlywheel, 40L);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            switch (AbsListView.this.mTouchMode) {
                default: {
                    this.endFling();
                    return;
                }
                case 3: {
                    if (this.mScroller.isFinished()) return;
                }
                case 4: {
                    boolean bl;
                    boolean bl2;
                    int n;
                    if (AbsListView.this.mDataChanged) {
                        AbsListView.this.layoutChildren();
                    }
                    if (AbsListView.this.mItemCount == 0 || AbsListView.this.getChildCount() == 0) {
                        this.endFling();
                        return;
                    }
                    OverScroller overScroller = this.mScroller;
                    boolean bl3 = overScroller.computeScrollOffset();
                    int n2 = overScroller.getCurrY();
                    int n3 = this.mLastFlingY - n2;
                    if (n3 > 0) {
                        AbsListView.this.mMotionPosition = AbsListView.this.mFirstPosition;
                        View view = AbsListView.this.getChildAt(0);
                        AbsListView.this.mMotionViewOriginalTop = view.getTop();
                        n = Math.min(-1 + (AbsListView.this.getHeight() - AbsListView.this.mPaddingBottom - AbsListView.this.mPaddingTop), n3);
                    } else {
                        int n4 = -1 + AbsListView.this.getChildCount();
                        AbsListView.this.mMotionPosition = n4 + AbsListView.this.mFirstPosition;
                        View view = AbsListView.this.getChildAt(n4);
                        AbsListView.this.mMotionViewOriginalTop = view.getTop();
                        n = Math.max(-(-1 + (AbsListView.this.getHeight() - AbsListView.this.mPaddingBottom - AbsListView.this.mPaddingTop)), n3);
                    }
                    View view = AbsListView.this.getChildAt(AbsListView.this.mMotionPosition - AbsListView.this.mFirstPosition);
                    int n5 = 0;
                    if (view != null) {
                        n5 = view.getTop();
                    }
                    if (bl2 = (bl = AbsListView.this.trackMotionScroll(n, n)) && n != 0) {
                        if (view != null) {
                            int n6 = -(n - (view.getTop() - n5));
                            AbsListView.this.overScrollBy(0, n6, 0, AbsListView.this.mScrollY, 0, 0, 0, AbsListView.this.mOverflingDistance, false);
                        }
                        if (!bl3) return;
                        this.edgeReached(n);
                        return;
                    }
                    if (bl3 && !bl2) {
                        if (bl) {
                            AbsListView.this.invalidate();
                        }
                        this.mLastFlingY = n2;
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    this.endFling();
                    return;
                }
                case 6: 
            }
            OverScroller overScroller = this.mScroller;
            if (!overScroller.computeScrollOffset()) {
                this.endFling();
                return;
            }
            int n = AbsListView.this.mScrollY;
            int n7 = overScroller.getCurrY();
            int n8 = n7 - n;
            if (!AbsListView.this.overScrollBy(0, n8, 0, n, 0, 0, 0, AbsListView.this.mOverflingDistance, false)) {
                AbsListView.this.invalidate();
                AbsListView.this.postOnAnimation(this);
                return;
            }
            boolean bl = n <= 0 && n7 > 0;
            boolean bl4 = n >= 0 && n7 < 0;
            if (!bl && !bl4) {
                this.startSpringback();
                return;
            }
            int n9 = (int)overScroller.getCurrVelocity();
            if (bl4) {
                n9 = -n9;
            }
            overScroller.abortAnimation();
            this.start(n9);
        }

        /*
         * Enabled aggressive block sorting
         */
        void start(int n) {
            int n2 = n < 0 ? Integer.MAX_VALUE : 0;
            this.mLastFlingY = n2;
            this.mScroller.setInterpolator(null);
            this.mScroller.fling(0, n2, 0, n, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
            AbsListView.this.mTouchMode = 4;
            AbsListView.this.postOnAnimation(this);
            if (AbsListView.this.mFlingStrictSpan == null) {
                AbsListView.access$1802(AbsListView.this, StrictMode.enterCriticalSpan("AbsListView-fling"));
            }
        }

        void startOverfling(int n) {
            this.mScroller.setInterpolator(null);
            this.mScroller.fling(0, AbsListView.this.mScrollY, 0, n, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, 0, AbsListView.this.getHeight());
            AbsListView.this.mTouchMode = 6;
            AbsListView.this.invalidate();
            AbsListView.this.postOnAnimation(this);
        }

        /*
         * Enabled aggressive block sorting
         */
        void startScroll(int n, int n2, boolean bl) {
            int n3 = n < 0 ? Integer.MAX_VALUE : 0;
            this.mLastFlingY = n3;
            OverScroller overScroller = this.mScroller;
            Interpolator interpolator2 = bl ? sLinearInterpolator : null;
            overScroller.setInterpolator(interpolator2);
            this.mScroller.startScroll(0, n3, 0, n, n2);
            AbsListView.this.mTouchMode = 4;
            AbsListView.this.postOnAnimation(this);
        }

        void startSpringback() {
            if (this.mScroller.springBack(0, AbsListView.this.mScrollY, 0, 0, 0, 0)) {
                AbsListView.this.mTouchMode = 6;
                AbsListView.this.invalidate();
                AbsListView.this.postOnAnimation(this);
                return;
            }
            AbsListView.this.mTouchMode = -1;
            AbsListView.this.reportScrollStateChange(0);
        }
    }

    private class InputConnectionWrapper
    implements InputConnection {
        private final EditorInfo mOutAttrs;
        private InputConnection mTarget;

        public InputConnectionWrapper(EditorInfo editorInfo) {
            this.mOutAttrs = editorInfo;
        }

        private InputConnection getTarget() {
            if (this.mTarget == null) {
                this.mTarget = AbsListView.this.getTextFilterInput().onCreateInputConnection(this.mOutAttrs);
            }
            return this.mTarget;
        }

        @Override
        public boolean beginBatchEdit() {
            return this.getTarget().beginBatchEdit();
        }

        @Override
        public boolean clearMetaKeyStates(int n) {
            return this.getTarget().clearMetaKeyStates(n);
        }

        @Override
        public boolean commitCompletion(CompletionInfo completionInfo) {
            return this.getTarget().commitCompletion(completionInfo);
        }

        @Override
        public boolean commitCorrection(CorrectionInfo correctionInfo) {
            return this.getTarget().commitCorrection(correctionInfo);
        }

        @Override
        public boolean commitText(CharSequence charSequence, int n) {
            return this.getTarget().commitText(charSequence, n);
        }

        @Override
        public boolean deleteSurroundingText(int n, int n2) {
            return this.getTarget().deleteSurroundingText(n, n2);
        }

        @Override
        public boolean endBatchEdit() {
            return this.getTarget().endBatchEdit();
        }

        @Override
        public boolean finishComposingText() {
            return this.mTarget == null || this.mTarget.finishComposingText();
        }

        @Override
        public int getCursorCapsMode(int n) {
            if (this.mTarget == null) {
                return 16384;
            }
            return this.mTarget.getCursorCapsMode(n);
        }

        @Override
        public ExtractedText getExtractedText(ExtractedTextRequest extractedTextRequest, int n) {
            return this.getTarget().getExtractedText(extractedTextRequest, n);
        }

        @Override
        public CharSequence getSelectedText(int n) {
            if (this.mTarget == null) {
                return "";
            }
            return this.mTarget.getSelectedText(n);
        }

        @Override
        public CharSequence getTextAfterCursor(int n, int n2) {
            if (this.mTarget == null) {
                return "";
            }
            return this.mTarget.getTextAfterCursor(n, n2);
        }

        @Override
        public CharSequence getTextBeforeCursor(int n, int n2) {
            if (this.mTarget == null) {
                return "";
            }
            return this.mTarget.getTextBeforeCursor(n, n2);
        }

        @Override
        public boolean performContextMenuAction(int n) {
            return this.getTarget().performContextMenuAction(n);
        }

        @Override
        public boolean performEditorAction(int n) {
            boolean bl = false;
            if (n == 6) {
                InputMethodManager inputMethodManager = (InputMethodManager)AbsListView.this.getContext().getSystemService("input_method");
                if (inputMethodManager != null) {
                    inputMethodManager.hideSoftInputFromWindow(AbsListView.this.getWindowToken(), 0);
                }
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean performPrivateCommand(String string2, Bundle bundle) {
            return this.getTarget().performPrivateCommand(string2, bundle);
        }

        @Override
        public boolean reportFullscreenMode(boolean bl) {
            return AbsListView.this.mDefInputConnection.reportFullscreenMode(bl);
        }

        @Override
        public boolean requestCursorUpdates(int n) {
            return this.getTarget().requestCursorUpdates(n);
        }

        @Override
        public boolean sendKeyEvent(KeyEvent keyEvent) {
            return AbsListView.this.mDefInputConnection.sendKeyEvent(keyEvent);
        }

        @Override
        public boolean setComposingRegion(int n, int n2) {
            return this.getTarget().setComposingRegion(n, n2);
        }

        @Override
        public boolean setComposingText(CharSequence charSequence, int n) {
            return this.getTarget().setComposingText(charSequence, n);
        }

        @Override
        public boolean setSelection(int n, int n2) {
            return this.getTarget().setSelection(n, n2);
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        @ViewDebug.ExportedProperty(category="list")
        boolean forceAdd;
        long itemId = -1L;
        @ViewDebug.ExportedProperty(category="list")
        boolean recycledHeaderFooter;
        int scrappedFromPosition;
        @ViewDebug.ExportedProperty(category="list", mapping={@ViewDebug.IntToString(from=-1, to="ITEM_VIEW_TYPE_IGNORE"), @ViewDebug.IntToString(from=-2, to="ITEM_VIEW_TYPE_HEADER_OR_FOOTER")})
        int viewType;

        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(int n, int n2, int n3) {
            super(n, n2);
            this.viewType = n3;
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }

    class ListItemAccessibilityDelegate
    extends View.AccessibilityDelegate {
        ListItemAccessibilityDelegate() {
        }

        @Override
        public AccessibilityNodeInfo createAccessibilityNodeInfo(View view) {
            if (AbsListView.this.mDataChanged) {
                return null;
            }
            return super.createAccessibilityNodeInfo(view);
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfo accessibilityNodeInfo) {
            super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfo);
            int n = AbsListView.this.getPositionForView(view);
            AbsListView.this.onInitializeAccessibilityNodeInfoForItem(view, n, accessibilityNodeInfo);
        }

        @Override
        public boolean performAccessibilityAction(View view, int n, Bundle bundle) {
            if (super.performAccessibilityAction(view, n, bundle)) {
                return true;
            }
            int n2 = AbsListView.this.getPositionForView(view);
            ListAdapter listAdapter = (ListAdapter)AbsListView.this.getAdapter();
            if (n2 == -1 || listAdapter == null) {
                return false;
            }
            if (!AbsListView.this.isEnabled() || !listAdapter.isEnabled(n2)) {
                return false;
            }
            long l = AbsListView.this.getItemIdAtPosition(n2);
            switch (n) {
                default: {
                    return false;
                }
                case 8: {
                    if (AbsListView.this.getSelectedItemPosition() == n2) {
                        AbsListView.this.setSelection(-1);
                        return true;
                    }
                    return false;
                }
                case 4: {
                    if (AbsListView.this.getSelectedItemPosition() != n2) {
                        AbsListView.this.setSelection(n2);
                        return true;
                    }
                    return false;
                }
                case 16: {
                    if (AbsListView.this.isClickable()) {
                        return AbsListView.this.performItemClick(view, n2, l);
                    }
                    return false;
                }
                case 32: 
            }
            if (AbsListView.this.isLongClickable()) {
                return AbsListView.this.performLongPress(view, n2, l);
            }
            return false;
        }
    }

    public static interface MultiChoiceModeListener
    extends ActionMode.Callback {
        public void onItemCheckedStateChanged(ActionMode var1, int var2, long var3, boolean var5);
    }

    class MultiChoiceModeWrapper
    implements MultiChoiceModeListener {
        private MultiChoiceModeListener mWrapped;

        MultiChoiceModeWrapper() {
        }

        public boolean hasWrappedCallback() {
            return this.mWrapped != null;
        }

        @Override
        public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
            return this.mWrapped.onActionItemClicked(actionMode, menuItem);
        }

        @Override
        public boolean onCreateActionMode(ActionMode actionMode, Menu menu2) {
            boolean bl = this.mWrapped.onCreateActionMode(actionMode, menu2);
            boolean bl2 = false;
            if (bl) {
                AbsListView.this.setLongClickable(false);
                bl2 = true;
            }
            return bl2;
        }

        @Override
        public void onDestroyActionMode(ActionMode actionMode) {
            this.mWrapped.onDestroyActionMode(actionMode);
            AbsListView.this.mChoiceActionMode = null;
            AbsListView.this.clearChoices();
            AbsListView.this.mDataChanged = true;
            AbsListView.this.rememberSyncState();
            AbsListView.this.requestLayout();
            AbsListView.this.setLongClickable(true);
        }

        @Override
        public void onItemCheckedStateChanged(ActionMode actionMode, int n, long l, boolean bl) {
            this.mWrapped.onItemCheckedStateChanged(actionMode, n, l, bl);
            if (AbsListView.this.getCheckedItemCount() == 0) {
                actionMode.finish();
            }
        }

        @Override
        public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
            return this.mWrapped.onPrepareActionMode(actionMode, menu2);
        }

        public void setWrapped(MultiChoiceModeListener multiChoiceModeListener) {
            this.mWrapped = multiChoiceModeListener;
        }
    }

    public static interface OnScrollListener {
        public static final int SCROLL_STATE_FLING = 2;
        public static final int SCROLL_STATE_IDLE = 0;
        public static final int SCROLL_STATE_TOUCH_SCROLL = 1;

        public void onScroll(AbsListView var1, int var2, int var3, int var4);

        public void onScrollStateChanged(AbsListView var1, int var2);
    }

    private class PerformClick
    extends WindowRunnnable
    implements Runnable {
        int mClickMotionPosition;

        private PerformClick() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run() {
            View view;
            int n;
            ListAdapter listAdapter;
            block3: {
                block2: {
                    if (AbsListView.this.mDataChanged) break block2;
                    listAdapter = AbsListView.this.mAdapter;
                    n = this.mClickMotionPosition;
                    if (listAdapter != null && AbsListView.this.mItemCount > 0 && n != -1 && n < listAdapter.getCount() && this.sameWindow() && (view = AbsListView.this.getChildAt(n - AbsListView.this.mFirstPosition)) != null) break block3;
                }
                return;
            }
            AbsListView.this.performItemClick(view, n, listAdapter.getItemId(n));
        }
    }

    class PositionScroller
    extends AbsPositionScroller
    implements Runnable {
        private static final int MOVE_DOWN_BOUND = 3;
        private static final int MOVE_DOWN_POS = 1;
        private static final int MOVE_OFFSET = 5;
        private static final int MOVE_UP_BOUND = 4;
        private static final int MOVE_UP_POS = 2;
        private static final int SCROLL_DURATION = 200;
        private int mBoundPos;
        private final int mExtraScroll;
        private int mLastSeenPos;
        private int mMode;
        private int mOffsetFromTop;
        private int mScrollDuration;
        private int mTargetPos;

        PositionScroller() {
            this.mExtraScroll = ViewConfiguration.get(AbsListView.this.mContext).getScaledFadingEdgeLength();
        }

        /*
         * Enabled aggressive block sorting
         */
        private void scrollToVisible(int n, int n2, int n3) {
            int n4 = AbsListView.this.mFirstPosition;
            int n5 = -1 + (n4 + AbsListView.this.getChildCount());
            int n6 = AbsListView.this.mListPadding.top;
            int n7 = AbsListView.this.getHeight() - AbsListView.this.mListPadding.bottom;
            if (n < n4 || n > n5) {
                Log.w(AbsListView.TAG, "scrollToVisible called with targetPos " + n + " not visible [" + n4 + ", " + n5 + "]");
            }
            if (n2 < n4 || n2 > n5) {
                n2 = -1;
            }
            View view = AbsListView.this.getChildAt(n - n4);
            int n8 = view.getTop();
            int n9 = view.getBottom();
            int n10 = 0;
            if (n9 > n7) {
                n10 = n9 - n7;
            }
            if (n8 < n6) {
                n10 = n8 - n6;
            }
            if (n10 == 0) {
                return;
            }
            if (n2 >= 0) {
                View view2 = AbsListView.this.getChildAt(n2 - n4);
                int n11 = view2.getTop();
                int n12 = view2.getBottom();
                int n13 = Math.abs(n10);
                if (n10 < 0 && n12 + n13 > n7) {
                    n10 = Math.max(0, n12 - n7);
                } else if (n10 > 0 && n11 - n13 < n6) {
                    n10 = Math.min(0, n11 - n6);
                }
            }
            AbsListView.this.smoothScrollBy(n10, n3);
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            int n;
            int n2 = AbsListView.this.getHeight();
            int n3 = AbsListView.this.mFirstPosition;
            switch (this.mMode) {
                default: {
                    return;
                }
                case 1: {
                    int n4 = -1 + AbsListView.this.getChildCount();
                    int n5 = n3 + n4;
                    if (n4 < 0) return;
                    if (n5 == this.mLastSeenPos) {
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    View view = AbsListView.this.getChildAt(n4);
                    int n6 = view.getHeight();
                    int n7 = n2 - view.getTop();
                    int n8 = n5 < -1 + AbsListView.this.mItemCount ? Math.max(AbsListView.this.mListPadding.bottom, this.mExtraScroll) : AbsListView.this.mListPadding.bottom;
                    int n9 = n8 + (n6 - n7);
                    AbsListView.this.smoothScrollBy(n9, this.mScrollDuration, true);
                    this.mLastSeenPos = n5;
                    if (n5 >= this.mTargetPos) return;
                    AbsListView.this.postOnAnimation(this);
                    return;
                }
                case 3: {
                    int n10 = AbsListView.this.getChildCount();
                    if (n3 == this.mBoundPos) return;
                    if (n10 <= 1) return;
                    if (n3 + n10 >= AbsListView.this.mItemCount) return;
                    int n11 = n3 + 1;
                    if (n11 == this.mLastSeenPos) {
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    View view = AbsListView.this.getChildAt(1);
                    int n12 = view.getHeight();
                    int n13 = view.getTop();
                    int n14 = Math.max(AbsListView.this.mListPadding.bottom, this.mExtraScroll);
                    if (n11 < this.mBoundPos) {
                        AbsListView.this.smoothScrollBy(Math.max(0, n12 + n13 - n14), this.mScrollDuration, true);
                        this.mLastSeenPos = n11;
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    if (n13 <= n14) return;
                    AbsListView.this.smoothScrollBy(n13 - n14, this.mScrollDuration, true);
                    return;
                }
                case 2: {
                    if (n3 == this.mLastSeenPos) {
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    View view = AbsListView.this.getChildAt(0);
                    if (view == null) return;
                    int n15 = view.getTop();
                    int n16 = n3 > 0 ? Math.max(this.mExtraScroll, AbsListView.this.mListPadding.top) : AbsListView.this.mListPadding.top;
                    AbsListView.this.smoothScrollBy(n15 - n16, this.mScrollDuration, true);
                    this.mLastSeenPos = n3;
                    if (n3 <= this.mTargetPos) return;
                    AbsListView.this.postOnAnimation(this);
                    return;
                }
                case 4: {
                    int n17 = -2 + AbsListView.this.getChildCount();
                    if (n17 < 0) return;
                    int n18 = n3 + n17;
                    if (n18 == this.mLastSeenPos) {
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    View view = AbsListView.this.getChildAt(n17);
                    int n19 = view.getHeight();
                    int n20 = view.getTop();
                    int n21 = n2 - n20;
                    int n22 = Math.max(AbsListView.this.mListPadding.top, this.mExtraScroll);
                    this.mLastSeenPos = n18;
                    if (n18 > this.mBoundPos) {
                        AbsListView.this.smoothScrollBy(-(n21 - n22), this.mScrollDuration, true);
                        AbsListView.this.postOnAnimation(this);
                        return;
                    }
                    int n23 = n2 - n22;
                    int n24 = n20 + n19;
                    if (n23 <= n24) return;
                    AbsListView.this.smoothScrollBy(-(n23 - n24), this.mScrollDuration, true);
                    return;
                }
                case 5: 
            }
            if (this.mLastSeenPos == n3) {
                AbsListView.this.postOnAnimation(this);
                return;
            }
            this.mLastSeenPos = n3;
            int n25 = AbsListView.this.getChildCount();
            int n26 = this.mTargetPos;
            int n27 = -1 + (n3 + n25);
            if (n26 < n3) {
                n = 1 + (n3 - n26);
            } else {
                n = 0;
                if (n26 > n27) {
                    n = n26 - n27;
                }
            }
            float f = Math.min(Math.abs((float)n / (float)n25), 1.0f);
            if (n26 < n3) {
                int n28 = (int)(f * (float)(-AbsListView.this.getHeight()));
                int n29 = (int)(f * (float)this.mScrollDuration);
                AbsListView.this.smoothScrollBy(n28, n29, true);
                AbsListView.this.postOnAnimation(this);
                return;
            }
            if (n26 > n27) {
                int n30 = (int)(f * (float)AbsListView.this.getHeight());
                int n31 = (int)(f * (float)this.mScrollDuration);
                AbsListView.this.smoothScrollBy(n30, n31, true);
                AbsListView.this.postOnAnimation(this);
                return;
            }
            int n32 = AbsListView.this.getChildAt(n26 - n3).getTop() - this.mOffsetFromTop;
            int n33 = (int)((float)this.mScrollDuration * ((float)Math.abs(n32) / (float)AbsListView.this.getHeight()));
            AbsListView.this.smoothScrollBy(n32, n33, true);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void start(final int n) {
            int n2;
            this.stop();
            if (AbsListView.this.mDataChanged) {
                AbsListView.this.mPositionScrollAfterLayout = new Runnable(){

                    @Override
                    public void run() {
                        PositionScroller.this.start(n);
                    }
                };
                return;
            }
            int n3 = AbsListView.this.getChildCount();
            if (n3 == 0) return;
            int n4 = AbsListView.this.mFirstPosition;
            int n5 = -1 + (n4 + n3);
            int n6 = Math.max(0, Math.min(-1 + AbsListView.this.getCount(), n));
            if (n6 < n4) {
                n2 = 1 + (n4 - n6);
                this.mMode = 2;
            } else {
                if (n6 <= n5) {
                    this.scrollToVisible(n6, -1, 200);
                    return;
                }
                n2 = 1 + (n6 - n5);
                this.mMode = 1;
            }
            this.mScrollDuration = n2 > 0 ? 200 / n2 : 200;
            this.mTargetPos = n6;
            this.mBoundPos = -1;
            this.mLastSeenPos = -1;
            AbsListView.this.postOnAnimation(this);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void start(final int n, final int n2) {
            int n3;
            this.stop();
            if (n2 == -1) {
                this.start(n);
                return;
            }
            if (AbsListView.this.mDataChanged) {
                AbsListView.this.mPositionScrollAfterLayout = new Runnable(){

                    @Override
                    public void run() {
                        PositionScroller.this.start(n, n2);
                    }
                };
                return;
            }
            int n4 = AbsListView.this.getChildCount();
            if (n4 == 0) return;
            int n5 = AbsListView.this.mFirstPosition;
            int n6 = -1 + (n5 + n4);
            int n7 = Math.max(0, Math.min(-1 + AbsListView.this.getCount(), n));
            if (n7 < n5) {
                int n8 = n6 - n2;
                if (n8 < 1) return;
                int n9 = n8 - 1;
                int n10 = 1 + (n5 - n7);
                if (n9 < n10) {
                    n3 = n9;
                    this.mMode = 4;
                } else {
                    n3 = n10;
                    this.mMode = 2;
                }
            } else {
                if (n7 <= n6) {
                    this.scrollToVisible(n7, n2, 200);
                    return;
                }
                int n11 = n2 - n5;
                if (n11 < 1) return;
                int n12 = n11 - 1;
                int n13 = 1 + (n7 - n6);
                if (n12 < n13) {
                    n3 = n12;
                    this.mMode = 3;
                } else {
                    n3 = n13;
                    this.mMode = 1;
                }
            }
            this.mScrollDuration = n3 > 0 ? 200 / n3 : 200;
            this.mTargetPos = n7;
            this.mBoundPos = n2;
            this.mLastSeenPos = -1;
            AbsListView.this.postOnAnimation(this);
        }

        @Override
        public void startWithOffset(int n, int n2) {
            this.startWithOffset(n, n2, 200);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void startWithOffset(final int n, final int n2, final int n3) {
            float f;
            int n4;
            this.stop();
            if (AbsListView.this.mDataChanged) {
                AbsListView.this.mPositionScrollAfterLayout = new Runnable(){

                    @Override
                    public void run() {
                        PositionScroller.this.startWithOffset(n, n2, n3);
                    }
                };
                return;
            }
            int n5 = AbsListView.this.getChildCount();
            if (n5 == 0) return;
            int n6 = n2 + AbsListView.this.getPaddingTop();
            this.mTargetPos = Math.max(0, Math.min(-1 + AbsListView.this.getCount(), n));
            this.mOffsetFromTop = n6;
            this.mBoundPos = -1;
            this.mLastSeenPos = -1;
            this.mMode = 5;
            int n7 = AbsListView.this.mFirstPosition;
            int n8 = -1 + (n7 + n5);
            if (this.mTargetPos < n7) {
                n4 = n7 - this.mTargetPos;
            } else {
                if (this.mTargetPos <= n8) {
                    int n9 = AbsListView.this.getChildAt(this.mTargetPos - n7).getTop();
                    AbsListView.this.smoothScrollBy(n9 - n6, n3, true);
                    return;
                }
                n4 = this.mTargetPos - n8;
            }
            if (!((f = (float)n4 / (float)n5) < 1.0f)) {
                n3 = (int)((float)n3 / f);
            }
            this.mScrollDuration = n3;
            this.mLastSeenPos = -1;
            AbsListView.this.postOnAnimation(this);
        }

        @Override
        public void stop() {
            AbsListView.this.removeCallbacks(this);
        }
    }

    class RecycleBin {
        private View[] mActiveViews = new View[0];
        private ArrayList<View> mCurrentScrap;
        private int mFirstActivePosition;
        private RecyclerListener mRecyclerListener;
        private ArrayList<View>[] mScrapViews;
        private ArrayList<View> mSkippedScrap;
        private SparseArray<View> mTransientStateViews;
        private LongSparseArray<View> mTransientStateViewsById;
        private int mViewTypeCount;

        RecycleBin() {
        }

        static /* synthetic */ RecyclerListener access$3902(RecycleBin recycleBin, RecyclerListener recyclerListener) {
            recycleBin.mRecyclerListener = recyclerListener;
            return recyclerListener;
        }

        private void clearAccessibilityFromScrap(View view) {
            if (view.isAccessibilityFocused()) {
                view.clearAccessibilityFocus();
            }
            view.setAccessibilityDelegate(null);
        }

        private void clearScrap(ArrayList<View> arrayList) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                this.removeDetachedView(arrayList.remove(n - 1 - i), false);
            }
        }

        private void pruneScrapViews() {
            LongSparseArray<View> longSparseArray;
            int n = this.mActiveViews.length;
            int n2 = this.mViewTypeCount;
            ArrayList<View>[] arrayListArray = this.mScrapViews;
            for (int i = 0; i < n2; ++i) {
                ArrayList<View> arrayList = arrayListArray[i];
                int n3 = arrayList.size();
                int n4 = n3 - n;
                int n5 = n3 - 1;
                int n6 = n5;
                for (int j = 0; j < n4; ++j) {
                    int n7 = n6 - 1;
                    this.removeDetachedView(arrayList.remove(n6), false);
                    n6 = n7;
                }
            }
            SparseArray<View> sparseArray = this.mTransientStateViews;
            if (sparseArray != null) {
                for (int i = 0; i < sparseArray.size(); ++i) {
                    View view = sparseArray.valueAt(i);
                    if (view.hasTransientState()) continue;
                    this.removeDetachedView(view, false);
                    sparseArray.removeAt(i);
                    --i;
                }
            }
            if ((longSparseArray = this.mTransientStateViewsById) != null) {
                for (int i = 0; i < longSparseArray.size(); ++i) {
                    View view = longSparseArray.valueAt(i);
                    if (view.hasTransientState()) continue;
                    this.removeDetachedView(view, false);
                    longSparseArray.removeAt(i);
                    --i;
                }
            }
        }

        private void removeDetachedView(View view, boolean bl) {
            view.setAccessibilityDelegate(null);
            AbsListView.this.removeDetachedView(view, bl);
        }

        private View retrieveFromScrap(ArrayList<View> arrayList, int n) {
            int n2 = arrayList.size();
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    LayoutParams layoutParams = (LayoutParams)arrayList.get(i).getLayoutParams();
                    if (AbsListView.this.mAdapterHasStableIds) {
                        if (AbsListView.this.mAdapter.getItemId(n) != layoutParams.itemId) continue;
                        return arrayList.remove(i);
                    }
                    if (layoutParams.scrappedFromPosition != n) continue;
                    View view = arrayList.remove(i);
                    this.clearAccessibilityFromScrap(view);
                    return view;
                }
                View view = arrayList.remove(n2 - 1);
                this.clearAccessibilityFromScrap(view);
                return view;
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         */
        void addScrapView(View view, int n) {
            block12: {
                block11: {
                    LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                    if (layoutParams == null) break block11;
                    layoutParams.scrappedFromPosition = n;
                    int n2 = layoutParams.viewType;
                    if (!this.shouldRecycleViewType(n2)) break block11;
                    view.dispatchStartTemporaryDetach();
                    AbsListView.this.notifyViewAccessibilityStateChangedIfNeeded(1);
                    if (view.hasTransientState()) {
                        if (AbsListView.this.mAdapter != null && AbsListView.this.mAdapterHasStableIds) {
                            if (this.mTransientStateViewsById == null) {
                                this.mTransientStateViewsById = new LongSparseArray();
                            }
                            this.mTransientStateViewsById.put(layoutParams.itemId, view);
                            return;
                        }
                        if (!AbsListView.this.mDataChanged) {
                            if (this.mTransientStateViews == null) {
                                this.mTransientStateViews = new SparseArray();
                            }
                            this.mTransientStateViews.put(n, view);
                            return;
                        }
                        if (this.mSkippedScrap == null) {
                            this.mSkippedScrap = new ArrayList();
                        }
                        this.mSkippedScrap.add(view);
                        return;
                    }
                    if (this.mViewTypeCount == 1) {
                        this.mCurrentScrap.add(view);
                    } else {
                        this.mScrapViews[n2].add(view);
                    }
                    if (this.mRecyclerListener != null) break block12;
                }
                return;
            }
            this.mRecyclerListener.onMovedToScrapHeap(view);
        }

        /*
         * Enabled aggressive block sorting
         */
        void clear() {
            if (this.mViewTypeCount == 1) {
                this.clearScrap(this.mCurrentScrap);
            } else {
                int n = this.mViewTypeCount;
                for (int i = 0; i < n; ++i) {
                    this.clearScrap(this.mScrapViews[i]);
                }
            }
            this.clearTransientStateViews();
        }

        void clearTransientStateViews() {
            LongSparseArray<View> longSparseArray;
            SparseArray<View> sparseArray = this.mTransientStateViews;
            if (sparseArray != null) {
                int n = sparseArray.size();
                for (int i = 0; i < n; ++i) {
                    this.removeDetachedView(sparseArray.valueAt(i), false);
                }
                sparseArray.clear();
            }
            if ((longSparseArray = this.mTransientStateViewsById) != null) {
                int n = longSparseArray.size();
                for (int i = 0; i < n; ++i) {
                    this.removeDetachedView(longSparseArray.valueAt(i), false);
                }
                longSparseArray.clear();
            }
        }

        void fillActiveViews(int n, int n2) {
            if (this.mActiveViews.length < n) {
                this.mActiveViews = new View[n];
            }
            this.mFirstActivePosition = n2;
            View[] viewArray = this.mActiveViews;
            for (int i = 0; i < n; ++i) {
                View view = AbsListView.this.getChildAt(i);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (layoutParams == null || layoutParams.viewType == -2) continue;
                viewArray[i] = view;
            }
        }

        View getActiveView(int n) {
            int n2 = n - this.mFirstActivePosition;
            View[] viewArray = this.mActiveViews;
            if (n2 >= 0 && n2 < viewArray.length) {
                View view = viewArray[n2];
                viewArray[n2] = null;
                return view;
            }
            return null;
        }

        View getScrapView(int n) {
            if (this.mViewTypeCount == 1) {
                return this.retrieveFromScrap(this.mCurrentScrap, n);
            }
            int n2 = AbsListView.this.mAdapter.getItemViewType(n);
            if (n2 >= 0 && n2 < this.mScrapViews.length) {
                return this.retrieveFromScrap(this.mScrapViews[n2], n);
            }
            return null;
        }

        View getTransientStateView(int n) {
            int n2;
            if (AbsListView.this.mAdapter != null && AbsListView.this.mAdapterHasStableIds && this.mTransientStateViewsById != null) {
                long l = AbsListView.this.mAdapter.getItemId(n);
                View view = this.mTransientStateViewsById.get(l);
                this.mTransientStateViewsById.remove(l);
                return view;
            }
            if (this.mTransientStateViews != null && (n2 = this.mTransientStateViews.indexOfKey(n)) >= 0) {
                View view = this.mTransientStateViews.valueAt(n2);
                this.mTransientStateViews.removeAt(n2);
                return view;
            }
            return null;
        }

        public void markChildrenDirty() {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> arrayList = this.mCurrentScrap;
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    arrayList.get(i).forceLayout();
                }
            } else {
                int n = this.mViewTypeCount;
                for (int i = 0; i < n; ++i) {
                    ArrayList<View> arrayList = this.mScrapViews[i];
                    int n2 = arrayList.size();
                    for (int j = 0; j < n2; ++j) {
                        arrayList.get(j).forceLayout();
                    }
                }
            }
            if (this.mTransientStateViews != null) {
                int n = this.mTransientStateViews.size();
                for (int i = 0; i < n; ++i) {
                    this.mTransientStateViews.valueAt(i).forceLayout();
                }
            }
            if (this.mTransientStateViewsById != null) {
                int n = this.mTransientStateViewsById.size();
                for (int i = 0; i < n; ++i) {
                    this.mTransientStateViewsById.valueAt(i).forceLayout();
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        void reclaimScrapViews(List<View> list) {
            if (this.mViewTypeCount == 1) {
                list.addAll(this.mCurrentScrap);
                return;
            } else {
                int n = this.mViewTypeCount;
                ArrayList<View>[] arrayListArray = this.mScrapViews;
                for (int i = 0; i < n; ++i) {
                    list.addAll(arrayListArray[i]);
                }
            }
        }

        void removeSkippedScrap() {
            if (this.mSkippedScrap == null) {
                return;
            }
            int n = this.mSkippedScrap.size();
            for (int i = 0; i < n; ++i) {
                this.removeDetachedView(this.mSkippedScrap.get(i), false);
            }
            this.mSkippedScrap.clear();
        }

        /*
         * Enabled aggressive block sorting
         */
        void scrapActiveViews() {
            View[] viewArray = this.mActiveViews;
            boolean bl = this.mRecyclerListener != null;
            boolean bl2 = this.mViewTypeCount > 1;
            ArrayList<View> arrayList = this.mCurrentScrap;
            int n = -1 + viewArray.length;
            while (true) {
                block12: {
                    int n2;
                    View view;
                    block13: {
                        block14: {
                            if (n < 0) {
                                this.pruneScrapViews();
                                return;
                            }
                            view = viewArray[n];
                            if (view == null) break block12;
                            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                            n2 = layoutParams.viewType;
                            viewArray[n] = null;
                            if (!view.hasTransientState()) break block13;
                            view.dispatchStartTemporaryDetach();
                            if (AbsListView.this.mAdapter == null || !AbsListView.this.mAdapterHasStableIds) break block14;
                            if (this.mTransientStateViewsById == null) {
                                this.mTransientStateViewsById = new LongSparseArray();
                            }
                            long l = AbsListView.this.mAdapter.getItemId(n + this.mFirstActivePosition);
                            this.mTransientStateViewsById.put(l, view);
                            break block12;
                        }
                        if (!AbsListView.this.mDataChanged) {
                            if (this.mTransientStateViews == null) {
                                this.mTransientStateViews = new SparseArray();
                            }
                            this.mTransientStateViews.put(n + this.mFirstActivePosition, view);
                            break block12;
                        } else if (n2 != -2) {
                            this.removeDetachedView(view, false);
                        }
                        break block12;
                    }
                    if (!this.shouldRecycleViewType(n2)) {
                        if (n2 != -2) {
                            this.removeDetachedView(view, false);
                        }
                    } else {
                        if (bl2) {
                            arrayList = this.mScrapViews[n2];
                        }
                        view.dispatchStartTemporaryDetach();
                        layoutParams.scrappedFromPosition = n + this.mFirstActivePosition;
                        arrayList.add(view);
                        if (bl) {
                            this.mRecyclerListener.onMovedToScrapHeap(view);
                        }
                    }
                }
                --n;
            }
        }

        void setCacheColorHint(int n) {
            if (this.mViewTypeCount == 1) {
                ArrayList<View> arrayList = this.mCurrentScrap;
                int n2 = arrayList.size();
                for (int i = 0; i < n2; ++i) {
                    arrayList.get(i).setDrawingCacheBackgroundColor(n);
                }
            } else {
                int n3 = this.mViewTypeCount;
                for (int i = 0; i < n3; ++i) {
                    ArrayList<View> arrayList = this.mScrapViews[i];
                    int n4 = arrayList.size();
                    for (int j = 0; j < n4; ++j) {
                        arrayList.get(j).setDrawingCacheBackgroundColor(n);
                    }
                }
            }
            for (View view : this.mActiveViews) {
                if (view == null) continue;
                view.setDrawingCacheBackgroundColor(n);
            }
        }

        public void setViewTypeCount(int n) {
            if (n < 1) {
                throw new IllegalArgumentException("Can't have a viewTypeCount < 1");
            }
            ArrayList[] arrayListArray = new ArrayList[n];
            for (int i = 0; i < n; ++i) {
                arrayListArray[i] = new ArrayList();
            }
            this.mViewTypeCount = n;
            this.mCurrentScrap = arrayListArray[0];
            this.mScrapViews = arrayListArray;
        }

        public boolean shouldRecycleViewType(int n) {
            return n >= 0;
        }
    }

    public static interface RecyclerListener {
        public void onMovedToScrapHeap(View var1);
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        LongSparseArray<Integer> checkIdState;
        SparseBooleanArray checkState;
        int checkedItemCount;
        String filter;
        long firstId;
        int height;
        boolean inActionMode;
        int position;
        long selectedId;
        int viewTop;

        /*
         * Enabled aggressive block sorting
         */
        private SavedState(Parcel parcel) {
            super(parcel);
            this.selectedId = parcel.readLong();
            this.firstId = parcel.readLong();
            this.viewTop = parcel.readInt();
            this.position = parcel.readInt();
            this.height = parcel.readInt();
            this.filter = parcel.readString();
            boolean bl = parcel.readByte() != 0;
            this.inActionMode = bl;
            this.checkedItemCount = parcel.readInt();
            this.checkState = parcel.readSparseBooleanArray();
            int n = parcel.readInt();
            if (n > 0) {
                this.checkIdState = new LongSparseArray();
                for (int i = 0; i < n; ++i) {
                    long l = parcel.readLong();
                    int n2 = parcel.readInt();
                    this.checkIdState.put(l, n2);
                }
            }
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            return "AbsListView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " selectedId=" + this.selectedId + " firstId=" + this.firstId + " viewTop=" + this.viewTop + " position=" + this.position + " height=" + this.height + " filter=" + this.filter + " checkState=" + this.checkState + "}";
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeLong(this.selectedId);
            parcel.writeLong(this.firstId);
            parcel.writeInt(this.viewTop);
            parcel.writeInt(this.position);
            parcel.writeInt(this.height);
            parcel.writeString(this.filter);
            boolean bl = this.inActionMode;
            parcel.writeByte((byte)(bl ? 1 : 0));
            parcel.writeInt(this.checkedItemCount);
            parcel.writeSparseBooleanArray(this.checkState);
            int n2 = this.checkIdState != null ? this.checkIdState.size() : 0;
            parcel.writeInt(n2);
            int n3 = 0;
            while (n3 < n2) {
                parcel.writeLong(this.checkIdState.keyAt(n3));
                parcel.writeInt(this.checkIdState.valueAt(n3));
                ++n3;
            }
            return;
        }
    }

    public static interface SelectionBoundsAdjuster {
        public void adjustListItemSelectionBounds(Rect var1);
    }

    private class WindowRunnnable {
        private int mOriginalAttachCount;

        private WindowRunnnable() {
        }

        public void rememberWindowAttachCount() {
            this.mOriginalAttachCount = AbsListView.this.getWindowAttachCount();
        }

        public boolean sameWindow() {
            return AbsListView.this.getWindowAttachCount() == this.mOriginalAttachCount;
        }
    }
}

