/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.SpellCheckerSession;
import android.view.textservice.SpellCheckerSubtype;
import com.android.internal.textservice.ITextServicesManager;
import java.util.Locale;

public final class TextServicesManager {
    private static final boolean DBG;
    private static final String TAG;
    private static TextServicesManager sInstance;
    private static ITextServicesManager sService;

    static {
        TAG = TextServicesManager.class.getSimpleName();
    }

    private TextServicesManager() {
        if (sService == null) {
            sService = ITextServicesManager.Stub.asInterface(ServiceManager.getService("textservices"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TextServicesManager getInstance() {
        synchronized (TextServicesManager.class) {
            if (sInstance != null) {
                return sInstance;
            }
            sInstance = new TextServicesManager();
            return sInstance;
        }
    }

    private static String parseLanguageFromLocaleString(String string2) {
        int n = string2.indexOf(95);
        if (n < 0) {
            return string2;
        }
        return string2.substring(0, n);
    }

    public SpellCheckerInfo getCurrentSpellChecker() {
        try {
            SpellCheckerInfo spellCheckerInfo = sService.getCurrentSpellChecker(null);
            return spellCheckerInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public SpellCheckerSubtype getCurrentSpellCheckerSubtype(boolean bl) {
        block3: {
            try {
                if (sService != null) break block3;
                Log.e(TAG, "sService is null.");
                return null;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Error in getCurrentSpellCheckerSubtype: " + remoteException);
                return null;
            }
        }
        SpellCheckerSubtype spellCheckerSubtype = sService.getCurrentSpellCheckerSubtype(null, bl);
        return spellCheckerSubtype;
    }

    public SpellCheckerInfo[] getEnabledSpellCheckers() {
        try {
            SpellCheckerInfo[] spellCheckerInfoArray = sService.getEnabledSpellCheckers();
            return spellCheckerInfoArray;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error in getEnabledSpellCheckers: " + remoteException);
            return null;
        }
    }

    public boolean isSpellCheckerEnabled() {
        try {
            boolean bl = sService.isSpellCheckerEnabled();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error in isSpellCheckerEnabled:" + remoteException);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SpellCheckerSession newSpellCheckerSession(Bundle bundle, Locale locale, SpellCheckerSession.SpellCheckerSessionListener spellCheckerSessionListener, boolean bl) {
        SpellCheckerInfo spellCheckerInfo;
        if (spellCheckerSessionListener == null) {
            throw new NullPointerException();
        }
        if (!bl && locale == null) {
            throw new IllegalArgumentException("Locale should not be null if you don't refer settings.");
        }
        if (bl && !this.isSpellCheckerEnabled()) {
            return null;
        }
        try {
            spellCheckerInfo = sService.getCurrentSpellChecker(null);
            if (spellCheckerInfo == null) {
                return null;
            }
        }
        catch (RemoteException remoteException) {
            return null;
        }
        SpellCheckerSubtype spellCheckerSubtype = null;
        if (bl) {
            String string2;
            spellCheckerSubtype = this.getCurrentSpellCheckerSubtype(true);
            if (spellCheckerSubtype == null) {
                return null;
            }
            if (!(locale == null || (string2 = TextServicesManager.parseLanguageFromLocaleString(spellCheckerSubtype.getLocale())).length() >= 2 && locale.getLanguage().equals(string2))) {
                return null;
            }
        } else {
            String string3 = locale.toString();
            for (int i = 0; i < spellCheckerInfo.getSubtypeCount(); ++i) {
                SpellCheckerSubtype spellCheckerSubtype2 = spellCheckerInfo.getSubtypeAt(i);
                String string4 = spellCheckerSubtype2.getLocale();
                String string5 = TextServicesManager.parseLanguageFromLocaleString(string4);
                if (string4.equals(string3)) {
                    spellCheckerSubtype = spellCheckerSubtype2;
                    break;
                }
                if (string5.length() < 2 || !locale.getLanguage().equals(string5)) continue;
                spellCheckerSubtype = spellCheckerSubtype2;
            }
        }
        if (spellCheckerSubtype == null) {
            return null;
        }
        SpellCheckerSession spellCheckerSession = new SpellCheckerSession(spellCheckerInfo, sService, spellCheckerSessionListener, spellCheckerSubtype);
        try {
            sService.getSpellCheckerService(spellCheckerInfo.getId(), spellCheckerSubtype.getLocale(), spellCheckerSession.getTextServicesSessionListener(), spellCheckerSession.getSpellCheckerSessionListener(), bundle);
            return spellCheckerSession;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCurrentSpellChecker(SpellCheckerInfo var1_1) {
        if (var1_1 != null) ** GOTO lbl-1000
        try {
            throw new NullPointerException("SpellCheckerInfo is null.");
        }
        catch (RemoteException var2_2) {
            Log.e(TextServicesManager.TAG, "Error in setCurrentSpellChecker: " + var2_2);
            return;
        }
lbl-1000:
        // 1 sources

        {
            TextServicesManager.sService.setCurrentSpellChecker(null, var1_1.getId());
            return;
        }
    }

    public void setSpellCheckerEnabled(boolean bl) {
        try {
            sService.setSpellCheckerEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Error in setSpellCheckerEnabled:" + remoteException);
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setSpellCheckerSubtype(SpellCheckerSubtype var1_1) {
        var5_2 = var1_1 == null ? 0 : (var4_3 = var1_1.hashCode());
        {
            ** try [egrp 0[TRYBLOCK] [0 : 7->25)] { 
lbl3:
            // 1 sources

            TextServicesManager.sService.setCurrentSpellCheckerSubtype(null, var5_2);
            return;
        }
lbl5:
        // 1 sources

        catch (RemoteException var2_4) {
            Log.e(TextServicesManager.TAG, "Error in setSpellCheckerSubtype:" + var2_4);
            return;
        }
    }
}

