/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Slog;
import android.view.textservice.SpellCheckerInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public final class SpellCheckerSubtype
implements Parcelable {
    public static final Parcelable.Creator<SpellCheckerSubtype> CREATOR;
    private static final String EXTRA_VALUE_KEY_VALUE_SEPARATOR = "=";
    private static final String EXTRA_VALUE_PAIR_SEPARATOR = ",";
    private static final String TAG;
    private HashMap<String, String> mExtraValueHashMapCache;
    private final String mSubtypeExtraValue;
    private final int mSubtypeHashCode;
    private final String mSubtypeLocale;
    private final int mSubtypeNameResId;

    static {
        TAG = SpellCheckerSubtype.class.getSimpleName();
        CREATOR = new Parcelable.Creator<SpellCheckerSubtype>(){

            @Override
            public SpellCheckerSubtype createFromParcel(Parcel parcel) {
                return new SpellCheckerSubtype(parcel);
            }

            public SpellCheckerSubtype[] newArray(int n) {
                return new SpellCheckerSubtype[n];
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    public SpellCheckerSubtype(int n, String string2, String string3) {
        this.mSubtypeNameResId = n;
        if (string2 == null) {
            string2 = "";
        }
        this.mSubtypeLocale = string2;
        if (string3 == null) {
            string3 = "";
        }
        this.mSubtypeExtraValue = string3;
        this.mSubtypeHashCode = SpellCheckerSubtype.hashCodeInternal(this.mSubtypeLocale, this.mSubtypeExtraValue);
    }

    /*
     * Enabled aggressive block sorting
     */
    SpellCheckerSubtype(Parcel parcel) {
        this.mSubtypeNameResId = parcel.readInt();
        String string2 = parcel.readString();
        if (string2 == null) {
            string2 = "";
        }
        this.mSubtypeLocale = string2;
        String string3 = parcel.readString();
        if (string3 == null) {
            string3 = "";
        }
        this.mSubtypeExtraValue = string3;
        this.mSubtypeHashCode = SpellCheckerSubtype.hashCodeInternal(this.mSubtypeLocale, this.mSubtypeExtraValue);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Locale constructLocaleFromString(String string2) {
        String[] stringArray;
        block6: {
            block5: {
                if (TextUtils.isEmpty(string2)) break block5;
                stringArray = string2.split("_", 3);
                if (stringArray.length == 1) {
                    return new Locale(stringArray[0]);
                }
                if (stringArray.length == 2) {
                    return new Locale(stringArray[0], stringArray[1]);
                }
                if (stringArray.length == 3) break block6;
            }
            return null;
        }
        return new Locale(stringArray[0], stringArray[1], stringArray[2]);
    }

    /*
     * Enabled aggressive block sorting
     */
    private HashMap<String, String> getExtraValueHashMap() {
        if (this.mExtraValueHashMapCache == null) {
            this.mExtraValueHashMapCache = new HashMap();
            String[] stringArray = this.mSubtypeExtraValue.split(EXTRA_VALUE_PAIR_SEPARATOR);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] stringArray2 = stringArray[i].split(EXTRA_VALUE_KEY_VALUE_SEPARATOR);
                if (stringArray2.length == 1) {
                    this.mExtraValueHashMapCache.put(stringArray2[0], null);
                    continue;
                }
                if (stringArray2.length <= 1) continue;
                if (stringArray2.length > 2) {
                    Slog.w(TAG, "ExtraValue has two or more '='s");
                }
                this.mExtraValueHashMapCache.put(stringArray2[0], stringArray2[1]);
            }
        }
        return this.mExtraValueHashMapCache;
    }

    private static int hashCodeInternal(String string2, String string3) {
        return Arrays.hashCode(new Object[]{string2, string3});
    }

    public static List<SpellCheckerSubtype> sort(Context context, int n, SpellCheckerInfo spellCheckerInfo, List<SpellCheckerSubtype> list) {
        if (spellCheckerInfo == null) {
            return list;
        }
        HashSet<SpellCheckerSubtype> hashSet = new HashSet<SpellCheckerSubtype>(list);
        ArrayList<SpellCheckerSubtype> arrayList = new ArrayList<SpellCheckerSubtype>();
        int n2 = spellCheckerInfo.getSubtypeCount();
        for (int i = 0; i < n2; ++i) {
            SpellCheckerSubtype spellCheckerSubtype = spellCheckerInfo.getSubtypeAt(i);
            if (!hashSet.contains(spellCheckerSubtype)) continue;
            arrayList.add(spellCheckerSubtype);
            hashSet.remove(spellCheckerSubtype);
        }
        Iterator<SpellCheckerSubtype> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    public boolean containsExtraValueKey(String string2) {
        return this.getExtraValueHashMap().containsKey(string2);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = object instanceof SpellCheckerSubtype;
        boolean bl2 = false;
        if (bl) {
            SpellCheckerSubtype spellCheckerSubtype = (SpellCheckerSubtype)object;
            int n = spellCheckerSubtype.hashCode();
            int n2 = this.hashCode();
            bl2 = false;
            if (n == n2) {
                int n3 = spellCheckerSubtype.getNameResId();
                int n4 = this.getNameResId();
                bl2 = false;
                if (n3 == n4) {
                    boolean bl3 = spellCheckerSubtype.getLocale().equals(this.getLocale());
                    bl2 = false;
                    if (bl3) {
                        boolean bl4 = spellCheckerSubtype.getExtraValue().equals(this.getExtraValue());
                        bl2 = false;
                        if (bl4) {
                            bl2 = true;
                        }
                    }
                }
            }
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CharSequence getDisplayName(Context context, String string2, ApplicationInfo applicationInfo) {
        CharSequence charSequence;
        Locale locale = SpellCheckerSubtype.constructLocaleFromString(this.mSubtypeLocale);
        String string3 = locale != null ? locale.getDisplayName() : this.mSubtypeLocale;
        if (this.mSubtypeNameResId == 0 || TextUtils.isEmpty(charSequence = context.getPackageManager().getText(string2, this.mSubtypeNameResId, applicationInfo))) {
            return string3;
        }
        return String.format(charSequence.toString(), string3);
    }

    public String getExtraValue() {
        return this.mSubtypeExtraValue;
    }

    public String getExtraValueOf(String string2) {
        return this.getExtraValueHashMap().get(string2);
    }

    public String getLocale() {
        return this.mSubtypeLocale;
    }

    public int getNameResId() {
        return this.mSubtypeNameResId;
    }

    public int hashCode() {
        return this.mSubtypeHashCode;
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mSubtypeNameResId);
        parcel.writeString(this.mSubtypeLocale);
        parcel.writeString(this.mSubtypeExtraValue);
    }
}

