/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.internal.R;

public class TranslateAnimation
extends Animation {
    private float mFromXDelta;
    private int mFromXType = 0;
    private float mFromXValue = 0.0f;
    private float mFromYDelta;
    private int mFromYType = 0;
    private float mFromYValue = 0.0f;
    private float mToXDelta;
    private int mToXType = 0;
    private float mToXValue = 0.0f;
    private float mToYDelta;
    private int mToYType = 0;
    private float mToYValue = 0.0f;

    public TranslateAnimation(float f, float f2, float f3, float f4) {
        this.mFromXValue = f;
        this.mToXValue = f2;
        this.mFromYValue = f3;
        this.mToYValue = f4;
        this.mFromXType = 0;
        this.mToXType = 0;
        this.mFromYType = 0;
        this.mToYType = 0;
    }

    public TranslateAnimation(int n, float f, int n2, float f2, int n3, float f3, int n4, float f4) {
        this.mFromXValue = f;
        this.mToXValue = f2;
        this.mFromYValue = f3;
        this.mToYValue = f4;
        this.mFromXType = n;
        this.mToXType = n2;
        this.mFromYType = n3;
        this.mToYType = n4;
    }

    public TranslateAnimation(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.TranslateAnimation);
        Animation.Description description = Animation.Description.parseValue(typedArray.peekValue(0));
        this.mFromXType = description.type;
        this.mFromXValue = description.value;
        Animation.Description description2 = Animation.Description.parseValue(typedArray.peekValue(1));
        this.mToXType = description2.type;
        this.mToXValue = description2.value;
        Animation.Description description3 = Animation.Description.parseValue(typedArray.peekValue(2));
        this.mFromYType = description3.type;
        this.mFromYValue = description3.value;
        Animation.Description description4 = Animation.Description.parseValue(typedArray.peekValue(3));
        this.mToYType = description4.type;
        this.mToYValue = description4.value;
        typedArray.recycle();
    }

    @Override
    protected void applyTransformation(float f, Transformation transformation) {
        float f2 = this.mFromXDelta;
        float f3 = this.mFromYDelta;
        if (this.mFromXDelta != this.mToXDelta) {
            f2 = this.mFromXDelta + f * (this.mToXDelta - this.mFromXDelta);
        }
        if (this.mFromYDelta != this.mToYDelta) {
            f3 = this.mFromYDelta + f * (this.mToYDelta - this.mFromYDelta);
        }
        transformation.getMatrix().setTranslate(f2, f3);
    }

    @Override
    public void initialize(int n, int n2, int n3, int n4) {
        super.initialize(n, n2, n3, n4);
        this.mFromXDelta = this.resolveSize(this.mFromXType, this.mFromXValue, n, n3);
        this.mToXDelta = this.resolveSize(this.mToXType, this.mToXValue, n, n3);
        this.mFromYDelta = this.resolveSize(this.mFromYType, this.mFromYValue, n2, n4);
        this.mToYDelta = this.resolveSize(this.mToYType, this.mToYValue, n2, n4);
    }
}

