/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pools;
import java.util.ArrayList;
import java.util.List;

public class WindowInfo
implements Parcelable {
    public static final Parcelable.Creator<WindowInfo> CREATOR;
    private static final int MAX_POOL_SIZE = 10;
    private static final Pools.SynchronizedPool<WindowInfo> sPool;
    public final Rect boundsInScreen = new Rect();
    public List<IBinder> childTokens;
    public boolean focused;
    public int layer;
    public IBinder parentToken;
    public IBinder token;
    public int type;

    static {
        sPool = new Pools.SynchronizedPool(10);
        CREATOR = new Parcelable.Creator<WindowInfo>(){

            @Override
            public WindowInfo createFromParcel(Parcel parcel) {
                WindowInfo windowInfo = WindowInfo.obtain();
                windowInfo.initFromParcel(parcel);
                return windowInfo;
            }

            public WindowInfo[] newArray(int n) {
                return new WindowInfo[n];
            }
        };
    }

    private WindowInfo() {
    }

    private void clear() {
        this.type = 0;
        this.layer = 0;
        this.token = null;
        this.parentToken = null;
        this.focused = false;
        this.boundsInScreen.setEmpty();
        if (this.childTokens != null) {
            this.childTokens.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initFromParcel(Parcel parcel) {
        this.type = parcel.readInt();
        this.layer = parcel.readInt();
        this.token = parcel.readStrongBinder();
        this.parentToken = parcel.readStrongBinder();
        boolean bl = parcel.readInt() == 1;
        this.focused = bl;
        this.boundsInScreen.readFromParcel(parcel);
        if (parcel.readInt() != 1) return;
        boolean bl2 = true;
        if (!bl2) return;
        if (this.childTokens == null) {
            this.childTokens = new ArrayList<IBinder>();
        }
        parcel.readBinderList(this.childTokens);
    }

    public static WindowInfo obtain() {
        WindowInfo windowInfo = sPool.acquire();
        if (windowInfo == null) {
            windowInfo = new WindowInfo();
        }
        return windowInfo;
    }

    public static WindowInfo obtain(WindowInfo windowInfo) {
        WindowInfo windowInfo2;
        block3: {
            block2: {
                windowInfo2 = WindowInfo.obtain();
                windowInfo2.type = windowInfo.type;
                windowInfo2.layer = windowInfo.layer;
                windowInfo2.token = windowInfo.token;
                windowInfo2.parentToken = windowInfo.parentToken;
                windowInfo2.focused = windowInfo.focused;
                windowInfo2.boundsInScreen.set(windowInfo.boundsInScreen);
                if (windowInfo.childTokens == null || windowInfo.childTokens.isEmpty()) break block2;
                if (windowInfo2.childTokens != null) break block3;
                windowInfo2.childTokens = new ArrayList<IBinder>(windowInfo.childTokens);
            }
            return windowInfo2;
        }
        windowInfo2.childTokens.addAll(windowInfo.childTokens);
        return windowInfo2;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void recycle() {
        this.clear();
        sPool.release(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WindowInfo[");
        stringBuilder.append("type=").append(this.type);
        stringBuilder.append(", layer=").append(this.layer);
        stringBuilder.append(", token=").append(this.token);
        stringBuilder.append(", bounds=").append(this.boundsInScreen);
        stringBuilder.append(", parent=").append(this.parentToken);
        stringBuilder.append(", focused=").append(this.focused);
        stringBuilder.append(", children=").append(this.childTokens);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.type);
        parcel.writeInt(this.layer);
        parcel.writeStrongBinder(this.token);
        parcel.writeStrongBinder(this.parentToken);
        int n2 = this.focused ? 1 : 0;
        parcel.writeInt(n2);
        this.boundsInScreen.writeToParcel(parcel, n);
        if (this.childTokens != null && !this.childTokens.isEmpty()) {
            parcel.writeInt(1);
            parcel.writeBinderList(this.childTokens);
            return;
        }
        parcel.writeInt(0);
    }
}

