/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.IBinder;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceSession;
import android.view.WindowAnimationFrameStats;
import android.view.WindowContentFrameStats;
import dalvik.system.CloseGuard;

public class SurfaceControl {
    public static final int BUILT_IN_DISPLAY_ID_HDMI = 1;
    public static final int BUILT_IN_DISPLAY_ID_MAIN = 0;
    public static final int CURSOR_WINDOW = 8192;
    public static final int FX_SURFACE_DIM = 131072;
    public static final int FX_SURFACE_MASK = 983040;
    public static final int FX_SURFACE_NORMAL = 0;
    public static final int HIDDEN = 4;
    public static final int NON_PREMULTIPLIED = 256;
    public static final int OPAQUE = 1024;
    public static final int POWER_MODE_DOZE = 1;
    public static final int POWER_MODE_DOZE_SUSPEND = 3;
    public static final int POWER_MODE_NORMAL = 2;
    public static final int POWER_MODE_OFF = 0;
    public static final int PROTECTED_APP = 2048;
    public static final int SECURE = 128;
    private static final int SURFACE_HIDDEN = 1;
    private static final int SURFACE_OPAQUE = 2;
    private static final String TAG = "SurfaceControl";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final String mName;
    long mNativeObject;

    public SurfaceControl(SurfaceSession surfaceSession, String string2, int n, int n2, int n3, int n4) throws Surface.OutOfResourcesException {
        if (surfaceSession == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if ((n4 & 4) == 0) {
            Log.w(TAG, "Surfaces should always be created with the HIDDEN flag set to ensure that they are not made visible prematurely before all of the surface's properties have been configured.  Set the other properties and make the surface visible within a transaction.  New surface name: " + string2, new Throwable());
        }
        this.mName = string2;
        this.mNativeObject = SurfaceControl.nativeCreate(surfaceSession, string2, n, n2, n3, n4);
        if (this.mNativeObject == 0L) {
            throw new Surface.OutOfResourcesException("Couldn't allocate SurfaceControl native object");
        }
        this.mCloseGuard.open("release");
    }

    private void checkNotReleased() {
        if (this.mNativeObject == 0L) {
            throw new NullPointerException("mNativeObject is null. Have you called release() already?");
        }
    }

    public static boolean clearAnimationFrameStats() {
        return SurfaceControl.nativeClearAnimationFrameStats();
    }

    public static void closeTransaction() {
        SurfaceControl.nativeCloseTransaction();
    }

    public static IBinder createDisplay(String string2, boolean bl) {
        if (string2 == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        return SurfaceControl.nativeCreateDisplay(string2, bl);
    }

    public static void destroyDisplay(IBinder iBinder) {
        if (iBinder == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeDestroyDisplay(iBinder);
    }

    public static int getActiveConfig(IBinder iBinder) {
        if (iBinder == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetActiveConfig(iBinder);
    }

    public static boolean getAnimationFrameStats(WindowAnimationFrameStats windowAnimationFrameStats) {
        return SurfaceControl.nativeGetAnimationFrameStats(windowAnimationFrameStats);
    }

    public static IBinder getBuiltInDisplay(int n) {
        return SurfaceControl.nativeGetBuiltInDisplay(n);
    }

    public static PhysicalDisplayInfo[] getDisplayConfigs(IBinder iBinder) {
        if (iBinder == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeGetDisplayConfigs(iBinder);
    }

    private static native boolean nativeClearAnimationFrameStats();

    private static native boolean nativeClearContentFrameStats(long var0);

    private static native void nativeCloseTransaction();

    private static native long nativeCreate(SurfaceSession var0, String var1, int var2, int var3, int var4, int var5) throws Surface.OutOfResourcesException;

    private static native IBinder nativeCreateDisplay(String var0, boolean var1);

    private static native void nativeDestroy(long var0);

    private static native void nativeDestroyDisplay(IBinder var0);

    private static native int nativeGetActiveConfig(IBinder var0);

    private static native boolean nativeGetAnimationFrameStats(WindowAnimationFrameStats var0);

    private static native IBinder nativeGetBuiltInDisplay(int var0);

    private static native boolean nativeGetContentFrameStats(long var0, WindowContentFrameStats var2);

    private static native PhysicalDisplayInfo[] nativeGetDisplayConfigs(IBinder var0);

    private static native void nativeOpenTransaction();

    private static native void nativeRelease(long var0);

    private static native Bitmap nativeScreenshot(IBinder var0, Rect var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7, int var8);

    private static native void nativeScreenshot(IBinder var0, Surface var1, Rect var2, int var3, int var4, int var5, int var6, boolean var7, boolean var8);

    private static native boolean nativeSetActiveConfig(IBinder var0, int var1);

    private static native void nativeSetAlpha(long var0, float var2);

    private static native void nativeSetAnimationTransaction();

    private static native void nativeSetDisplayLayerStack(IBinder var0, int var1);

    private static native void nativeSetDisplayPowerMode(IBinder var0, int var1);

    private static native void nativeSetDisplayProjection(IBinder var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private static native void nativeSetDisplaySize(IBinder var0, int var1, int var2);

    private static native void nativeSetDisplaySurface(IBinder var0, long var1);

    private static native void nativeSetFlags(long var0, int var2, int var3);

    private static native void nativeSetLayer(long var0, int var2);

    private static native void nativeSetLayerStack(long var0, int var2);

    private static native void nativeSetMatrix(long var0, float var2, float var3, float var4, float var5);

    private static native void nativeSetPosition(long var0, float var2, float var3);

    private static native void nativeSetSize(long var0, int var2, int var3);

    private static native void nativeSetTransparentRegionHint(long var0, Region var2);

    private static native void nativeSetWindowCrop(long var0, int var2, int var3, int var4, int var5);

    public static void openTransaction() {
        SurfaceControl.nativeOpenTransaction();
    }

    public static Bitmap screenshot(int n, int n2) {
        return SurfaceControl.nativeScreenshot(SurfaceControl.getBuiltInDisplay(0), new Rect(), n, n2, 0, 0, true, false, 0);
    }

    public static Bitmap screenshot(Rect rect, int n, int n2, int n3, int n4, boolean bl, int n5) {
        return SurfaceControl.nativeScreenshot(SurfaceControl.getBuiltInDisplay(0), rect, n, n2, n3, n4, false, bl, n5);
    }

    public static void screenshot(IBinder iBinder, Surface surface) {
        SurfaceControl.screenshot(iBinder, surface, new Rect(), 0, 0, 0, 0, true, false);
    }

    public static void screenshot(IBinder iBinder, Surface surface, int n, int n2) {
        SurfaceControl.screenshot(iBinder, surface, new Rect(), n, n2, 0, 0, true, false);
    }

    public static void screenshot(IBinder iBinder, Surface surface, int n, int n2, int n3, int n4, boolean bl) {
        SurfaceControl.screenshot(iBinder, surface, new Rect(), n, n2, n3, n4, false, bl);
    }

    private static void screenshot(IBinder iBinder, Surface surface, Rect rect, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        if (iBinder == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (surface == null) {
            throw new IllegalArgumentException("consumer must not be null");
        }
        SurfaceControl.nativeScreenshot(iBinder, surface, rect, n, n2, n3, n4, bl, bl2);
    }

    public static boolean setActiveConfig(IBinder iBinder, int n) {
        if (iBinder == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        return SurfaceControl.nativeSetActiveConfig(iBinder, n);
    }

    public static void setAnimationTransaction() {
        SurfaceControl.nativeSetAnimationTransaction();
    }

    public static void setDisplayLayerStack(IBinder iBinder, int n) {
        if (iBinder == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetDisplayLayerStack(iBinder, n);
    }

    public static void setDisplayPowerMode(IBinder iBinder, int n) {
        if (iBinder == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        SurfaceControl.nativeSetDisplayPowerMode(iBinder, n);
    }

    public static void setDisplayProjection(IBinder iBinder, int n, Rect rect, Rect rect2) {
        if (iBinder == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (rect == null) {
            throw new IllegalArgumentException("layerStackRect must not be null");
        }
        if (rect2 == null) {
            throw new IllegalArgumentException("displayRect must not be null");
        }
        SurfaceControl.nativeSetDisplayProjection(iBinder, n, rect.left, rect.top, rect.right, rect.bottom, rect2.left, rect2.top, rect2.right, rect2.bottom);
    }

    public static void setDisplaySize(IBinder iBinder, int n, int n2) {
        if (iBinder == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("width and height must be positive");
        }
        SurfaceControl.nativeSetDisplaySize(iBinder, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setDisplaySurface(IBinder iBinder, Surface surface) {
        if (iBinder == null) {
            throw new IllegalArgumentException("displayToken must not be null");
        }
        if (surface != null) {
            Object object = surface.mLock;
            synchronized (object) {
                SurfaceControl.nativeSetDisplaySurface(iBinder, surface.mNativeObject);
                return;
            }
        }
        SurfaceControl.nativeSetDisplaySurface(iBinder, 0L);
    }

    public boolean clearContentFrameStats() {
        this.checkNotReleased();
        return SurfaceControl.nativeClearContentFrameStats(this.mNativeObject);
    }

    public void destroy() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeDestroy(this.mNativeObject);
            this.mNativeObject = 0L;
        }
        this.mCloseGuard.close();
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            if (this.mNativeObject != 0L) {
                SurfaceControl.nativeRelease(this.mNativeObject);
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    public boolean getContentFrameStats(WindowContentFrameStats windowContentFrameStats) {
        this.checkNotReleased();
        return SurfaceControl.nativeGetContentFrameStats(this.mNativeObject, windowContentFrameStats);
    }

    public void hide() {
        this.checkNotReleased();
        SurfaceControl.nativeSetFlags(this.mNativeObject, 1, 1);
    }

    public void release() {
        if (this.mNativeObject != 0L) {
            SurfaceControl.nativeRelease(this.mNativeObject);
            this.mNativeObject = 0L;
        }
        this.mCloseGuard.close();
    }

    public void setAlpha(float f) {
        this.checkNotReleased();
        SurfaceControl.nativeSetAlpha(this.mNativeObject, f);
    }

    public void setLayer(int n) {
        this.checkNotReleased();
        SurfaceControl.nativeSetLayer(this.mNativeObject, n);
    }

    public void setLayerStack(int n) {
        this.checkNotReleased();
        SurfaceControl.nativeSetLayerStack(this.mNativeObject, n);
    }

    public void setMatrix(float f, float f2, float f3, float f4) {
        this.checkNotReleased();
        SurfaceControl.nativeSetMatrix(this.mNativeObject, f, f2, f3, f4);
    }

    public void setOpaque(boolean bl) {
        this.checkNotReleased();
        if (bl) {
            SurfaceControl.nativeSetFlags(this.mNativeObject, 2, 2);
            return;
        }
        SurfaceControl.nativeSetFlags(this.mNativeObject, 0, 2);
    }

    public void setPosition(float f, float f2) {
        this.checkNotReleased();
        SurfaceControl.nativeSetPosition(this.mNativeObject, f, f2);
    }

    public void setSize(int n, int n2) {
        this.checkNotReleased();
        SurfaceControl.nativeSetSize(this.mNativeObject, n, n2);
    }

    public void setTransparentRegionHint(Region region) {
        this.checkNotReleased();
        SurfaceControl.nativeSetTransparentRegionHint(this.mNativeObject, region);
    }

    public void setWindowCrop(Rect rect) {
        this.checkNotReleased();
        if (rect != null) {
            SurfaceControl.nativeSetWindowCrop(this.mNativeObject, rect.left, rect.top, rect.right, rect.bottom);
            return;
        }
        SurfaceControl.nativeSetWindowCrop(this.mNativeObject, 0, 0, 0, 0);
    }

    public void show() {
        this.checkNotReleased();
        SurfaceControl.nativeSetFlags(this.mNativeObject, 0, 1);
    }

    public String toString() {
        return "Surface(name=" + this.mName + ")";
    }

    public static final class PhysicalDisplayInfo {
        public long appVsyncOffsetNanos;
        public float density;
        public int height;
        public long presentationDeadlineNanos;
        public float refreshRate;
        public boolean secure;
        public int width;
        public float xDpi;
        public float yDpi;

        public PhysicalDisplayInfo() {
        }

        public PhysicalDisplayInfo(PhysicalDisplayInfo physicalDisplayInfo) {
            this.copyFrom(physicalDisplayInfo);
        }

        public void copyFrom(PhysicalDisplayInfo physicalDisplayInfo) {
            this.width = physicalDisplayInfo.width;
            this.height = physicalDisplayInfo.height;
            this.refreshRate = physicalDisplayInfo.refreshRate;
            this.density = physicalDisplayInfo.density;
            this.xDpi = physicalDisplayInfo.xDpi;
            this.yDpi = physicalDisplayInfo.yDpi;
            this.secure = physicalDisplayInfo.secure;
            this.appVsyncOffsetNanos = physicalDisplayInfo.appVsyncOffsetNanos;
            this.presentationDeadlineNanos = physicalDisplayInfo.presentationDeadlineNanos;
        }

        public boolean equals(PhysicalDisplayInfo physicalDisplayInfo) {
            return physicalDisplayInfo != null && this.width == physicalDisplayInfo.width && this.height == physicalDisplayInfo.height && this.refreshRate == physicalDisplayInfo.refreshRate && this.density == physicalDisplayInfo.density && this.xDpi == physicalDisplayInfo.xDpi && this.yDpi == physicalDisplayInfo.yDpi && this.secure == physicalDisplayInfo.secure && this.appVsyncOffsetNanos == physicalDisplayInfo.appVsyncOffsetNanos && this.presentationDeadlineNanos == physicalDisplayInfo.presentationDeadlineNanos;
        }

        public boolean equals(Object object) {
            return object instanceof PhysicalDisplayInfo && this.equals((PhysicalDisplayInfo)object);
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "PhysicalDisplayInfo{" + this.width + " x " + this.height + ", " + this.refreshRate + " fps, " + "density " + this.density + ", " + this.xDpi + " x " + this.yDpi + " dpi, secure " + this.secure + ", appVsyncOffset " + this.appVsyncOffsetNanos + ", bufferDeadline " + this.presentationDeadlineNanos + "}";
        }
    }
}

