/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pools;

public class MagnificationSpec
implements Parcelable {
    public static final Parcelable.Creator<MagnificationSpec> CREATOR;
    private static final int MAX_POOL_SIZE = 20;
    private static final Pools.SynchronizedPool<MagnificationSpec> sPool;
    public float offsetX;
    public float offsetY;
    public float scale = 1.0f;

    static {
        sPool = new Pools.SynchronizedPool(20);
        CREATOR = new Parcelable.Creator<MagnificationSpec>(){

            @Override
            public MagnificationSpec createFromParcel(Parcel parcel) {
                MagnificationSpec magnificationSpec = MagnificationSpec.obtain();
                magnificationSpec.initFromParcel(parcel);
                return magnificationSpec;
            }

            public MagnificationSpec[] newArray(int n) {
                return new MagnificationSpec[n];
            }
        };
    }

    private MagnificationSpec() {
    }

    private void initFromParcel(Parcel parcel) {
        this.scale = parcel.readFloat();
        this.offsetX = parcel.readFloat();
        this.offsetY = parcel.readFloat();
    }

    public static MagnificationSpec obtain() {
        MagnificationSpec magnificationSpec = sPool.acquire();
        if (magnificationSpec != null) {
            return magnificationSpec;
        }
        return new MagnificationSpec();
    }

    public static MagnificationSpec obtain(MagnificationSpec magnificationSpec) {
        MagnificationSpec magnificationSpec2 = MagnificationSpec.obtain();
        magnificationSpec2.scale = magnificationSpec.scale;
        magnificationSpec2.offsetX = magnificationSpec.offsetX;
        magnificationSpec2.offsetY = magnificationSpec.offsetY;
        return magnificationSpec2;
    }

    public void clear() {
        this.scale = 1.0f;
        this.offsetX = 0.0f;
        this.offsetY = 0.0f;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void initialize(float f, float f2, float f3) {
        this.scale = f;
        this.offsetX = f2;
        this.offsetY = f3;
    }

    public boolean isNop() {
        return this.scale == 1.0f && this.offsetX == 0.0f && this.offsetY == 0.0f;
    }

    public boolean isOneHandControlling() {
        return this.scale < 1.0f;
    }

    public void recycle() {
        this.clear();
        sPool.release(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<scale:");
        stringBuilder.append(this.scale);
        stringBuilder.append(",offsetX:");
        stringBuilder.append(this.offsetX);
        stringBuilder.append(",offsetY:");
        stringBuilder.append(this.offsetY);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeFloat(this.scale);
        parcel.writeFloat(this.offsetX);
        parcel.writeFloat(this.offsetY);
        this.recycle();
    }
}

