/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Looper;
import android.os.MessageQueue;
import android.util.LongSparseArray;
import android.util.Pools;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;

public final class InputQueue {
    private final LongSparseArray<ActiveInputEvent> mActiveEventArray = new LongSparseArray(20);
    private final Pools.Pool<ActiveInputEvent> mActiveInputEventPool = new Pools.SimplePool<ActiveInputEvent>(20);
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private long mPtr = InputQueue.nativeInit(new WeakReference<InputQueue>(this), Looper.myQueue());

    public InputQueue() {
        this.mCloseGuard.open("dispose");
    }

    private void finishInputEvent(long l, boolean bl) {
        int n = this.mActiveEventArray.indexOfKey(l);
        if (n >= 0) {
            ActiveInputEvent activeInputEvent = this.mActiveEventArray.valueAt(n);
            this.mActiveEventArray.removeAt(n);
            activeInputEvent.mCallback.onFinishedInputEvent(activeInputEvent.mToken, bl);
            this.recycleActiveInputEvent(activeInputEvent);
        }
    }

    private static native void nativeDispose(long var0);

    private static native long nativeInit(WeakReference<InputQueue> var0, MessageQueue var1);

    private static native long nativeSendKeyEvent(long var0, KeyEvent var2, boolean var3);

    private static native long nativeSendMotionEvent(long var0, MotionEvent var2);

    private ActiveInputEvent obtainActiveInputEvent(Object object, FinishedInputEventCallback finishedInputEventCallback) {
        ActiveInputEvent activeInputEvent = this.mActiveInputEventPool.acquire();
        if (activeInputEvent == null) {
            activeInputEvent = new ActiveInputEvent();
        }
        activeInputEvent.mToken = object;
        activeInputEvent.mCallback = finishedInputEventCallback;
        return activeInputEvent;
    }

    private void recycleActiveInputEvent(ActiveInputEvent activeInputEvent) {
        activeInputEvent.recycle();
        this.mActiveInputEventPool.release(activeInputEvent);
    }

    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean bl) {
        if (this.mCloseGuard != null) {
            if (bl) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (this.mPtr != 0L) {
            InputQueue.nativeDispose(this.mPtr);
            this.mPtr = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public long getNativePtr() {
        return this.mPtr;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void sendInputEvent(InputEvent inputEvent, Object object, boolean bl, FinishedInputEventCallback finishedInputEventCallback) {
        ActiveInputEvent activeInputEvent = this.obtainActiveInputEvent(object, finishedInputEventCallback);
        long l = inputEvent instanceof KeyEvent ? InputQueue.nativeSendKeyEvent(this.mPtr, (KeyEvent)inputEvent, bl) : InputQueue.nativeSendMotionEvent(this.mPtr, (MotionEvent)inputEvent);
        this.mActiveEventArray.put(l, activeInputEvent);
    }

    private final class ActiveInputEvent {
        public FinishedInputEventCallback mCallback;
        public Object mToken;

        private ActiveInputEvent() {
        }

        public void recycle() {
            this.mToken = null;
            this.mCallback = null;
        }
    }

    public static interface Callback {
        public void onInputQueueCreated(InputQueue var1);

        public void onInputQueueDestroyed(InputQueue var1);
    }

    public static interface FinishedInputEventCallback {
        public void onFinishedInputEvent(Object var1, boolean var2);
    }
}

