/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Looper;
import android.os.MessageQueue;
import android.util.Log;
import android.view.InputChannel;
import android.view.InputEvent;
import android.view.KeyEvent;
import android.view.MotionEvent;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;

public abstract class InputEventSender {
    private static final String TAG = "InputEventSender";
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private InputChannel mInputChannel;
    private MessageQueue mMessageQueue;
    private long mSenderPtr;

    public InputEventSender(InputChannel inputChannel, Looper looper) {
        if (inputChannel == null) {
            throw new IllegalArgumentException("inputChannel must not be null");
        }
        if (looper == null) {
            throw new IllegalArgumentException("looper must not be null");
        }
        this.mInputChannel = inputChannel;
        this.mMessageQueue = looper.getQueue();
        this.mSenderPtr = InputEventSender.nativeInit(new WeakReference<InputEventSender>(this), inputChannel, this.mMessageQueue);
        this.mCloseGuard.open("dispose");
    }

    private void dispatchInputEventFinished(int n, boolean bl) {
        this.onInputEventFinished(n, bl);
    }

    private void dispose(boolean bl) {
        if (this.mCloseGuard != null) {
            if (bl) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (this.mSenderPtr != 0L) {
            InputEventSender.nativeDispose(this.mSenderPtr);
            this.mSenderPtr = 0L;
        }
        this.mInputChannel = null;
        this.mMessageQueue = null;
    }

    private static native void nativeDispose(long var0);

    private static native long nativeInit(WeakReference<InputEventSender> var0, InputChannel var1, MessageQueue var2);

    private static native boolean nativeSendKeyEvent(long var0, int var2, KeyEvent var3);

    private static native boolean nativeSendMotionEvent(long var0, int var2, MotionEvent var3);

    public void dispose() {
        this.dispose(false);
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public void onInputEventFinished(int n, boolean bl) {
    }

    public final boolean sendInputEvent(int n, InputEvent inputEvent) {
        if (inputEvent == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        if (this.mSenderPtr == 0L) {
            Log.w(TAG, "Attempted to send an input event but the input event sender has already been disposed.");
            return false;
        }
        if (inputEvent instanceof KeyEvent) {
            return InputEventSender.nativeSendKeyEvent(this.mSenderPtr, n, (KeyEvent)inputEvent);
        }
        return InputEventSender.nativeSendMotionEvent(this.mSenderPtr, n, (MotionEvent)inputEvent);
    }
}

