/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.hardware.input.InputDeviceIdentifier;
import android.hardware.input.InputManager;
import android.os.NullVibrator;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Vibrator;
import android.view.KeyCharacterMap;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.List;

public final class InputDevice
implements Parcelable {
    public static final Parcelable.Creator<InputDevice> CREATOR = new Parcelable.Creator<InputDevice>(){

        @Override
        public InputDevice createFromParcel(Parcel parcel) {
            return new InputDevice(parcel);
        }

        public InputDevice[] newArray(int n) {
            return new InputDevice[n];
        }
    };
    public static final int KEYBOARD_TYPE_ALPHABETIC = 2;
    public static final int KEYBOARD_TYPE_NONE = 0;
    public static final int KEYBOARD_TYPE_NON_ALPHABETIC = 1;
    @Deprecated
    public static final int MOTION_RANGE_ORIENTATION = 8;
    @Deprecated
    public static final int MOTION_RANGE_PRESSURE = 2;
    @Deprecated
    public static final int MOTION_RANGE_SIZE = 3;
    @Deprecated
    public static final int MOTION_RANGE_TOOL_MAJOR = 6;
    @Deprecated
    public static final int MOTION_RANGE_TOOL_MINOR = 7;
    @Deprecated
    public static final int MOTION_RANGE_TOUCH_MAJOR = 4;
    @Deprecated
    public static final int MOTION_RANGE_TOUCH_MINOR = 5;
    @Deprecated
    public static final int MOTION_RANGE_X = 0;
    @Deprecated
    public static final int MOTION_RANGE_Y = 1;
    public static final int SOURCE_ANY = -256;
    public static final int SOURCE_CLASS_BUTTON = 1;
    public static final int SOURCE_CLASS_JOYSTICK = 16;
    public static final int SOURCE_CLASS_MASK = 255;
    public static final int SOURCE_CLASS_NONE = 0;
    public static final int SOURCE_CLASS_POINTER = 2;
    public static final int SOURCE_CLASS_POSITION = 8;
    public static final int SOURCE_CLASS_TRACKBALL = 4;
    public static final int SOURCE_DPAD = 513;
    public static final int SOURCE_GAMEPAD = 1025;
    public static final int SOURCE_HDMI = 0x2000001;
    public static final int SOURCE_JOYSTICK = 0x1000010;
    public static final int SOURCE_KEYBOARD = 257;
    public static final int SOURCE_MOUSE = 8194;
    public static final int SOURCE_STYLUS = 16386;
    public static final int SOURCE_TOUCHPAD = 0x100008;
    public static final int SOURCE_TOUCHSCREEN = 4098;
    public static final int SOURCE_TOUCH_NAVIGATION = 0x200000;
    public static final int SOURCE_TRACKBALL = 65540;
    public static final int SOURCE_UNKNOWN;
    private final int mControllerNumber;
    private final String mDescriptor;
    private final int mGeneration;
    private final boolean mHasButtonUnderPad;
    private final boolean mHasVibrator;
    private final int mId;
    private final InputDeviceIdentifier mIdentifier;
    private final boolean mIsExternal;
    private final KeyCharacterMap mKeyCharacterMap;
    private final int mKeyboardType;
    private final ArrayList<MotionRange> mMotionRanges;
    private final String mName;
    private final int mProductId;
    private final int mSources;
    private final int mVendorId;
    private Vibrator mVibrator;

    private InputDevice(int n, int n2, int n3, String string2, int n4, int n5, String string3, boolean bl, int n6, int n7, KeyCharacterMap keyCharacterMap, boolean bl2, boolean bl3) {
        this.mMotionRanges = new ArrayList();
        this.mId = n;
        this.mGeneration = n2;
        this.mControllerNumber = n3;
        this.mName = string2;
        this.mVendorId = n4;
        this.mProductId = n5;
        this.mDescriptor = string3;
        this.mIsExternal = bl;
        this.mSources = n6;
        this.mKeyboardType = n7;
        this.mKeyCharacterMap = keyCharacterMap;
        this.mHasVibrator = bl2;
        this.mHasButtonUnderPad = bl3;
        this.mIdentifier = new InputDeviceIdentifier(string3, n4, n5);
    }

    /*
     * Enabled aggressive block sorting
     */
    private InputDevice(Parcel parcel) {
        boolean bl = true;
        this.mMotionRanges = new ArrayList();
        this.mId = parcel.readInt();
        this.mGeneration = parcel.readInt();
        this.mControllerNumber = parcel.readInt();
        this.mName = parcel.readString();
        this.mVendorId = parcel.readInt();
        this.mProductId = parcel.readInt();
        this.mDescriptor = parcel.readString();
        boolean bl2 = parcel.readInt() != 0 ? bl : false;
        this.mIsExternal = bl2;
        this.mSources = parcel.readInt();
        this.mKeyboardType = parcel.readInt();
        this.mKeyCharacterMap = KeyCharacterMap.CREATOR.createFromParcel(parcel);
        boolean bl3 = parcel.readInt() != 0 ? bl : false;
        this.mHasVibrator = bl3;
        if (parcel.readInt() == 0) {
            bl = false;
        }
        this.mHasButtonUnderPad = bl;
        this.mIdentifier = new InputDeviceIdentifier(this.mDescriptor, this.mVendorId, this.mProductId);
        int n;
        while ((n = parcel.readInt()) >= 0) {
            this.addMotionRange(n, parcel.readInt(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat());
        }
        return;
    }

    private void addMotionRange(int n, int n2, float f, float f2, float f3, float f4, float f5) {
        this.mMotionRanges.add(new MotionRange(n, n2, f, f2, f3, f4, f5));
    }

    private void appendSourceDescriptionIfApplicable(StringBuilder stringBuilder, int n, String string2) {
        if ((n & this.mSources) == n) {
            stringBuilder.append(" ");
            stringBuilder.append(string2);
        }
    }

    public static InputDevice getDevice(int n) {
        return InputManager.getInstance().getInputDevice(n);
    }

    public static int[] getDeviceIds() {
        return InputManager.getInstance().getInputDeviceIds();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getControllerNumber() {
        return this.mControllerNumber;
    }

    public String getDescriptor() {
        return this.mDescriptor;
    }

    public int getGeneration() {
        return this.mGeneration;
    }

    public int getId() {
        return this.mId;
    }

    public InputDeviceIdentifier getIdentifier() {
        return this.mIdentifier;
    }

    public KeyCharacterMap getKeyCharacterMap() {
        return this.mKeyCharacterMap;
    }

    public int getKeyboardType() {
        return this.mKeyboardType;
    }

    public MotionRange getMotionRange(int n) {
        int n2 = this.mMotionRanges.size();
        for (int i = 0; i < n2; ++i) {
            MotionRange motionRange = this.mMotionRanges.get(i);
            if (motionRange.mAxis != n) continue;
            return motionRange;
        }
        return null;
    }

    public MotionRange getMotionRange(int n, int n2) {
        int n3 = this.mMotionRanges.size();
        for (int i = 0; i < n3; ++i) {
            MotionRange motionRange = this.mMotionRanges.get(i);
            if (motionRange.mAxis != n || motionRange.mSource != n2) continue;
            return motionRange;
        }
        return null;
    }

    public List<MotionRange> getMotionRanges() {
        return this.mMotionRanges;
    }

    public String getName() {
        return this.mName;
    }

    public int getProductId() {
        return this.mProductId;
    }

    public int getSources() {
        return this.mSources;
    }

    public int getVendorId() {
        return this.mVendorId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vibrator getVibrator() {
        ArrayList<MotionRange> arrayList = this.mMotionRanges;
        synchronized (arrayList) {
            if (this.mVibrator != null) return this.mVibrator;
            this.mVibrator = this.mHasVibrator ? InputManager.getInstance().getInputDeviceVibrator(this.mId) : NullVibrator.getInstance();
            return this.mVibrator;
        }
    }

    public boolean hasButtonUnderPad() {
        return this.mHasButtonUnderPad;
    }

    public boolean[] hasKeys(int ... nArray) {
        return InputManager.getInstance().deviceHasKeys(this.mId, nArray);
    }

    public boolean isExternal() {
        return this.mIsExternal;
    }

    public boolean isFullKeyboard() {
        return (0x101 & this.mSources) == 257 && this.mKeyboardType == 2;
    }

    public boolean isVirtual() {
        return this.mId < 0;
    }

    public boolean supportsSource(int n) {
        return (n & this.mSources) == n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Input Device ").append(this.mId).append(": ").append(this.mName).append("\n");
        stringBuilder.append("  Descriptor: ").append(this.mDescriptor).append("\n");
        stringBuilder.append("  Generation: ").append(this.mGeneration).append("\n");
        StringBuilder stringBuilder2 = stringBuilder.append("  Location: ");
        String string2 = this.mIsExternal ? "external" : "built-in";
        stringBuilder2.append(string2).append("\n");
        stringBuilder.append("  Keyboard Type: ");
        switch (this.mKeyboardType) {
            case 0: {
                stringBuilder.append("none");
                break;
            }
            case 1: {
                stringBuilder.append("non-alphabetic");
                break;
            }
            case 2: {
                stringBuilder.append("alphabetic");
            }
        }
        stringBuilder.append("\n");
        stringBuilder.append("  Has Vibrator: ").append(this.mHasVibrator).append("\n");
        stringBuilder.append("  Sources: 0x").append(Integer.toHexString(this.mSources)).append(" (");
        this.appendSourceDescriptionIfApplicable(stringBuilder, 257, "keyboard");
        this.appendSourceDescriptionIfApplicable(stringBuilder, 513, "dpad");
        this.appendSourceDescriptionIfApplicable(stringBuilder, 4098, "touchscreen");
        this.appendSourceDescriptionIfApplicable(stringBuilder, 8194, "mouse");
        this.appendSourceDescriptionIfApplicable(stringBuilder, 16386, "stylus");
        this.appendSourceDescriptionIfApplicable(stringBuilder, 65540, "trackball");
        this.appendSourceDescriptionIfApplicable(stringBuilder, 0x100008, "touchpad");
        this.appendSourceDescriptionIfApplicable(stringBuilder, 0x1000010, "joystick");
        this.appendSourceDescriptionIfApplicable(stringBuilder, 1025, "gamepad");
        stringBuilder.append(" )\n");
        int n = this.mMotionRanges.size();
        for (int i = 0; i < n; ++i) {
            MotionRange motionRange = this.mMotionRanges.get(i);
            stringBuilder.append("    ").append(MotionEvent.axisToString(motionRange.mAxis));
            stringBuilder.append(": source=0x").append(Integer.toHexString(motionRange.mSource));
            stringBuilder.append(" min=").append(motionRange.mMin);
            stringBuilder.append(" max=").append(motionRange.mMax);
            stringBuilder.append(" flat=").append(motionRange.mFlat);
            stringBuilder.append(" fuzz=").append(motionRange.mFuzz);
            stringBuilder.append(" resolution=").append(motionRange.mResolution);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeInt(this.mId);
        parcel.writeInt(this.mGeneration);
        parcel.writeInt(this.mControllerNumber);
        parcel.writeString(this.mName);
        parcel.writeInt(this.mVendorId);
        parcel.writeInt(this.mProductId);
        parcel.writeString(this.mDescriptor);
        int n3 = this.mIsExternal ? n2 : 0;
        parcel.writeInt(n3);
        parcel.writeInt(this.mSources);
        parcel.writeInt(this.mKeyboardType);
        this.mKeyCharacterMap.writeToParcel(parcel, n);
        int n4 = this.mHasVibrator ? n2 : 0;
        parcel.writeInt(n4);
        if (!this.mHasButtonUnderPad) {
            n2 = 0;
        }
        parcel.writeInt(n2);
        int n5 = this.mMotionRanges.size();
        int n6 = 0;
        while (true) {
            if (n6 >= n5) {
                parcel.writeInt(-1);
                return;
            }
            MotionRange motionRange = this.mMotionRanges.get(n6);
            parcel.writeInt(motionRange.mAxis);
            parcel.writeInt(motionRange.mSource);
            parcel.writeFloat(motionRange.mMin);
            parcel.writeFloat(motionRange.mMax);
            parcel.writeFloat(motionRange.mFlat);
            parcel.writeFloat(motionRange.mFuzz);
            parcel.writeFloat(motionRange.mResolution);
            ++n6;
        }
    }

    public static final class MotionRange {
        private int mAxis;
        private float mFlat;
        private float mFuzz;
        private float mMax;
        private float mMin;
        private float mResolution;
        private int mSource;

        private MotionRange(int n, int n2, float f, float f2, float f3, float f4, float f5) {
            this.mAxis = n;
            this.mSource = n2;
            this.mMin = f;
            this.mMax = f2;
            this.mFlat = f3;
            this.mFuzz = f4;
            this.mResolution = f5;
        }

        public int getAxis() {
            return this.mAxis;
        }

        public float getFlat() {
            return this.mFlat;
        }

        public float getFuzz() {
            return this.mFuzz;
        }

        public float getMax() {
            return this.mMax;
        }

        public float getMin() {
            return this.mMin;
        }

        public float getRange() {
            return this.mMax - this.mMin;
        }

        public float getResolution() {
            return this.mResolution;
        }

        public int getSource() {
            return this.mSource;
        }

        public boolean isFromSource(int n) {
            return (n & this.getSource()) == n;
        }
    }
}

