/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.ClipData;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.IWindow;
import android.view.IWindowId;
import android.view.InputChannel;
import android.view.Surface;
import android.view.WindowManager;

public interface IWindowSession
extends IInterface {
    public int add(IWindow var1, int var2, WindowManager.LayoutParams var3, int var4, Rect var5, InputChannel var6) throws RemoteException;

    public int addToDisplay(IWindow var1, int var2, WindowManager.LayoutParams var3, int var4, int var5, Rect var6, InputChannel var7) throws RemoteException;

    public int addToDisplayWithoutInputChannel(IWindow var1, int var2, WindowManager.LayoutParams var3, int var4, int var5, Rect var6) throws RemoteException;

    public int addWithoutInputChannel(IWindow var1, int var2, WindowManager.LayoutParams var3, int var4, Rect var5) throws RemoteException;

    public void dragRecipientEntered(IWindow var1) throws RemoteException;

    public void dragRecipientExited(IWindow var1) throws RemoteException;

    public void finishDrawing(IWindow var1) throws RemoteException;

    public void getDisplayFrame(IWindow var1, Rect var2) throws RemoteException;

    public boolean getInTouchMode() throws RemoteException;

    public IWindowId getWindowId(IBinder var1) throws RemoteException;

    public void onRectangleOnScreenRequested(IBinder var1, Rect var2) throws RemoteException;

    public boolean outOfMemory(IWindow var1) throws RemoteException;

    public void performDeferredDestroy(IWindow var1) throws RemoteException;

    public boolean performDrag(IWindow var1, IBinder var2, float var3, float var4, float var5, float var6, ClipData var7) throws RemoteException;

    public boolean performHapticFeedback(IWindow var1, int var2, boolean var3) throws RemoteException;

    public IBinder prepareDrag(IWindow var1, int var2, int var3, int var4, Surface var5) throws RemoteException;

    public int relayout(IWindow var1, int var2, WindowManager.LayoutParams var3, int var4, int var5, int var6, int var7, Rect var8, Rect var9, Rect var10, Rect var11, Rect var12, Configuration var13, Surface var14) throws RemoteException;

    public void remove(IWindow var1) throws RemoteException;

    public void reportDropResult(IWindow var1, boolean var2) throws RemoteException;

    public Bundle sendWallpaperCommand(IBinder var1, String var2, int var3, int var4, int var5, Bundle var6, boolean var7) throws RemoteException;

    public void setInTouchMode(boolean var1) throws RemoteException;

    public void setInsets(IWindow var1, int var2, Rect var3, Rect var4, Region var5) throws RemoteException;

    public void setTransparentRegion(IWindow var1, Region var2) throws RemoteException;

    public void setUniverseTransform(IBinder var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8) throws RemoteException;

    public void setWallpaperDisplayOffset(IBinder var1, int var2, int var3) throws RemoteException;

    public void setWallpaperPosition(IBinder var1, float var2, float var3, float var4, float var5) throws RemoteException;

    public void wallpaperCommandComplete(IBinder var1, Bundle var2) throws RemoteException;

    public void wallpaperOffsetsComplete(IBinder var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowSession {
        private static final String DESCRIPTOR = "android.view.IWindowSession";
        static final int TRANSACTION_add = 1;
        static final int TRANSACTION_addToDisplay = 2;
        static final int TRANSACTION_addToDisplayWithoutInputChannel = 4;
        static final int TRANSACTION_addWithoutInputChannel = 3;
        static final int TRANSACTION_dragRecipientEntered = 19;
        static final int TRANSACTION_dragRecipientExited = 20;
        static final int TRANSACTION_finishDrawing = 12;
        static final int TRANSACTION_getDisplayFrame = 11;
        static final int TRANSACTION_getInTouchMode = 14;
        static final int TRANSACTION_getWindowId = 28;
        static final int TRANSACTION_onRectangleOnScreenRequested = 27;
        static final int TRANSACTION_outOfMemory = 8;
        static final int TRANSACTION_performDeferredDestroy = 7;
        static final int TRANSACTION_performDrag = 17;
        static final int TRANSACTION_performHapticFeedback = 15;
        static final int TRANSACTION_prepareDrag = 16;
        static final int TRANSACTION_relayout = 6;
        static final int TRANSACTION_remove = 5;
        static final int TRANSACTION_reportDropResult = 18;
        static final int TRANSACTION_sendWallpaperCommand = 24;
        static final int TRANSACTION_setInTouchMode = 13;
        static final int TRANSACTION_setInsets = 10;
        static final int TRANSACTION_setTransparentRegion = 9;
        static final int TRANSACTION_setUniverseTransform = 26;
        static final int TRANSACTION_setWallpaperDisplayOffset = 23;
        static final int TRANSACTION_setWallpaperPosition = 21;
        static final int TRANSACTION_wallpaperCommandComplete = 25;
        static final int TRANSACTION_wallpaperOffsetsComplete = 22;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWindowSession asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IWindowSession) {
                return (IWindowSession)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    int n3 = parcel.readInt();
                    WindowManager.LayoutParams layoutParams = parcel.readInt() != 0 ? WindowManager.LayoutParams.CREATOR.createFromParcel(parcel) : null;
                    int n4 = parcel.readInt();
                    Rect rect = new Rect();
                    InputChannel inputChannel = new InputChannel();
                    int n5 = this.add(iWindow, n3, layoutParams, n4, rect, inputChannel);
                    parcel2.writeNoException();
                    parcel2.writeInt(n5);
                    if (rect != null) {
                        parcel2.writeInt(1);
                        rect.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    if (inputChannel != null) {
                        parcel2.writeInt(1);
                        inputChannel.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    int n6 = parcel.readInt();
                    WindowManager.LayoutParams layoutParams = parcel.readInt() != 0 ? WindowManager.LayoutParams.CREATOR.createFromParcel(parcel) : null;
                    int n7 = parcel.readInt();
                    int n8 = parcel.readInt();
                    Rect rect = new Rect();
                    InputChannel inputChannel = new InputChannel();
                    int n9 = this.addToDisplay(iWindow, n6, layoutParams, n7, n8, rect, inputChannel);
                    parcel2.writeNoException();
                    parcel2.writeInt(n9);
                    if (rect != null) {
                        parcel2.writeInt(1);
                        rect.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    if (inputChannel != null) {
                        parcel2.writeInt(1);
                        inputChannel.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    int n10 = parcel.readInt();
                    WindowManager.LayoutParams layoutParams = parcel.readInt() != 0 ? WindowManager.LayoutParams.CREATOR.createFromParcel(parcel) : null;
                    int n11 = parcel.readInt();
                    Rect rect = new Rect();
                    int n12 = this.addWithoutInputChannel(iWindow, n10, layoutParams, n11, rect);
                    parcel2.writeNoException();
                    parcel2.writeInt(n12);
                    if (rect != null) {
                        parcel2.writeInt(1);
                        rect.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    int n13 = parcel.readInt();
                    WindowManager.LayoutParams layoutParams = parcel.readInt() != 0 ? WindowManager.LayoutParams.CREATOR.createFromParcel(parcel) : null;
                    int n14 = parcel.readInt();
                    int n15 = parcel.readInt();
                    Rect rect = new Rect();
                    int n16 = this.addToDisplayWithoutInputChannel(iWindow, n13, layoutParams, n14, n15, rect);
                    parcel2.writeNoException();
                    parcel2.writeInt(n16);
                    if (rect != null) {
                        parcel2.writeInt(1);
                        rect.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.remove(IWindow.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    int n17 = parcel.readInt();
                    WindowManager.LayoutParams layoutParams = parcel.readInt() != 0 ? WindowManager.LayoutParams.CREATOR.createFromParcel(parcel) : null;
                    int n18 = parcel.readInt();
                    int n19 = parcel.readInt();
                    int n20 = parcel.readInt();
                    int n21 = parcel.readInt();
                    Rect rect = new Rect();
                    Rect rect2 = new Rect();
                    Rect rect3 = new Rect();
                    Rect rect4 = new Rect();
                    Rect rect5 = new Rect();
                    Configuration configuration = new Configuration();
                    Surface surface = new Surface();
                    int n22 = this.relayout(iWindow, n17, layoutParams, n18, n19, n20, n21, rect, rect2, rect3, rect4, rect5, configuration, surface);
                    parcel2.writeNoException();
                    parcel2.writeInt(n22);
                    if (rect != null) {
                        parcel2.writeInt(1);
                        rect.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    if (rect2 != null) {
                        parcel2.writeInt(1);
                        rect2.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    if (rect3 != null) {
                        parcel2.writeInt(1);
                        rect3.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    if (rect4 != null) {
                        parcel2.writeInt(1);
                        rect4.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    if (rect5 != null) {
                        parcel2.writeInt(1);
                        rect5.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    if (configuration != null) {
                        parcel2.writeInt(1);
                        configuration.writeToParcel(parcel2, 1);
                    } else {
                        parcel2.writeInt(0);
                    }
                    if (surface != null) {
                        parcel2.writeInt(1);
                        surface.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.performDeferredDestroy(IWindow.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.outOfMemory(IWindow.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    int n23 = bl ? 1 : 0;
                    parcel2.writeInt(n23);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    Region region = parcel.readInt() != 0 ? Region.CREATOR.createFromParcel(parcel) : null;
                    this.setTransparentRegion(iWindow, region);
                    parcel2.writeNoException();
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    int n24 = parcel.readInt();
                    Rect rect = parcel.readInt() != 0 ? Rect.CREATOR.createFromParcel(parcel) : null;
                    Rect rect6 = parcel.readInt() != 0 ? Rect.CREATOR.createFromParcel(parcel) : null;
                    Region region = parcel.readInt() != 0 ? Region.CREATOR.createFromParcel(parcel) : null;
                    this.setInsets(iWindow, n24, rect, rect6, region);
                    parcel2.writeNoException();
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    Rect rect = new Rect();
                    this.getDisplayFrame(iWindow, rect);
                    parcel2.writeNoException();
                    if (rect != null) {
                        parcel2.writeInt(1);
                        rect.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.finishDrawing(IWindow.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    this.setInTouchMode(bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.getInTouchMode();
                    parcel2.writeNoException();
                    int n25 = bl ? 1 : 0;
                    parcel2.writeInt(n25);
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    int n26 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = this.performHapticFeedback(iWindow, n26, bl);
                    parcel2.writeNoException();
                    int n27 = bl2 ? 1 : 0;
                    parcel2.writeInt(n27);
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    int n28 = parcel.readInt();
                    int n29 = parcel.readInt();
                    int n30 = parcel.readInt();
                    Surface surface = new Surface();
                    IBinder iBinder = this.prepareDrag(iWindow, n28, n29, n30, surface);
                    parcel2.writeNoException();
                    parcel2.writeStrongBinder(iBinder);
                    if (surface != null) {
                        parcel2.writeInt(1);
                        surface.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    IBinder iBinder = parcel.readStrongBinder();
                    float f = parcel.readFloat();
                    float f2 = parcel.readFloat();
                    float f3 = parcel.readFloat();
                    float f4 = parcel.readFloat();
                    ClipData clipData = parcel.readInt() != 0 ? ClipData.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.performDrag(iWindow, iBinder, f, f2, f3, f4, clipData);
                    parcel2.writeNoException();
                    int n31 = bl ? 1 : 0;
                    parcel2.writeInt(n31);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IWindow iWindow = IWindow.Stub.asInterface(parcel.readStrongBinder());
                    boolean bl = parcel.readInt() != 0;
                    this.reportDropResult(iWindow, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.dragRecipientEntered(IWindow.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.dragRecipientExited(IWindow.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setWallpaperPosition(parcel.readStrongBinder(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat());
                    parcel2.writeNoException();
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.wallpaperOffsetsComplete(parcel.readStrongBinder());
                    parcel2.writeNoException();
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setWallpaperDisplayOffset(parcel.readStrongBinder(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    String string2 = parcel.readString();
                    int n32 = parcel.readInt();
                    int n33 = parcel.readInt();
                    int n34 = parcel.readInt();
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    Bundle bundle2 = this.sendWallpaperCommand(iBinder, string2, n32, n33, n34, bundle, bl);
                    parcel2.writeNoException();
                    if (bundle2 != null) {
                        parcel2.writeInt(1);
                        bundle2.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    this.wallpaperCommandComplete(iBinder, bundle);
                    parcel2.writeNoException();
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setUniverseTransform(parcel.readStrongBinder(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat(), parcel.readFloat());
                    parcel2.writeNoException();
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    IBinder iBinder = parcel.readStrongBinder();
                    Rect rect = parcel.readInt() != 0 ? Rect.CREATOR.createFromParcel(parcel) : null;
                    this.onRectangleOnScreenRequested(iBinder, rect);
                    parcel2.writeNoException();
                    return true;
                }
                case 28: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            IWindowId iWindowId = this.getWindowId(parcel.readStrongBinder());
            parcel2.writeNoException();
            IBinder iBinder = iWindowId != null ? iWindowId.asBinder() : null;
            parcel2.writeStrongBinder(iBinder);
            return true;
        }

        private static class Proxy
        implements IWindowSession {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int add(IWindow iWindow, int n, WindowManager.LayoutParams layoutParams, int n2, Rect rect, InputChannel inputChannel) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    if (layoutParams != null) {
                        parcel.writeInt(1);
                        layoutParams.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n2);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        rect.readFromParcel(parcel2);
                    }
                    if (parcel2.readInt() != 0) {
                        inputChannel.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return n3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int addToDisplay(IWindow iWindow, int n, WindowManager.LayoutParams layoutParams, int n2, int n3, Rect rect, InputChannel inputChannel) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    if (layoutParams != null) {
                        parcel.writeInt(1);
                        layoutParams.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    int n4 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        rect.readFromParcel(parcel2);
                    }
                    if (parcel2.readInt() != 0) {
                        inputChannel.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return n4;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int addToDisplayWithoutInputChannel(IWindow iWindow, int n, WindowManager.LayoutParams layoutParams, int n2, int n3, Rect rect) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    if (layoutParams != null) {
                        parcel.writeInt(1);
                        layoutParams.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    int n4 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        rect.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return n4;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int addWithoutInputChannel(IWindow iWindow, int n, WindowManager.LayoutParams layoutParams, int n2, Rect rect) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    if (layoutParams != null) {
                        parcel.writeInt(1);
                        layoutParams.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n2);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        rect.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return n3;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void dragRecipientEntered(IWindow iWindow) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void dragRecipientExited(IWindow iWindow) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void finishDrawing(IWindow iWindow) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void getDisplayFrame(IWindow iWindow, Rect rect) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    if (parcel2.readInt() != 0) {
                        rect.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean getInTouchMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            @Override
            public IWindowId getWindowId(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    IWindowId iWindowId = IWindowId.Stub.asInterface(parcel2.readStrongBinder());
                    return iWindowId;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onRectangleOnScreenRequested(IBinder iBinder, Rect rect) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    if (rect != null) {
                        parcel.writeInt(1);
                        rect.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(27, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean outOfMemory(IWindow iWindow) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void performDeferredDestroy(IWindow iWindow) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean performDrag(IWindow iWindow, IBinder iBinder, float f, float f2, float f3, float f4, ClipData clipData) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            IBinder iBinder2 = iWindow != null ? iWindow.asBinder() : null;
                            parcel2.writeStrongBinder(iBinder2);
                            parcel2.writeStrongBinder(iBinder);
                            parcel2.writeFloat(f);
                            parcel2.writeFloat(f2);
                            parcel2.writeFloat(f3);
                            parcel2.writeFloat(f4);
                            if (clipData != null) {
                                parcel2.writeInt(1);
                                clipData.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(17, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean performHapticFeedback(IWindow iWindow, int n, boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl2;
                block3: {
                    block2: {
                        bl2 = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                            parcel2.writeStrongBinder(iBinder);
                            parcel2.writeInt(n);
                            boolean bl3 = bl ? bl2 : false;
                            parcel2.writeInt(bl3 ? 1 : 0);
                            this.mRemote.transact(15, parcel2, parcel, 0);
                            parcel.readException();
                            int n2 = parcel.readInt();
                            if (n2 == 0) break block2;
                            break block3;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl2 = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public IBinder prepareDrag(IWindow iWindow, int n, int n2, int n3, Surface surface) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    IBinder iBinder2 = parcel2.readStrongBinder();
                    if (parcel2.readInt() != 0) {
                        surface.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return iBinder2;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int relayout(IWindow iWindow, int n, WindowManager.LayoutParams layoutParams, int n2, int n3, int n4, int n5, Rect rect, Rect rect2, Rect rect3, Rect rect4, Rect rect5, Configuration configuration, Surface surface) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    if (layoutParams != null) {
                        parcel.writeInt(1);
                        layoutParams.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    parcel.writeInt(n4);
                    parcel.writeInt(n5);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    int n6 = parcel2.readInt();
                    if (parcel2.readInt() != 0) {
                        rect.readFromParcel(parcel2);
                    }
                    if (parcel2.readInt() != 0) {
                        rect2.readFromParcel(parcel2);
                    }
                    if (parcel2.readInt() != 0) {
                        rect3.readFromParcel(parcel2);
                    }
                    if (parcel2.readInt() != 0) {
                        rect4.readFromParcel(parcel2);
                    }
                    if (parcel2.readInt() != 0) {
                        rect5.readFromParcel(parcel2);
                    }
                    if (parcel2.readInt() != 0) {
                        configuration.readFromParcel(parcel2);
                    }
                    if (parcel2.readInt() != 0) {
                        surface.readFromParcel(parcel2);
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return n6;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void remove(IWindow iWindow) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void reportDropResult(IWindow iWindow, boolean bl) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    int n = 0;
                    if (bl) {
                        n = 1;
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Bundle sendWallpaperCommand(IBinder iBinder, String string2, int n, int n2, int n3, Bundle bundle, boolean bl) throws RemoteException {
                int n4 = 1;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                if (!bl) {
                    n4 = 0;
                }
                parcel.writeInt(n4);
                this.mRemote.transact(24, parcel, parcel2, 0);
                parcel2.readException();
                Bundle bundle2 = parcel2.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel2) : null;
                parcel2.recycle();
                parcel.recycle();
                return bundle2;
            }

            @Override
            public void setInTouchMode(boolean bl) throws RemoteException {
                int n;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    n = 0;
                    if (!bl) break block4;
                    n = 1;
                }
                try {
                    parcel2.writeInt(n);
                    this.mRemote.transact(13, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setInsets(IWindow iWindow, int n, Rect rect, Rect rect2, Region region) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                block9: {
                    block8: {
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                            parcel2.writeStrongBinder(iBinder);
                            parcel2.writeInt(n);
                            if (rect != null) {
                                parcel2.writeInt(1);
                                rect.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            if (rect2 != null) {
                                parcel2.writeInt(1);
                                rect2.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            if (region == null) break block8;
                            parcel2.writeInt(1);
                            region.writeToParcel(parcel2, 0);
                            break block9;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    parcel2.writeInt(0);
                }
                this.mRemote.transact(10, parcel2, parcel, 0);
                parcel.readException();
                parcel.recycle();
                parcel2.recycle();
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setTransparentRegion(IWindow iWindow, Region region) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iWindow != null ? iWindow.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (region != null) {
                        parcel.writeInt(1);
                        region.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setUniverseTransform(IBinder iBinder, float f, float f2, float f3, float f4, float f5, float f6, float f7) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeFloat(f);
                    parcel.writeFloat(f2);
                    parcel.writeFloat(f3);
                    parcel.writeFloat(f4);
                    parcel.writeFloat(f5);
                    parcel.writeFloat(f6);
                    parcel.writeFloat(f7);
                    this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setWallpaperDisplayOffset(IBinder iBinder, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setWallpaperPosition(IBinder iBinder, float f, float f2, float f3, float f4) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeFloat(f);
                    parcel.writeFloat(f2);
                    parcel.writeFloat(f3);
                    parcel.writeFloat(f4);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void wallpaperCommandComplete(IBinder iBinder, Bundle bundle) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    if (bundle != null) {
                        parcel.writeInt(1);
                        bundle.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(25, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void wallpaperOffsetsComplete(IBinder iBinder) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }
        }
    }
}

