/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.InputEventConsistencyVerifier;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;

public class GestureDetector {
    private static final int DOUBLE_TAP_MIN_TIME = 0;
    private static final int DOUBLE_TAP_TIMEOUT = 0;
    private static final int LONGPRESS_TIMEOUT = 0;
    private static final int LONG_PRESS = 2;
    private static final int SHOW_PRESS = 1;
    private static final int TAP = 3;
    private static final int TAP_TIMEOUT;
    private boolean mAlwaysInBiggerTapRegion;
    private boolean mAlwaysInTapRegion;
    private MotionEvent mCurrentDownEvent;
    private boolean mDeferConfirmSingleTap;
    private OnDoubleTapListener mDoubleTapListener;
    private int mDoubleTapSlopSquare;
    private int mDoubleTapTouchSlopSquare;
    private float mDownFocusX;
    private float mDownFocusY;
    private final Handler mHandler;
    private boolean mInLongPress;
    private final InputEventConsistencyVerifier mInputEventConsistencyVerifier;
    private boolean mIsDoubleTapping;
    private boolean mIsLongpressEnabled;
    private float mLastFocusX;
    private float mLastFocusY;
    private final OnGestureListener mListener;
    private int mMaximumFlingVelocity;
    private int mMinimumFlingVelocity;
    private MotionEvent mPreviousUpEvent;
    private boolean mStillDown;
    private int mTouchSlopSquare;
    private VelocityTracker mVelocityTracker;

    static {
        LONGPRESS_TIMEOUT = ViewConfiguration.getLongPressTimeout();
        TAP_TIMEOUT = ViewConfiguration.getTapTimeout();
        DOUBLE_TAP_TIMEOUT = ViewConfiguration.getDoubleTapTimeout();
        DOUBLE_TAP_MIN_TIME = ViewConfiguration.getDoubleTapMinTime();
    }

    public GestureDetector(Context context, OnGestureListener onGestureListener) {
        this(context, onGestureListener, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public GestureDetector(Context context, OnGestureListener onGestureListener, Handler handler) {
        InputEventConsistencyVerifier inputEventConsistencyVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0) : null;
        this.mInputEventConsistencyVerifier = inputEventConsistencyVerifier;
        this.mHandler = handler != null ? new GestureHandler(handler) : new GestureHandler();
        this.mListener = onGestureListener;
        if (onGestureListener instanceof OnDoubleTapListener) {
            this.setOnDoubleTapListener((OnDoubleTapListener)((Object)onGestureListener));
        }
        this.init(context);
    }

    public GestureDetector(Context context, OnGestureListener onGestureListener, Handler handler, boolean bl) {
        this(context, onGestureListener, handler);
    }

    @Deprecated
    public GestureDetector(OnGestureListener onGestureListener) {
        this(null, onGestureListener, null);
    }

    @Deprecated
    public GestureDetector(OnGestureListener onGestureListener, Handler handler) {
        this(null, onGestureListener, handler);
    }

    static /* synthetic */ boolean access$502(GestureDetector gestureDetector, boolean bl) {
        gestureDetector.mDeferConfirmSingleTap = bl;
        return bl;
    }

    private void cancel() {
        this.mHandler.removeMessages(1);
        this.mHandler.removeMessages(2);
        this.mHandler.removeMessages(3);
        this.mVelocityTracker.recycle();
        this.mVelocityTracker = null;
        this.mIsDoubleTapping = false;
        this.mStillDown = false;
        this.mAlwaysInTapRegion = false;
        this.mAlwaysInBiggerTapRegion = false;
        this.mDeferConfirmSingleTap = false;
        if (this.mInLongPress) {
            this.mInLongPress = false;
        }
    }

    private void cancelTaps() {
        this.mHandler.removeMessages(1);
        this.mHandler.removeMessages(2);
        this.mHandler.removeMessages(3);
        this.mIsDoubleTapping = false;
        this.mAlwaysInTapRegion = false;
        this.mAlwaysInBiggerTapRegion = false;
        this.mDeferConfirmSingleTap = false;
        if (this.mInLongPress) {
            this.mInLongPress = false;
        }
    }

    private void dispatchLongPress() {
        this.mHandler.removeMessages(3);
        this.mDeferConfirmSingleTap = false;
        this.mInLongPress = true;
        this.mListener.onLongPress(this.mCurrentDownEvent);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void init(Context context) {
        int n;
        int n2;
        int n3;
        if (this.mListener == null) {
            throw new NullPointerException("OnGestureListener must not be null");
        }
        this.mIsLongpressEnabled = true;
        if (context == null) {
            n2 = n3 = ViewConfiguration.getTouchSlop();
            n = ViewConfiguration.getDoubleTapSlop();
            this.mMinimumFlingVelocity = ViewConfiguration.getMinimumFlingVelocity();
            this.mMaximumFlingVelocity = ViewConfiguration.getMaximumFlingVelocity();
        } else {
            ViewConfiguration viewConfiguration = ViewConfiguration.get(context);
            n3 = viewConfiguration.getScaledTouchSlop();
            n2 = viewConfiguration.getScaledDoubleTapTouchSlop();
            n = viewConfiguration.getScaledDoubleTapSlop();
            this.mMinimumFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
            this.mMaximumFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        }
        this.mTouchSlopSquare = n3 * n3;
        this.mDoubleTapTouchSlopSquare = n2 * n2;
        this.mDoubleTapSlopSquare = n * n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isConsideredDoubleTap(MotionEvent motionEvent, MotionEvent motionEvent2, MotionEvent motionEvent3) {
        int n;
        int n2;
        long l;
        return this.mAlwaysInBiggerTapRegion && (l = motionEvent3.getEventTime() - motionEvent2.getEventTime()) <= (long)DOUBLE_TAP_TIMEOUT && l >= (long)DOUBLE_TAP_MIN_TIME && (n2 = (int)motionEvent.getX() - (int)motionEvent3.getX()) * n2 + (n = (int)motionEvent.getY() - (int)motionEvent3.getY()) * n < this.mDoubleTapSlopSquare;
    }

    public boolean isLongpressEnabled() {
        return this.mIsLongpressEnabled;
    }

    /*
     * Unable to fully structure code
     */
    public boolean onTouchEvent(MotionEvent var1_1) {
        block32: {
            block31: {
                block34: {
                    block33: {
                        if (this.mInputEventConsistencyVerifier != null) {
                            this.mInputEventConsistencyVerifier.onTouchEvent(var1_1, 0);
                        }
                        var2_2 = var1_1.getAction();
                        if (this.mVelocityTracker == null) {
                            this.mVelocityTracker = VelocityTracker.obtain();
                        }
                        this.mVelocityTracker.addMovement(var1_1);
                        if ((var2_2 & 255) != 6) break block33;
                        var3_3 = true;
lbl9:
                        // 2 sources

                        while (var3_3) {
                            var4_4 = var1_1.getActionIndex();
lbl11:
                            // 2 sources

                            while (true) {
                                var5_5 = 0.0f;
                                var6_6 = 0.0f;
                                var7_7 = var1_1.getPointerCount();
                                block10: for (var8_8 = 0; var8_8 < var7_7; ++var8_8) {
                                    if (var4_4 == var8_8) lbl-1000:
                                    // 2 sources

                                    {
                                        continue block10;
                                    }
                                    break block31;
                                }
                                break block32;
                                break;
                            }
                        }
                        break block34;
                    }
                    var3_3 = false;
                    ** GOTO lbl9
                }
                var4_4 = -1;
                ** while (true)
            }
            var5_5 += var1_1.getX(var8_8);
            var6_6 += var1_1.getY(var8_8);
            ** while (true)
        }
        if (!var3_3) ** GOTO lbl46
        var9_9 = var7_7 - 1;
        block12: while (true) {
            var10_10 = var5_5 / (float)var9_9;
            var11_11 = var6_6 / (float)var9_9;
            var12_12 = var2_2 & 255;
            var13_13 = false;
            switch (var12_12) lbl-1000:
            // 11 sources

            {
                default: lbl-1000:
                // 2 sources

                {
                    while (true) {
                        if (!var13_13 && this.mInputEventConsistencyVerifier != null) {
                            this.mInputEventConsistencyVerifier.onUnhandledEvent(var1_1, 0);
                        }
                        return var13_13;
                    }
                }
lbl46:
                // 1 sources

                var9_9 = var7_7;
                continue block12;
                case 5: {
                    this.mLastFocusX = var10_10;
                    this.mDownFocusX = var10_10;
                    this.mLastFocusY = var11_11;
                    this.mDownFocusY = var11_11;
                    this.cancelTaps();
                    var13_13 = false;
                    ** GOTO lbl-1000
                }
                case 6: {
                    this.mLastFocusX = var10_10;
                    this.mDownFocusX = var10_10;
                    this.mLastFocusY = var11_11;
                    this.mDownFocusY = var11_11;
                    this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaximumFlingVelocity);
                    var35_14 = var1_1.getActionIndex();
                    var36_15 = var1_1.getPointerId(var35_14);
                    var37_16 = this.mVelocityTracker.getXVelocity(var36_15);
                    var38_17 = this.mVelocityTracker.getYVelocity(var36_15);
                    var39_18 = 0;
                    block15: while (true) {
                        var40_19 = ++var39_18;
                        var13_13 = false;
                        if (var40_19 >= var7_7) ** GOTO lbl-1000
                        if (var39_18 != var35_14) break;
                        continue block15;
                        break;
                    }
                    if (!(var37_16 * this.mVelocityTracker.getXVelocity(var41_20 = var1_1.getPointerId(var39_18)) + var38_17 * this.mVelocityTracker.getYVelocity(var41_20) < 0.0f)) ** continue;
                    this.mVelocityTracker.clear();
                    var13_13 = false;
                    ** GOTO lbl-1000
                }
                case 0: {
                    var29_21 = this.mDoubleTapListener;
                    var30_22 = false;
                    if (var29_21 == null) ** GOTO lbl88
                    var33_23 = this.mHandler.hasMessages(3);
                    if (var33_23) {
                        this.mHandler.removeMessages(3);
                    }
                    if (this.mCurrentDownEvent == null || this.mPreviousUpEvent == null || !var33_23 || !this.isConsideredDoubleTap(this.mCurrentDownEvent, this.mPreviousUpEvent, var1_1)) ** GOTO lbl109
                    this.mIsDoubleTapping = true;
                    var30_22 = false | this.mDoubleTapListener.onDoubleTap(this.mCurrentDownEvent) | this.mDoubleTapListener.onDoubleTapEvent(var1_1);
lbl88:
                    // 3 sources

                    while (true) {
                        this.mLastFocusX = var10_10;
                        this.mDownFocusX = var10_10;
                        this.mLastFocusY = var11_11;
                        this.mDownFocusY = var11_11;
                        if (this.mCurrentDownEvent != null) {
                            this.mCurrentDownEvent.recycle();
                        }
                        this.mCurrentDownEvent = MotionEvent.obtain(var1_1);
                        this.mAlwaysInTapRegion = true;
                        this.mAlwaysInBiggerTapRegion = true;
                        this.mStillDown = true;
                        this.mInLongPress = false;
                        this.mDeferConfirmSingleTap = false;
                        if (this.mIsLongpressEnabled) {
                            this.mHandler.removeMessages(2);
                            this.mHandler.sendEmptyMessageAtTime(2, this.mCurrentDownEvent.getDownTime() + (long)GestureDetector.TAP_TIMEOUT + (long)GestureDetector.LONGPRESS_TIMEOUT);
                        }
                        this.mHandler.sendEmptyMessageAtTime(1, this.mCurrentDownEvent.getDownTime() + (long)GestureDetector.TAP_TIMEOUT);
                        var13_13 = var30_22 | this.mListener.onDown(var1_1);
                        ** GOTO lbl-1000
                        break;
                    }
lbl109:
                    // 1 sources

                    this.mHandler.sendEmptyMessageDelayed(3, GestureDetector.DOUBLE_TAP_TIMEOUT);
                    var30_22 = false;
                    ** continue;
                }
                case 2: {
                    var21_24 = this.mInLongPress;
                    var13_13 = false;
                    if (var21_24) ** GOTO lbl-1000
                    var22_25 = this.mLastFocusX - var10_10;
                    var23_26 = this.mLastFocusY - var11_11;
                    if (!this.mIsDoubleTapping) ** GOTO lbl122
                    var13_13 = false | this.mDoubleTapListener.onDoubleTapEvent(var1_1);
                    ** GOTO lbl-1000
lbl122:
                    // 1 sources

                    if (!this.mAlwaysInTapRegion) ** GOTO lbl139
                    var25_27 = (int)(var10_10 - this.mDownFocusX);
                    var26_28 = (int)(var11_11 - this.mDownFocusY);
                    var27_29 = var25_27 * var25_27 + var26_28 * var26_28;
                    var28_30 = this.mTouchSlopSquare;
                    var13_13 = false;
                    if (var27_29 > var28_30) {
                        var13_13 = this.mListener.onScroll(this.mCurrentDownEvent, var1_1, var22_25, var23_26);
                        this.mLastFocusX = var10_10;
                        this.mLastFocusY = var11_11;
                        this.mAlwaysInTapRegion = false;
                        this.mHandler.removeMessages(3);
                        this.mHandler.removeMessages(1);
                        this.mHandler.removeMessages(2);
                    }
                    if (var27_29 > this.mDoubleTapTouchSlopSquare) {
                        this.mAlwaysInBiggerTapRegion = false;
                    }
                    ** GOTO lbl-1000
lbl139:
                    // 1 sources

                    if (Math.abs(var22_25) >= 1.0f) ** GOTO lbl144
                    cfr_temp_0 = Math.abs(var23_26) - 1.0f;
                    var24_31 = cfr_temp_0 == 0.0f ? 0 : (cfr_temp_0 > 0.0f ? 1 : -1);
                    var13_13 = false;
                    if (var24_31 < 0) ** GOTO lbl-1000
lbl144:
                    // 2 sources

                    var13_13 = this.mListener.onScroll(this.mCurrentDownEvent, var1_1, var22_25, var23_26);
                    this.mLastFocusX = var10_10;
                    this.mLastFocusY = var11_11;
                    ** GOTO lbl-1000
                }
                case 1: {
                    this.mStillDown = false;
                    var14_32 = MotionEvent.obtain(var1_1);
                    if (!this.mIsDoubleTapping) ** GOTO lbl165
                    var13_13 = false | this.mDoubleTapListener.onDoubleTapEvent(var1_1);
lbl153:
                    // 5 sources

                    while (true) {
                        if (this.mPreviousUpEvent != null) {
                            this.mPreviousUpEvent.recycle();
                        }
                        this.mPreviousUpEvent = var14_32;
                        if (this.mVelocityTracker != null) {
                            this.mVelocityTracker.recycle();
                            this.mVelocityTracker = null;
                        }
                        this.mIsDoubleTapping = false;
                        this.mDeferConfirmSingleTap = false;
                        this.mHandler.removeMessages(1);
                        this.mHandler.removeMessages(2);
                        ** GOTO lbl-1000
                        break;
                    }
lbl165:
                    // 1 sources

                    if (!this.mInLongPress) ** GOTO lbl170
                    this.mHandler.removeMessages(3);
                    this.mInLongPress = false;
                    var13_13 = false;
                    ** GOTO lbl153
lbl170:
                    // 1 sources

                    if (!this.mAlwaysInTapRegion) ** GOTO lbl176
                    var13_13 = this.mListener.onSingleTapUp(var1_1);
                    if (this.mDeferConfirmSingleTap && this.mDoubleTapListener != null) {
                        this.mDoubleTapListener.onSingleTapConfirmed(var1_1);
                    }
                    ** GOTO lbl153
lbl176:
                    // 1 sources

                    var15_33 = this.mVelocityTracker;
                    var16_34 = var1_1.getPointerId(0);
                    var15_33.computeCurrentVelocity(1000, this.mMaximumFlingVelocity);
                    var17_35 = var15_33.getYVelocity(var16_34);
                    var18_36 = var15_33.getXVelocity(var16_34);
                    if (Math.abs(var17_35) > (float)this.mMinimumFlingVelocity) ** GOTO lbl186
                    cfr_temp_1 = Math.abs(var18_36) - (float)this.mMinimumFlingVelocity;
                    var19_37 = cfr_temp_1 == 0.0f ? 0 : (cfr_temp_1 > 0.0f ? 1 : -1);
                    var13_13 = false;
                    if (var19_37 <= 0) ** GOTO lbl153
lbl186:
                    // 2 sources

                    var13_13 = this.mListener.onFling(this.mCurrentDownEvent, var1_1, var18_36, var17_35);
                    ** continue;
                }
                case 3: 
            }
            break;
        }
        this.cancel();
        var13_13 = false;
        ** while (true)
    }

    public void setIsLongpressEnabled(boolean bl) {
        this.mIsLongpressEnabled = bl;
    }

    public void setOnDoubleTapListener(OnDoubleTapListener onDoubleTapListener) {
        this.mDoubleTapListener = onDoubleTapListener;
    }

    private class GestureHandler
    extends Handler {
        GestureHandler() {
        }

        GestureHandler(Handler handler) {
            super(handler.getLooper());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    throw new RuntimeException("Unknown message " + message);
                }
                case 1: {
                    GestureDetector.this.mListener.onShowPress(GestureDetector.this.mCurrentDownEvent);
                    return;
                }
                case 2: {
                    GestureDetector.this.dispatchLongPress();
                    return;
                }
                case 3: {
                    if (GestureDetector.this.mDoubleTapListener == null) return;
                    if (!GestureDetector.this.mStillDown) {
                        GestureDetector.this.mDoubleTapListener.onSingleTapConfirmed(GestureDetector.this.mCurrentDownEvent);
                        return;
                    } else {
                        break;
                    }
                }
            }
            GestureDetector.access$502(GestureDetector.this, true);
        }
    }

    public static interface OnDoubleTapListener {
        public boolean onDoubleTap(MotionEvent var1);

        public boolean onDoubleTapEvent(MotionEvent var1);

        public boolean onSingleTapConfirmed(MotionEvent var1);
    }

    public static interface OnGestureListener {
        public boolean onDown(MotionEvent var1);

        public boolean onFling(MotionEvent var1, MotionEvent var2, float var3, float var4);

        public void onLongPress(MotionEvent var1);

        public boolean onScroll(MotionEvent var1, MotionEvent var2, float var3, float var4);

        public void onShowPress(MotionEvent var1);

        public boolean onSingleTapUp(MotionEvent var1);
    }

    public static class SimpleOnGestureListener
    implements OnGestureListener,
    OnDoubleTapListener {
        @Override
        public boolean onDoubleTap(MotionEvent motionEvent) {
            return false;
        }

        @Override
        public boolean onDoubleTapEvent(MotionEvent motionEvent) {
            return false;
        }

        @Override
        public boolean onDown(MotionEvent motionEvent) {
            return false;
        }

        @Override
        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
            return false;
        }

        @Override
        public void onLongPress(MotionEvent motionEvent) {
        }

        @Override
        public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
            return false;
        }

        @Override
        public void onShowPress(MotionEvent motionEvent) {
        }

        @Override
        public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
            return false;
        }

        @Override
        public boolean onSingleTapUp(MotionEvent motionEvent) {
            return false;
        }
    }
}

