/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.res.CompatibilityInfo;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.DisplayAdjustments;
import java.util.Arrays;
import libcore.util.EmptyArray;
import libcore.util.Objects;

public final class DisplayInfo
implements Parcelable {
    public static final Parcelable.Creator<DisplayInfo> CREATOR = new Parcelable.Creator<DisplayInfo>(){

        @Override
        public DisplayInfo createFromParcel(Parcel parcel) {
            return new DisplayInfo(parcel);
        }

        public DisplayInfo[] newArray(int n) {
            return new DisplayInfo[n];
        }
    };
    public String address;
    public int appHeight;
    public long appVsyncOffsetNanos;
    public int appWidth;
    public int flags;
    public int largestNominalAppHeight;
    public int largestNominalAppWidth;
    public int layerStack;
    public int logicalDensityDpi;
    public int logicalHeight;
    public int logicalWidth;
    public String name;
    public int overscanBottom;
    public int overscanLeft;
    public int overscanRight;
    public int overscanTop;
    public String ownerPackageName;
    public int ownerUid;
    public float physicalXDpi;
    public float physicalYDpi;
    public long presentationDeadlineNanos;
    public float refreshRate;
    public int rotation;
    public int smallestNominalAppHeight;
    public int smallestNominalAppWidth;
    public int state;
    public float[] supportedRefreshRates = EmptyArray.FLOAT;
    public int type;

    public DisplayInfo() {
    }

    private DisplayInfo(Parcel parcel) {
        this.readFromParcel(parcel);
    }

    public DisplayInfo(DisplayInfo displayInfo) {
        this.copyFrom(displayInfo);
    }

    private static String flagsToString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 2) != 0) {
            stringBuilder.append(", FLAG_SECURE");
        }
        if ((n & 1) != 0) {
            stringBuilder.append(", FLAG_SUPPORTS_PROTECTED_BUFFERS");
        }
        if ((n & 4) != 0) {
            stringBuilder.append(", FLAG_PRIVATE");
        }
        if ((n & 8) != 0) {
            stringBuilder.append(", FLAG_PRESENTATION");
        }
        return stringBuilder.toString();
    }

    private void getMetricsWithSize(DisplayMetrics displayMetrics, CompatibilityInfo compatibilityInfo, IBinder iBinder, int n, int n2) {
        float f;
        float f2;
        float f3;
        float f4;
        int n3;
        displayMetrics.noncompatDensityDpi = n3 = this.logicalDensityDpi;
        displayMetrics.densityDpi = n3;
        displayMetrics.widthPixels = n;
        displayMetrics.noncompatWidthPixels = n;
        displayMetrics.heightPixels = n2;
        displayMetrics.noncompatHeightPixels = n2;
        displayMetrics.noncompatDensity = f4 = 0.00625f * (float)this.logicalDensityDpi;
        displayMetrics.noncompatScaledDensity = f3 = (displayMetrics.density = f4);
        displayMetrics.scaledDensity = f3;
        displayMetrics.noncompatXdpi = f2 = this.physicalXDpi;
        displayMetrics.xdpi = f2;
        displayMetrics.noncompatYdpi = f = this.physicalYDpi;
        displayMetrics.ydpi = f;
        if (!compatibilityInfo.equals(CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO)) {
            compatibilityInfo.applyToDisplayMetrics(displayMetrics);
        }
    }

    public void copyFrom(DisplayInfo displayInfo) {
        this.layerStack = displayInfo.layerStack;
        this.flags = displayInfo.flags;
        this.type = displayInfo.type;
        this.address = displayInfo.address;
        this.name = displayInfo.name;
        this.appWidth = displayInfo.appWidth;
        this.appHeight = displayInfo.appHeight;
        this.smallestNominalAppWidth = displayInfo.smallestNominalAppWidth;
        this.smallestNominalAppHeight = displayInfo.smallestNominalAppHeight;
        this.largestNominalAppWidth = displayInfo.largestNominalAppWidth;
        this.largestNominalAppHeight = displayInfo.largestNominalAppHeight;
        this.logicalWidth = displayInfo.logicalWidth;
        this.logicalHeight = displayInfo.logicalHeight;
        this.overscanLeft = displayInfo.overscanLeft;
        this.overscanTop = displayInfo.overscanTop;
        this.overscanRight = displayInfo.overscanRight;
        this.overscanBottom = displayInfo.overscanBottom;
        this.rotation = displayInfo.rotation;
        this.refreshRate = displayInfo.refreshRate;
        this.supportedRefreshRates = Arrays.copyOf(displayInfo.supportedRefreshRates, displayInfo.supportedRefreshRates.length);
        this.logicalDensityDpi = displayInfo.logicalDensityDpi;
        this.physicalXDpi = displayInfo.physicalXDpi;
        this.physicalYDpi = displayInfo.physicalYDpi;
        this.appVsyncOffsetNanos = displayInfo.appVsyncOffsetNanos;
        this.presentationDeadlineNanos = displayInfo.presentationDeadlineNanos;
        this.state = displayInfo.state;
        this.ownerUid = displayInfo.ownerUid;
        this.ownerPackageName = displayInfo.ownerPackageName;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(DisplayInfo displayInfo) {
        return displayInfo != null && this.layerStack == displayInfo.layerStack && this.flags == displayInfo.flags && this.type == displayInfo.type && Objects.equal((Object)this.address, (Object)displayInfo.address) && Objects.equal((Object)this.name, (Object)displayInfo.name) && this.appWidth == displayInfo.appWidth && this.appHeight == displayInfo.appHeight && this.smallestNominalAppWidth == displayInfo.smallestNominalAppWidth && this.smallestNominalAppHeight == displayInfo.smallestNominalAppHeight && this.largestNominalAppWidth == displayInfo.largestNominalAppWidth && this.largestNominalAppHeight == displayInfo.largestNominalAppHeight && this.logicalWidth == displayInfo.logicalWidth && this.logicalHeight == displayInfo.logicalHeight && this.overscanLeft == displayInfo.overscanLeft && this.overscanTop == displayInfo.overscanTop && this.overscanRight == displayInfo.overscanRight && this.overscanBottom == displayInfo.overscanBottom && this.rotation == displayInfo.rotation && this.refreshRate == displayInfo.refreshRate && this.logicalDensityDpi == displayInfo.logicalDensityDpi && this.physicalXDpi == displayInfo.physicalXDpi && this.physicalYDpi == displayInfo.physicalYDpi && this.appVsyncOffsetNanos == displayInfo.appVsyncOffsetNanos && this.presentationDeadlineNanos == displayInfo.presentationDeadlineNanos && this.state == displayInfo.state && this.ownerUid == displayInfo.ownerUid && Objects.equal((Object)this.ownerPackageName, (Object)displayInfo.ownerPackageName);
    }

    public boolean equals(Object object) {
        return object instanceof DisplayInfo && this.equals((DisplayInfo)object);
    }

    public void getAppMetrics(DisplayMetrics displayMetrics) {
        this.getAppMetrics(displayMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, null);
    }

    public void getAppMetrics(DisplayMetrics displayMetrics, CompatibilityInfo compatibilityInfo, IBinder iBinder) {
        this.getMetricsWithSize(displayMetrics, compatibilityInfo, iBinder, this.appWidth, this.appHeight);
    }

    public void getAppMetrics(DisplayMetrics displayMetrics, DisplayAdjustments displayAdjustments) {
        this.getMetricsWithSize(displayMetrics, displayAdjustments.getCompatibilityInfo(), displayAdjustments.getActivityToken(), this.appWidth, this.appHeight);
    }

    public void getLogicalMetrics(DisplayMetrics displayMetrics, CompatibilityInfo compatibilityInfo, IBinder iBinder) {
        this.getMetricsWithSize(displayMetrics, compatibilityInfo, iBinder, this.logicalWidth, this.logicalHeight);
    }

    public int getNaturalHeight() {
        if (this.rotation == 0 || this.rotation == 2) {
            return this.logicalHeight;
        }
        return this.logicalWidth;
    }

    public int getNaturalWidth() {
        if (this.rotation == 0 || this.rotation == 2) {
            return this.logicalWidth;
        }
        return this.logicalHeight;
    }

    public boolean hasAccess(int n) {
        return Display.hasAccess(n, this.flags, this.ownerUid);
    }

    public int hashCode() {
        return 0;
    }

    public void readFromParcel(Parcel parcel) {
        this.layerStack = parcel.readInt();
        this.flags = parcel.readInt();
        this.type = parcel.readInt();
        this.address = parcel.readString();
        this.name = parcel.readString();
        this.appWidth = parcel.readInt();
        this.appHeight = parcel.readInt();
        this.smallestNominalAppWidth = parcel.readInt();
        this.smallestNominalAppHeight = parcel.readInt();
        this.largestNominalAppWidth = parcel.readInt();
        this.largestNominalAppHeight = parcel.readInt();
        this.logicalWidth = parcel.readInt();
        this.logicalHeight = parcel.readInt();
        this.overscanLeft = parcel.readInt();
        this.overscanTop = parcel.readInt();
        this.overscanRight = parcel.readInt();
        this.overscanBottom = parcel.readInt();
        this.rotation = parcel.readInt();
        this.refreshRate = parcel.readFloat();
        this.supportedRefreshRates = parcel.createFloatArray();
        this.logicalDensityDpi = parcel.readInt();
        this.physicalXDpi = parcel.readFloat();
        this.physicalYDpi = parcel.readFloat();
        this.appVsyncOffsetNanos = parcel.readLong();
        this.presentationDeadlineNanos = parcel.readLong();
        this.state = parcel.readInt();
        this.ownerUid = parcel.readInt();
        this.ownerPackageName = parcel.readString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DisplayInfo{\"");
        stringBuilder.append(this.name);
        stringBuilder.append("\", app ");
        stringBuilder.append(this.appWidth);
        stringBuilder.append(" x ");
        stringBuilder.append(this.appHeight);
        stringBuilder.append(", real ");
        stringBuilder.append(this.logicalWidth);
        stringBuilder.append(" x ");
        stringBuilder.append(this.logicalHeight);
        if (this.overscanLeft != 0 || this.overscanTop != 0 || this.overscanRight != 0 || this.overscanBottom != 0) {
            stringBuilder.append(", overscan (");
            stringBuilder.append(this.overscanLeft);
            stringBuilder.append(",");
            stringBuilder.append(this.overscanTop);
            stringBuilder.append(",");
            stringBuilder.append(this.overscanRight);
            stringBuilder.append(",");
            stringBuilder.append(this.overscanBottom);
            stringBuilder.append(")");
        }
        stringBuilder.append(", largest app ");
        stringBuilder.append(this.largestNominalAppWidth);
        stringBuilder.append(" x ");
        stringBuilder.append(this.largestNominalAppHeight);
        stringBuilder.append(", smallest app ");
        stringBuilder.append(this.smallestNominalAppWidth);
        stringBuilder.append(" x ");
        stringBuilder.append(this.smallestNominalAppHeight);
        stringBuilder.append(", ");
        stringBuilder.append(this.refreshRate);
        stringBuilder.append(" fps, supportedRefreshRates ");
        stringBuilder.append(Arrays.toString(this.supportedRefreshRates));
        stringBuilder.append(", rotation ");
        stringBuilder.append(this.rotation);
        stringBuilder.append(", density ");
        stringBuilder.append(this.logicalDensityDpi);
        stringBuilder.append(" (");
        stringBuilder.append(this.physicalXDpi);
        stringBuilder.append(" x ");
        stringBuilder.append(this.physicalYDpi);
        stringBuilder.append(") dpi, layerStack ");
        stringBuilder.append(this.layerStack);
        stringBuilder.append(", appVsyncOff ");
        stringBuilder.append(this.appVsyncOffsetNanos);
        stringBuilder.append(", presDeadline ");
        stringBuilder.append(this.presentationDeadlineNanos);
        stringBuilder.append(", type ");
        stringBuilder.append(Display.typeToString(this.type));
        if (this.address != null) {
            stringBuilder.append(", address ").append(this.address);
        }
        stringBuilder.append(", state ");
        stringBuilder.append(Display.stateToString(this.state));
        if (this.ownerUid != 0 || this.ownerPackageName != null) {
            stringBuilder.append(", owner ").append(this.ownerPackageName);
            stringBuilder.append(" (uid ").append(this.ownerUid).append(")");
        }
        stringBuilder.append(DisplayInfo.flagsToString(this.flags));
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.layerStack);
        parcel.writeInt(this.flags);
        parcel.writeInt(this.type);
        parcel.writeString(this.address);
        parcel.writeString(this.name);
        parcel.writeInt(this.appWidth);
        parcel.writeInt(this.appHeight);
        parcel.writeInt(this.smallestNominalAppWidth);
        parcel.writeInt(this.smallestNominalAppHeight);
        parcel.writeInt(this.largestNominalAppWidth);
        parcel.writeInt(this.largestNominalAppHeight);
        parcel.writeInt(this.logicalWidth);
        parcel.writeInt(this.logicalHeight);
        parcel.writeInt(this.overscanLeft);
        parcel.writeInt(this.overscanTop);
        parcel.writeInt(this.overscanRight);
        parcel.writeInt(this.overscanBottom);
        parcel.writeInt(this.rotation);
        parcel.writeFloat(this.refreshRate);
        parcel.writeFloatArray(this.supportedRefreshRates);
        parcel.writeInt(this.logicalDensityDpi);
        parcel.writeFloat(this.physicalXDpi);
        parcel.writeFloat(this.physicalYDpi);
        parcel.writeLong(this.appVsyncOffsetNanos);
        parcel.writeLong(this.presentationDeadlineNanos);
        parcel.writeInt(this.state);
        parcel.writeInt(this.ownerUid);
        parcel.writeString(this.ownerPackageName);
    }
}

