/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.hardware.display.DisplayManagerGlobal;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.Log;
import android.util.TimeUtils;
import android.view.DisplayEventReceiver;
import java.io.PrintWriter;

public final class Choreographer {
    public static final int CALLBACK_ANIMATION = 1;
    public static final int CALLBACK_INPUT = 0;
    private static final int CALLBACK_LAST = 2;
    public static final int CALLBACK_TRAVERSAL = 2;
    private static final boolean DEBUG = false;
    private static final long DEFAULT_FRAME_DELAY = 10L;
    private static final Object FRAME_CALLBACK_TOKEN;
    private static final int MSG_DO_FRAME = 0;
    private static final int MSG_DO_SCHEDULE_CALLBACK = 2;
    private static final int MSG_DO_SCHEDULE_VSYNC = 1;
    private static final int SKIPPED_FRAME_WARNING_LIMIT = 0;
    private static final String TAG = "Choreographer";
    private static final boolean USE_FRAME_TIME;
    private static final boolean USE_VSYNC;
    private static volatile long sFrameDelay;
    private static final ThreadLocal<Choreographer> sThreadInstance;
    private CallbackRecord mCallbackPool;
    private final CallbackQueue[] mCallbackQueues;
    private boolean mCallbacksRunning;
    private final FrameDisplayEventReceiver mDisplayEventReceiver;
    private long mFrameIntervalNanos;
    private boolean mFrameScheduled;
    private final FrameHandler mHandler;
    private long mLastFrameTimeNanos;
    private final Object mLock = new Object();
    private final Looper mLooper;

    static {
        sFrameDelay = 10L;
        sThreadInstance = new ThreadLocal<Choreographer>(){

            @Override
            protected Choreographer initialValue() {
                Looper looper = Looper.myLooper();
                if (looper == null) {
                    throw new IllegalStateException("The current thread must have a looper!");
                }
                return new Choreographer(looper);
            }
        };
        USE_VSYNC = SystemProperties.getBoolean("debug.choreographer.vsync", true);
        USE_FRAME_TIME = SystemProperties.getBoolean("debug.choreographer.frametime", true);
        SKIPPED_FRAME_WARNING_LIMIT = SystemProperties.getInt("debug.choreographer.skipwarning", 30);
        FRAME_CALLBACK_TOKEN = new Object(){

            public String toString() {
                return "FRAME_CALLBACK_TOKEN";
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private Choreographer(Looper looper) {
        this.mLooper = looper;
        this.mHandler = new FrameHandler(looper);
        FrameDisplayEventReceiver frameDisplayEventReceiver = USE_VSYNC ? new FrameDisplayEventReceiver(looper) : null;
        this.mDisplayEventReceiver = frameDisplayEventReceiver;
        this.mLastFrameTimeNanos = Long.MIN_VALUE;
        this.mFrameIntervalNanos = (long)(1.0E9f / Choreographer.getRefreshRate());
        this.mCallbackQueues = new CallbackQueue[3];
        int n = 0;
        while (n <= 2) {
            this.mCallbackQueues[n] = new CallbackQueue();
            ++n;
        }
        return;
    }

    static /* synthetic */ CallbackRecord access$500(Choreographer choreographer, long l, Object object, Object object2) {
        return choreographer.obtainCallbackLocked(l, object, object2);
    }

    public static long getFrameDelay() {
        return sFrameDelay;
    }

    public static Choreographer getInstance() {
        return sThreadInstance.get();
    }

    private static float getRefreshRate() {
        return DisplayManagerGlobal.getInstance().getDisplayInfo((int)0).refreshRate;
    }

    private boolean isRunningOnLooperThreadLocked() {
        return Looper.myLooper() == this.mLooper;
    }

    /*
     * Enabled aggressive block sorting
     */
    private CallbackRecord obtainCallbackLocked(long l, Object object, Object object2) {
        CallbackRecord callbackRecord = this.mCallbackPool;
        if (callbackRecord == null) {
            callbackRecord = new CallbackRecord();
        } else {
            this.mCallbackPool = callbackRecord.next;
            callbackRecord.next = null;
        }
        callbackRecord.dueTime = l;
        callbackRecord.action = object;
        callbackRecord.token = object2;
        return callbackRecord;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void postCallbackDelayedInternal(int n, Object object, Object object2, long l) {
        Object object3 = this.mLock;
        synchronized (object3) {
            long l2 = SystemClock.uptimeMillis();
            long l3 = l2 + l;
            this.mCallbackQueues[n].addCallbackLocked(l3, object, object2);
            if (l3 <= l2) {
                this.scheduleFrameLocked(l2);
            } else {
                Message message = this.mHandler.obtainMessage(2, object);
                message.arg1 = n;
                message.setAsynchronous(true);
                this.mHandler.sendMessageAtTime(message, l3);
            }
            return;
        }
    }

    private void recycleCallbackLocked(CallbackRecord callbackRecord) {
        callbackRecord.action = null;
        callbackRecord.token = null;
        callbackRecord.next = this.mCallbackPool;
        this.mCallbackPool = callbackRecord;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeCallbacksInternal(int n, Object object, Object object2) {
        Object object3 = this.mLock;
        synchronized (object3) {
            this.mCallbackQueues[n].removeCallbacksLocked(object, object2);
            if (object != null && object2 == null) {
                this.mHandler.removeMessages(2, object);
            }
            return;
        }
    }

    private void scheduleFrameLocked(long l) {
        block3: {
            block4: {
                block2: {
                    if (this.mFrameScheduled) break block2;
                    this.mFrameScheduled = true;
                    if (!USE_VSYNC) break block3;
                    if (!this.isRunningOnLooperThreadLocked()) break block4;
                    this.scheduleVsyncLocked();
                }
                return;
            }
            Message message = this.mHandler.obtainMessage(1);
            message.setAsynchronous(true);
            this.mHandler.sendMessageAtFrontOfQueue(message);
            return;
        }
        long l2 = Math.max(this.mLastFrameTimeNanos / 1000000L + sFrameDelay, l);
        Message message = this.mHandler.obtainMessage(0);
        message.setAsynchronous(true);
        this.mHandler.sendMessageAtTime(message, l2);
    }

    private void scheduleVsyncLocked() {
        this.mDisplayEventReceiver.scheduleVsync();
    }

    public static void setFrameDelay(long l) {
        sFrameDelay = l;
    }

    public static long subtractFrameDelay(long l) {
        long l2 = sFrameDelay;
        if (l <= l2) {
            return 0L;
        }
        return l - l2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doCallbacks(int n, long l) {
        CallbackRecord callbackRecord;
        Object object = this.mLock;
        synchronized (object) {
            long l2 = SystemClock.uptimeMillis();
            callbackRecord = this.mCallbackQueues[n].extractDueCallbacksLocked(l2);
            if (callbackRecord == null) {
                return;
            }
            this.mCallbacksRunning = true;
        }
        CallbackRecord callbackRecord2 = callbackRecord;
        while (callbackRecord2 != null) {
            try {
                callbackRecord2.run(l);
                callbackRecord2 = callbackRecord2.next;
            }
            catch (Throwable throwable) {
                Object object2 = this.mLock;
                synchronized (object2) {
                    CallbackRecord callbackRecord3;
                    this.mCallbacksRunning = false;
                    do {
                        callbackRecord3 = callbackRecord.next;
                        this.recycleCallbackLocked(callbackRecord);
                    } while ((callbackRecord = callbackRecord3) != null);
                    throw throwable;
                }
            }
        }
        Object object3 = this.mLock;
        synchronized (object3) {
            CallbackRecord callbackRecord4;
            this.mCallbacksRunning = false;
            do {
                callbackRecord4 = callbackRecord.next;
                this.recycleCallbackLocked(callbackRecord);
            } while ((callbackRecord = callbackRecord4) != null);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doFrame(long l, int n) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mFrameScheduled) {
                return;
            }
            long l2 = System.nanoTime();
            long l3 = l2 - l;
            if (l3 >= this.mFrameIntervalNanos) {
                long l4 = l3 / this.mFrameIntervalNanos;
                if (l4 >= (long)SKIPPED_FRAME_WARNING_LIMIT) {
                    Log.i(TAG, "Skipped " + l4 + " frames!  " + "The application may be doing too much work on its main thread.");
                }
                l = l2 - l3 % this.mFrameIntervalNanos;
            }
            if (l < this.mLastFrameTimeNanos) {
                this.scheduleVsyncLocked();
                return;
            }
            this.mFrameScheduled = false;
            this.mLastFrameTimeNanos = l;
        }
        this.doCallbacks(0, l);
        this.doCallbacks(1, l);
        this.doCallbacks(2, l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doScheduleCallback(int n) {
        Object object = this.mLock;
        synchronized (object) {
            long l;
            if (!this.mFrameScheduled && this.mCallbackQueues[n].hasDueCallbacksLocked(l = SystemClock.uptimeMillis())) {
                this.scheduleFrameLocked(l);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doScheduleVsync() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mFrameScheduled) {
                this.scheduleVsyncLocked();
            }
            return;
        }
    }

    void dump(String string2, PrintWriter printWriter) {
        String string3 = string2 + "  ";
        printWriter.print(string2);
        printWriter.println("Choreographer:");
        printWriter.print(string3);
        printWriter.print("mFrameScheduled=");
        printWriter.println(this.mFrameScheduled);
        printWriter.print(string3);
        printWriter.print("mLastFrameTime=");
        printWriter.println(TimeUtils.formatUptime(this.mLastFrameTimeNanos / 1000000L));
    }

    public long getFrameIntervalNanos() {
        return this.mFrameIntervalNanos;
    }

    public long getFrameTime() {
        return this.getFrameTimeNanos() / 1000000L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getFrameTimeNanos() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mCallbacksRunning) {
                throw new IllegalStateException("This method must only be called as part of a callback while a frame is in progress.");
            }
            long l = System.nanoTime();
            if (!USE_FRAME_TIME) return l;
            return this.mLastFrameTimeNanos;
        }
    }

    public void postCallback(int n, Runnable runnable, Object object) {
        this.postCallbackDelayed(n, runnable, object, 0L);
    }

    public void postCallbackDelayed(int n, Runnable runnable, Object object, long l) {
        if (runnable == null) {
            throw new IllegalArgumentException("action must not be null");
        }
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("callbackType is invalid");
        }
        this.postCallbackDelayedInternal(n, runnable, object, l);
    }

    public void postFrameCallback(FrameCallback frameCallback) {
        this.postFrameCallbackDelayed(frameCallback, 0L);
    }

    public void postFrameCallbackDelayed(FrameCallback frameCallback, long l) {
        if (frameCallback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.postCallbackDelayedInternal(1, frameCallback, FRAME_CALLBACK_TOKEN, l);
    }

    public void removeCallbacks(int n, Runnable runnable, Object object) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("callbackType is invalid");
        }
        this.removeCallbacksInternal(n, runnable, object);
    }

    public void removeFrameCallback(FrameCallback frameCallback) {
        if (frameCallback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        this.removeCallbacksInternal(1, frameCallback, FRAME_CALLBACK_TOKEN);
    }

    private final class CallbackQueue {
        private CallbackRecord mHead;

        private CallbackQueue() {
        }

        /*
         * Unable to fully structure code
         */
        public void addCallbackLocked(long var1_1, Object var3_2, Object var4_3) {
            block2: {
                var5_4 = Choreographer.access$500(Choreographer.this, var1_1, var3_2, var4_3);
                var6_5 = this.mHead;
                if (var6_5 == null) {
                    this.mHead = var5_4;
                    return;
                }
                if (var1_1 >= var6_5.dueTime) ** GOTO lbl11
                var5_4.next = var6_5;
                this.mHead = var5_4;
                return;
lbl-1000:
                // 1 sources

                {
                    var6_5 = var6_5.next;
lbl11:
                    // 2 sources

                    if (var6_5.next == null) break block2;
                    ** while (var1_1 >= var6_5.next.dueTime)
                }
lbl13:
                // 1 sources

                var5_4.next = var6_5.next;
            }
            var6_5.next = var5_4;
        }

        public CallbackRecord extractDueCallbacksLocked(long l) {
            CallbackRecord callbackRecord = this.mHead;
            if (callbackRecord == null || callbackRecord.dueTime > l) {
                return null;
            }
            CallbackRecord callbackRecord2 = callbackRecord;
            CallbackRecord callbackRecord3 = callbackRecord2.next;
            while (true) {
                block6: {
                    block5: {
                        if (callbackRecord3 == null) break block5;
                        if (callbackRecord3.dueTime <= l) break block6;
                        callbackRecord2.next = null;
                    }
                    this.mHead = callbackRecord3;
                    return callbackRecord;
                }
                callbackRecord2 = callbackRecord3;
                callbackRecord3 = callbackRecord3.next;
            }
        }

        public boolean hasDueCallbacksLocked(long l) {
            return this.mHead != null && this.mHead.dueTime <= l;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void removeCallbacksLocked(Object object, Object object2) {
            CallbackRecord callbackRecord = null;
            CallbackRecord callbackRecord2 = this.mHead;
            while (callbackRecord2 != null) {
                CallbackRecord callbackRecord3 = callbackRecord2.next;
                if (!(object != null && callbackRecord2.action != object || object2 != null && callbackRecord2.token != object2)) {
                    if (callbackRecord != null) {
                        callbackRecord.next = callbackRecord3;
                    } else {
                        this.mHead = callbackRecord3;
                    }
                    Choreographer.this.recycleCallbackLocked(callbackRecord2);
                } else {
                    callbackRecord = callbackRecord2;
                }
                callbackRecord2 = callbackRecord3;
            }
            return;
        }
    }

    private static final class CallbackRecord {
        public Object action;
        public long dueTime;
        public CallbackRecord next;
        public Object token;

        private CallbackRecord() {
        }

        public void run(long l) {
            if (this.token == FRAME_CALLBACK_TOKEN) {
                ((FrameCallback)this.action).doFrame(l);
                return;
            }
            ((Runnable)this.action).run();
        }
    }

    public static interface FrameCallback {
        public void doFrame(long var1);
    }

    private final class FrameDisplayEventReceiver
    extends DisplayEventReceiver
    implements Runnable {
        private int mFrame;
        private boolean mHavePendingVsync;
        private long mTimestampNanos;

        public FrameDisplayEventReceiver(Looper looper) {
            super(looper);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onVsync(long l, int n, int n2) {
            if (n != 0) {
                Log.d(Choreographer.TAG, "Received vsync from secondary display, but we don't support this case yet.  Choreographer needs a way to explicitly request vsync for a specific display to ensure it doesn't lose track of its scheduled vsync.");
                this.scheduleVsync();
                return;
            }
            long l2 = System.nanoTime();
            if (l > l2) {
                Log.w(Choreographer.TAG, "Frame time is " + 1.0E-6f * (float)(l - l2) + " ms in the future!  Check that graphics HAL is generating vsync " + "timestamps using the correct timebase.");
                l = l2;
            }
            if (this.mHavePendingVsync) {
                Log.w(Choreographer.TAG, "Already have a pending vsync event.  There should only be one at a time.");
            } else {
                this.mHavePendingVsync = true;
            }
            this.mTimestampNanos = l;
            this.mFrame = n2;
            Message message = Message.obtain((Handler)Choreographer.this.mHandler, this);
            message.setAsynchronous(true);
            Choreographer.this.mHandler.sendMessageAtTime(message, l / 1000000L);
        }

        @Override
        public void run() {
            this.mHavePendingVsync = false;
            Choreographer.this.doFrame(this.mTimestampNanos, this.mFrame);
        }
    }

    private final class FrameHandler
    extends Handler {
        public FrameHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 0: {
                    Choreographer.this.doFrame(System.nanoTime(), 0);
                    return;
                }
                case 1: {
                    Choreographer.this.doScheduleVsync();
                    return;
                }
                case 2: 
            }
            Choreographer.this.doScheduleCallback(message.arg1);
        }
    }
}

