/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.SystemClock;
import android.util.Log;
import java.util.ArrayList;

public class TimingLogger {
    private boolean mDisabled;
    private String mLabel;
    ArrayList<String> mSplitLabels;
    ArrayList<Long> mSplits;
    private String mTag;

    public TimingLogger(String string2, String string3) {
        this.reset(string2, string3);
    }

    public void addSplit(String string2) {
        if (this.mDisabled) {
            return;
        }
        long l = SystemClock.elapsedRealtime();
        this.mSplits.add(l);
        this.mSplitLabels.add(string2);
    }

    public void dumpToLog() {
        long l;
        if (this.mDisabled) {
            return;
        }
        Log.d(this.mTag, this.mLabel + ": begin");
        long l2 = l = this.mSplits.get(0).longValue();
        for (int i = 1; i < this.mSplits.size(); ++i) {
            l2 = this.mSplits.get(i);
            String string2 = this.mSplitLabels.get(i);
            long l3 = this.mSplits.get(i - 1);
            Log.d(this.mTag, this.mLabel + ":      " + (l2 - l3) + " ms, " + string2);
        }
        Log.d(this.mTag, this.mLabel + ": end, " + (l2 - l) + " ms");
    }

    /*
     * Enabled aggressive block sorting
     */
    public void reset() {
        boolean bl = !Log.isLoggable(this.mTag, 2);
        this.mDisabled = bl;
        if (this.mDisabled) {
            return;
        }
        if (this.mSplits == null) {
            this.mSplits = new ArrayList();
            this.mSplitLabels = new ArrayList();
        } else {
            this.mSplits.clear();
            this.mSplitLabels.clear();
        }
        this.addSplit(null);
    }

    public void reset(String string2, String string3) {
        this.mTag = string2;
        this.mLabel = string3;
        this.reset();
    }
}

