/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.NoSuchPropertyException;
import android.util.Property;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ReflectiveProperty<T, V>
extends Property<T, V> {
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_IS = "is";
    private static final String PREFIX_SET = "set";
    private Field mField;
    private Method mGetter;
    private Method mSetter;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReflectiveProperty(Class<T> clazz, Class<V> clazz2, String string2) {
        super(clazz2, string2);
        Class<?> clazz3;
        char c = Character.toUpperCase(string2.charAt(0));
        String string3 = string2.substring(1);
        String string4 = c + string3;
        String string5 = PREFIX_GET + string4;
        try {
            this.mGetter = clazz.getMethod(string5, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string6 = PREFIX_IS + string4;
            try {
                this.mGetter = clazz.getMethod(string6, null);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                try {
                    this.mField = clazz.getField(string2);
                    Class<?> clazz4 = this.mField.getType();
                    if (this.typesMatch(clazz2, clazz4)) return;
                    throw new NoSuchPropertyException("Underlying type (" + clazz4 + ") " + "does not match Property type (" + clazz2 + ")");
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new NoSuchPropertyException("No accessor method or field found for property with name " + string2);
                }
            }
        }
        if (!this.typesMatch(clazz2, clazz3 = this.mGetter.getReturnType())) {
            throw new NoSuchPropertyException("Underlying type (" + clazz3 + ") " + "does not match Property type (" + clazz2 + ")");
        }
        String string7 = PREFIX_SET + string4;
        try {
            this.mSetter = clazz.getMethod(string7, clazz3);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
    }

    private boolean typesMatch(Class<V> clazz, Class clazz2) {
        block2: {
            boolean bl;
            block3: {
                block4: {
                    if (clazz2 == clazz) break block2;
                    boolean bl2 = clazz2.isPrimitive();
                    bl = false;
                    if (!bl2) break block3;
                    if (clazz2 == Float.TYPE && clazz == Float.class || clazz2 == Integer.TYPE && clazz == Integer.class || clazz2 == Boolean.TYPE && clazz == Boolean.class || clazz2 == Long.TYPE && clazz == Long.class || clazz2 == Double.TYPE && clazz == Double.class || clazz2 == Short.TYPE && clazz == Short.class || clazz2 == Byte.TYPE && clazz == Byte.class) break block4;
                    Class<Character> clazz3 = Character.TYPE;
                    bl = false;
                    if (clazz2 != clazz3) break block3;
                    bl = false;
                    if (clazz != Character.class) break block3;
                }
                bl = true;
            }
            return bl;
        }
        return true;
    }

    @Override
    public V get(T t) {
        if (this.mGetter != null) {
            Object object;
            try {
                object = this.mGetter.invoke(t, null);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
            return (V)object;
        }
        if (this.mField != null) {
            Object object;
            try {
                object = this.mField.get(t);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            return (V)object;
        }
        throw new AssertionError();
    }

    @Override
    public boolean isReadOnly() {
        return this.mSetter == null && this.mField == null;
    }

    @Override
    public void set(T t, V v) {
        if (this.mSetter != null) {
            try {
                this.mSetter.invoke(t, v);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getCause());
            }
        }
        if (this.mField != null) {
            try {
                this.mField.set(t, v);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError();
            }
        }
        throw new UnsupportedOperationException("Property " + this.getName() + " is read-only");
    }
}

