/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.Log;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.HashMap;

public class EventLog {
    private static final String COMMENT_PATTERN = "^\\s*(#.*)?$";
    private static final String TAG = "EventLog";
    private static final String TAGS_FILE = "/system/etc/event-log-tags";
    private static final String TAG_PATTERN = "^\\s*(\\d+)\\s+(\\w+)\\s*(\\(.*\\))?\\s*$";
    private static HashMap<String, Integer> sTagCodes = null;
    private static HashMap<Integer, String> sTagNames = null;

    public static int getTagCode(String string2) {
        EventLog.readTagsFile();
        Integer n = sTagCodes.get(string2);
        if (n != null) {
            return n;
        }
        return -1;
    }

    public static String getTagName(int n) {
        EventLog.readTagsFile();
        return sTagNames.get(n);
    }

    public static native void readEvents(int[] var0, Collection<Event> var1) throws IOException;

    /*
     * Exception decompiling
     */
    private static void readTagsFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [12, 11, 13 : 178->228)] java.io.IOException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static native int writeEvent(int var0, int var1);

    public static native int writeEvent(int var0, long var1);

    public static native int writeEvent(int var0, String var1);

    public static native int writeEvent(int var0, Object ... var1);

    public static final class Event {
        private static final int DATA_OFFSET = 4;
        private static final int HEADER_SIZE_OFFSET = 2;
        private static final byte INT_TYPE = 0;
        private static final int LENGTH_OFFSET = 0;
        private static final byte LIST_TYPE = 3;
        private static final byte LONG_TYPE = 1;
        private static final int NANOSECONDS_OFFSET = 16;
        private static final int PROCESS_OFFSET = 4;
        private static final int SECONDS_OFFSET = 12;
        private static final byte STRING_TYPE = 2;
        private static final int THREAD_OFFSET = 8;
        private static final int V1_PAYLOAD_START = 20;
        private final ByteBuffer mBuffer;

        Event(byte[] byArray) {
            this.mBuffer = ByteBuffer.wrap(byArray);
            this.mBuffer.order(ByteOrder.nativeOrder());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Object decodeObject() {
            byte by = this.mBuffer.get();
            switch (by) {
                default: {
                    throw new IllegalArgumentException("Unknown entry type: " + by);
                }
                case 0: {
                    return Integer.valueOf(this.mBuffer.getInt());
                }
                case 1: {
                    return this.mBuffer.getLong();
                }
                case 2: {
                    try {
                        int n = this.mBuffer.getInt();
                        int n2 = this.mBuffer.position();
                        this.mBuffer.position(n2 + n);
                        return new String(this.mBuffer.array(), n2, n, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        Log.wtf(EventLog.TAG, "UTF-8 is not supported", unsupportedEncodingException);
                        return null;
                    }
                }
                case 3: 
            }
            int n = this.mBuffer.get();
            if (n < 0) {
                n += 256;
            }
            Object[] objectArray = new Object[n];
            int n3 = 0;
            while (n3 < n) {
                objectArray[n3] = this.decodeObject();
                ++n3;
            }
            return objectArray;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object getData() {
            synchronized (this) {
                try {
                    int n = this.mBuffer.getShort(2);
                    if (n == 0) {
                        n = 20;
                    }
                    this.mBuffer.limit(n + this.mBuffer.getShort(0));
                    this.mBuffer.position(n + 4);
                    Object object = this.decodeObject();
                    return object;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Log.wtf(EventLog.TAG, "Illegal entry payload: tag=" + this.getTag(), illegalArgumentException);
                    return null;
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    Log.wtf(EventLog.TAG, "Truncated entry payload: tag=" + this.getTag(), bufferUnderflowException);
                    return null;
                }
            }
        }

        public int getProcessId() {
            return this.mBuffer.getInt(4);
        }

        public int getTag() {
            int n = this.mBuffer.getShort(2);
            if (n == 0) {
                n = 20;
            }
            return this.mBuffer.getInt(n);
        }

        public int getThreadId() {
            return this.mBuffer.getInt(8);
        }

        public long getTimeNanos() {
            return 1000000000L * (long)this.mBuffer.getInt(12) + (long)this.mBuffer.getInt(16);
        }
    }
}

