/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ContainerHelpers;
import android.util.Log;
import android.util.MapCollections;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import libcore.util.EmptyArray;

public final class ArrayMap<K, V>
implements Map<K, V> {
    private static final int BASE_SIZE = 4;
    private static final int CACHE_SIZE = 10;
    private static final boolean DEBUG = false;
    public static final ArrayMap EMPTY = new ArrayMap(true);
    static final int[] EMPTY_IMMUTABLE_INTS = new int[0];
    private static final String TAG = "ArrayMap";
    static Object[] mBaseCache;
    static int mBaseCacheSize;
    static Object[] mTwiceBaseCache;
    static int mTwiceBaseCacheSize;
    Object[] mArray;
    MapCollections<K, V> mCollections;
    int[] mHashes;
    int mSize;

    public ArrayMap() {
        this.mHashes = EmptyArray.INT;
        this.mArray = EmptyArray.OBJECT;
        this.mSize = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ArrayMap(int n) {
        if (n == 0) {
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
        } else {
            this.allocArrays(n);
        }
        this.mSize = 0;
    }

    public ArrayMap(ArrayMap arrayMap) {
        this();
        if (arrayMap != null) {
            this.putAll(arrayMap);
        }
    }

    private ArrayMap(boolean bl) {
        this.mHashes = EmptyArray.INT;
        this.mArray = EmptyArray.OBJECT;
        this.mSize = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void allocArrays(int n) {
        if (this.mHashes == EMPTY_IMMUTABLE_INTS) {
            throw new UnsupportedOperationException("ArrayMap is immutable");
        }
        if (n == 8) {
            synchronized (ArrayMap.class) {
                if (mTwiceBaseCache != null) {
                    Object[] objectArray = mTwiceBaseCache;
                    this.mArray = objectArray;
                    mTwiceBaseCache = (Object[])objectArray[0];
                    this.mHashes = (int[])objectArray[1];
                    objectArray[1] = null;
                    objectArray[0] = null;
                    mTwiceBaseCacheSize = -1 + mTwiceBaseCacheSize;
                    return;
                }
            }
        } else if (n == 4) {
            synchronized (ArrayMap.class) {
                if (mBaseCache != null) {
                    Object[] objectArray = mBaseCache;
                    this.mArray = objectArray;
                    mBaseCache = (Object[])objectArray[0];
                    this.mHashes = (int[])objectArray[1];
                    objectArray[1] = null;
                    objectArray[0] = null;
                    mBaseCacheSize = -1 + mBaseCacheSize;
                    return;
                }
            }
        }
        this.mHashes = new int[n];
        this.mArray = new Object[n << 1];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void freeArrays(int[] nArray, Object[] objectArray, int n) {
        if (nArray.length == 8) {
            synchronized (ArrayMap.class) {
                if (mTwiceBaseCacheSize < 10) {
                    objectArray[0] = mTwiceBaseCache;
                    objectArray[1] = nArray;
                    for (int i = -1 + (n << 1); i >= 2; --i) {
                        objectArray[i] = null;
                    }
                    mTwiceBaseCache = objectArray;
                    mTwiceBaseCacheSize = 1 + mTwiceBaseCacheSize;
                }
                return;
            }
        }
        if (nArray.length != 4) {
            return;
        }
        synchronized (ArrayMap.class) {
            if (mBaseCacheSize < 10) {
                objectArray[0] = mBaseCache;
                objectArray[1] = nArray;
                for (int i = -1 + (n << 1); i >= 2; --i) {
                    objectArray[i] = null;
                }
                mBaseCache = objectArray;
                mBaseCacheSize = 1 + mBaseCacheSize;
            }
            return;
        }
    }

    private MapCollections<K, V> getCollection() {
        if (this.mCollections == null) {
            this.mCollections = new MapCollections<K, V>(){

                @Override
                protected void colClear() {
                    ArrayMap.this.clear();
                }

                @Override
                protected Object colGetEntry(int n, int n2) {
                    return ArrayMap.this.mArray[n2 + (n << 1)];
                }

                @Override
                protected Map<K, V> colGetMap() {
                    return ArrayMap.this;
                }

                @Override
                protected int colGetSize() {
                    return ArrayMap.this.mSize;
                }

                @Override
                protected int colIndexOfKey(Object object) {
                    return ArrayMap.this.indexOfKey(object);
                }

                @Override
                protected int colIndexOfValue(Object object) {
                    return ArrayMap.this.indexOfValue(object);
                }

                @Override
                protected void colPut(K k, V v) {
                    ArrayMap.this.put(k, v);
                }

                @Override
                protected void colRemoveAt(int n) {
                    ArrayMap.this.removeAt(n);
                }

                @Override
                protected V colSetValue(int n, V v) {
                    return ArrayMap.this.setValueAt(n, v);
                }
            };
        }
        return this.mCollections;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void append(K k, V v) {
        int n = this.mSize;
        int n2 = k == null ? 0 : k.hashCode();
        if (n >= this.mHashes.length) {
            throw new IllegalStateException("Array is full");
        }
        if (n > 0 && this.mHashes[n - 1] > n2) {
            RuntimeException runtimeException = new RuntimeException("here");
            runtimeException.fillInStackTrace();
            Log.w(TAG, "New hash " + n2 + " is before end of array hash " + this.mHashes[n - 1] + " at index " + n + " key " + k, runtimeException);
            this.put(k, v);
            return;
        }
        this.mSize = n + 1;
        this.mHashes[n] = n2;
        int n3 = n << 1;
        this.mArray[n3] = k;
        this.mArray[n3 + 1] = v;
    }

    @Override
    public void clear() {
        if (this.mSize > 0) {
            ArrayMap.freeArrays(this.mHashes, this.mArray, this.mSize);
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
            this.mSize = 0;
        }
    }

    public boolean containsAll(Collection<?> collection) {
        return MapCollections.containsAllHelper(this, collection);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.indexOfKey(object) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.indexOfValue(object) >= 0;
    }

    public void ensureCapacity(int n) {
        if (this.mHashes.length < n) {
            int[] nArray = this.mHashes;
            Object[] objectArray = this.mArray;
            this.allocArrays(n);
            if (this.mSize > 0) {
                System.arraycopy((int[])nArray, (int)0, (int[])this.mHashes, (int)0, (int)this.mSize);
                System.arraycopy(objectArray, 0, this.mArray, 0, this.mSize << 1);
            }
            ArrayMap.freeArrays(nArray, objectArray, this.mSize);
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.getCollection().getEntrySet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Map)) return false;
        Map map = (Map)object;
        if (this.size() != map.size()) {
            return false;
        }
        int n = 0;
        try {
            while (n < this.mSize) {
                K k = this.keyAt(n);
                V v = this.valueAt(n);
                Object v2 = map.get(k);
                if (v == null) {
                    if (v2 != null) return false;
                    if (!map.containsKey(k)) {
                        return false;
                    }
                } else {
                    boolean bl = v.equals(v2);
                    if (!bl) {
                        return false;
                    }
                }
                ++n;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public void erase() {
        if (this.mSize > 0) {
            int n = this.mSize << 1;
            Object[] objectArray = this.mArray;
            for (int i = 0; i < n; ++i) {
                objectArray[i] = null;
            }
            this.mSize = 0;
        }
    }

    @Override
    public V get(Object object) {
        int n = this.indexOfKey(object);
        if (n >= 0) {
            return (V)this.mArray[1 + (n << 1)];
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int hashCode() {
        int[] nArray = this.mHashes;
        Object[] objectArray = this.mArray;
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = this.mSize;
        while (n2 < n4) {
            Object object = objectArray[n3];
            int n5 = nArray[n2];
            int n6 = object == null ? 0 : object.hashCode();
            n += n6 ^ n5;
            ++n2;
            n3 += 2;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int indexOf(Object object, int n) {
        int n2;
        int n3 = this.mSize;
        if (n3 == 0) {
            return -1;
        }
        int n4 = ContainerHelpers.binarySearch(this.mHashes, n3, n);
        if (n4 < 0) return n4;
        if (object.equals(this.mArray[n4 << 1])) return n4;
        for (n2 = n4 + 1; n2 < n3 && this.mHashes[n2] == n; ++n2) {
            if (!object.equals(this.mArray[n2 << 1])) continue;
            return n2;
        }
        int n5 = n4 - 1;
        while (n5 >= 0) {
            if (this.mHashes[n5] != n) return ~n2;
            if (object.equals(this.mArray[n5 << 1])) {
                return n5;
            }
            --n5;
        }
        return ~n2;
    }

    public int indexOfKey(Object object) {
        if (object == null) {
            return this.indexOfNull();
        }
        return this.indexOf(object, object.hashCode());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int indexOfNull() {
        int n;
        int n2 = this.mSize;
        if (n2 == 0) {
            return -1;
        }
        int n3 = ContainerHelpers.binarySearch(this.mHashes, n2, 0);
        if (n3 < 0) return n3;
        if (this.mArray[n3 << 1] == null) return n3;
        for (n = n3 + 1; n < n2 && this.mHashes[n] == 0; ++n) {
            if (this.mArray[n << 1] != null) continue;
            return n;
        }
        int n4 = n3 - 1;
        while (n4 >= 0) {
            if (this.mHashes[n4] != 0) return ~n;
            if (this.mArray[n4 << 1] == null) {
                return n4;
            }
            --n4;
        }
        return ~n;
    }

    int indexOfValue(Object object) {
        int n = 2 * this.mSize;
        Object[] objectArray = this.mArray;
        if (object == null) {
            for (int i = 1; i < n; i += 2) {
                if (objectArray[i] != null) continue;
                return i >> 1;
            }
        } else {
            for (int i = 1; i < n; i += 2) {
                if (!object.equals(objectArray[i])) continue;
                return i >> 1;
            }
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.mSize <= 0;
    }

    public K keyAt(int n) {
        return (K)this.mArray[n << 1];
    }

    @Override
    public Set<K> keySet() {
        return this.getCollection().getKeySet();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public V put(K k, V v) {
        int n;
        int n2;
        int n3 = 8;
        if (k == null) {
            n2 = 0;
            n = this.indexOfNull();
        } else {
            n2 = k.hashCode();
            n = this.indexOf(k, n2);
        }
        if (n >= 0) {
            int n4 = 1 + (n << 1);
            Object object = this.mArray[n4];
            this.mArray[n4] = v;
            return (V)object;
        }
        int n5 = ~n;
        if (this.mSize >= this.mHashes.length) {
            if (this.mSize >= n3) {
                n3 = this.mSize + (this.mSize >> 1);
            } else if (this.mSize < 4) {
                n3 = 4;
            }
            int[] nArray = this.mHashes;
            Object[] objectArray = this.mArray;
            this.allocArrays(n3);
            if (this.mHashes.length > 0) {
                System.arraycopy((int[])nArray, (int)0, (int[])this.mHashes, (int)0, (int)nArray.length);
                System.arraycopy(objectArray, 0, this.mArray, 0, objectArray.length);
            }
            ArrayMap.freeArrays(nArray, objectArray, this.mSize);
        }
        if (n5 < this.mSize) {
            System.arraycopy((int[])this.mHashes, (int)n5, (int[])this.mHashes, (int)(n5 + 1), (int)(this.mSize - n5));
            System.arraycopy(this.mArray, n5 << 1, this.mArray, n5 + 1 << 1, this.mSize - n5 << 1);
        }
        this.mHashes[n5] = n2;
        this.mArray[n5 << 1] = k;
        this.mArray[1 + (n5 << 1)] = v;
        this.mSize = 1 + this.mSize;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void putAll(ArrayMap<? extends K, ? extends V> arrayMap) {
        int n = arrayMap.mSize;
        this.ensureCapacity(n + this.mSize);
        if (this.mSize == 0) {
            if (n <= 0) return;
            System.arraycopy((int[])arrayMap.mHashes, (int)0, (int[])this.mHashes, (int)0, (int)n);
            System.arraycopy(arrayMap.mArray, 0, this.mArray, 0, n << 1);
            this.mSize = n;
            return;
        } else {
            for (int i = 0; i < n; ++i) {
                this.put(arrayMap.keyAt(i), arrayMap.valueAt(i));
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.ensureCapacity(this.mSize + map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        int n = this.indexOfKey(object);
        if (n >= 0) {
            return this.removeAt(n);
        }
        return null;
    }

    public boolean removeAll(Collection<?> collection) {
        return MapCollections.removeAllHelper(this, collection);
    }

    /*
     * Enabled aggressive block sorting
     */
    public V removeAt(int n) {
        int n2 = 8;
        Object object = this.mArray[1 + (n << 1)];
        if (this.mSize <= 1) {
            ArrayMap.freeArrays(this.mHashes, this.mArray, this.mSize);
            this.mHashes = EmptyArray.INT;
            this.mArray = EmptyArray.OBJECT;
            this.mSize = 0;
            return (V)object;
        }
        if (this.mHashes.length > n2 && this.mSize < this.mHashes.length / 3) {
            if (this.mSize > n2) {
                n2 = this.mSize + (this.mSize >> 1);
            }
            int[] nArray = this.mHashes;
            Object[] objectArray = this.mArray;
            this.allocArrays(n2);
            this.mSize = -1 + this.mSize;
            if (n > 0) {
                System.arraycopy((int[])nArray, (int)0, (int[])this.mHashes, (int)0, (int)n);
                System.arraycopy(objectArray, 0, this.mArray, 0, n << 1);
            }
            if (n >= this.mSize) return (V)object;
            System.arraycopy((int[])nArray, (int)(n + 1), (int[])this.mHashes, (int)n, (int)(this.mSize - n));
            System.arraycopy(objectArray, n + 1 << 1, this.mArray, n << 1, this.mSize - n << 1);
            return (V)object;
        }
        this.mSize = -1 + this.mSize;
        if (n < this.mSize) {
            System.arraycopy((int[])this.mHashes, (int)(n + 1), (int[])this.mHashes, (int)n, (int)(this.mSize - n));
            System.arraycopy(this.mArray, n + 1 << 1, this.mArray, n << 1, this.mSize - n << 1);
        }
        this.mArray[this.mSize << 1] = null;
        this.mArray[1 + (this.mSize << 1)] = null;
        return (V)object;
    }

    public boolean retainAll(Collection<?> collection) {
        return MapCollections.retainAllHelper(this, collection);
    }

    public V setValueAt(int n, V v) {
        int n2 = 1 + (n << 1);
        Object object = this.mArray[n2];
        this.mArray[n2] = v;
        return (V)object;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(28 * this.mSize);
        stringBuilder.append('{');
        int n = 0;
        while (true) {
            K k;
            if (n >= this.mSize) {
                stringBuilder.append('}');
                return stringBuilder.toString();
            }
            if (n > 0) {
                stringBuilder.append(", ");
            }
            if ((k = this.keyAt(n)) != this) {
                stringBuilder.append(k);
            } else {
                stringBuilder.append("(this Map)");
            }
            stringBuilder.append('=');
            V v = this.valueAt(n);
            if (v != this) {
                stringBuilder.append(v);
            } else {
                stringBuilder.append("(this Map)");
            }
            ++n;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void validate() {
        var1_1 = this.mSize;
        if (var1_1 <= 1) {
            return;
        }
        var2_2 = this.mHashes[0];
        var3_3 = 0;
        var4_4 = 1;
        block1: while (true) {
            if (var4_4 >= var1_1) ** continue;
            var5_5 = this.mHashes[var4_4];
            if (var5_5 == var2_2) break;
            var2_2 = var5_5;
            var3_3 = var4_4;
            while (true) {
                ++var4_4;
                continue block1;
                break;
            }
            break;
        }
        var6_6 = this.mArray[var4_4 << 1];
        var7_7 = var4_4 - 1;
        while (true) {
            if (var7_7 < var3_3) ** continue;
            var8_8 = this.mArray[var7_7 << 1];
            if (var6_6 == var8_8) {
                throw new IllegalArgumentException("Duplicate key in ArrayMap: " + var6_6);
            }
            if (var6_6 != null && var8_8 != null && var6_6.equals(var8_8)) {
                throw new IllegalArgumentException("Duplicate key in ArrayMap: " + var6_6);
            }
            --var7_7;
        }
    }

    public V valueAt(int n) {
        return (V)this.mArray[1 + (n << 1)];
    }

    @Override
    public Collection<V> values() {
        return this.getCollection().getValues();
    }
}

