/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.transition.TransitionValues;
import android.transition.Visibility;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.android.internal.R;

public class Fade
extends Visibility {
    private static boolean DBG = false;
    public static final int IN = 1;
    private static final String LOG_TAG = "Fade";
    public static final int OUT = 2;

    static {
        DBG = false;
    }

    public Fade() {
    }

    public Fade(int n) {
        this.setMode(n);
    }

    public Fade(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setMode(context.obtainStyledAttributes(attributeSet, R.styleable.Fade).getInt(0, this.getMode()));
    }

    private Animator createAnimation(View view, float f, float f2) {
        if (f == f2) {
            return null;
        }
        view.setTransitionAlpha(f);
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)view, "transitionAlpha", f2);
        if (DBG) {
            Log.d(LOG_TAG, "Created animator " + objectAnimator);
        }
        FadeAnimatorListener fadeAnimatorListener = new FadeAnimatorListener(view);
        objectAnimator.addListener(fadeAnimatorListener);
        objectAnimator.addPauseListener(fadeAnimatorListener);
        return objectAnimator;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Animator onAppear(ViewGroup viewGroup, View view, TransitionValues transitionValues, TransitionValues transitionValues2) {
        if (DBG) {
            View view2 = transitionValues != null ? transitionValues.view : null;
            Log.d(LOG_TAG, "Fade.onAppear: startView, startVis, endView, endVis = " + view2 + ", " + view);
        }
        return this.createAnimation(view, 0.0f, 1.0f);
    }

    @Override
    public Animator onDisappear(ViewGroup viewGroup, View view, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return this.createAnimation(view, 1.0f, 0.0f);
    }

    private static class FadeAnimatorListener
    extends AnimatorListenerAdapter {
        private boolean mCanceled = false;
        private boolean mLayerTypeChanged = false;
        private float mPausedAlpha = -1.0f;
        private final View mView;

        public FadeAnimatorListener(View view) {
            this.mView = view;
        }

        @Override
        public void onAnimationCancel(Animator animator2) {
            this.mCanceled = true;
            if (this.mPausedAlpha >= 0.0f) {
                this.mView.setTransitionAlpha(this.mPausedAlpha);
            }
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
            if (!this.mCanceled) {
                this.mView.setTransitionAlpha(1.0f);
            }
            if (this.mLayerTypeChanged) {
                this.mView.setLayerType(0, null);
            }
        }

        @Override
        public void onAnimationPause(Animator animator2) {
            this.mPausedAlpha = this.mView.getTransitionAlpha();
            this.mView.setTransitionAlpha(1.0f);
        }

        @Override
        public void onAnimationResume(Animator animator2) {
            this.mView.setTransitionAlpha(this.mPausedAlpha);
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            if (this.mView.hasOverlappingRendering() && this.mView.getLayerType() == 0) {
                this.mLayerTypeChanged = true;
                this.mView.setLayerType(2, null);
            }
        }
    }
}

