/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.graphics.Color;
import android.transition.Transition;
import android.transition.TransitionValues;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import java.util.Map;

public class ChangeText
extends Transition {
    public static final int CHANGE_BEHAVIOR_IN = 2;
    public static final int CHANGE_BEHAVIOR_KEEP = 0;
    public static final int CHANGE_BEHAVIOR_OUT = 1;
    public static final int CHANGE_BEHAVIOR_OUT_IN = 3;
    private static final String LOG_TAG = "TextChange";
    private static final String PROPNAME_TEXT = "android:textchange:text";
    private static final String PROPNAME_TEXT_COLOR = "android:textchange:textColor";
    private static final String PROPNAME_TEXT_SELECTION_END = "android:textchange:textSelectionEnd";
    private static final String PROPNAME_TEXT_SELECTION_START = "android:textchange:textSelectionStart";
    private static final String[] sTransitionProperties = new String[]{"android:textchange:text", "android:textchange:textSelectionStart", "android:textchange:textSelectionEnd"};
    private int mChangeBehavior = 0;

    private void captureValues(TransitionValues transitionValues) {
        if (transitionValues.view instanceof TextView) {
            TextView textView = (TextView)transitionValues.view;
            transitionValues.values.put(PROPNAME_TEXT, textView.getText());
            if (textView instanceof EditText) {
                transitionValues.values.put(PROPNAME_TEXT_SELECTION_START, textView.getSelectionStart());
                transitionValues.values.put(PROPNAME_TEXT_SELECTION_END, textView.getSelectionEnd());
            }
            if (this.mChangeBehavior > 0) {
                transitionValues.values.put(PROPNAME_TEXT_COLOR, textView.getCurrentTextColor());
            }
        }
    }

    private void setSelection(EditText editText, int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            editText.setSelection(n, n2);
        }
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public Animator createAnimator(ViewGroup viewGroup, TransitionValues transitionValues, TransitionValues transitionValues2) {
        void var21_17;
        int n;
        void var8_9;
        int n2;
        int n3;
        int n4;
        int n5;
        CharSequence charSequence;
        TextView textView;
        block19: {
            ValueAnimator valueAnimator;
            ValueAnimator valueAnimator2;
            block23: {
                block22: {
                    block21: {
                        int n6;
                        block20: {
                            Map<String, Object> map;
                            Map<String, Object> map2;
                            block18: {
                                if (transitionValues == null || transitionValues2 == null || !(transitionValues.view instanceof TextView) || !(transitionValues2.view instanceof TextView)) {
                                    return null;
                                }
                                textView = (TextView)transitionValues2.view;
                                map2 = transitionValues.values;
                                map = transitionValues2.values;
                                charSequence = map2.get(PROPNAME_TEXT) != null ? (CharSequence)map2.get(PROPNAME_TEXT) : "";
                                if (map.get(PROPNAME_TEXT) != null) {
                                    CharSequence charSequence2 = (CharSequence)map.get(PROPNAME_TEXT);
                                } else {
                                    String string2 = "";
                                }
                                if (textView instanceof EditText) {
                                    n5 = map2.get(PROPNAME_TEXT_SELECTION_START) != null ? (Integer)map2.get(PROPNAME_TEXT_SELECTION_START) : -1;
                                    n4 = map2.get(PROPNAME_TEXT_SELECTION_END) != null ? (Integer)map2.get(PROPNAME_TEXT_SELECTION_END) : n5;
                                    n3 = map.get(PROPNAME_TEXT_SELECTION_START) != null ? (Integer)map.get(PROPNAME_TEXT_SELECTION_START) : -1;
                                    n2 = map.get(PROPNAME_TEXT_SELECTION_END) != null ? (Integer)map.get(PROPNAME_TEXT_SELECTION_END) : n3;
                                } else {
                                    n3 = n2 = -1;
                                    n4 = n2;
                                    n5 = n2;
                                }
                                if (charSequence.equals(var8_9)) {
                                    return null;
                                }
                                if (this.mChangeBehavior != 2) {
                                    textView.setText(charSequence);
                                    if (textView instanceof EditText) {
                                        this.setSelection((EditText)textView, n5, n4);
                                    }
                                }
                                if (this.mChangeBehavior != 0) break block18;
                                n = 0;
                                ValueAnimator valueAnimator3 = ValueAnimator.ofFloat(0.0f, 1.0f);
                                AnimatorListenerAdapter animatorListenerAdapter = new AnimatorListenerAdapter((CharSequence)var8_9, n3, n2){
                                    final /* synthetic */ int val$endSelectionEnd;
                                    final /* synthetic */ int val$endSelectionStart;
                                    final /* synthetic */ CharSequence val$endText;
                                    {
                                        this.val$endText = charSequence2;
                                        this.val$endSelectionStart = n;
                                        this.val$endSelectionEnd = n2;
                                    }

                                    @Override
                                    public void onAnimationEnd(Animator animator2) {
                                        if (charSequence.equals(textView.getText())) {
                                            textView.setText(this.val$endText);
                                            if (textView instanceof EditText) {
                                                ChangeText.this.setSelection((EditText)textView, this.val$endSelectionStart, this.val$endSelectionEnd);
                                            }
                                        }
                                    }
                                };
                                valueAnimator3.addListener(animatorListenerAdapter);
                                break block19;
                            }
                            n6 = (Integer)map2.get(PROPNAME_TEXT_COLOR);
                            n = (Integer)map.get(PROPNAME_TEXT_COLOR);
                            if (this.mChangeBehavior == 3) break block20;
                            int n7 = this.mChangeBehavior;
                            valueAnimator2 = null;
                            if (n7 != 1) break block21;
                        }
                        valueAnimator2 = ValueAnimator.ofInt(255, 0);
                        ValueAnimator.AnimatorUpdateListener animatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

                            @Override
                            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                                int n = (Integer)valueAnimator.getAnimatedValue();
                                textView.setTextColor(n << 24 | 0xFF0000 & n6 | 0xFF00 & n6 | 0xFF & n6);
                            }
                        };
                        valueAnimator2.addUpdateListener(animatorUpdateListener);
                        AnimatorListenerAdapter animatorListenerAdapter = new AnimatorListenerAdapter((CharSequence)var8_9, n3, n2, n){
                            final /* synthetic */ int val$endColor;
                            final /* synthetic */ int val$endSelectionEnd;
                            final /* synthetic */ int val$endSelectionStart;
                            final /* synthetic */ CharSequence val$endText;
                            {
                                this.val$endText = charSequence2;
                                this.val$endSelectionStart = n;
                                this.val$endSelectionEnd = n2;
                                this.val$endColor = n3;
                            }

                            @Override
                            public void onAnimationEnd(Animator animator2) {
                                if (charSequence.equals(textView.getText())) {
                                    textView.setText(this.val$endText);
                                    if (textView instanceof EditText) {
                                        ChangeText.this.setSelection((EditText)textView, this.val$endSelectionStart, this.val$endSelectionEnd);
                                    }
                                }
                                textView.setTextColor(this.val$endColor);
                            }
                        };
                        valueAnimator2.addListener(animatorListenerAdapter);
                    }
                    if (this.mChangeBehavior == 3) break block22;
                    int n8 = this.mChangeBehavior;
                    valueAnimator = null;
                    if (n8 != 2) break block23;
                }
                valueAnimator = ValueAnimator.ofInt(0, 255);
                ValueAnimator.AnimatorUpdateListener animatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

                    @Override
                    public void onAnimationUpdate(ValueAnimator valueAnimator) {
                        int n2 = (Integer)valueAnimator.getAnimatedValue();
                        textView.setTextColor(n2 << 24 | Color.red(n) << 16 | Color.green(n) << 8 | Color.red(n));
                    }
                };
                valueAnimator.addUpdateListener(animatorUpdateListener);
                AnimatorListenerAdapter animatorListenerAdapter = new AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationCancel(Animator animator2) {
                        textView.setTextColor(n);
                    }
                };
                valueAnimator.addListener(animatorListenerAdapter);
            }
            if (valueAnimator2 != null && valueAnimator != null) {
                AnimatorSet animatorSet = new AnimatorSet();
                animatorSet.playSequentially(valueAnimator2, valueAnimator);
            } else if (valueAnimator2 != null) {
                ValueAnimator valueAnimator4 = valueAnimator2;
            } else {
                ValueAnimator valueAnimator5 = valueAnimator;
            }
        }
        this.addListener(new Transition.TransitionListenerAdapter((CharSequence)var8_9, n3, n2, n, charSequence, n5, n4){
            int mPausedColor = 0;
            final /* synthetic */ int val$endColor;
            final /* synthetic */ int val$endSelectionEnd;
            final /* synthetic */ int val$endSelectionStart;
            final /* synthetic */ CharSequence val$endText;
            final /* synthetic */ int val$startSelectionEnd;
            final /* synthetic */ int val$startSelectionStart;
            final /* synthetic */ CharSequence val$startText;
            {
                this.val$endText = charSequence;
                this.val$endSelectionStart = n;
                this.val$endSelectionEnd = n2;
                this.val$endColor = n3;
                this.val$startText = charSequence2;
                this.val$startSelectionStart = n4;
                this.val$startSelectionEnd = n5;
            }

            @Override
            public void onTransitionPause(Transition transition2) {
                if (ChangeText.this.mChangeBehavior != 2) {
                    textView.setText(this.val$endText);
                    if (textView instanceof EditText) {
                        ChangeText.this.setSelection((EditText)textView, this.val$endSelectionStart, this.val$endSelectionEnd);
                    }
                }
                if (ChangeText.this.mChangeBehavior > 0) {
                    this.mPausedColor = textView.getCurrentTextColor();
                    textView.setTextColor(this.val$endColor);
                }
            }

            @Override
            public void onTransitionResume(Transition transition2) {
                if (ChangeText.this.mChangeBehavior != 2) {
                    textView.setText(this.val$startText);
                    if (textView instanceof EditText) {
                        ChangeText.this.setSelection((EditText)textView, this.val$startSelectionStart, this.val$startSelectionEnd);
                    }
                }
                if (ChangeText.this.mChangeBehavior > 0) {
                    textView.setTextColor(this.mPausedColor);
                }
            }
        });
        return var21_17;
    }

    public int getChangeBehavior() {
        return this.mChangeBehavior;
    }

    @Override
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    public ChangeText setChangeBehavior(int n) {
        if (n >= 0 && n <= 3) {
            this.mChangeBehavior = n;
        }
        return this;
    }
}

