/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.transition.Transition;
import android.transition.TransitionUtils;
import android.transition.TransitionValues;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import java.util.Map;

public class ChangeImageTransform
extends Transition {
    private static Property<ImageView, Matrix> ANIMATED_TRANSFORM_PROPERTY;
    private static TypeEvaluator<Matrix> NULL_MATRIX_EVALUATOR;
    private static final String PROPNAME_BOUNDS = "android:changeImageTransform:bounds";
    private static final String PROPNAME_MATRIX = "android:changeImageTransform:matrix";
    private static final String TAG = "ChangeImageTransform";
    private static final String[] sTransitionProperties;

    static {
        sTransitionProperties = new String[]{PROPNAME_MATRIX, PROPNAME_BOUNDS};
        NULL_MATRIX_EVALUATOR = new TypeEvaluator<Matrix>(){

            @Override
            public Matrix evaluate(float f, Matrix matrix, Matrix matrix2) {
                return null;
            }
        };
        ANIMATED_TRANSFORM_PROPERTY = new Property<ImageView, Matrix>(Matrix.class, "animatedTransform"){

            @Override
            public Matrix get(ImageView imageView) {
                return null;
            }

            @Override
            public void set(ImageView imageView, Matrix matrix) {
                imageView.animateTransform(matrix);
            }
        };
    }

    public ChangeImageTransform() {
    }

    public ChangeImageTransform(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void captureValues(TransitionValues transitionValues) {
        Matrix matrix;
        Map<String, Object> map;
        block5: {
            ImageView imageView;
            block6: {
                Drawable drawable2;
                View view = transitionValues.view;
                if (!(view instanceof ImageView) || view.getVisibility() != 0 || (drawable2 = (imageView = (ImageView)view).getDrawable()) == null) {
                    return;
                }
                map = transitionValues.values;
                Rect rect = new Rect(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
                map.put(PROPNAME_BOUNDS, rect);
                if (imageView.getScaleType() != ImageView.ScaleType.FIT_XY) break block6;
                Matrix matrix2 = imageView.getImageMatrix();
                if (!matrix2.isIdentity()) {
                    matrix = new Matrix(matrix2);
                    break block5;
                } else {
                    int n = drawable2.getIntrinsicWidth();
                    int n2 = drawable2.getIntrinsicHeight();
                    if (n > 0 && n2 > 0) {
                        float f = (float)rect.width() / (float)n;
                        float f2 = (float)rect.height() / (float)n2;
                        matrix = new Matrix();
                        matrix.setScale(f, f2);
                        break block5;
                    } else {
                        matrix = null;
                    }
                }
                break block5;
            }
            matrix = new Matrix(imageView.getImageMatrix());
        }
        map.put(PROPNAME_MATRIX, matrix);
    }

    private ObjectAnimator createMatrixAnimator(ImageView imageView, Matrix matrix, Matrix matrix2) {
        return ObjectAnimator.ofObject(imageView, ANIMATED_TRANSFORM_PROPERTY, new TransitionUtils.MatrixEvaluator(), matrix, matrix2);
    }

    private ObjectAnimator createNullAnimator(ImageView imageView) {
        return ObjectAnimator.ofObject(imageView, ANIMATED_TRANSFORM_PROPERTY, NULL_MATRIX_EVALUATOR, null, null);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Animator createAnimator(ViewGroup viewGroup, TransitionValues transitionValues, TransitionValues transitionValues2) {
        Matrix matrix;
        Matrix matrix2;
        block7: {
            block6: {
                if (transitionValues == null || transitionValues2 == null) break block6;
                Rect rect = (Rect)transitionValues.values.get(PROPNAME_BOUNDS);
                Rect rect2 = (Rect)transitionValues2.values.get(PROPNAME_BOUNDS);
                if (rect == null || rect2 == null) break block6;
                matrix2 = (Matrix)transitionValues.values.get(PROPNAME_MATRIX);
                matrix = (Matrix)transitionValues2.values.get(PROPNAME_MATRIX);
                boolean bl = matrix2 == null && matrix == null || matrix2 != null && matrix2.equals(matrix);
                if (!rect.equals(rect2) || !bl) break block7;
            }
            return null;
        }
        ImageView imageView = (ImageView)transitionValues2.view;
        Drawable drawable2 = imageView.getDrawable();
        int n = drawable2.getIntrinsicWidth();
        int n2 = drawable2.getIntrinsicHeight();
        if (n == 0 || n2 == 0) {
            return this.createNullAnimator(imageView);
        }
        if (matrix2 == null) {
            matrix2 = Matrix.IDENTITY_MATRIX;
        }
        if (matrix == null) {
            matrix = Matrix.IDENTITY_MATRIX;
        }
        ANIMATED_TRANSFORM_PROPERTY.set(imageView, matrix2);
        return this.createMatrixAnimator(imageView, matrix2, matrix);
    }

    @Override
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }
}

