/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Parcel;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;

public class TypefaceSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    private final String mFamily;

    public TypefaceSpan(Parcel parcel) {
        this.mFamily = parcel.readString();
    }

    public TypefaceSpan(String string2) {
        this.mFamily = string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void apply(Paint paint, String string2) {
        Typeface typeface;
        Typeface typeface2 = paint.getTypeface();
        int n = typeface2 == null ? 0 : typeface2.getStyle();
        int n2 = n & (0xFFFFFFFF ^ (typeface = Typeface.create(string2, n)).getStyle());
        if ((n2 & 1) != 0) {
            paint.setFakeBoldText(true);
        }
        if ((n2 & 2) != 0) {
            paint.setTextSkewX(-0.25f);
        }
        paint.setTypeface(typeface);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getFamily() {
        return this.mFamily;
    }

    @Override
    public int getSpanTypeId() {
        return 13;
    }

    @Override
    public void updateDrawState(TextPaint textPaint) {
        TypefaceSpan.apply(textPaint, this.mFamily);
    }

    @Override
    public void updateMeasureState(TextPaint textPaint) {
        TypefaceSpan.apply(textPaint, this.mFamily);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mFamily);
    }
}

