/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Parcel;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;

public class StyleSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    private final int mStyle;

    public StyleSpan(int n) {
        this.mStyle = n;
    }

    public StyleSpan(Parcel parcel) {
        this.mStyle = parcel.readInt();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void apply(Paint paint, int n) {
        Typeface typeface;
        int n2;
        Typeface typeface2 = paint.getTypeface();
        int n3 = typeface2 == null ? 0 : typeface2.getStyle();
        int n4 = n3 | n;
        if (paint.getTextSkewX() == -0.25f && n == 1 && typeface2 == Typeface.defaultFromStyle(2)) {
            typeface2 = Typeface.defaultFromStyle(1);
        }
        if (((n2 = n4 & (0xFFFFFFFF ^ (typeface = typeface2 == null ? Typeface.defaultFromStyle(n4) : Typeface.create(typeface2, n4)).getStyle())) & 1) != 0) {
            paint.setFakeBoldText(true);
        }
        if ((n2 & 2) != 0) {
            paint.setTextSkewX(-0.25f);
        }
        paint.setTypeface(typeface);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public int getSpanTypeId() {
        return 7;
    }

    public int getStyle() {
        return this.mStyle;
    }

    @Override
    public void updateDrawState(TextPaint textPaint) {
        StyleSpan.apply(textPaint, this.mStyle);
    }

    @Override
    public void updateMeasureState(TextPaint textPaint) {
        StyleSpan.apply(textPaint, this.mStyle);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mStyle);
    }
}

