/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;

public class DrawableMarginSpan
implements LeadingMarginSpan,
LineHeightSpan {
    private Drawable mDrawable;
    private int mPad;

    public DrawableMarginSpan(Drawable drawable2) {
        this.mDrawable = drawable2;
    }

    public DrawableMarginSpan(Drawable drawable2, int n) {
        this.mDrawable = drawable2;
        this.mPad = n;
    }

    @Override
    public void chooseHeight(CharSequence charSequence, int n, int n2, int n3, int n4, Paint.FontMetricsInt fontMetricsInt) {
        if (n2 == ((Spanned)charSequence).getSpanEnd(this)) {
            int n5;
            int n6 = this.mDrawable.getIntrinsicHeight();
            int n7 = n6 - (n4 + fontMetricsInt.descent - fontMetricsInt.ascent - n3);
            if (n7 > 0) {
                fontMetricsInt.descent = n7 + fontMetricsInt.descent;
            }
            if ((n5 = n6 - (n4 + fontMetricsInt.bottom - fontMetricsInt.top - n3)) > 0) {
                fontMetricsInt.bottom = n5 + fontMetricsInt.bottom;
            }
        }
    }

    @Override
    public void drawLeadingMargin(Canvas canvas, Paint paint, int n, int n2, int n3, int n4, int n5, CharSequence charSequence, int n6, int n7, boolean bl, Layout layout2) {
        int n8 = layout2.getLineTop(layout2.getLineForOffset(((Spanned)charSequence).getSpanStart(this)));
        int n9 = this.mDrawable.getIntrinsicWidth();
        int n10 = this.mDrawable.getIntrinsicHeight();
        this.mDrawable.setBounds(n, n8, n + n9, n8 + n10);
        this.mDrawable.draw(canvas);
    }

    @Override
    public int getLeadingMargin(boolean bl) {
        return this.mDrawable.getIntrinsicWidth() + this.mPad;
    }
}

