/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.os.Parcel;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;

public class BulletSpan
implements LeadingMarginSpan,
ParcelableSpan {
    private static final int BULLET_RADIUS = 3;
    public static final int STANDARD_GAP_WIDTH = 2;
    private static Path sBulletPath = null;
    private final int mColor;
    private final int mGapWidth;
    private final boolean mWantColor;

    public BulletSpan() {
        this.mGapWidth = 2;
        this.mWantColor = false;
        this.mColor = 0;
    }

    public BulletSpan(int n) {
        this.mGapWidth = n;
        this.mWantColor = false;
        this.mColor = 0;
    }

    public BulletSpan(int n, int n2) {
        this.mGapWidth = n;
        this.mWantColor = true;
        this.mColor = n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public BulletSpan(Parcel parcel) {
        this.mGapWidth = parcel.readInt();
        boolean bl = parcel.readInt() != 0;
        this.mWantColor = bl;
        this.mColor = parcel.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void drawLeadingMargin(Canvas canvas, Paint paint, int n, int n2, int n3, int n4, int n5, CharSequence charSequence, int n6, int n7, boolean bl, Layout layout2) {
        if (((Spanned)charSequence).getSpanStart(this) == n6) {
            Paint.Style style2 = paint.getStyle();
            boolean bl2 = this.mWantColor;
            int n8 = 0;
            if (bl2) {
                n8 = paint.getColor();
                paint.setColor(this.mColor);
            }
            paint.setStyle(Paint.Style.FILL);
            if (canvas.isHardwareAccelerated()) {
                if (sBulletPath == null) {
                    sBulletPath = new Path();
                    sBulletPath.addCircle(0.0f, 0.0f, 3.6000001f, Path.Direction.CW);
                }
                canvas.save();
                canvas.translate(n + n2 * 3, (float)(n3 + n5) / 2.0f);
                canvas.drawPath(sBulletPath, paint);
                canvas.restore();
            } else {
                canvas.drawCircle(n + n2 * 3, (float)(n3 + n5) / 2.0f, 3.0f, paint);
            }
            if (this.mWantColor) {
                paint.setColor(n8);
            }
            paint.setStyle(style2);
        }
    }

    @Override
    public int getLeadingMargin(boolean bl) {
        return 6 + this.mGapWidth;
    }

    @Override
    public int getSpanTypeId() {
        return 8;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mGapWidth);
        int n2 = this.mWantColor ? 1 : 0;
        parcel.writeInt(n2);
        parcel.writeInt(this.mColor);
    }
}

