/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Selection;
import android.text.SpannableStringBuilder;
import java.text.BreakIterator;
import java.util.Locale;

public class WordIterator
implements Selection.PositionIterator {
    private static final int WINDOW_WIDTH = 50;
    private BreakIterator mIterator;
    private int mOffsetShift;
    private String mString;

    public WordIterator() {
        this(Locale.getDefault());
    }

    public WordIterator(Locale locale) {
        this.mIterator = BreakIterator.getWordInstance(locale);
    }

    private void checkOffsetIsValid(int n) {
        if (n < 0 || n > this.mString.length()) {
            throw new IllegalArgumentException("Invalid offset: " + (n + this.mOffsetShift) + ". Valid range is [" + this.mOffsetShift + ", " + (this.mString.length() + this.mOffsetShift) + "]");
        }
    }

    private boolean isAfterLetterOrDigit(int n) {
        return n >= 1 && n <= this.mString.length() && Character.isLetterOrDigit(this.mString.codePointBefore(n));
    }

    private boolean isOnLetterOrDigit(int n) {
        return n >= 0 && n < this.mString.length() && Character.isLetterOrDigit(this.mString.codePointAt(n));
    }

    @Override
    public int following(int n) {
        int n2 = n - this.mOffsetShift;
        do {
            if ((n2 = this.mIterator.following(n2)) != -1) continue;
            return -1;
        } while (!this.isAfterLetterOrDigit(n2));
        return n2 + this.mOffsetShift;
    }

    public int getBeginning(int n) {
        int n2 = n - this.mOffsetShift;
        this.checkOffsetIsValid(n2);
        if (this.isOnLetterOrDigit(n2)) {
            if (this.mIterator.isBoundary(n2)) {
                return n2 + this.mOffsetShift;
            }
            return this.mIterator.preceding(n2) + this.mOffsetShift;
        }
        if (this.isAfterLetterOrDigit(n2)) {
            return this.mIterator.preceding(n2) + this.mOffsetShift;
        }
        return -1;
    }

    public int getEnd(int n) {
        int n2 = n - this.mOffsetShift;
        this.checkOffsetIsValid(n2);
        if (this.isAfterLetterOrDigit(n2)) {
            if (this.mIterator.isBoundary(n2)) {
                return n2 + this.mOffsetShift;
            }
            return this.mIterator.following(n2) + this.mOffsetShift;
        }
        if (this.isOnLetterOrDigit(n2)) {
            return this.mIterator.following(n2) + this.mOffsetShift;
        }
        return -1;
    }

    @Override
    public int preceding(int n) {
        int n2 = n - this.mOffsetShift;
        do {
            if ((n2 = this.mIterator.preceding(n2)) != -1) continue;
            return -1;
        } while (!this.isOnLetterOrDigit(n2));
        return n2 + this.mOffsetShift;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCharSequence(CharSequence charSequence, int n, int n2) {
        this.mOffsetShift = Math.max(0, n - 50);
        int n3 = Math.min(charSequence.length(), n2 + 50);
        this.mString = charSequence instanceof SpannableStringBuilder ? ((SpannableStringBuilder)charSequence).substring(this.mOffsetShift, n3) : charSequence.subSequence(this.mOffsetShift, n3).toString();
        this.mIterator.setText(this.mString);
    }
}

