/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Layout;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.MovementMethod;
import android.text.method.ScrollingMovementMethod;
import android.text.style.ClickableSpan;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.widget.TextView;

public class LinkMovementMethod
extends ScrollingMovementMethod {
    private static final int CLICK = 1;
    private static final int DOWN = 3;
    private static Object FROM_BELOW = new NoCopySpan.Concrete();
    private static final int UP = 2;
    private static LinkMovementMethod sInstance;

    /*
     * Enabled aggressive block sorting
     */
    private boolean action(int n, TextView textView, Spannable spannable) {
        Layout layout2 = textView.getLayout();
        int n2 = textView.getTotalPaddingTop() + textView.getTotalPaddingBottom();
        int n3 = textView.getScrollY();
        int n4 = n3 + textView.getHeight() - n2;
        int n5 = layout2.getLineForVertical(n3);
        int n6 = layout2.getLineForVertical(n4);
        int n7 = layout2.getLineStart(n5);
        int n8 = layout2.getLineEnd(n6);
        ClickableSpan[] clickableSpanArray = spannable.getSpans(n7, n8, ClickableSpan.class);
        int n9 = Selection.getSelectionStart(spannable);
        int n10 = Selection.getSelectionEnd(spannable);
        int n11 = Math.min(n9, n10);
        int n12 = Math.max(n9, n10);
        if (n11 < 0 && spannable.getSpanStart(FROM_BELOW) >= 0) {
            n11 = n12 = spannable.length();
        }
        if (n11 > n8) {
            n11 = n12 = Integer.MAX_VALUE;
        }
        if (n12 < n7) {
            n11 = n12 = -1;
        }
        switch (n) {
            case 1: {
                if (n11 == n12) {
                    return false;
                }
                ClickableSpan[] clickableSpanArray2 = spannable.getSpans(n11, n12, ClickableSpan.class);
                if (clickableSpanArray2.length != 1) {
                    return false;
                }
                clickableSpanArray2[0].onClick(textView);
                return false;
            }
            case 2: {
                int n13 = -1;
                int n14 = -1;
                int n15 = 0;
                while (true) {
                    if (n15 >= clickableSpanArray.length) {
                        if (n13 < 0) return false;
                        Selection.setSelection(spannable, n14, n13);
                        return true;
                    }
                    int n16 = spannable.getSpanEnd(clickableSpanArray[n15]);
                    if ((n16 < n12 || n11 == n12) && n16 > n14) {
                        n13 = spannable.getSpanStart(clickableSpanArray[n15]);
                        n14 = n16;
                    }
                    ++n15;
                }
            }
            case 3: {
                int n17 = Integer.MAX_VALUE;
                int n18 = Integer.MAX_VALUE;
                int n19 = 0;
                while (true) {
                    if (n19 >= clickableSpanArray.length) {
                        if (n18 >= Integer.MAX_VALUE) return false;
                        Selection.setSelection(spannable, n17, n18);
                        return true;
                    }
                    int n20 = spannable.getSpanStart(clickableSpanArray[n19]);
                    if ((n20 > n11 || n11 == n12) && n20 < n17) {
                        n17 = n20;
                        n18 = spannable.getSpanEnd(clickableSpanArray[n19]);
                    }
                    ++n19;
                }
            }
        }
        return false;
    }

    public static MovementMethod getInstance() {
        if (sInstance == null) {
            sInstance = new LinkMovementMethod();
        }
        return sInstance;
    }

    @Override
    public boolean canSelectArbitrarily() {
        return true;
    }

    @Override
    protected boolean down(TextView textView, Spannable spannable) {
        if (this.action(3, textView, spannable)) {
            return true;
        }
        return super.down(textView, spannable);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected boolean handleMovementKey(TextView textView, Spannable spannable, int n, int n2, KeyEvent keyEvent) {
        switch (n) {
            default: {
                return super.handleMovementKey(textView, spannable, n, n2, keyEvent);
            }
            case 23: 
            case 66: {
                if (!KeyEvent.metaStateHasNoModifiers(n2) || keyEvent.getAction() != 0 || keyEvent.getRepeatCount() != 0 || !this.action(1, textView, spannable)) return super.handleMovementKey(textView, spannable, n, n2, keyEvent);
                return true;
            }
        }
    }

    @Override
    public void initialize(TextView textView, Spannable spannable) {
        Selection.removeSelection(spannable);
        spannable.removeSpan(FROM_BELOW);
    }

    @Override
    protected boolean left(TextView textView, Spannable spannable) {
        if (this.action(2, textView, spannable)) {
            return true;
        }
        return super.left(textView, spannable);
    }

    @Override
    public void onTakeFocus(TextView textView, Spannable spannable, int n) {
        Selection.removeSelection(spannable);
        if ((n & 1) != 0) {
            spannable.setSpan(FROM_BELOW, 0, 0, 34);
            return;
        }
        spannable.removeSpan(FROM_BELOW);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean onTouchEvent(TextView textView, Spannable spannable, MotionEvent motionEvent) {
        int n = motionEvent.getAction();
        if (n != 1 && n != 0) return super.onTouchEvent(textView, spannable, motionEvent);
        int n2 = (int)motionEvent.getX();
        int n3 = (int)motionEvent.getY();
        int n4 = n2 - textView.getTotalPaddingLeft();
        int n5 = n3 - textView.getTotalPaddingTop();
        int n6 = n4 + textView.getScrollX();
        int n7 = n5 + textView.getScrollY();
        Layout layout2 = textView.getLayout();
        int n8 = layout2.getOffsetForHorizontal(layout2.getLineForVertical(n7), n6);
        ClickableSpan[] clickableSpanArray = spannable.getSpans(n8, n8, ClickableSpan.class);
        if (clickableSpanArray.length != 0) {
            if (n == 1) {
                clickableSpanArray[0].onClick(textView);
                return true;
            } else {
                if (n != 0) return true;
                Selection.setSelection(spannable, spannable.getSpanStart(clickableSpanArray[0]), spannable.getSpanEnd(clickableSpanArray[0]));
                return true;
            }
        }
        Selection.removeSelection(spannable);
        return super.onTouchEvent(textView, spannable, motionEvent);
    }

    @Override
    protected boolean right(TextView textView, Spannable spannable) {
        if (this.action(3, textView, spannable)) {
            return true;
        }
        return super.right(textView, spannable);
    }

    @Override
    protected boolean up(TextView textView, Spannable spannable) {
        if (this.action(2, textView, spannable)) {
            return true;
        }
        return super.up(textView, spannable);
    }
}

