/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.Spanned;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import java.lang.reflect.Array;
import libcore.util.EmptyArray;

abstract class SpannableStringInternal {
    private static final int COLUMNS = 3;
    static final Object[] EMPTY = new Object[0];
    private static final int END = 1;
    private static final int FLAGS = 2;
    private static final int START;
    private int mSpanCount;
    private int[] mSpanData;
    private Object[] mSpans;
    private String mText;

    /*
     * Enabled aggressive block sorting
     */
    SpannableStringInternal(CharSequence charSequence, int n, int n2) {
        this.mText = n == 0 && n2 == charSequence.length() ? charSequence.toString() : charSequence.toString().substring(n, n2);
        this.mSpans = EmptyArray.OBJECT;
        this.mSpanData = EmptyArray.INT;
        if (charSequence instanceof Spanned) {
            Spanned spanned = (Spanned)charSequence;
            Object[] objectArray = spanned.getSpans(n, n2, Object.class);
            for (int i = 0; i < objectArray.length; ++i) {
                int n3 = spanned.getSpanStart(objectArray[i]);
                int n4 = spanned.getSpanEnd(objectArray[i]);
                int n5 = spanned.getSpanFlags(objectArray[i]);
                if (n3 < n) {
                    n3 = n;
                }
                if (n4 > n2) {
                    n4 = n2;
                }
                this.setSpan(objectArray[i], n3 - n, n4 - n, n5);
            }
        }
    }

    private void checkRange(String string2, int n, int n2) {
        if (n2 < n) {
            throw new IndexOutOfBoundsException(string2 + " " + SpannableStringInternal.region(n, n2) + " has end before start");
        }
        int n3 = this.length();
        if (n > n3 || n2 > n3) {
            throw new IndexOutOfBoundsException(string2 + " " + SpannableStringInternal.region(n, n2) + " ends beyond length " + n3);
        }
        if (n < 0 || n2 < 0) {
            throw new IndexOutOfBoundsException(string2 + " " + SpannableStringInternal.region(n, n2) + " starts before 0");
        }
    }

    private static String region(int n, int n2) {
        return "(" + n + " ... " + n2 + ")";
    }

    private void sendSpanAdded(Object object, int n, int n2) {
        SpanWatcher[] spanWatcherArray = this.getSpans(n, n2, SpanWatcher.class);
        int n3 = spanWatcherArray.length;
        for (int i = 0; i < n3; ++i) {
            spanWatcherArray[i].onSpanAdded((Spannable)((Object)this), object, n, n2);
        }
    }

    private void sendSpanChanged(Object object, int n, int n2, int n3, int n4) {
        SpanWatcher[] spanWatcherArray = this.getSpans(Math.min(n, n3), Math.max(n2, n4), SpanWatcher.class);
        int n5 = spanWatcherArray.length;
        for (int i = 0; i < n5; ++i) {
            spanWatcherArray[i].onSpanChanged((Spannable)((Object)this), object, n, n2, n3, n4);
        }
    }

    private void sendSpanRemoved(Object object, int n, int n2) {
        SpanWatcher[] spanWatcherArray = this.getSpans(n, n2, SpanWatcher.class);
        int n3 = spanWatcherArray.length;
        for (int i = 0; i < n3; ++i) {
            spanWatcherArray[i].onSpanRemoved((Spannable)((Object)this), object, n, n2);
        }
    }

    public final char charAt(int n) {
        return this.mText.charAt(n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        Spanned spanned;
        Object[] objectArray;
        if (object instanceof Spanned && this.toString().equals(object.toString()) && this.mSpanCount == (objectArray = (spanned = (Spanned)object).getSpans(0, spanned.length(), Object.class)).length) {
            int n = 0;
            while (true) {
                if (n >= this.mSpanCount) {
                    return true;
                }
                Object object2 = this.mSpans[n];
                Object object3 = objectArray[n];
                if (object2 != this ? !object2.equals(object3) || this.getSpanStart(object2) != spanned.getSpanStart(object3) || this.getSpanEnd(object2) != spanned.getSpanEnd(object3) || this.getSpanFlags(object2) != spanned.getSpanFlags(object3) : spanned != object3 || this.getSpanStart(object2) != spanned.getSpanStart(object3) || this.getSpanEnd(object2) != spanned.getSpanEnd(object3) || this.getSpanFlags(object2) != spanned.getSpanFlags(object3)) break;
                ++n;
            }
        }
        return false;
    }

    public final void getChars(int n, int n2, char[] cArray, int n3) {
        this.mText.getChars(n, n2, cArray, n3);
    }

    public int getSpanEnd(Object object) {
        int n = this.mSpanCount;
        Object[] objectArray = this.mSpans;
        int[] nArray = this.mSpanData;
        for (int i = n - 1; i >= 0; --i) {
            if (objectArray[i] != object) continue;
            return nArray[1 + i * 3];
        }
        return -1;
    }

    public int getSpanFlags(Object object) {
        int n = this.mSpanCount;
        Object[] objectArray = this.mSpans;
        int[] nArray = this.mSpanData;
        for (int i = n - 1; i >= 0; --i) {
            if (objectArray[i] != object) continue;
            return nArray[2 + i * 3];
        }
        return 0;
    }

    public int getSpanStart(Object object) {
        int n = this.mSpanCount;
        Object[] objectArray = this.mSpans;
        int[] nArray = this.mSpanData;
        for (int i = n - 1; i >= 0; --i) {
            if (objectArray[i] != object) continue;
            return nArray[0 + i * 3];
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public <T> T[] getSpans(int var1_1, int var2_2, Class<T> var3_3) {
        var4_4 = this.mSpanCount;
        var5_5 = this.mSpans;
        var6_6 = this.mSpanData;
        var7_7 = null;
        var8_8 = null;
        var10_10 = 0;
        block0: for (var9_9 = 0; var9_9 < var4_4; ++var9_9) {
            block13: {
                block12: {
                    block10: {
                        block11: {
                            block9: {
                                block8: {
                                    if (var3_3 != null && !var3_3.isInstance(var5_5[var9_9])) {
                                        var16_14 = var10_10;
lbl10:
                                        // 8 sources

                                        while (true) {
                                            var10_10 = var16_14;
                                            continue block0;
                                            break;
                                        }
                                    }
                                    var13_11 = var6_6[0 + var9_9 * 3];
                                    var14_12 = var6_6[1 + var9_9 * 3];
                                    if (var13_11 <= var2_2) break block8;
                                    var16_14 = var10_10;
                                    ** GOTO lbl10
                                }
                                if (var14_12 >= var1_1) break block9;
                                var16_14 = var10_10;
                                ** GOTO lbl10
                            }
                            if (var13_11 == var14_12 || var1_1 == var2_2) break block10;
                            if (var13_11 != var2_2) break block11;
                            var16_14 = var10_10;
                            ** GOTO lbl10
                        }
                        if (var14_12 != var1_1) break block10;
                        var16_14 = var10_10;
                        ** GOTO lbl10
                    }
                    if (var10_10 != 0) break block12;
                    var8_8 = var5_5[var9_9];
                    var16_14 = var10_10 + 1;
                    ** GOTO lbl10
                }
                if (var10_10 == 1) {
                    var7_7 = (Object[])Array.newInstance(var3_3, 1 + (var4_4 - var9_9));
                    var7_7[0] = var8_8;
                }
                if ((var15_13 = 0xFF0000 & var6_6[2 + var9_9 * 3]) == 0) break block13;
                var17_15 = 0;
                while (true) {
                    block14: {
                        if (var17_15 < var10_10 && var15_13 <= (0xFF0000 & this.getSpanFlags(var7_7[var17_15]))) break block14;
                        System.arraycopy(var7_7, var17_15, var7_7, var17_15 + 1, var10_10 - var17_15);
                        var7_7[var17_15] = var5_5[var9_9];
                        var16_14 = var10_10 + 1;
                        ** GOTO lbl10
                    }
                    ++var17_15;
                }
            }
            var16_14 = var10_10 + 1;
            var7_7[var10_10] = var5_5[var9_9];
            ** continue;
        }
        if (var10_10 == 0) {
            return ArrayUtils.emptyArray(var3_3);
        }
        if (var10_10 == 1) {
            var12_16 = (Object[])Array.newInstance(var3_3, 1);
            var12_16[0] = var8_8;
            return var12_16;
        }
        if (var10_10 == var7_7.length) {
            return var7_7;
        }
        var11_17 = (Object[])Array.newInstance(var3_3, var10_10);
        System.arraycopy(var7_7, 0, var11_17, 0, var10_10);
        return var11_17;
    }

    public int hashCode() {
        int n = 31 * this.toString().hashCode() + this.mSpanCount;
        for (int i = 0; i < this.mSpanCount; ++i) {
            Object object = this.mSpans[i];
            if (object != this) {
                n = n * 31 + object.hashCode();
            }
            n = 31 * (31 * (n * 31 + this.getSpanStart(object)) + this.getSpanEnd(object)) + this.getSpanFlags(object);
        }
        return n;
    }

    public final int length() {
        return this.mText.length();
    }

    public int nextSpanTransition(int n, int n2, Class clazz) {
        int n3 = this.mSpanCount;
        Object[] objectArray = this.mSpans;
        int[] nArray = this.mSpanData;
        if (clazz == null) {
            clazz = Object.class;
        }
        for (int i = 0; i < n3; ++i) {
            int n4 = nArray[0 + i * 3];
            int n5 = nArray[1 + i * 3];
            if (n4 > n && n4 < n2 && clazz.isInstance(objectArray[i])) {
                n2 = n4;
            }
            if (n5 <= n || n5 >= n2 || !clazz.isInstance(objectArray[i])) continue;
            n2 = n5;
        }
        return n2;
    }

    void removeSpan(Object object) {
        int n = this.mSpanCount;
        Object[] objectArray = this.mSpans;
        int[] nArray = this.mSpanData;
        int n2 = n - 1;
        while (true) {
            block4: {
                block3: {
                    if (n2 < 0) break block3;
                    if (objectArray[n2] != object) break block4;
                    int n3 = nArray[0 + n2 * 3];
                    int n4 = nArray[1 + n2 * 3];
                    int n5 = n - (n2 + 1);
                    System.arraycopy(objectArray, n2 + 1, objectArray, n2, n5);
                    System.arraycopy((int[])nArray, (int)(3 * (n2 + 1)), (int[])nArray, (int)(n2 * 3), (int)(n5 * 3));
                    this.mSpanCount = -1 + this.mSpanCount;
                    this.sendSpanRemoved(object, n3, n4);
                }
                return;
            }
            --n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void setSpan(Object object, int n, int n2, int n3) {
        this.checkRange("setSpan", n, n2);
        if ((n3 & 0x33) == 51) {
            char c;
            char c2;
            if (n != 0 && n != this.length() && (c2 = this.charAt(n - 1)) != '\n') {
                throw new RuntimeException("PARAGRAPH span must start at paragraph boundary (" + n + " follows " + c2 + ")");
            }
            if (n2 != 0 && n2 != this.length() && (c = this.charAt(n2 - 1)) != '\n') {
                throw new RuntimeException("PARAGRAPH span must end at paragraph boundary (" + n2 + " follows " + c + ")");
            }
        }
        int n4 = this.mSpanCount;
        Object[] objectArray = this.mSpans;
        int[] nArray = this.mSpanData;
        for (int i = 0; i < n4; ++i) {
            if (objectArray[i] != object) continue;
            int n5 = nArray[0 + i * 3];
            int n6 = nArray[1 + i * 3];
            nArray[0 + i * 3] = n;
            nArray[1 + i * 3] = n2;
            nArray[2 + i * 3] = n3;
            this.sendSpanChanged(object, n5, n6, n, n2);
            return;
        }
        if (1 + this.mSpanCount >= this.mSpans.length) {
            Object[] objectArray2 = ArrayUtils.newUnpaddedObjectArray(GrowingArrayUtils.growSize(this.mSpanCount));
            int[] nArray2 = new int[3 * objectArray2.length];
            System.arraycopy(this.mSpans, 0, objectArray2, 0, this.mSpanCount);
            System.arraycopy((int[])this.mSpanData, (int)0, (int[])nArray2, (int)0, (int)(3 * this.mSpanCount));
            this.mSpans = objectArray2;
            this.mSpanData = nArray2;
        }
        this.mSpans[this.mSpanCount] = object;
        this.mSpanData[0 + 3 * this.mSpanCount] = n;
        this.mSpanData[1 + 3 * this.mSpanCount] = n2;
        this.mSpanData[2 + 3 * this.mSpanCount] = n3;
        this.mSpanCount = 1 + this.mSpanCount;
        if (!(this instanceof Spannable)) return;
        this.sendSpanAdded(object, n, n2);
    }

    public final String toString() {
        return this.mText;
    }
}

