/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.Layout;
import android.text.NoCopySpan;
import android.text.Spannable;
import android.text.Spanned;

public class Selection {
    public static final Object SELECTION_END;
    public static final Object SELECTION_START;

    static {
        SELECTION_START = new START();
        SELECTION_END = new END();
    }

    private Selection() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int chooseHorizontal(Layout layout2, int n, int n2, int n3) {
        if (layout2.getLineForOffset(n2) == layout2.getLineForOffset(n3)) {
            float f = layout2.getPrimaryHorizontal(n2);
            float f2 = layout2.getPrimaryHorizontal(n3);
            if (n < 0) {
                if (f < f2) return n2;
                return n3;
            }
            if (!(f > f2)) return n3;
            return n2;
        }
        if (layout2.getParagraphDirection(layout2.getLineForOffset(n2)) != n) return Math.min(n2, n3);
        return Math.max(n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean extendDown(Spannable spannable, Layout layout2) {
        int n = Selection.getSelectionEnd(spannable);
        int n2 = layout2.getLineForOffset(n);
        if (n2 < -1 + layout2.getLineCount()) {
            int n3;
            if (layout2.getParagraphDirection(n2) == layout2.getParagraphDirection(n2 + 1)) {
                float f = layout2.getPrimaryHorizontal(n);
                n3 = layout2.getOffsetForHorizontal(n2 + 1, f);
            } else {
                n3 = layout2.getLineStart(n2 + 1);
            }
            Selection.extendSelection(spannable, n3);
            return true;
        } else {
            if (n == spannable.length()) return true;
            Selection.extendSelection(spannable, spannable.length());
            return true;
        }
    }

    public static boolean extendLeft(Spannable spannable, Layout layout2) {
        int n = Selection.getSelectionEnd(spannable);
        int n2 = layout2.getOffsetToLeftOf(n);
        if (n2 != n) {
            Selection.extendSelection(spannable, n2);
        }
        return true;
    }

    public static boolean extendRight(Spannable spannable, Layout layout2) {
        int n = Selection.getSelectionEnd(spannable);
        int n2 = layout2.getOffsetToRightOf(n);
        if (n2 != n) {
            Selection.extendSelection(spannable, n2);
        }
        return true;
    }

    public static final void extendSelection(Spannable spannable, int n) {
        if (spannable.getSpanStart(SELECTION_END) != n) {
            spannable.setSpan(SELECTION_END, n, n, 34);
        }
    }

    public static boolean extendToLeftEdge(Spannable spannable, Layout layout2) {
        Selection.extendSelection(spannable, Selection.findEdge(spannable, layout2, -1));
        return true;
    }

    public static boolean extendToRightEdge(Spannable spannable, Layout layout2) {
        Selection.extendSelection(spannable, Selection.findEdge(spannable, layout2, 1));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean extendUp(Spannable spannable, Layout layout2) {
        int n = Selection.getSelectionEnd(spannable);
        int n2 = layout2.getLineForOffset(n);
        if (n2 > 0) {
            int n3;
            if (layout2.getParagraphDirection(n2) == layout2.getParagraphDirection(n2 - 1)) {
                float f = layout2.getPrimaryHorizontal(n);
                n3 = layout2.getOffsetForHorizontal(n2 - 1, f);
            } else {
                n3 = layout2.getLineStart(n2 - 1);
            }
            Selection.extendSelection(spannable, n3);
            return true;
        } else {
            if (n == 0) return true;
            Selection.extendSelection(spannable, 0);
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int findEdge(Spannable spannable, Layout layout2, int n) {
        int n2 = layout2.getLineForOffset(Selection.getSelectionEnd(spannable));
        if (n * layout2.getParagraphDirection(n2) < 0) {
            return layout2.getLineStart(n2);
        }
        int n3 = layout2.getLineEnd(n2);
        if (n2 == -1 + layout2.getLineCount()) return n3;
        return n3 - 1;
    }

    public static final int getSelectionEnd(CharSequence charSequence) {
        if (charSequence instanceof Spanned) {
            return ((Spanned)charSequence).getSpanStart(SELECTION_END);
        }
        return -1;
    }

    public static final int getSelectionStart(CharSequence charSequence) {
        if (charSequence instanceof Spanned) {
            return ((Spanned)charSequence).getSpanStart(SELECTION_START);
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean moveDown(Spannable spannable, Layout layout2) {
        int n;
        int n2 = Selection.getSelectionStart(spannable);
        if (n2 != (n = Selection.getSelectionEnd(spannable))) {
            int n3 = Math.min(n2, n);
            int n4 = Math.max(n2, n);
            Selection.setSelection(spannable, n4);
            if (n3 == 0 && n4 == spannable.length()) return false;
            return true;
        }
        int n5 = layout2.getLineForOffset(n);
        if (n5 < -1 + layout2.getLineCount()) {
            int n6;
            if (layout2.getParagraphDirection(n5) == layout2.getParagraphDirection(n5 + 1)) {
                float f = layout2.getPrimaryHorizontal(n);
                n6 = layout2.getOffsetForHorizontal(n5 + 1, f);
            } else {
                n6 = layout2.getLineStart(n5 + 1);
            }
            Selection.setSelection(spannable, n6);
            return true;
        }
        if (n == spannable.length()) {
            return false;
        }
        Selection.setSelection(spannable, spannable.length());
        return true;
    }

    public static boolean moveLeft(Spannable spannable, Layout layout2) {
        int n;
        int n2 = Selection.getSelectionStart(spannable);
        if (n2 != (n = Selection.getSelectionEnd(spannable))) {
            Selection.setSelection(spannable, Selection.chooseHorizontal(layout2, -1, n2, n));
            return true;
        }
        int n3 = layout2.getOffsetToLeftOf(n);
        if (n3 != n) {
            Selection.setSelection(spannable, n3);
            return true;
        }
        return false;
    }

    public static boolean moveRight(Spannable spannable, Layout layout2) {
        int n;
        int n2 = Selection.getSelectionStart(spannable);
        if (n2 != (n = Selection.getSelectionEnd(spannable))) {
            Selection.setSelection(spannable, Selection.chooseHorizontal(layout2, 1, n2, n));
            return true;
        }
        int n3 = layout2.getOffsetToRightOf(n);
        if (n3 != n) {
            Selection.setSelection(spannable, n3);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean moveToFollowing(Spannable spannable, PositionIterator positionIterator, boolean bl) {
        int n;
        block4: {
            block3: {
                n = positionIterator.following(Selection.getSelectionEnd(spannable));
                if (n == -1) break block3;
                if (!bl) break block4;
                Selection.extendSelection(spannable, n);
            }
            return true;
        }
        Selection.setSelection(spannable, n);
        return true;
    }

    public static boolean moveToLeftEdge(Spannable spannable, Layout layout2) {
        Selection.setSelection(spannable, Selection.findEdge(spannable, layout2, -1));
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean moveToPreceding(Spannable spannable, PositionIterator positionIterator, boolean bl) {
        int n;
        block4: {
            block3: {
                n = positionIterator.preceding(Selection.getSelectionEnd(spannable));
                if (n == -1) break block3;
                if (!bl) break block4;
                Selection.extendSelection(spannable, n);
            }
            return true;
        }
        Selection.setSelection(spannable, n);
        return true;
    }

    public static boolean moveToRightEdge(Spannable spannable, Layout layout2) {
        Selection.setSelection(spannable, Selection.findEdge(spannable, layout2, 1));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean moveUp(Spannable spannable, Layout layout2) {
        int n;
        int n2 = Selection.getSelectionStart(spannable);
        if (n2 != (n = Selection.getSelectionEnd(spannable))) {
            int n3 = Math.min(n2, n);
            int n4 = Math.max(n2, n);
            Selection.setSelection(spannable, n3);
            if (n3 == 0 && n4 == spannable.length()) return false;
            return true;
        }
        int n5 = layout2.getLineForOffset(n);
        if (n5 > 0) {
            int n6;
            if (layout2.getParagraphDirection(n5) == layout2.getParagraphDirection(n5 - 1)) {
                float f = layout2.getPrimaryHorizontal(n);
                n6 = layout2.getOffsetForHorizontal(n5 - 1, f);
            } else {
                n6 = layout2.getLineStart(n5 - 1);
            }
            Selection.setSelection(spannable, n6);
            return true;
        }
        if (n == 0) {
            return false;
        }
        Selection.setSelection(spannable, 0);
        return true;
    }

    public static final void removeSelection(Spannable spannable) {
        spannable.removeSpan(SELECTION_START);
        spannable.removeSpan(SELECTION_END);
    }

    public static final void selectAll(Spannable spannable) {
        Selection.setSelection(spannable, 0, spannable.length());
    }

    public static final void setSelection(Spannable spannable, int n) {
        Selection.setSelection(spannable, n, n);
    }

    public static void setSelection(Spannable spannable, int n, int n2) {
        int n3 = Selection.getSelectionStart(spannable);
        int n4 = Selection.getSelectionEnd(spannable);
        if (n3 != n || n4 != n2) {
            spannable.setSpan(SELECTION_START, n, n, 546);
            spannable.setSpan(SELECTION_END, n2, n2, 34);
        }
    }

    private static final class END
    implements NoCopySpan {
        private END() {
        }
    }

    public static interface PositionIterator {
        public static final int DONE = -1;

        public int following(int var1);

        public int preceding(int var1);
    }

    private static final class START
    implements NoCopySpan {
        private START() {
        }
    }
}

