/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.InputFilter;
import android.text.SpannableStringBuilder;
import android.text.Spanned;

public abstract class LoginFilter
implements InputFilter {
    private boolean mAppendInvalid;

    LoginFilter() {
        this.mAppendInvalid = false;
    }

    LoginFilter(boolean bl) {
        this.mAppendInvalid = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
        this.onStart();
        for (int i = 0; i < n3; ++i) {
            char c = spanned.charAt(i);
            if (this.isAllowed(c)) continue;
            this.onInvalidCharacter(c);
        }
        SpannableStringBuilder spannableStringBuilder = null;
        int n5 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (this.isAllowed(c)) {
                ++n5;
                continue;
            }
            if (this.mAppendInvalid) {
                ++n5;
            } else {
                if (spannableStringBuilder == null) {
                    spannableStringBuilder = new SpannableStringBuilder(charSequence, n, n2);
                    n5 = i - n;
                }
                spannableStringBuilder.delete(n5, n5 + 1);
            }
            this.onInvalidCharacter(c);
        }
        int n6 = n4;
        while (true) {
            if (n6 >= spanned.length()) {
                this.onStop();
                return spannableStringBuilder;
            }
            char c = spanned.charAt(n6);
            if (!this.isAllowed(c)) {
                this.onInvalidCharacter(c);
            }
            ++n6;
        }
    }

    public abstract boolean isAllowed(char var1);

    public void onInvalidCharacter(char c) {
    }

    public void onStart() {
    }

    public void onStop() {
    }

    public static class PasswordFilterGMail
    extends LoginFilter {
        public PasswordFilterGMail() {
            super(false);
        }

        public PasswordFilterGMail(boolean bl) {
            super(bl);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean isAllowed(char c) {
            return ' ' <= c && c <= '\u007f' || '\u00a0' <= c && c <= '\u00ff';
        }
    }

    public static class UsernameFilterGMail
    extends LoginFilter {
        public UsernameFilterGMail() {
            super(false);
        }

        public UsernameFilterGMail(boolean bl) {
            super(bl);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean isAllowed(char c) {
            return '0' <= c && c <= '9' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '.' == c;
        }
    }

    public static class UsernameFilterGeneric
    extends LoginFilter {
        private static final String mAllowed = "@_-+.";

        public UsernameFilterGeneric() {
            super(false);
        }

        public UsernameFilterGeneric(boolean bl) {
            super(bl);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean isAllowed(char c) {
            return '0' <= c && c <= '9' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || mAllowed.indexOf(c) != -1;
        }
    }
}

